/***********************************************************************
 * $Id:: BLDC.c 3871 2010-07-16 11:50:22Z gerritdewaard                $
 *
 * Project: LPC1100 BLDC Motor Control AN
 *
 * Description:
 *
 *
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/


/******************************************************************************
 * Includes
 *****************************************************************************/
#include "application.h"

extern volatile uint32_t SysTick_cntr;

/****************************************************/
/* Startup message on OLED							*/
/****************************************************/
void vGUI_StartupMessage (void)
{
	/****************************************************/
	/* First screen: "Thank you for buying..."			*/
	/****************************************************/
	oled_putString(6, 0, "Thank you for\n buying the...", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
	oled_putString(18, 20, "LPCXpresso", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
	oled_putString(9, 28, "Motor Control", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
	oled_putString(33, 36, "Board", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
    oled_line(2, 18, 93, 18, OLED_COLOR_WHITE);
    oled_line(93, 18, 93, 44, OLED_COLOR_WHITE);
    oled_line(93, 44, 2, 44, OLED_COLOR_WHITE);
    oled_line(2, 44, 2, 18, OLED_COLOR_WHITE);

    oled_line(4, 45, 94, 45, OLED_COLOR_WHITE);
    oled_line(94, 20, 94, 45, OLED_COLOR_WHITE);

    //Delay 1.5 sec
    SysTick_cntr = 0; while (SysTick_cntr < 1500);
	oled_putString(0, 47, SW_VERSION_STRING, OLED_COLOR_WHITE, OLED_COLOR_BLACK);

    //Delay 3 sec
    SysTick_cntr = 0; while (SysTick_cntr < 3000);

	/****************************************************/
	/* Second screen: "Developed by Embedded Artists..."*/
	/****************************************************/
    /* Clear the OLED screen */
    oled_clearScreen(OLED_COLOR_BLACK);

    /* Draw EA logotype */
	vGUI_printImage(0,0, eaImage_data, (uint8_t) eaImage_width, (uint8_t) eaImage_height);

	/* Print message */
	oled_putString(40, 6, "Developed", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
	oled_putString(63, 24, "by", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
	oled_putString(45, 44, "Embedded", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
	oled_putString(49, 52, "Artists", OLED_COLOR_WHITE, OLED_COLOR_BLACK);

    //Delay 3 sec
	SysTick_cntr = 0; while (SysTick_cntr < 3000);

	/****************************************************/
	/* Third screen: "...in cooperation with NXP"		*/
	/****************************************************/
    /* Clear the OLED screen */
    oled_clearScreen(OLED_COLOR_BLACK);

    /* Print message */
	oled_putString(0, 1, "...in close co-\noperation with", OLED_COLOR_WHITE, OLED_COLOR_BLACK);

	/* Draw NXP logotype */
	vGUI_printImage(0,20,nxpImage_data, (uint8_t) nxpImage_width, (uint8_t) nxpImage_height);

    //Delay 3 sec
	SysTick_cntr = 0; while (SysTick_cntr < 3000);

	/****************************************************/
	/* Fourth screen: "Start motor by..."				*/
	/****************************************************/
    /* Clear the OLED screen */
    oled_clearScreen(OLED_COLOR_BLACK);

#ifdef __LPC11C2x
    /* Print first message on screen */
	oled_putString(0, 4, "Start motor\nby using\nleft key\nof joystick.", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
	oled_putString(0, 42, "Adjust speed by\nup/down-keys.", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
#elif defined __LPC111x
    /* Print first message on screen */
	oled_putString(0, 4, "Start motor\nby pressing\ncenter-key\nof joystick.", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
	oled_putString(0, 42, "Adjust speed by\nup/down-keys.", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
#endif
}

void vGUI_PrintInstruction (void)
{
    /* Clear the OLED screen */
    oled_clearScreen(OLED_COLOR_BLACK);

#ifdef __LPC11C2x
    /* Print first message on screen */
	oled_putString(0, 4, "Start motor\nby using\nleft key\nof joystick.", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
	oled_putString(0, 42, "Adjust speed by\nup/down-keys.", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
#elif defined __LPC111x
    /* Print first message on screen */
	oled_putString(0, 4, "Start motor\nby pressing\ncenter-key\nof joystick.", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
	oled_putString(0, 42, "Adjust speed by\nup/down-keys.", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
#endif
}

void vGUI_printImage (uint8_t x, uint8_t y, uint16_t * img, uint8_t width, uint8_t height)
{
	uint8_t colCnt;
	uint8_t rowCnt;
	uint16_t pixels;

	for (rowCnt = 0; rowCnt < height; rowCnt++)
	{
		for (colCnt = 0; colCnt < width; colCnt++)
		{
			if ((colCnt & 0x000f) == 0)
				pixels = *img++;
			if (pixels & 0x8000)
				oled_putPixel(x + colCnt, y, OLED_COLOR_WHITE);
			pixels <<= 1;

		}
		y++;
	}
}

