/***********************************************************************
 * $Id:: BLDC.h 3871 2010-07-16 11:50:22Z gerritdewaard                $
 *
 * Project: LPC1100 BLDC Motor Control AN  
 *
 * Description:
 *			
 *     
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/

#ifndef __BLDC_MOTOR_H 
#define __BLDC_MOTOR_H

#define MOTOR_FS			20000
#define MOTOR_PERIOD 		(SystemCoreClock/MOTOR_FS)		//	4800 / 2 = 2400
#define MOTOR_MAX_PERIOD 	(MOTOR_PERIOD * 0.9)
#define MOTOR_RAMPUP_DUTY	(MOTOR_MAX_PERIOD * 0.5)


#define motor_BRAKEON	(GPIOSetValue( 1, 9, 0 ))	
#define motor_BRAKEOFF	(GPIOSetValue( 1, 9, 1 ))	

#define BUTTON_STOP		(GPIO0_DATA&(1<<4))
#define BUTTON_START	(GPIO0_DATA&(1<<4))
#define BUTTON_UP		(GPIO0_DATA&(1<<4))
#define BUTTON_DOWN		(GPIO0_DATA&(1<<4))

/****************************************************/
/* PWM (FET drivers) connections					*/
/****************************************************/
/* PIO0_1	PHASE1_H  CT32B0_MAT2					*/
/* PIO0_11	PHASE1_L  CT32B0_MAT3					*/
/* PIO0_8	PHASE2_H  CT16B0_MAT0					*/
/* PIO0_9	PHASE2_L  CT16B0_MAT1					*/
/* PIO1_1	PHASE3_H  CT32B1_MAT0					*/
/* PIO1_2	PHASE3_L  CT32B1_MAT1					*/
/****************************************************/
#define H1REG			LPC_TMR32B0->MR2 // Phase 1 Hi 
#define L1REG			LPC_TMR32B0->MR3 // Phase 1 Lo	
#define H2REG			LPC_TMR16B0->MR0 // Phase 2 Hi
#define L2REG			LPC_TMR16B0->MR1 // Phase 2 Lo
#define H3REG			LPC_TMR32B1->MR0 // Phase 3 Hi
#define L3REG			LPC_TMR32B1->MR1 // Phase 3 Lo

#define HI_OFF			0xFFFF
#define LO_OFF			0x0

#define HALL_A_PORT		2
#define HALL_A_PIN		0
#define HALL_A_GPIODATA	LPC_GPIO2->DATA

#define HALL_B_PORT		2
#define HALL_B_PIN		1
#define HALL_B_GPIODATA	LPC_GPIO2->DATA

#define HALL_C_PORT		2
#define HALL_C_PIN		2
#define HALL_C_GPIODATA	LPC_GPIO2->DATA

/* Rotation indication */
enum rotation { CCW = 0, CW = !CCW};

typedef volatile struct _MOTORstr {
		int32_t		Kp;
		int32_t		Ki;
		int32_t		Kd;
		uint32_t	sp;	   	// setpoint
		uint32_t	pv;	   	// proces value
		int32_t		err[3];	// error
		int32_t 	IntError;
		int32_t 	LastError;
		uint32_t	mv;		// control output
		uint32_t	HALstate[2];
		uint32_t	TMRval[2];
		uint32_t	Deadtime;
		uint32_t	CMT_CNT;
		uint32_t	CMT_step;
		uint32_t   	RPM;
		uint8_t		Enable;
		uint8_t		Direction;
		uint8_t		RampingUp;
		uint32_t	Startup;
		uint8_t		Brake;
		uint8_t		CMT_flag;
		uint32_t   	max_mv; 
		uint8_t    	PolePairs;
		uint32_t	Trap_CNT; 
		uint16_t	Current[3];
		uint16_t	Voltage[3];      		
}MOTOR_TypeDef;


void vBLDC_Init (MOTOR_TypeDef *ptr);
void vBLDC_Stop (void);
void vBLDC_Commutate (volatile uint8_t step);
void vBLDC_ReadHall(void);
void vBLDC_CalcRPM (MOTOR_TypeDef *ptr);
void vBLDC_RampUp (MOTOR_TypeDef *ptr, uint32_t max_RPM);

#endif
