/***********************************************************************
 * $Id:: handlers.c 3871 2010-07-16 11:50:22Z gerritdewaard            $
 *
 * Project: LPC1100 BLDC Motor Control AN  
 *
 * Description:
 *			
 *     
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/

#include "application.h"


extern volatile uint32_t bldc_Tick;
extern volatile uint32_t bldc_SySTickold;
extern volatile uint32_t bldc_SySTicknew;
extern volatile MOTOR_TypeDef Motor;
extern volatile uint8_t show_graph;
extern volatile uint8_t show_temperature;
volatile uint32_t SysTick_cntr = 0;

/*****************************************************************************
** Function name:		PIOINT0_IRQHandler
**
** Descriptions:		Use one GPIO pin(port0 pin1) as interrupt source
**
** parameters:			None
** Returned value:		None
** 
*****************************************************************************/
#ifndef GPIO_GENERIC_INTS

void PIOINT2_IRQHandler(void)
{
  	uint32_t regVal;

  	regVal = LPC_GPIO2->MIS;

  	switch (regVal)
  	{
  	case (1<<HALL_A_PIN):
			/* Calculate the actual RPM */
			vBLDC_CalcRPM(&Motor);
			/* Read the HALL sensor  */
			vBLDC_ReadHall();
			break;
  	case ((1<<HALL_B_PIN)):
  	case ((1<<HALL_C_PIN)):
			vBLDC_ReadHall();
  			break;
  	case (1<<JOY_C_PIN):
  	case (1<<JOY_L_PIN):
			if (Motor.Enable)
			{
				/* Disable the motor */
				Motor.Enable = 0;
				/* Set the RPM to 0 */
				Motor.RPM = 0;
				Motor.RampingUp = FALSE;
			}
			else
			{
				/* Enable the motor */
				Motor.Enable = 1;
				Motor.CMT_CNT = 0;
				Motor.RampingUp = TRUE;
				show_graph = TRUE;
				show_temperature = TRUE;
			}
  			break;
  	case (1<<JOY_U_PIN):
				Motor.sp+=50;
				if (Motor.sp >= 4100)
					Motor.sp = 4100;
  	  			break;
  	case (1<<JOY_D_PIN):
				Motor.sp-=50;
				if (Motor.sp<= 0)
					Motor.sp = 0;
  	  			break;
  	case (1<<JOY_R_PIN):
				if (Motor.Direction == CW)
						Motor.Direction = CCW;
				else
					Motor.Direction = CW;
  	  			break;
  	default:
  		break;
  	}
  	/* Clear all interrupt sources */
	LPC_GPIO2->IC = 0xFFF;
  return;
}
#endif //GPIO_GENERIC_INTS


void SysTick_Handler (void)
{
	SysTick_cntr++;
	bldc_Tick++;
}


