/*****************************************************************************
 * callbacks.c 
 *
 * Project: LPC17xx Capacitive Touch Sensing demo program
 *
 * Description:
 *   Implements the callbacks functions called for the key presses 
 *
 *----------------------------------------------------------------------------
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *                  (C) Copyright 2011 NXP Semiconductors
 *****************************************************************************/
/* includes */
#include "includes.h"  

/* local function prototypes */
static void NO_ACTION(KeypadIdType kbdNum);


/*****************************************************************************
 * Callback functions for the key presses                                    
 * the debug strings include:
 *
 *  - a progressive counter on the number of keypresses detected
 *  - the keypad number being pressed
 *  - the last ADC value sampled
 *  - the average (threshold) value for the channel
 *
 * users shall modify the function body at convenience
 * only functions for defined keypads (USE_KBDn) are significant
 ****************************************************************************/

/*****************************************************************************
 * Keypad #1 
 ****************************************************************************/
#if(USE_KBD1)
    void kbd1Action(KeypadIdType kbdNum)
    {
        kbdPress[kbdNum] = 0;   /* reset kpress status */
    	sprintf(uartLogBuf,"[%d %d]\t0x%X\t0x%X\n\r",kPressCntr,kbdNum+1,reading[KBD1_ASSIGNED_CHANNEL],average[KBD1_ASSIGNED_CHANNEL]);
    	sendUart((uint8_t *)uartLogBuf, strlen(uartLogBuf));
    }
#else
    #define kbd1Action (NO_ACTION)
#endif

/*****************************************************************************
 * Keypad #2 
 ****************************************************************************/
#if(USE_KBD2)
    void kbd2Action(KeypadIdType kbdNum)
    {
        kbdPress[kbdNum] = 0;   /* reset kpress status */
    	sprintf(uartLogBuf,"[%d %d]\t0x%X\t0x%X\n\r",kPressCntr,kbdNum+1,reading[KBD2_ASSIGNED_CHANNEL],average[KBD2_ASSIGNED_CHANNEL]);
    	sendUart((uint8_t *)uartLogBuf, strlen(uartLogBuf));
    }
#else
    #define kbd2Action (NO_ACTION)
#endif

/*****************************************************************************
 * Keypad #3 
 ****************************************************************************/
#if(USE_KBD3)
    void kbd3Action(KeypadIdType kbdNum)
    {
        kbdPress[kbdNum] = 0;   /* reset kpress status */
    	sprintf(uartLogBuf,"[%d %d]\t0x%X\t0x%X\n\r",kPressCntr,kbdNum+1,reading[KBD3_ASSIGNED_CHANNEL],average[KBD3_ASSIGNED_CHANNEL]);
    	sendUart((uint8_t *)uartLogBuf, strlen(uartLogBuf));
    }
#else
    #define kbd3Action (NO_ACTION)
#endif

/*****************************************************************************
 * Keypad #4 
 ****************************************************************************/
#if(USE_KBD4)
    void kbd4Action(KeypadIdType kbdNum)
    {
        kbdPress[kbdNum] = 0;   /* reset kpress status */
    	sprintf(uartLogBuf,"[%d %d]\t0x%X\t0x%X\n\r",kPressCntr,kbdNum+1,reading[KBD4_ASSIGNED_CHANNEL],average[KBD4_ASSIGNED_CHANNEL]);
    	sendUart((uint8_t *)uartLogBuf, strlen(uartLogBuf));
    }
#else
    #define kbd4Action (NO_ACTION)
#endif

/*****************************************************************************
 * Keypad #5 
 ****************************************************************************/
#if(USE_KBD5)
    void kbd5Action(KeypadIdType kbdNum)
    {
        kbdPress[kbdNum] = 0;   /* reset kpress status */
    	sprintf(uartLogBuf,"[%d %d]\t0x%X\t0x%X\n\r",kPressCntr,kbdNum+1,reading[KBD5_ASSIGNED_CHANNEL],average[KBD5_ASSIGNED_CHANNEL]);
    	sendUart((uint8_t *)uartLogBuf, strlen(uartLogBuf));
    }
#else
    #define kbd5Action (NO_ACTION)
#endif

/*****************************************************************************
 * Keypad #6 
 ****************************************************************************/
#if(USE_KBD6)
    void kbd6Action(KeypadIdType kbdNum)
    {
        kbdPress[kbdNum] = 0;   /* reset kpress status */
        sprintf(uartLogBuf,"[%d %d]\t0x%X\t0x%X\n\r",kPressCntr,kbdNum+1,reading[KBD6_ASSIGNED_CHANNEL],average[KBD6_ASSIGNED_CHANNEL]);
    	sendUart((uint8_t *)uartLogBuf, strlen(uartLogBuf));
    }
#else
    #define kbd6Action (NO_ACTION)
#endif

/*****************************************************************************
 * Keypad #7 
 ****************************************************************************/
#if(USE_KBD7)
    void kbd7Action(KeypadIdType kbdNum)
    {
        kbdPress[kbdNum] = 0;   /* reset kpress status */
    	sprintf(uartLogBuf,"[%d %d]\t0x%X\t0x%X\n\r",kPressCntr,kbdNum+1,reading[KBD7_ASSIGNED_CHANNEL],average[KBD7_ASSIGNED_CHANNEL]);
    	sendUart((uint8_t *)uartLogBuf, strlen(uartLogBuf));
    }
#else
    #define kbd7Action (NO_ACTION)
#endif

/*****************************************************************************
 * Keypad #8 
 ****************************************************************************/
#if(USE_KBD8)
    void kbd8Action(KeypadIdType kbdNum)
    {
        kbdPress[kbdNum] = 0;   /* reset kpress status */
    	sprintf(uartLogBuf,"[%d %d]\t0x%X\t0x%X\n\r",kPressCntr,kbdNum+1,reading[KBD8_ASSIGNED_CHANNEL],average[KBD8_ASSIGNED_CHANNEL]);
    	sendUart((uint8_t *)uartLogBuf, strlen(uartLogBuf));
    }
#else
    #define kbd8Action (NO_ACTION)
#endif


/*****************************************************************************
 * this table holds the set of callback functions for the kpress 
 ****************************************************************************/
const CallbackFctType KeypadAction[NUM_KPAD]  = 
{
    (CallbackFctType) kbd1Action,
    (CallbackFctType) kbd2Action,
    (CallbackFctType) kbd3Action,
    (CallbackFctType) kbd4Action,
    (CallbackFctType) kbd5Action,
    (CallbackFctType) kbd6Action,
    (CallbackFctType) kbd7Action,
    (CallbackFctType) kbd8Action        
};

/*****************************************************************************
 * this is the default function for unused keypads (just a return)
 ****************************************************************************/
__attribute__((used))
void NO_ACTION(KeypadIdType kbdNum) { return; };


/* end of file */
