/*****************************************************************************
 * led.c 
 *
 * Project: LPC17xx Capacitive Touch Sensing demo program
 *
 * Description:
 *   Implements a led debug output 
 *
 *----------------------------------------------------------------------------
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *                  (C) Copyright 2011 NXP Semiconductors
 *****************************************************************************/
/* includes */
#include "includes.h"


/*****************************************************************************
 * this function sets the output port as GPIO for the led                    *
 ****************************************************************************/
#define GPIO_0_22       (~(0x3 << 12))
void initLed(void)
{
    /* P0.22 led on lpcxpresso stick */
    LPC_GPIO0->FIODIR |= (1<<22);                      
    LPC_PINCON->PINSEL1 &= GPIO_0_22;
}


/*****************************************************************************
 * this function toggles the gpio port (led)                                 *
 ****************************************************************************/
#define setLed()    (LPC_GPIO0->FIOSET = (1<<22))
#define clearLed()  (LPC_GPIO0->FIOCLR = (1<<22))

void toggleLed(void)
{
    if(LPC_GPIO0->FIOPIN & (1<<22)) clearLed();
    else setLed();
}


 /* end of file */
