/*****************************************************************************
 * main.c 
 *
 * Project: LPC17xx Capacitive Touch Sensing demo program
 *
 * Description:
 *   Implements a demo program showing how to perform low-cost multichannel 
 *   capacitive touch sensing on LPC1700
 *
 *----------------------------------------------------------------------------
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *                  (C) Copyright 2011 NXP Semiconductors
 *****************************************************************************/

/* includes */
#include "includes.h"  


/* function prototypes */
void SysTickHandler(void);


/* main routine */
int main (void)
{
    /* setup the system for clock configuration */
    /* CPU configured to run at 100 MHz */
    SystemInit();

    /* convenience debug output on timer0 - match 1	 > DBG LPC6, TP143 */
    /* used to check the clock settings, output is CPU/4 (25 MHz) */
    /* normally commented out in the demo code */
    #if(0)
	LPC_PINCON->PINSEL3 |= (0x3 << 26);		/* select timer mode  for pin */
	LPC_TIM0->MR1 = 0x1;                    /* count to one for toggling */
	LPC_TIM0->MCR |= (0x1 << 4);            /* reset on match */
	LPC_TIM0->EMR |= (0x3 << 6);            /* toggle on match */
	LPC_TIM0->TCR = 0x1;                    /* start the timer */
    #endif


	/* initialize adc and uart debug output */
    initAdc(SystemFrequency);
    
    /* initialize uart debug output */
    /* note: default frequency of 115200 bps selected within uart.c module */
    initUart();    

    /* initialize led port */
    initLed();

    /* calibration loop on all active channels to setup mean threshold value */
    calibrateAllChannels();

    /* config systick to generate interrupts @ 100HZ - 10ms rate */
    SysTick_Config(SystemFrequency/100);           

    while (1)
    {
        /* processor goes to sleep in between ADC readings */                      
        __wfi();                
        
        /* processor is woken up by systick interrupt */
        /* activate callback functions for the detected keypress */
        processKeystrokes();    
    }
}



/*****************************************************************************
 * generate a SysTick Timer ISR every 10 msec                                *   
 ****************************************************************************/
volatile int cntr = 0;
void SysTick_Handler(void)                         
{
    /* iterate through the active channel list to perform readings */
    processChannels();

    /* just simple heartbeat indication, toggle every second */
	cntr++;
	if(cntr == 49) 
	{
        toggleLed();
	    cntr=0;
	}
}


/* end of file */

