/*****************************************************************************
 * uart.c 
 *
 * Project: LPC17xx Capacitive Touch Sensing demo program
 *
 * Description:
 *   Implements a debug output on uart serial line
 *
 *----------------------------------------------------------------------------
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *                  (C) Copyright 2011 NXP Semiconductors
 *****************************************************************************/
/* includes */
#include <string.h>
#include <LPC17xx.h>
#include "uart.h"

/* external references */
char uartLogBuf[BUFSIZE];

/* settings for UART  port */
/* choose one of them, either UART_9600 or UART_115200 */
#define UART_9600 		0	
#define UART_115200 	1


/*****************************************************************************
 * configure the uart debug output                                              
 ****************************************************************************/
void initUart(void)
{
    memset (uartLogBuf,0,BUFSIZE);

    /* RxD3 is P0.1 and TxD3 is P0.0 */
	LPC_PINCON->PINSEL0 &= ~0x0000000F;
	LPC_PINCON->PINSEL0 |=  0x0000000A;  

    /* 8 bits, no Parity, 1 Stop bit */
    LPC_UART3->LCR = 0x83;		

	if(UART_115200)
	{
        /* settings apply for : */
        /* PCLK = 25MHz (100MHz divide by 4 */
        /* 115200 baud rate */    
	    LPC_UART3->DLM = 0; 
	    LPC_UART3->DLL = 9;
        LPC_UART3->FDR = ((0x2 << 4)| 0x1); /* DIVADDVAL 1, MULVAL 2 */
	}

	if(UART_9600)
	{
        /* settings apply for : */
        /* PCLK = 25MHz (100MHz divide by 4 */
        /* 115200 baud rate */
        LPC_UART3->DLM = 0; 
	    LPC_UART3->DLL = 108;
        LPC_UART3->FDR = ((0x2 << 4)| 0x1); /* DIVADDVAL 1, MULVAL 2 */
	}

	LPC_UART3->LCR = 0x03;		/* DLAB = 0 */
	LPC_UART3->FCR = 0x07;		/* Enable and reset TX and RX FIFO. */
}


/*****************************************************************************
 * send characters to the uart debug output                                     
 ****************************************************************************/
#define LSR_THRE	0x20
void sendUart(uint8_t *BufferPtr, uint32_t Length )
{
    uint32_t i;
			
	for(i=0;i<Length;i++)
	{
	    /* Wait for Tx to complete polling the THRE flash */
        while(!(LPC_UART3->LSR&LSR_THRE));	
		LPC_UART3->THR = (*BufferPtr++);
	} 
}

/* end of file */

