/*****************************************************************************
 * main.c 
 *
 * Project: SCT Application Example for LPC1800
 *
 * Description:
 *   Implements the blinky tutorial from the SCT FSM designer user manual
 *
 *----------------------------------------------------------------------------
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/

#include <stdio.h>

#ifdef LPC43XX
    #include "LPC43xx_TC2.h"
    #include "scu_LPC43xx.h"
    #include "emc_LPC43xx.h"
#endif

#ifdef LPC18XX
    #include "LPC18xx.h"
    #include "lpc18xx_scu.h"
#endif

#include "sct_fsm.h"


/******************************************************************************
 * Initialize board type specific IO's
 *  - Hitex board version A2
 *
 * CTIN0    PD_13  DOWN			X19-1 or JP29-1
 * CTIN1    PD_10  RESET		X19-2 or JP34-1
 *
 * CTOUT2   PE_6   LED_GREEN    -
 * CTOUT3   PE_5   LED_RED      -
 * CTOUT4   PE_8   LED_BLUE     -
 *
 *
 ******************************************************************************/
void IOInit(void)
{
    // Board (and chip) specific initializations - Hitex board
    #ifdef LPC43XX
    scu_pinmux (0x0E, 6, MD_PLN, FUNC1);   // PE_6 (M16):  CTOUT2
    scu_pinmux (0x0E, 5, MD_PLN, FUNC1);   // PE_5 (N16):  CTOUT3
    scu_pinmux (0x0E, 8, MD_PLN, FUNC1);   // PE_8 (F14):  CTOUT4

    scu_pinmux(0x0D, 13,  MD_PUP|MD_EZI, FUNC1);  // PD_13:  CTIN_0: DOWN on X19-1 or JP29-1
    scu_pinmux(0x0D, 10,  MD_PUP|MD_EZI, FUNC1);  // PD_10:  CTIN_1: RESET on X19-2 or JP34-1
    #endif
    
    #ifdef LPC18XX
    scu_pinmux (0x0E, 6, MD_PLN, FUNC1);
    scu_pinmux (0x0E, 5, MD_PLN, FUNC1);
    scu_pinmux (0x0E, 8, MD_PLN, FUNC1);

    scu_pinmux(0x0D, 13,  MD_PUP|MD_EZI, FUNC1);
    scu_pinmux(0x0D, 10,  MD_PUP|MD_EZI, FUNC1);
    #endif
}




/******************************************************************************
 * SCT interrupt handler
 * 
 *
 *  
 ******************************************************************************/
void SCT_IRQHandler (void)
{
    /* Acknowledge the interrupt source */
    ;
}



/******************************************************************************
 * main 
 * 
 *
 *  
 ******************************************************************************/
int sct_main (void)
{
    // Set the Vector table offset if the program code is in external memory
    #ifdef EXTFLASH
        extern unsigned long __Vectors;
        SCB->VTOR = (unsigned long)&__Vectors;
    #endif
    
    // System and board specific initializations 
    SystemInit();

    // Enable clocks and PLL
    LPC_CREG->CREG0 |= (1<<1)|(1<<0);               // Enable 32 kHz & 1 kHz on osc32k 
#if 0
    SetPL160M(SRC_XTAL, 10);                    // Set PL160M @ 10*12 = 120 MHz with the XTAL as source clock 
    #ifdef LPC43XX
        SetClock(BASE_M4_CLK, SRC_PL160M_0, DIV1);      // Run base M3 clock from PL160M, div by 1 = no division 
    #endif
    #ifdef LPC18XX
        SetClock(BASE_M3_CLK, SRC_PL160M_0, DIV1);      // Run base M3 clock from PL160M, div by 1 = no division 
    #endif
#endif
    // Initialise the IO's needed for this example
    IOInit();

    // Configure the EMC in case the software runs from external flash 
    #ifdef EXTFLASH
        EMC_Config_Pinmux();
        EMC_Config_Static();
    #endif

    // Global configuration of the SCT  
    #ifdef LPC43XX
        LPC_CCU1->CLK_M4_SCT_CFG = 0x00000001;          // Enable SCT branch clock in CCU1, RUN=1, AUTO=0, WAKE=0 
    #endif
    #ifdef LPC18XX
        LPC_CCU1->CLK_M3_SCT_CFG = 0x00000001;          // Enable SCT branch clock in CCU1, RUN=1, AUTO=0, WAKE=0 
    #endif

    LPC_SCT->CONFIG = 0x00000000;                   // Configure as two separate 16-bit timers, clocked internally 

    LPC_SCT->CTRL_L = 0x000C + ((256-1) << 5);      // L counter:
                                                    // Set prescaler = 255 (that's the maximum). Clear counter. Keep halted 
                                              
    //LPC_SCT->CTRL_H = 0x000C + ((100-1) << 5);    // H counter: not used
                                                    // Set prescaler = 100. Clear counter. Keep halted 

    // Now use the FSM code to configure the state machine 
    sct_fsm_init();

    // Additional manual configuration and overrides: 
    // Conflict resolution: CLR override for all 
    LPC_SCT->RES = (2 << (2*0)) | (2 << (2*1)) | (2 << (2*2)) | (2 << (2*3));

    // Start the SCT 
    // LPC_UT->CTRL_U &= ~((1 << 2) | (1 << 18));   // Run both timer sides H+L 
    LPC_SCT->CTRL_U &= ~(1 << 2);                   // Run L only 


    // NVIC_EnableIRQ (SCT_IRQn);  // Interrupts not used in this example


    // run CPU in an endless loop, the SCT runs independently
    while (1) 
    {
    }

}


