

/************************** PRIVATE DEFINITIONS *************************/
//#define LCD_WIDTH		480
//#define LCD_HEIGHT		272
#define LOGO_WIDTH		110
#define LOGO_HEIGHT		42

#define FRAMEBUFFER_ADDR        0x28000000

/************************** PRIVATE VARIABLES *************************/
uint32_t msec;

extern void SDRAM_Init (void);
extern const unsigned char image[];

//#define XGA1600x900
//#define VGA		// 800x600
#define CGA		// 640x480

#if defined XGA1600x900				// really 800x900 as 
/* LCD configured struct  as VGA*/
 #define VIDEO_DIVIDE 2
 #define LCD_WIDTH		800
 #define LCD_HEIGHT		900

const LCD_CFG_Type Sharp = {
	LCD_WIDTH,	  	//limited to 1024 pixels/line so display each twice
	LCD_HEIGHT,		//480
	{24,40},
	{3,18},
	16,
	5,
	1,
	LCD_SIGNAL_ACTIVE_HIGH,
	LCD_SIGNAL_ACTIVE_LOW,
	LCD_CLK_RISING,
	LCD_SIGNAL_ACTIVE_LOW,
	10,
	LCD_BPP8,
	LCD_TFT,
	LCD_COLOR_FORMAT_RGB,
	FALSE
};
#elif defined VGA
/* LCD configured struct  as VGA*/
 #define VIDEO_DIVIDE 2
 #define LCD_WIDTH		800
 #define LCD_HEIGHT		600

const LCD_CFG_Type Sharp = {
	800,	  	//640
	600,		//480
	{40,128},
	{1,23},
	88,
	4,
	1,
	LCD_SIGNAL_ACTIVE_HIGH,
	LCD_SIGNAL_ACTIVE_HIGH,
	LCD_CLK_RISING,
	LCD_SIGNAL_ACTIVE_LOW,
	10,
	LCD_BPP24,
	LCD_TFT,
	LCD_COLOR_FORMAT_RGB,
	FALSE
};
#elif defined CGA
/* LCD configured struct  as VGA*/
 #define VIDEO_DIVIDE 20
 #define LCD_WIDTH		640
 #define LCD_HEIGHT		480

const LCD_CFG_Type Sharp = {
	LCD_WIDTH,	  	//640
	LCD_HEIGHT,		//480
	{16,48},
	{10,33},
	96,
	2,
	1,
	LCD_SIGNAL_ACTIVE_LOW,
	LCD_SIGNAL_ACTIVE_LOW,
	LCD_CLK_RISING,
	LCD_SIGNAL_ACTIVE_LOW,
	10,
	LCD_BPP16_565, //LCD_BPP24,
	LCD_TFT,
	LCD_COLOR_FORMAT_RGB,
	FALSE
};
#else
/* LCD configured struct */
 #define VIDEO_DIVIDE 4
 #define LCD_WIDTH		640
 #define LCD_HEIGHT		480

const LCD_CFG_Type Sharp = {
	LCD_WIDTH,
	LCD_HEIGHT,
	{2,2},
	{2,2},
	41,
	10,
	1,
	LCD_SIGNAL_ACTIVE_LOW,
	LCD_SIGNAL_ACTIVE_LOW,
	LCD_CLK_RISING,
	LCD_SIGNAL_ACTIVE_LOW,
	10,
	LCD_BPP24,
	LCD_TFT,
	LCD_COLOR_FORMAT_RGB,
	FALSE
};
#endif

/* pointer to frame buffer */
uint32_t *framebuffer = (uint32_t *)FRAMEBUFFER_ADDR;
/************************** PRIVATE FUNCTIONS *************************/

/*----------------- INTERRUPT SERVICE ROUTINES --------------------------*/
/*********************************************************************//**
 * @brief		SysTick handler sub-routine (1ms)
 * @param[in]	None
 * @return 		None
 **********************************************************************/
void SysTick_Handler (void) 					// SysTick Interrupt Handler @ 1000Hz
{
	if(msec)msec--;
}
/*-------------------------PRIVATE FUNCTIONS------------------------------*/
/*********************************************************************//**
 * @brief		put a pixel
 * @param[in]	x,y postion of pixel
 * @param[in]	val color value of pixel in 32bit
 * @return 		None
 **********************************************************************/

void putpixel(uint32_t x, uint32_t y, uint32_t val){
	framebuffer[x+y*480] = val;
}



#define SDRAM_PIXELS
#define DMA_A_LINE

#if (defined SDRAM_PIXELS) ||(defined DMA_A_LINE)		// allocated in 0x10000000 RAM

short *pixelbuf = (short *)FRAMEBUFFER_ADDR;		 // 128	 x 160 words
#define set_pixelbuf(r,c)	pixelbuf[(160+r)*LCD_WIDTH*2+c+200]
#define get_pixelbuf(r,c)	pixelbuf[(160+r)*LCD_WIDTH*2+c+200]


#else

char pixelbuf[128][BYTEperHLINE];		 // 128	 x 160 words   -- in local RAM
#define set_pixelbuf(r,c)	pixelbuf[r][c]
#define get_pixelbuf(r,c)	pixelbuf[r][c]

#endif

#define NXP_RED			0x7800
#define NXP_BLUE		0x02ff
#define NXP_GREEN		0x07e0
#define NXP_DEEPGREEN	0x03e0
#define NXP_ORANGE		0x7be0

#define JUST_BLUE		0x001f

void paintApicture (void) {			// fill the screen with an image here
	int line, pixel;
	

//	write an initial NXP into the onchip SRAM
	for (line=0; line<16; line++) {
		for (pixel = 0;  pixel<(52+line); pixel++) 
			set_pixelbuf (line,330 + pixel) = NXP_GREEN;				// top of P
	}
	for (line=16; line<32; line++) {
		for (pixel = 0;  pixel<30; pixel++) 
			set_pixelbuf (line,365 + pixel) = NXP_GREEN;				// ) of the P
	}
	for (line=32; line<48; line++) {
		for (pixel = 0;  pixel<(52+(48-line)); pixel++) 
			set_pixelbuf (line,330 + pixel) = NXP_GREEN;				// bar of the P
	}

	for (line=0; line<64; line++) {
		for (pixel = 0;  pixel<30; pixel++) {
			set_pixelbuf (line,170 + pixel) = NXP_ORANGE;				// left of N
			set_pixelbuf (line,240 + pixel) = NXP_ORANGE;				// right of N
			set_pixelbuf (line,308 + pixel) = NXP_GREEN;				// left of P
		}
		for (pixel = 0;  pixel<38; pixel++) {
			set_pixelbuf (line,170 + pixel+line) = NXP_ORANGE;		// diag of N
		}			
		for (pixel = 0;  pixel<38; pixel++) {
			set_pixelbuf (line,240 + pixel+line) = get_pixelbuf (line,240 + pixel+line) | NXP_BLUE	;	// X
			set_pixelbuf (line,300 + pixel-line) = get_pixelbuf (line,300 + pixel-line) | NXP_BLUE	;	// X
			
		}
	}

	for (line=0; line<64; line++) {				   // make the overlap green
		for (pixel = 0;  pixel<30; pixel++) {
			if (get_pixelbuf (line,240 + pixel) & JUST_BLUE) set_pixelbuf (line,240 + pixel) = NXP_DEEPGREEN;				// right of N
			if (get_pixelbuf (line,308 + pixel) & JUST_BLUE) set_pixelbuf (line,310 + pixel) = NXP_DEEPGREEN;				// left of P
		}
	}

	for (line=0; line<100; line++) {
		for (pixel = 0;  pixel<50; pixel++) {
			set_pixelbuf (line,  50 + pixel) = 0 + (line<<5);		// color test
			set_pixelbuf (line,   0 + pixel) = 0 + ((line/2)<<0);		// color test
			set_pixelbuf (line, -50 + pixel) = 0 + ((line/2)<<11);		// color test
		}
	}
	
	
}
