/*-----------------------------------------------------------------------------
 * Name:    Demo.c
 * Purpose: Demo example for MCB4300
 * Note(s):
 *-----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2004-2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#include "LPC43xx.h"                    /* LPC43xx Definitions                */
#include <stdio.h>
#include "GLCD.h"
#include "SGPIOcamera.h"

#ifdef SPIFI_BOOT
 #include "SPIFIboot.h"
#endif

/* EEPROM Logger definitions */
typedef struct {
  uint16_t MemSz;
  uint16_t WrAddr;
  uint16_t WrCount;
} EE_LOG;

EE_LOG Log;
int row=0;
int col=0;
int OneFrameDone=0;
extern int OneFrameBegin;
void SystemCoreClockUpdate (void);
/* Mode switch timeout variable */
uint32_t KeyTick, Measure;

/* GLCD string buffer */
#define STRINGBUF_LEN   21
#define CAM_WIDTH	320
#define CAM_HEIGHT	240
#define CAM_BUF_START	0x28040000
#define LCD_BUF_START	0x28000000
static int *pixelPTR = (int *) CAM_BUF_START;

char StringBuf[STRINGBUF_LEN];
volatile unsigned int *sgpio_status1 = (volatile unsigned int *)&LPC_SGPIO->STATUS_1;
/* Extern variables */
extern unsigned char Arrows_16bpp_red[];
extern unsigned char Button_16bpp[];
extern unsigned char Bulb_16bpp[];

#ifdef SPIFI_BOOT
 #include "SPIFIboot.c"		// can't do conditional compiles in Keil projects, so force it to happen this way

  void goto_takeSnapshot(void) {
    takeSnapshot();
  }
#endif


/*-----------------------------------------------------------------------------
  SysTick IRQ Handler @ 10 ms
 *----------------------------------------------------------------------------*/
void SysTick_Handler (void) {
  static uint8_t TickKbd, TickTh;
  

  if (KeyTick == 0) {
    TickKbd++;
    if (TickKbd == 50) {
      KeyTick = 1;
      TickKbd = 0;
    }
  }
  else TickKbd = 0;
  
  TickTh++;
  if (TickTh > 200) {
    TickTh  = 0;
    Measure = 1;
  }
}




///////////////////////////////////////////////////////////////////////
// setup the clocks
//
// this has to be done centrally to minimize interference
// someday we should have a tool to do this
///////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////
//

//#define MHZ25_175
//#define MHZ30

#ifdef MHZ25_175
  #define	PLL0mdiv	0x23e14e9
  #define	PLL0npdiv	0xf500e
#elif defined MHZ30
  #define	PLL0mdiv	0xc2e4ccc
  #define	PLL0npdiv	0x202017
#elif defined MHZ35					// runs here -monitor is UNHAPPY -- can't always keep up -- marginal
  #define	PLL0mdiv	0x43e5b69
  #define	PLL0npdiv	0xc7015
#elif defined MHZ41				   	// can't keep up here
  #define	PLL0mdiv	0xb2a54cc
  #define	PLL0npdiv	0x20200a
#elif defined MHZ43		  // broke -- wrong freq
  #define	PLL0mdiv	0x53e36c1
  #define	PLL0npdiv	0x3d008
#elif defined MHZ45		  		  	// can't keep up here
  #define	PLL0mdiv	0xc2e4ccc
  #define	PLL0npdiv	0x20200a
#elif defined MHZ50					// can't keep up here		  
  #define	PLL0mdiv	0x73e35b2
  #define	PLL0npdiv	0xb005
#elif defined MHZ55					// can not quite keep up on internal RAM
  #define	PLL0mdiv	0xe3833bb
  #define	PLL0npdiv	0x1002
#else	// 24.576 MHz   -- 44.1KHz audio
  #define	PLL0mdiv	0x23e34d3
  #define	PLL0npdiv	0x3f00e
#endif


uint32_t CGU_SetPLL0audio2vga(void){
    /* disable clock, disable skew enable, power down pll,
    * (dis/en)able post divider, (dis/en)able pre-divider,
    * disable free running mode, disable bandsel,
    * enable up limmiter, disable bypass
    */
    LPC_CGU->PLL0AUDIO_CTRL = (6 << 24)   /* source = XTAL OSC 12 MHz */
                      | (1 << 0); /* power down */

		LPC_CGU->PLL0AUDIO_MDIV = PLL0mdiv;	  		
		LPC_CGU->PLL0AUDIO_NP_DIV = PLL0npdiv;

    LPC_CGU->PLL0AUDIO_CTRL = (6 << 24)   /* source = XTAL OSC 12 MHz */
											| (6 << 12)		  // fractional divider off and bypassed
                      | (1 << 4);   /* CLKEN */
    /* wait for lock */
    while (!(LPC_CGU->PLL0AUDIO_STAT & 1)); 
    
	LPC_CGU->BASE_PERIPH_CLK =	(8 << 24);		// PLL0 for audio to SGPIO
        
	return 0;
}

uint32_t M4Frequency;
uint32_t XtalFrequency = 12000000;

void ClockInit() {
	
	M4Frequency = SystemCoreClock = 96000000;
	
  /* Connect base clock */
  LPC_CGU->BASE_SSP0_CLK = (1    << 11) |
                           (SRC_PLL1 << 24) ; /* PLL1 is SSP0 clock source        */

  LPC_CGU->BASE_LCD_CLK  = (1    << 11) |
                           (SRC_IDIV_E << 24) ; /* IDIVE is clock source            */

//#warning -- SetClock() in system_LPC43xx is setting most clocks -- need to move it into the app someday

	
	// IDIV_D used for CLKOUT which is the clock to the camera
	
  	LPC_CGU->IDIVD_CTRL = (0              <<  0) |  /* Disable Power-down       */
                        (7     <<  2) |  /* IDIV                     */
                        (SRC_PLL1  << 24) ;  /* Clock source             */
	
// this Falcon requires ALL SCU_CLK to be set to EMC_CLK* when SDRAM is used --  "feature"	
//  	LPC_SCU->SFSP1_19  = 4;  /* P1_19:  CLKOUT       */
	
	LPC_SCU->SFSCLK_3 = 1;  /* CLK3   -- CLKOUT                            */
	
	LPC_CGU->BASE_OUT_CLK = SRC_IDIV_D <<24;		// camera clock
	
  /* Connect base clock */
  	LPC_CGU->BASE_APB1_CLK = (1    << 11) |
                           (SRC_XTAL << 24) ; /* XTAL is APB1 clock source        */

	LPC_CGU->BASE_PERIPH_CLK =	(SRC_PLL1 << 24);		// PLL1 SGPIO

}

void SGPIO_IRQHandler (void)                    //Handles all SGPIO interrupts
{
	uint32_t interruptvar = 0;										//Variable used to store the interrupt value, what slice had an interrupt.
	volatile unsigned int *sgpio_shadow = &LPC_SGPIO->REG_SS[0];
  interruptvar = LPC_SGPIO->STATUS_1;	
	sgpio_clear_status;		// empty buffers at the beginning of a frame
	if (OneFrameBegin==1)
	{
		if(interruptvar & 1)
		{
		 *pixelPTR++ = sgpio_shadow[11] ;
		 *pixelPTR++ = sgpio_shadow[5]  ;
		 *pixelPTR++ = sgpio_shadow[10] ;
		 *pixelPTR++ = sgpio_shadow[2]  ;
		 *pixelPTR++ = sgpio_shadow[9]  ;
		 *pixelPTR++ = sgpio_shadow[4]  ;
		 *pixelPTR++ = sgpio_shadow[8]  ;
		 *pixelPTR++ = sgpio_shadow[0]  ;
		
		if(col<CAM_WIDTH)
			col+=16;
		else if(row<CAM_HEIGHT && col==CAM_WIDTH)
		{

			row+=1;
			col=0;
		}
		else if( col==CAM_WIDTH && row==CAM_HEIGHT)
    {
			row=0;
			col=0;
		  
		  pixelPTR = (int *)CAM_BUF_START;
			OneFrameDone=1;
		}
	}
	
	}
	
}

/*-----------------------------------------------------------------------------
  Main function
 *----------------------------------------------------------------------------*/
int main (void) {
	
 #ifdef SPIFI_BOOT	
	checkSPIFIstart();		// same code shared in SPIFI as in RAM, when in SPIFI, it copies itself to RAM and call it
 #endif
	
	ClockInit();
  SystemCoreClockUpdate();              /* Update SystemCoreClock variable    */
  SysTick_Config(SystemCoreClock/100-1);/* Generate interrupt each 10 ms      */
	
  setup_SGPIO_image_capture();
  camera_setup();

  GLCD_Init();                          /* Graphical Display Init             */

  GLCD_Clear (White);
  GLCD_SetBackColor  (Blue);
  GLCD_SetTextColor  (White);
  GLCD_DisplayString (0, 0, 1, "       MCB4300      ");
  GLCD_DisplayString (1, 0, 1, "    Go brucee ...   ");
  GLCD_SetBackColor  (White);
  GLCD_SetTextColor  (Blue);
  
  GLCD_DisplayString (3, 0, 1, " display is up      ");
  GLCD_DisplayString (4, 0, 1, "   switch example   ");
  GLCD_DisplayString (5, 0, 1, "        mode        ");

  GLCD_DisplayString (8, 0, 1, "  Press any key to  ");
  GLCD_DisplayString (9, 0, 1, "      continue      ");

  camera_setup();
NVIC_EnableIRQ(SGPIO_IRQn);        			//Enable SGPIO Interrupt
LPC_SGPIO->SET_EN_1 = 0x0001;					//interrupt when slice 0 switches data register
  while (1) {

		loop_capture_image();		// stay here in  RAM
	}
}
