/***********************************************************************
* $Id:: error.h 128 2011-01-21 01:37:26Z usb10131               $
*
* Project: LPC chip software
*
* Description:
*     This file contains unified error codes to be used across driver,
* middleware, applications, hal and demo software. 
*
* Notes:
*
****************************************************************************
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* products. This software is supplied "AS IS" without any warranties.
* NXP Semiconductors assumes no responsibility or liability for the
* use of the software, conveys no license or title under any patent,
* copyright, or mask work right to the product. NXP Semiconductors
* reserves the right to make changes in the software without
* notification. NXP Semiconductors also make no representation or
* warranty that such application will be suitable for the specified
* use without further testing or modification.

* Permission to use, copy, modify, and distribute this software and its 
* documentation is hereby granted, under NXP Semiconductors 
* relevant copyright in the software, without fee, provided that it 
* is used in conjunction with NXP Semiconductors microcontrollers.  This 
* copyright, permission, and disclaimer notice must appear in all copies of 
* this code.

****************************************************************************/

#ifndef __LPC_ERROR_H__
#define __LPC_ERROR_H__

/** \file
 *  \brief Error code returned by Boot ROM drivers/library functions.
 *  \ingroup Common
 *
 *  This file contains unified error codes to be used across driver,
 *  middleware, applications, hal and demo software.
 *
 */

/** Error code returned by Boot ROM drivers/library functions 
* 
*  Error codes are a 32-bit value with :
*      - The 16 MSB contains the peripheral code number
*      - The 16 LSB contains an error code number associated to that peripheral
*   
*/

typedef enum
{
  /**\b 0x00000000*/ LPC_OK=0, /**< enum value returned on Success */
					 ERROR, /**< enum value returned on general failure */
  /*  I2C related errors   */
  ERR_I2C_BASE = 0x00060000,
/*0x00060001*/	 ERR_I2C_NAK=ERR_I2C_BASE+1,
/*0x00060002*/	 ERR_I2C_BUFFER_OVERFLOW,    
/*0x00060003*/	 ERR_I2C_BYTE_COUNT_ERR,     
/*0x00060004*/	 ERR_I2C_LOSS_OF_ARBRITRATION,    
/*0x00060005*/	 ERR_I2C_SLAVE_NOT_ADDRESSED,     
/*0x00060006*/	 ERR_I2C_LOSS_OF_ARBRITRATION_NAK_BIT,   
/*0x00060007*/	 ERR_I2C_GENERAL_FAILURE,         
/*0x00060008*/	 ERR_I2C_REGS_SET_TO_DEFAULT

} ErrorCode_t;



#define offsetof(s,m)   (int)&(((s *)0)->m)
#define COMPILE_TIME_ASSERT(pred)    switch(0){case 0:case pred:;}

#endif /* __LPC_ERROR_H__ */
