;/******************************************************************************
; * @file:    startup_LPC11xx.s
; * @purpose: CMSIS ARM Cortex-M0 Core Device Startup File
;
; * @version: V1.02
; * @date:    27. July 2009
; *------- <<< Use Configuration Wizard in Context Menu >>> ------------------
; *
; * Copyright (C) 2009 ARM Limited. All rights reserved.
; * ARM Limited (ARM) is supplying this software for use with Cortex-M3
; * processor based microcontrollers.  This file can be freely distributed
; * within development tools that are supporting such ARM based processors.
; *
; * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
; * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
; * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
; * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
; * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
; *
; *****************************************************************************/


; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Stack_Size      EQU     0x00000200

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp


; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Heap_Size       EQU     0x00000000

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit


                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset

                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors

__Vectors       DCD     __initial_sp              ; Top of Stack
                DCD     Reset_Handler             ; Reset Handler
                DCD     NMI_Handler               ; NMI Handler
                DCD     HardFault_Handler         ; Hard Fault Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     SVC_Handler               ; SVCall Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     PendSV_Handler            ; PendSV Handler
                DCD     SysTick_Handler           ; SysTick Handler

                ; External Interrupts
				DCD     WAKEUP_IRQHandler           ; WAKEUP PIO0.0 Interrupt
        		DCD     WAKEUP_IRQHandler           ; WAKEUP PIO0.1 Interrupt
        		DCD     WAKEUP_IRQHandler           ; WAKEUP PIO0.2 Interrupt
		        DCD     WAKEUP_IRQHandler           ; WAKEUP PIO0.3 Interrupt
		        DCD     WAKEUP_IRQHandler           ; WAKEUP PIO0.4 Interrupt
		        DCD     WAKEUP_IRQHandler           ; WAKEUP PIO0.5 Interrupt
		        DCD     WAKEUP_IRQHandler           ; WAKEUP PIO0.6 Interrupt
		        DCD     WAKEUP_IRQHandler           ; WAKEUP PIO0.7 Interrupt
		        DCD     WAKEUP_IRQHandler           ; WAKEUP PIO0.8 Interrupt
		        DCD     WAKEUP_IRQHandler           ; WAKEUP PIO0.9 Interrupt
		        DCD     WAKEUP_IRQHandler           ; WAKEUP PIO0.10 Interrupt
		        DCD     WAKEUP_IRQHandler           ; WAKEUP PIO0.11 Interrupt
		        DCD     WAKEUP_IRQHandler           ; WAKEUP PIO1.0 Interrupt
		        DCD     0                           ; Reserved
		        DCD     SSP1_IRQHandler             ; SSP1 Interrupt
		        DCD     I2C_IRQHandler              ; I2C Interrupt
		        DCD     TIMER16_0_IRQHandler        ; 16-bit Counter Timer0 Interrupt
		        DCD     TIMER16_1_IRQHandler        ; 16-bit Counter Timer1 Interrupt
		        DCD     TIMER32_0_IRQHandler        ; 32-bit Counter Timer0 Interrupt
		        DCD     TIMER32_1_IRQHandler        ; 32-bit Counter Timer1 Interrupt
		        DCD     SSP0_IRQHandler             ; SSP0 Interrupt
		        DCD     UART_IRQHandler             ; UART Interrupt
		        DCD     0                           ; Reserved
		        DCD     0                           ; Reserved
		        DCD     ADC_IRQHandler              ; ADC Interrupt
		        DCD     WDT_IRQHandler              ; WDT Interrupt
		        DCD     BOD_IRQHandler              ; BOD Interrupt
		        DCD     0                           ; Reserved
		        DCD     PIOINT3_IRQHandler          ; PIO INT3 Interrupt
		        DCD     PIOINT2_IRQHandler          ; PIO INT2 Interrupt
		        DCD     PIOINT1_IRQHandler          ; PIO INT1 Interrupt
		        DCD     PIOINT0_IRQHandler          ; PIO INT0 Interrupt


                AREA    |.text|, CODE, READONLY


; Reset Handler

Reset_Handler   PROC
                EXPORT  Reset_Handler             [WEAK]
                IMPORT  SystemInit
                IMPORT  __main
                LDR     R0, =SystemInit
                BLX     R0
                LDR     R0, =__main
                BX      R0
                ENDP


; Dummy Exception Handlers (infinite loops which can be modified)

NMI_Handler     PROC
                EXPORT  NMI_Handler               [WEAK]
                B       .
                ENDP
HardFault_Handler\
                PROC
                EXPORT  HardFault_Handler         [WEAK]
                B       .
                ENDP
SVC_Handler     PROC
                EXPORT  SVC_Handler               [WEAK]
                B       .
                ENDP
PendSV_Handler  PROC
                EXPORT  PendSV_Handler            [WEAK]
                B       .
                ENDP
SysTick_Handler PROC
                EXPORT  SysTick_Handler           [WEAK]
                B       .
                ENDP

Default_Handler PROC
				EXPORT  WAKEUP_IRQHandler           	[WEAK]
				EXPORT  SSP1_IRQHandler           		[WEAK]
				EXPORT  I2C_IRQHandler           		[WEAK]
				EXPORT  TIMER16_0_IRQHandler        	[WEAK]
				EXPORT  TIMER16_1_IRQHandler           	[WEAK]
				EXPORT  TIMER32_0_IRQHandler           	[WEAK]
				EXPORT  TIMER32_1_IRQHandler           	[WEAK]
				EXPORT  SSP0_IRQHandler           		[WEAK]
				EXPORT  UART_IRQHandler           		[WEAK]
				EXPORT  ADC_IRQHandler           		[WEAK]
				EXPORT  WDT_IRQHandler           		[WEAK]
				EXPORT  BOD_IRQHandler           		[WEAK]
				EXPORT  PIOINT3_IRQHandler           	[WEAK]
				EXPORT  PIOINT2_IRQHandler           	[WEAK]
				EXPORT  PIOINT1_IRQHandler           	[WEAK]
				EXPORT  PIOINT0_IRQHandler           	[WEAK]

WAKEUP_IRQHandler
SSP1_IRQHandler
I2C_IRQHandler
TIMER16_0_IRQHandler
TIMER16_1_IRQHandler
TIMER32_0_IRQHandler
TIMER32_1_IRQHandler
SSP0_IRQHandler
UART_IRQHandler
ADC_IRQHandler
WDT_IRQHandler
BOD_IRQHandler
PIOINT3_IRQHandler
PIOINT2_IRQHandler
PIOINT1_IRQHandler
PIOINT0_IRQHandler

				B       .
				ENDP


                ALIGN


; User Initial Stack & Heap

                IF      :DEF:__MICROLIB

                EXPORT  __initial_sp
                EXPORT  __heap_base
                EXPORT  __heap_limit

                ELSE

                IMPORT  __use_two_region_memory
                EXPORT  __user_initial_stackheap
__user_initial_stackheap

                LDR     R0, =  Heap_Mem
                LDR     R1, =(Stack_Mem + Stack_Size)
                LDR     R2, = (Heap_Mem +  Heap_Size)
                LDR     R3, = Stack_Mem
                BX      LR

                ALIGN

                ENDIF


                END
