/*
===============================================================================
 Name        : main.c
 Author      :
 Version     :
 Copyright   : Copyright (C)
 Description : main definition
===============================================================================
*/
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "crt_flash_if.h"

extern struct FlashDevice const FlashDevice;

extern int Init (unsigned long adr, unsigned long clk, unsigned long fnc);
extern int UnInit (unsigned long fnc);
extern int EraseSector (unsigned long adr);
extern int ProgramPage (unsigned long adr, unsigned long sz, unsigned char *buf);

unsigned char buf[1024];
 char itoa_buf[32];
int main(void)
{
	unsigned int addr;
	unsigned int sector_addr = 0xFFFFFFFF;
	unsigned int sector_size = 0xFFFFFFFF;
	unsigned int allocated = 0;
	int idx;
	int no_blocks = 0;
	int no_sectors = 0;
	int status = 0;
	volatile int pattern = 0;

    puts("Flash Driver test program starting\n") ;

	// Flash driver function initialization
	// (1 - Erase, 2 - Program, 3 - Verify)
	status = Init(FlashDevice.DevAdr, 16000, 1);
	if (!status)
		status = Init(FlashDevice.DevAdr, 16000, 2);
	if (!status)
		status = Init(FlashDevice.DevAdr, 16000, 3);

	// no_blocks is the number of entries in FlashDevice.sectors
	for (idx = 0; idx < SECTOR_NUM; idx++)
	{
	  if ((FlashDevice.sectors[idx].szSector   == 0xFFFFFFFF)
	  &&  (FlashDevice.sectors[idx].AddrSector == 0xFFFFFFFF))
		break;
	  no_blocks++;
	} // end for

	// Rules check for loadable flash driver
	for (idx = 0; idx < no_blocks; idx++)
	{
	  if ((FlashDevice.sectors[idx].AddrSector == 0xFFFFFFFF)
	  &&  (FlashDevice.szDev - allocated))
	  {
		no_sectors += (FlashDevice.szDev - allocated) / FlashDevice.sectors[idx - 1].szSector;
		break;
	  }
	  else if (sector_addr == -1)
	  {
		sector_addr = FlashDevice.sectors[idx].AddrSector;
		sector_size = FlashDevice.sectors[idx].szSector;
		if (!allocated)
		{
		  no_sectors += (FlashDevice.szDev / sector_size);
		  allocated = FlashDevice.szDev;
		}
	  }
	  else
	  {
		allocated = FlashDevice.sectors[idx].AddrSector - FlashDevice.sectors[idx - 1].AddrSector;
		no_sectors += allocated / FlashDevice.sectors[idx].szSector;
	  }
	}
	// populate buffer with pattern
	for (idx = 0; idx < FlashDevice.szPage; idx++)
	{
		if (pattern)
			buf[idx] = pattern;
		else
			buf[idx] = idx % 256;
	}
	// address of flash device
	addr = sector_addr = FlashDevice.DevAdr;
	for (idx = 0; idx < no_sectors; idx++)
	{
		if (sector_addr == addr)
		{
			status = EraseSector(addr);			// erase sector
			sector_addr = addr + sector_size;	// next sector address
			if (status)
			{
				//printf("Erase sector %d (0x%x) failed.\n", idx, addr);
				puts("Erase sector failed\n");
				break;
			} else {
				// null
			}
		}
		do {
			// program sector by page
			status = ProgramPage(addr, FlashDevice.szPage, buf);
			// verify page
			if (!status)
				status = memcmp((void *)addr, buf, FlashDevice.szPage);
			if (status)
			{
				//printf("Program sector %d failed at 0x%x.\n", idx, addr);
				puts("Program sector failed\n");
				break;
			} else {
				// null
			}
			addr += FlashDevice.szPage;
		} while (addr != sector_addr);
		if (status)  break;
	}

	if (EraseChip)
		status = EraseChip();

	UnInit(1);
	UnInit(2);
	UnInit(3);

    puts("Finished\n") ;

	return(0);
}
