;/******************************************************************************
; * @file:    startup_LPC18xx_m0s.s (M0 serial core inside LPC43xx)
; * @purpose: CMSIS ARM Cortex-M0 Core Device Startup File
;
; * @version: V1.02
; * @date:    27. July 2009
; *------- <<< Use Configuration Wizard in Context Menu >>> ------------------
; *
; * Copyright (C) 2009 ARM Limited. All rights reserved.
; * ARM Limited (ARM) is supplying this software for use with Cortex-M3
; * processor based microcontrollers.  This file can be freely distributed
; * within development tools that are supporting such ARM based processors.
; *
; * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
; * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
; * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
; * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
; * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
; *
; *****************************************************************************/


; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Stack_Size      EQU     0x00000200

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp


; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Heap_Size       EQU     0x00000000

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit


                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset

                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors

__Vectors       DCD     __initial_sp              ; Top of Stack
                DCD     Reset_Handler             ; Reset Handler
                DCD     NMI_Handler               ; NMI Handler
                DCD     HardFault_Handler         ; Hard Fault Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     SVC_Handler               ; SVCall Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     PendSV_Handler            ; PendSV Handler
                DCD     SysTick_Handler           ; SysTick Handler

                ; External Interrupts				
				DCD		DAC_IRQHandler	 			; 16 D/A Converter
				DCD		M3_IRQHandler				; 17 M3
				DCD		DMA_IRQHandler				; 18 General Purpose DMA
				DCD		EZH_IRQHandler				; 19 EZH/EDM
				DCD		SGPIO_INPUT_IRQHandler		; 20 SGPIO INPUT
				DCD		SGPIO_MATCH_IRQHandler		; 21 SGPIO MATCH
				DCD		SGPIO_SHIFT_IRQHandler		; 22 SGPIO SHIFT
				DCD		SGPIO_POS_IRQHandler		; 23 SGPIO POS
				DCD		USB0_IRQHandler				; 24 USB0
				DCD		USB1_IRQHandler				; 25 USB1
				DCD		SCT_IRQHandler				; 26 State Configurable Timer
				DCD		RIT_IRQHandler				; 27 Repetitive Interrupt Timer
				DCD		GINT0_IRQHandler			; 28 GINT0
				DCD		TIMER1_IRQHandler			; 29 Timer1
				DCD		TIMER2_IRQHandler			; 30 Timer2
				DCD		GPIO5_IRQHandler			; 31 GPIO5
				DCD		MCPWM_IRQHandler			; 32 Motor Control PWM
				DCD		ADC0_IRQHandler				; 33 A/D Converter 0
				DCD		I2C0_IRQHandler				; 34 I2C0
				DCD		I2C1_IRQHandler				; 35 I2C1
				DCD		SPI_IRQHandler				; 36 SPI
				DCD		ADC1_IRQHandler				; 37 A/D Converter 1
				DCD		SSP0_SSP1_IRQHandler		; 38 SSP0 and SSP1 or'ed
				DCD		EVRT_IRQHandler				; 39 Event Router
				DCD		UART0_IRQHandler			; 40 UART0
				DCD		UART1_IRQHandler			; 41 UART1
				DCD		UART2_CAN1_IRQHandler		; 42 UART2 and C_CAN1 or'ed
				DCD		UART3_IRQHandler			; 43 UART3
				DCD		I2S0_I2S1_QEI_IRQHandler	; 44 I2S0, I2s1 and QEI or'ed
				DCD		CAN0_IRQHandler				; 45 C_CAN0
				DCD		SPIFI_VADC_IRQHandler		; 46 SPIFI and VADC or'ed
				DCD		M0a_IRQHandler				; 47 M0a

                AREA    |.text|, CODE, READONLY
				

; Reset Handler

Reset_Handler   PROC
                EXPORT  Reset_Handler             [WEAK]
;                IMPORT  SystemInit
;				ENTRY
;                IMPORT  M0_main					; GP modified
;                LDR     R0, =SystemInit
;                BLX     R0
;c                LDR     R0, = M0_main
;                BX      R0
                IMPORT  __main
c                LDR     R0, =__main
                BX      R0
                ENDP


; Dummy Exception Handlers (infinite loops which can be modified)

NMI_Handler     PROC
                EXPORT  NMI_Handler               [WEAK]
                B       .
                ENDP
HardFault_Handler\
                PROC
                EXPORT  HardFault_Handler         [WEAK]
                B       .
                ENDP
SVC_Handler     PROC
                EXPORT  SVC_Handler               [WEAK]
                B       .
                ENDP
PendSV_Handler  PROC
                EXPORT  PendSV_Handler            [WEAK]
                B       .
                ENDP
SysTick_Handler PROC
                EXPORT  SysTick_Handler           [WEAK]
                B       .
                ENDP

Default_Handler PROC

				EXPORT	DAC_IRQHandler	 		[WEAK]
				EXPORT	M3_IRQHandler			[WEAK]
				EXPORT	DMA_IRQHandler			[WEAK]
				EXPORT	EZH_IRQHandler			[WEAK]
				EXPORT	SGPIO_INPUT_IRQHandler	[WEAK]
				EXPORT	SGPIO_MATCH_IRQHandler	[WEAK]
				EXPORT	SGPIO_SHIFT_IRQHandler	[WEAK]
				EXPORT	SGPIO_POS_IRQHandler	[WEAK]
				EXPORT	USB0_IRQHandler			[WEAK]
				EXPORT	USB1_IRQHandler			[WEAK]
				EXPORT	SCT_IRQHandler			[WEAK]
				EXPORT	RIT_IRQHandler			[WEAK]
				EXPORT	GINT0_IRQHandler		[WEAK]
				EXPORT	TIMER1_IRQHandler		[WEAK]
				EXPORT	TIMER2_IRQHandler		[WEAK]
				EXPORT	GPIO5_IRQHandler		[WEAK]
				EXPORT	MCPWM_IRQHandler		[WEAK]
				EXPORT	ADC0_IRQHandler			[WEAK]
				EXPORT	I2C0_IRQHandler			[WEAK]
				EXPORT	I2C1_IRQHandler			[WEAK]
				EXPORT	SPI_IRQHandler			[WEAK]
				EXPORT	ADC1_IRQHandler			[WEAK]
				EXPORT	SSP0_SSP1_IRQHandler	[WEAK]
				EXPORT	EVRT_IRQHandler			[WEAK]
				EXPORT	UART0_IRQHandler		[WEAK]
				EXPORT	UART1_IRQHandler		[WEAK]
				EXPORT	UART2_CAN1_IRQHandler	[WEAK]
				EXPORT	UART3_IRQHandler		[WEAK]
				EXPORT	I2S0_I2S1_QEI_IRQHandler	[WEAK]
				EXPORT	CAN0_IRQHandler			[WEAK]
				EXPORT	SPIFI_VADC_IRQHandler	[WEAK]
				EXPORT	M0a_IRQHandler			[WEAK]

DAC_IRQHandler
M3_IRQHandler
DMA_IRQHandler
EZH_IRQHandler
SGPIO_INPUT_IRQHandler
SGPIO_MATCH_IRQHandler
SGPIO_SHIFT_IRQHandler
SGPIO_POS_IRQHandler
USB0_IRQHandler
USB1_IRQHandler
SCT_IRQHandler
RIT_IRQHandler
GINT0_IRQHandler
TIMER1_IRQHandler
TIMER2_IRQHandler
GPIO5_IRQHandler
MCPWM_IRQHandler
ADC0_IRQHandler
I2C0_IRQHandler
I2C1_IRQHandler
SPI_IRQHandler
ADC1_IRQHandler
SSP0_SSP1_IRQHandler
EVRT_IRQHandler
UART0_IRQHandler
UART1_IRQHandler
UART2_CAN1_IRQHandler
UART3_IRQHandler
I2S0_I2S1_QEI_IRQHandler
CAN0_IRQHandler
SPIFI_VADC_IRQHandler
M0a_IRQHandler

				B       .
				ENDP


                ALIGN


; User Initial Stack & Heap

                IF      :DEF:__MICROLIB

                EXPORT  __initial_sp
                EXPORT  __heap_base
                EXPORT  __heap_limit

                ELSE

                IMPORT  __use_two_region_memory
                EXPORT  __user_initial_stackheap
__user_initial_stackheap

                LDR     R0, =  Heap_Mem
                LDR     R1, =(Stack_Mem + Stack_Size)
                LDR     R2, = (Heap_Mem +  Heap_Size)
                LDR     R3, = Stack_Mem
                BX      LR

                ALIGN

                ENDIF


                END
