/*****************************************************************************
 *   uart.h:  Header file for NXP LPC18xx Family Microprocessors
 *
 *   Copyright(C) 2011, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2011.06.22  ver 1.00    Initial version
 *
******************************************************************************/
#ifndef __UART_H 
#define __UART_H

#define AUTOBAUD1_ENABLE		0
#define FDR_CALIBRATION			0

#define IER_RBR		(0x01<<0)
#define IER_THRE	(0x01<<1)
#define IER_RLS		(0x01<<2)
#define IER_ABEO	(0x01<<8)
#define IER_ABTO	(0x01<<9)

#define IIR_PEND	0x01
#define IIR_RLS		0x03
#define IIR_RDA		0x02
#define IIR_CTI		0x06
#define IIR_THRE	0x01
#define IIR_ABEO	(0x01<<8)
#define IIR_ABTO	(0x01<<9)

#define LSR_RDR		(0x01<<0)
#define LSR_OE		(0x01<<1)
#define LSR_PE		(0x01<<2)
#define LSR_FE		(0x01<<3)
#define LSR_BI		(0x01<<4)
#define LSR_THRE	(0x01<<5)
#define LSR_TEMT	(0x01<<6)
#define LSR_RXFE	(0x01<<7)

uint32_t uart1_set_divisors(uint32_t UARTClk, uint32_t baudrate);
uint32_t UARTInit( uint32_t portNum, uint32_t Baudrate );
void UART0_IRQHandler( void );
void UART1_IRQHandler( void );
void UART2_IRQHandler( void );
void UART3_IRQHandler( void );
void UARTSend( uint32_t portNum, uint8_t *BufferPtr, uint32_t Length );

#endif /* end __UART_H */
/*****************************************************************************
**                            End Of File
******************************************************************************/
