/*********************************************************************
*                SEGGER MICROCONTROLLER GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 2003-2012     SEGGER Microcontroller GmbH & Co KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

----------------------------------------------------------------------
File    : I2C_PCA9532.h
Purpose : Generic I2C_PCA9532 module header
--------  END-OF-HEADER  ---------------------------------------------
*/

#ifndef I2C_PCA9532_H                       /* avoid multiple inclusion */
#define I2C_PCA9532_H

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define I2C_PCA9532_PWM0   2

/*********************************************************************
*
*       Functions
*
**********************************************************************
*/
void I2C_PCA9532_Init        (uint32_t ClockRate);
uint8_t   I2C_PCA9532_GetPinState (uint32_t I2CBaseAddr, uint8_t Addr, uint16_t * pState);
uint8_t   I2C_PCA9532_SetPinSelect(uint32_t I2CBaseAddr, uint8_t Addr, uint8_t Pin, uint8_t State);
uint8_t   I2C_PCA9532_SetPwm      (uint32_t I2CBaseAddr, uint8_t Addr, uint8_t Pin, uint8_t PwmNumber, uint8_t Pwm, uint8_t Psc);

#endif                                  /* avoid multiple inclusion */

/*************************** End of file ****************************/
