/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2012  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.18 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  NXP Semiconductors USA, Inc.  whose
registered  office  is  situated  at  1109 McKay Dr, M/S 76, San Jose, 
CA 95131, USA  solely for  the  purposes  of  creating  libraries  for 
NXPs M0, M3/M4 and  ARM7/9 processor-based  devices,  sublicensed  and
distributed under the terms and conditions of the NXP End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : LCDConf.h
Purpose     : Display driver configuration file
----------------------------------------------------------------------*/

#ifndef LCDCONF_H
#define LCDCONF_H

#include "GUI.h"
#include <stddef.h>

#ifndef _WINDOWS
  #include "GUIDRV_Lin.h"
  #include "LCDConf.h"
#endif

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/

//
// LCD configuration for 3.2" Truly display
//
#define HBP_TRULY_3_2   28       // Horizontal back porch in clocks
#define HFP_TRULY_3_2   10       // Horizontal front porch in clocks
#define HSW_TRULY_3_2   2        // HSYNC pulse width in clocks
#define PPL_TRULY_3_2   240      // Pixels per line
#define VBP_TRULY_3_2   2        // Vertical back porch in clocks
#define VFP_TRULY_3_2   1        // Vertical front porch in clocks
#define VSW_TRULY_3_2   2        // VSYNC pulse width in clocks
#define LPP_TRULY_3_2   320      // Lines per panel
#define IOE_TRULY_3_2   0        // Invert output enable, 1 = invert
#define IPC_TRULY_3_2   1        // Invert panel clock, 1 = invert
#define IHS_TRULY_3_2   1        // Invert HSYNC, 1 = invert
#define IVS_TRULY_3_2   1        // Invert VSYNC, 1 = invert
#define ACB_TRULY_3_2   1        // AC bias frequency in clocks (not used)
#define BPP_TRULY_3_2   16       // Bits per pixel b110 = 16 bpp 5:6:5 mode
#define CLK_TRULY_3_2   8200000  // Optimal clock rate (Hz) between 1-8.22 MHz according to SSD1289 datasheet
#define LCD_TRULY_3_2   0        // Panel type; 0: LCD TFT panel
#define DUAL_TRULY_3_2  0        // No dual panel

//
// Touch screen
//
#define TOUCH_CS_BIT                   20

//
// Touch controller settings for 3.2" Truly display
//
#define TOUCH_TRULY_240_320_AD_LEFT    3686
#define TOUCH_TRULY_240_320_AD_RIGHT   205
#define TOUCH_TRULY_240_320_AD_TOP     3842
#define TOUCH_TRULY_240_320_AD_BOTTOM  267

//
// Touch controller settings for 4.3" display board
//
#define TOUCH_BOARD_480_272_AD_LEFT    500
#define TOUCH_BOARD_480_272_AD_RIGHT   3650
#define TOUCH_BOARD_480_272_AD_TOP     3300
#define TOUCH_BOARD_480_272_AD_BOTTOM  610

//
// Touch controller settings for 7" display board
//
// orig
//#define TOUCH_BOARD_800_480_AD_LEFT    750
//#define TOUCH_BOARD_800_480_AD_RIGHT   3200
//#define TOUCH_BOARD_800_480_AD_TOP     3320
//#define TOUCH_BOARD_800_480_AD_BOTTOM  870
// better
/*#define TOUCH_BOARD_800_480_AD_LEFT    3440
#define TOUCH_BOARD_800_480_AD_RIGHT   600
#define TOUCH_BOARD_800_480_AD_TOP     750
#define TOUCH_BOARD_800_480_AD_BOTTOM  2930
*/
/*#define TOUCH_BOARD_800_480_AD_LEFT    3500
#define TOUCH_BOARD_800_480_AD_RIGHT   490
#define TOUCH_BOARD_800_480_AD_TOP     610
#define TOUCH_BOARD_800_480_AD_BOTTOM  3100*/
#define TOUCH_BOARD_800_480_AD_LEFT    3500
#define TOUCH_BOARD_800_480_AD_RIGHT   490
#define TOUCH_BOARD_800_480_AD_TOP     550
#define TOUCH_BOARD_800_480_AD_BOTTOM  3160
//
// Display framebuffer size
// These values can be reduced if using a smaller display and might have
// to be adjusted if using virtual screens. The values will be checked
// during emWin init.
//
#define FB_XSIZE  800
#define FB_YSIZE  480
#define VY_IMAGE_SIZE			1400
#define VX_IMAGE_SIZE     800
//
// Pixel width in bytes
//
#define LCD_BITSPERPIXEL 16  //(5:6:5) mode
#define PIXEL_WIDTH  (LCD_BITSPERPIXEL/8) 
//
// SSP
//
#define SSPSR_TNF      (1 << 1)  // Transmit FIFO not full
#define SSPSR_RNE      (1 << 2)  // Receive FIFO not empty
#define SSPSR_BSY      (1 << 4)  // Busy
#define SSP_CLOCK      3000000
#define SSP_FIFO_SIZE  8

#define SSP_MODE_LCD   0
#define SSP_MODE_TS    1

#define ADS_START                      (1 << 7)
#define ADS_A2A1A0_d_y                 (1 << 4)  // Differential
#define ADS_A2A1A0_d_z1                (3 << 4)  // Differential
#define ADS_A2A1A0_d_z2                (4 << 4)  // Differential
#define ADS_A2A1A0_d_x                 (5 << 4)  // Differential
#define ADS_A2A1A0_vaux                (6 << 4)  // Non-differential
#define ADS_12_BIT                     (0 << 3)
#define ADS_SER                        (1 << 2)  // Non-differential
#define ADS_DFR                        (0 << 2)  // Differential
#define ADS_PD10_ADC_ON                (1 << 0)  // ADC on
#define ADS_PD10_REF_ON                (2 << 0)  // vREF on + penirq
#define ADS_PD10_ALL_ON                (3 << 0)  // ADC + vREF on

#define READ_12BIT_DFR(D, ADC, VREF)  (ADS_START                    | \
                                       D                            | \
                                       ADS_12_BIT                   | \
                                       ADS_DFR                      | \
                                       (ADC  ? ADS_PD10_ADC_ON : 0) | \
                                       (VREF ? ADS_PD10_REF_ON : 0))


#define READ_12BIT_SER(x)              (ADS_START  | /* Single-ended samples need to power   */ \
                                        x          | /* up reference voltage first; therefor */ \
                                        ADS_12_BIT | /* we leave both VREF and ADC powered.  */ \
                                        ADS_SER)

#define REF_ON                         (READ_12BIT_DFR(ADS_A2A1A0_d_x,  1, 1))
#define READ_Y(VREF)                   (READ_12BIT_DFR(ADS_A2A1A0_d_y,  1, VREF))
#define READ_Z1(VREF)                  (READ_12BIT_DFR(ADS_A2A1A0_d_z1, 1, VREF))
#define READ_Z2(VREF)                  (READ_12BIT_DFR(ADS_A2A1A0_d_z2, 1, VREF))
#define READ_X(VREF)                   (READ_12BIT_DFR(ADS_A2A1A0_d_x,  1, VREF))
#define PWRDOWN                        (READ_12BIT_DFR(ADS_A2A1A0_d_y,  0, 0))

#define TS_DEBOUNCE_MAX                10
#define TS_DEBOUNCE_TOL                3

#ifndef   ABS
  #define ABS(x)                       (((int32_t)(x)) < 0 ? (-x) : (x))
#endif


//
// LCDC
//
#define LCDC_BPP_16_565    6     // Bits per pixel b110 = 16 bpp 5:6:5 mode
#define LCDC_TFT           1     // TFT value for LCDC

#define BGR                1     // Swap red and blue

#define BCD_BIT            26    // Bypass pixel clock divider
#define LCD_BACKLIGHT_BIT  18    // P1.18
#define LCD_REG_BIT        19    // P0.19

/*********************************************************************
*
*       Types
*
**********************************************************************
*/

typedef struct {
  U8  HBP;   // Horizontal back porch in clocks
  U8  HFP;   // Horizontal front porch in clocks
  U8  HSW;   // HSYNC pulse width in clocks
  U16 PPL;   // Pixels per line
  U8  VBP;   // Vertical back porch in clocks
  U8  VFP;   // Vertical front porch in clocks
  U8  VSW;   // VSYNC pulse width in clocks
  U16 LPP;   // Lines per panel
  U8  IOE;   // Invert output enable, 1 = invert
  U8  IPC;   // Invert panel clock, 1 = invert
  U8  IHS;   // Invert HSYNC, 1 = invert
  U8  IVS;   // Invert VSYNC, 1 = invert
  U8  ACB;   // AC bias frequency in clocks (not used)
  U8  BPP;   // Maximum bits per pixel the display supports
  U32 Clk;   // Optimal clock rate (Hz)
  U8  LCD;   // LCD panel type
  U8  Dual;  // Dual panel, 1 = dual panel display
} LCD_PARAM;

typedef struct {
  U16 LcdParams;
  U16 LcdInit;
  U16 PowerDown;
  U16 Touch;
  U16 End;
} EEPROM_CONFIG_OFFS;

//
// LCD
//
extern LCD_PARAM          _LcdParams;
extern U8                 _Display;

//
// Touch screen results
//
extern int _TouchX;
extern int _TouchY;
extern U32 _aVRAM[];

//
// LCD types
//
enum {
  DISPLAY_TRULY_240_320,
  DISPLAY_BOARD_480_272,
  DISPLAY_BOARD_800_480
};
extern void InitTouch(void);

#endif /* LCDCONF_H */

