;/**
; * @file       IEC60335_B_CPUregTestBIST_ARM.asm
; * @purpose    IEC60335 Class B CPU register tests library
; * @version    v1.0
; * @date       6-aug-2009
; * @author     nlv15840
;*/
;/*----------------------------------------------------------------------------
; * Software that is described herein is for illustrative purposes only
; * which provides customers with programming information regarding the
; * products. This software is supplied "AS IS" without any warranties.
; * NXP Semiconductors assumes no responsibility or liability for the
; * use of the software, conveys no license or title under any patent,
; * copyright, or mask work right to the product. NXP Semiconductors
; * reserves the right to make changes in the software without
; * notification. NXP Semiconductors also make no representation or
; * warranty that such application will be suitable for the specified
; * use without further testing or modification.
; **********************************************************************/

	AREA    |.text|, CODE, READONLY

	EXPORT	_CPUregTestLOW
	EXPORT	_CPUregTestMID
	EXPORT	_CPUregTestHIGH
	EXPORT	_CPUregTestSP
	EXPORT	_CPUregTestSPEC
			
	IMPORT	CPUregTestBIST_struct

;/* Test pattern definition */ 
pattern1 	EQU		0xAAAAAAAA
pattern2 	EQU		0xAAAAAAA8
pattern3 	EQU		0x55555555
pattern4 	EQU		0x55555554
pattern5 	EQU		0xA000009F
pattern6 	EQU		0x5000005F

;/* Test structure offset definitions */
testState  	EQU 	0x0
testPassed 	EQU 	0x4

Mode_SYS        EQU     0x1F
I_DISABLED      EQU     0x80            ; when I bit is set, IRQ is disabled
F_DISABLED      EQU     0x40            ; when F bit is set, FIQ is disabled

;/**************************************/
;/* START of the CPU register test LOW */
;/**************************************/
_CPUregTestLOW

;   /* Push ALL registers to stack */
    push    {r0-r12,r14}

;/*---- LOW REGISTERS r0-r7 --------------------
; *     First the low registers r0-r7 are tested
; */

;/* r0 register test:
; * Since r0 is the first register to be tested
; * and no other registers may be used, r0 should be tested
; * by only using immediate instructions.
; */
_cpu_low_test

;   /* Since cmp can only compare with an immediate
;    * 8-bit value, the bits to be tested needs to
;    * be shifted to the LSB's.
;    */
;   /* r0 - stuck at 0 test */
    mov    	r0, #0xAA
;   /* r0 - test r0[7:0] */
    cmp     r0, #0xAA
    bne     _cpu_low_test_fail
;   /* r0 - test r0[15:8] */
    mov    	r0, #0xAA00
    lsr     r0, r0, #8
    cmp     r0, #0xAA
    bne     _cpu_low_test_fail
;   /* r0 - test r0[23:16] */
    mov	    r0, #0xAA0000
    lsr     r0, r0, #16
    cmp     r0, #0xAA
    bne     _cpu_low_test_fail
;   /* r0 - test r0[31:24] */
    mov   	r0, #0xAA000000
    lsr     r0, r0, #24
    cmp     r0, #0xAA
    bne     _cpu_low_test_fail

;   /* r0 - inverted pattern and
;    * neighbour stuck test
;    */
    mov    	r0, #0x55
;   /* r0 - test r0[7:0] */
    cmp     r0, #0x55
    bne     _cpu_low_test_fail
;   /* r0 - test r0[15:8] */
    mov	    r0, #0x5500
    lsr     r0, r0, #8
    cmp     r0, #0x55
    bne     _cpu_low_test_fail
;   /* r0 - test r0[23:16] */
    mov	    r0, #0x550000
    lsr     r0, r0, #16
    cmp     r0, #0x55
    bne     _cpu_low_test_fail
;   /* r0 - test r0[31:24] */
    mov	    r0, #0x55000000
    lsr     r0, r0, #24
    cmp     r0, #0x55
    bne     _cpu_low_test_fail

;   /*!! NOW r0 is known good !!*/

_cpu_r0_test_pass
    b       _cpu_r1_r7_test

_cpu_r0_test_fail
    b       _cpu_low_test_fail


;/* Register r1-r7 test:
; * The registers under test will be written with
; * pattern1 = 0xAAAA.AAAA. Each register will be individually
; * compared to r0 for a pass/fail for the test.
; * The second part of the test will write the inverted pattern
; * in the register under test and pass/fail with a cmp
; */
_cpu_r1_r7_test

;   /* Load pattern1 in r0 */
    ldr     r0,=pattern1

;   /* Put patter1 in r1-r7 */
    mov     r1,r0
    cmp     r1,r0
    bne     _cpu_low_test_fail

    mov     r2,r0
    cmp     r2,r0
    bne     _cpu_low_test_fail

    mov     r3,r0
    cmp     r3,r0
    bne     _cpu_low_test_fail

    mov     r4,r0
    cmp     r4,r0
    bne     _cpu_low_test_fail

    mov     r5,r0
    cmp     r5,r0
    bne     _cpu_low_test_fail

    mov     r6,r0
    cmp     r6,r0
    bne     _cpu_low_test_fail

    mov     r7,r0
    cmp     r7,r0
    bne     _cpu_low_test_fail

;   /* Load pattern3 in r0 */
    ldr     r0,=pattern3

;   /* Put patter3 in r1-r7 */
    mov     r1,r0
    cmp     r1,r0
    bne     _cpu_low_test_fail

    mov     r2,r0
    cmp     r2,r0
    bne     _cpu_low_test_fail

    mov     r3,r0
    cmp     r3,r0
    bne     _cpu_low_test_fail

    mov     r4,r0
    cmp     r4,r0
    bne     _cpu_low_test_fail

    mov     r5,r0
    cmp     r5,r0
    bne     _cpu_low_test_fail

    mov     r6,r0
    cmp     r6,r0
    bne     _cpu_low_test_fail

    mov     r7,r0
    cmp     r7,r0
    bne     _cpu_low_test_fail

_cpu_low_test_pass

;   /* Indicate in the CPUregTestBIST_struct
;    * that r0-r7 tests passed.
;    */
    ldr     r1, =CPUregTestBIST_struct

;   /* Indicate LOW test has passed */
    mov     r0, #0xFF
    ldr     r2, [r1]
    orr     r0, r0, r2
    str     r0, [r1,#testState]

;   /* Indicate the test has passed */
    mov     r0, #0x01
    str     r0, [r1,#testPassed]

_cpu_low_test_fail
;   /* Pop the stack back */
    pop     {r0-r12,r14}
;   /* Branch back */
    bx      lr

;/**************************************/
;/* END of the CPU register test LOW   */
;/**************************************/

;/**************************************/
;/* START of the CPU register test MID */
;/**************************************/

;/*--- HIGH REGISTERS r4-r10 ---*/
_CPUregTestMID

;   /* Push ALL registers to stack */
    push    {r0-r12,r14}

;   /* Clear r0 */
    mov r0, #0x00

;   /* Load pattern1 in r0 */
    ldr     r0,=pattern1

;   /* Put patter1 in r4-r10 */
    mov     r4,r0
    cmp     r4,r0
    bne     _cpu_mid_test_fail

    mov     r5,r0
    cmp     r5,r0
    bne     _cpu_mid_test_fail

    mov     r6,r0
    cmp     r6,r0
    bne     _cpu_mid_test_fail

    mov     r7,r0
    cmp     r7,r0
    bne     _cpu_mid_test_fail

    mov     r8,r0
    cmp     r8,r0
    bne     _cpu_mid_test_fail

    mov     r9,r0
    cmp     r9,r0
    bne     _cpu_mid_test_fail

    mov     r10,r0
    cmp     r10,r0
    bne     _cpu_mid_test_fail

;   /* Load pattern3 in r0 */
    ldr     r0,=pattern3

;   /* Put patter1 in r4-r10 */
    mov     r4,r0
    cmp     r4,r0
    bne     _cpu_mid_test_fail

    mov     r5,r0
    cmp     r5,r0
    bne     _cpu_mid_test_fail

    mov     r6,r0
    cmp     r6,r0
    bne     _cpu_mid_test_fail

    mov     r7,r0
    cmp     r7,r0
    bne     _cpu_mid_test_fail

    mov     r8,r0
    cmp     r8,r0
    bne     _cpu_mid_test_fail

    mov     r9,r0
    cmp     r9,r0
    bne     _cpu_mid_test_fail

    mov     r10,r0
    cmp     r10,r0
    bne     _cpu_mid_test_fail

_cpu_mid_test_pass

;   /* Indicate in the CPUregTestBIST_struct
;    * that r4-r10 tests passed.
;    */
    ldr     r1, =CPUregTestBIST_struct

;   /* Indicate MID test has passed */
    mov	    r0, #0x7F0
    ldr     r2, [r1]
    orr     r0, r0, r2

    str     r0, [r1,#testState]

;   /* Indicate the test has passed */
    mov     r0, #0x01
    str     r0, [r1,#testPassed]

_cpu_mid_test_fail
;   /* Pop the stack back */
    pop     {r0-r12,r14}
    bx      lr

;/**************************************/
;/* END of the CPU register test MID   */
;/**************************************/

;/**************************************/
;/* START of the CPU register test HIGH*/
;/**************************************/

;/*--- HIGH REGISTERS r8-r12 ---*/
_CPUregTestHIGH

;   /* Push ALL registers to stack */
    push    {r0-r12,r14}

;   /* Clear r0 */
    mov r0, #0x00

;   /* Load pattern1 in r0 */
    ldr     r0,=pattern1

;   /* Put patter1 in r8-r12 */
    mov     r8,r0
    cmp     r8,r0
    bne     _cpu_high_test_fail

    mov     r9,r0
    cmp     r9,r0
    bne     _cpu_high_test_fail

    mov     r10,r0
    cmp     r10,r0
    bne     _cpu_high_test_fail

    mov     r11,r0
    cmp     r11,r0
    bne     _cpu_high_test_fail

    mov     r12,r0
    cmp     r12,r0
    bne     _cpu_high_test_fail

;   /* Load pattern3 in r0 */
    ldr     r0,=pattern3

;   /* Put patter1 in r8-r12 */
    mov     r8,r0
    cmp     r8,r0
    bne     _cpu_high_test_fail

    mov     r9,r0
    cmp     r9,r0
    bne     _cpu_high_test_fail

    mov     r10,r0
    cmp     r10,r0
    bne     _cpu_high_test_fail

    mov     r11,r0
    cmp     r11,r0
    bne     _cpu_high_test_fail

    mov     r12,r0
    cmp     r12,r0
    bne     _cpu_high_test_fail

_cpu_high_test_pass

;   /* Indicate in the CPUregTestBIST_struct
;    * that r0-r12 tests passed.
;    */
    ldr     r1, =CPUregTestBIST_struct

;   /* Indicate LOW test has passed */
    mov	    r0, #0x1F00
    ldr     r2, [r1]
    orr     r0, r0, r2
    str     r0, [r1,#testState]

;   /* Indicate the test has passed */
    mov     r0, #0x01
    str     r0, [r1,#testPassed]

_cpu_high_test_fail
;   /* Pop the stack back */
    pop     {r0-r12,r14}
;   /* Branch back */
    bx      lr

;/**************************************/
;/* END of the CPU register test HIGH  */
;/**************************************/

;/**************************************/
;/* START of the CPU register test SP  */
;/**************************************/
;/* SP register tests:
; * For the SP a different pattern is used because SP[1:0] are
; * always zero.
; */
_CPUregTestSP

;   /* Push ALL registers to stack */
    push    {r0-r12,r14}
	
;   /* store the current CPSR and Disable all interrupts in privileged mode */
	mrs     r3, CPSR 
	msr     CPSR_c, #Mode_SYS:OR:I_DISABLED:OR:F_DISABLED

;   /* Store the current SP */
    mov     r4, r13

;   /* Load pattern2 in r0 */
    ldr     r0,=pattern2

;   /* Move pattern2 in the SP */
    mov     r13, r0

;   /* Compare the pattern with the input pattern */
    cmp     r13, r0
    bne     _cpu_SP_test_fail

;   /* Load pattern4 in r0 */
    ldr     r0,=pattern4

;   /* Move pattern4 in the SP */
    mov     r13, r0

;   /* Compare the pattern with the input pattern */
    cmp     r13, r0
    bne     _cpu_SP_test_fail

_cpu_SP_test_pass
;   /* Restore the SP and CPSR */
    mov     r13, r4
    msr     CPSR_cxsf, r3
;   /* Indicate in the CPUregTestBIST_struct
;    * that MSP tests passed.
;    */
    ldr     r1, =CPUregTestBIST_struct

;   /* Indicate LOW test has passed */
    mov    	r0, #0x2000
    ldr     r2, [r1]
    orr     r0, r0, r2
    str     r0, [r1,#testState]

;   /* Indicate the test has passed */
    mov     r0, #0x01
    str     r0, [r1,#testPassed]

_cpu_SP_test_fail
;   /* Restore the MSP and CONTROL */
    mov     r13, r4
    msr     CPSR_cxsf, r3

;   /* Pop the stack back */
    pop     {r0-r12,r14}

;   /* Branch back */
    bx      lr
;/**************************************/
;/* END of the CPU register test SP    */
;/**************************************/

;/**************************************/
;/* START of the CPU register test SPEC*/
;/**************************************/
;/* LR register test:
; * The link register will be written with pattern1,
; * then compared for a pass/fail. Secondly the inverse
; * of the pattern will be tested.
; */
_CPUregTestSPEC

;   /* Push ALL registers to stack */
    push    {r0-r12,r14}

;   /* Store the current link register */
    mov     r3, r14

;   /* Load pattern1 in r0 */
    ldr     r0,=pattern1

;   /* Move pattern1 in the MSP */
    mov     r14, r0

;   /* Compare the pattern with the input pattern */
    cmp     r14, r0
    bne     _cpu_LR_test_fail

;   /* Load pattern1 in r0 */
    ldr     r0,=pattern3

;   /* Move pattern1 in the MSP */
    mov     r14, r0

;   /* Compare the pattern with the input pattern */
    cmp     r14, r0
    bne     _cpu_LR_test_fail

_cpu_LR_test_pass
;   /* Restore the LR */
    mov     r14, r3

;   /* Indicate in the CPUregTestBIST_struct
;      LR test has passed
;    */
    mov	    r0, #0x4000
    ldr     r1, =CPUregTestBIST_struct+testState
    ldr     r2, [r1]
    orr     r0, r0, r2
    str     r0, [r1]
    b       _cpu_CPSR_test

_cpu_LR_test_fail
;   /* Restore the LR */
    mov     r14, r3
    b       _cpu_CPSR_test_fail

;/* CPSR register tests:
; *  The CPSR register will be written with pattern5, because only APSR[31:28...7:6]
; * can be modified,
; * then compared for a pass/fail. Secondly the inverse
; * of the pattern will be tested.
; */
_cpu_CPSR_test

;   /* Store the current CPSR register */
    mrs     r3, CPSR

;   /* Load pattern5 in r0 */
    ldr     r0,=pattern5

;   /* Move pattern1 in the CPSR */
    msr     CPSR_cxsf, r0

;   /* Read pattern5 from the CPSR */
    mrs     r1, CPSR

;   /* Compare the pattern with the input pattern */
    cmp     r1, r0
    bne     _cpu_CPSR_test_fail

;   /* Load pattern6 in r0 */
    ldr     r0,=pattern6

;   /* Move pattern6 in the APSR */
    msr     CPSR_cxsf, r0

;   /* Read pattern6 from the CPSR */
    mrs     r1, CPSR

;   /* Compare the pattern with the input pattern */
    cmp     r1, r0
    bne     _cpu_CPSR_test_fail

_cpu_CPSR_test_pass
;   /* Restore the CPSR */
    msr     CPSR_cxsf, r3
;   /* Indicate in the CPUregTestBIST_struct
;      CPSR test has passed
;    */
    mov    r0, #0x8000
    ldr     r1, =CPUregTestBIST_struct+testState
    ldr     r2, [r1]
    orr     r0, r0, r2
    str     r0, [r1]
	
;   /* Indicate the test has passed */
    mov     r0, #0x01
    str     r0, [r1,#testPassed]	
   
_cpu_CPSR_test_fail
;   /* Restore the CPSR */
    msr     CPSR_cxsf, r3
    
;   /* Pop the stack back */
    pop     {r0-r12,r14}

;   /* Branch back */
    bx      lr
;/**************************************/
;/* END of the CPU register test SPEC  */
;/**************************************/
	NOP
	END