;/****************************************************************************
 *   Project     : Example for the NXP ARM7 IEC60335 Class B library	
 *   Description : Timer 1 source file
; *
; ****************************************************************************
; * Software that is described herein is for illustrative purposes only
; * which provides customers with programming information regarding the
; * products. This software is supplied "AS IS" without any warranties.
; * NXP Semiconductors assumes no responsibility or liability for the
; * use of the software, conveys no license or title under any patent,
; * copyright, or mask work right to the product. NXP Semiconductors
; * reserves the right to make changes in the software without
; * notification. NXP Semiconductors also make no representation or
; * warranty that such application will be suitable for the specified
; * use without further testing or modification.
;****************************************************************************/
#include "LPC214x.h"
#include "IEC60335.h"
#include "target.h"

extern type_InterruptTest TC1_IntTest;

__irq void tc1(void)                           // Timer 1 Interrupt every 1 ms
{
    IEC60335_InterruptOcurred(&TC1_IntTest);   // For Class B testing
    T1IR        = 1;                           // Clear interrupt flag
    VICVectAddr = 0;                           // Acknowledge Interrupt
}

void TC1_Init(void)
{
    T1MR0 = (Fpclk / 1000) - 1;                // 1 msec = 1000 Hz
    T1MCR = 3;                                 // Interrupt and Reset on MR0
    T1TCR = 1;                                 // Timer 1 enable
    VICVectAddr1  = (UINT32) &tc1;             // Set interrupt vector in 1
    VICVectCntl1  = 0x20 | 5;                  // Use it for Timer 1 Interrupt
    VICIntEnable |= 0x00000020;                // Enable Timer 1 Interrupt
}
