/* 
* TITL: NM1COM.C
* Written and Developed by: 
* Orchid Technologies Engineering and Consulting, Inc. 
* 147 Main Street 
* Maynard, Ma.  01754 
* TEL: 978-461-2000  
* 
* This Source Code is the property of Orchid Technologies 
* Engineering and Consulting, Inc.  Copyright 2003, 2004, 2005, 
* 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 
* and NXP Semiconductors 2013.

* THIS SOFTWARE IS PROVIDED BY ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING INC. 
* AND NXP SEMICONDUCTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, 
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
* PARTICULAR PURPOSE, AND NON-INFRINGEMENT OF INTELLECTUAL PROPERTY RIGHTS ARE 
* DISCLAIMED. IN NO EVENT SHALL ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING, 
* INC. OR NXP SEMICONDUCTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
* BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
* IN CONTRACT, STRICT LIABILITY, OR TORT(INCLUDING NEGLIGENCE OR OTHERWISE) 
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
* POSSIBILITY OF SUCH DAMAGE. ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING INC. 
* AND NXP SEMICONDUCTORS RESERVE THE RIGHT TO MAKE CHANGES IN THE SOFTWARE 
* WITHOUT NOTIFICATION. 
*
* @par
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors' and its
* licensor's relevant copyrights in the software, without fee, provided that it
* is used in conjunction with NXP Semiconductors microcontrollers.  This
* copyright, permission, and disclaimer notice must appear in all copies of
* this code.
*/

//Include Files
#include "arm_comm.h"
#include "iolpc15xx.h"
#include "nm1def.h"            /* Control Defines    */
#include "nm1lib.h"            /* Library Prototypes */
#include "nm1com.h"            /* Communications     */
#include "nm1app.h"            /* Application        */
#include "nm1mem.h"            /* Global Memory      */
#include <stdio.h>

// These routines support UART0 Tx/Rx
// These routines support UART0 Tx/Rx
// These routines support UART0 Tx/Rx

//comm_getc0
//This routine reads bytes from the input data buffer and updates the
//ring buffer pointers.  This routine is blocking, use comm_rxtestc to
//determine if data is available in the buffers.
unsigned char comm_getc0(void)
{
   unsigned char indata;

   while(rxring_count0 == 0);     //Wait for data

   __disable_interrupt();
   rxring_count0--;               //Update RxRing Status
   indata = *rxring_outptr0++;    //Read the data from the ring
   if(rxring_outptr0 >= &sci_rxbuffer0[SCI_BUF_SIZE1])
   rxring_outptr0 = sci_rxbuffer0; //Update RxRing Pointer
   __enable_interrupt();

   return(indata);
}

//comm_getline0
//This routine gets an input line from SCI0.  This routine echoes
//the input characters and recognizes back space.  <CR> ends the
//line input function.
void comm_getline0(void)
{
   unsigned char indat;

   //Should we be idle
   if(comm_lineflag0 == STATE_IDLE)
   return;

   //Is the line buffer availabe?
   if(comm_lineflag0 == STATE2)
   return;

#if GUI_Interface  
  if(comm_lineflag0 == STATE0)
   {
       comm_lineflag0 = STATE1;
   }
#else
   //Should we send prompt
   if(comm_lineflag0 == STATE0)
   {
   comm_putc0('N');
   comm_putc0('M');
   comm_putc0('>');
   comm_lineflag0 = STATE1;
   }
#endif
   //Is there a character available?
   if((comm_testrx0()) != 1)  //Is a character available
   return;                    //No, We're done

#if GUI_Interface 
   if((comm_testrx_packet(PACKET_SIZE)) != 1)
      return;
    //Get character input
  for(comm_linecount0=0;comm_linecount0<PACKET_SIZE;comm_linecount0++){
     indat = comm_getc0();
     comm_linebuf0[comm_linecount0] = indat;
  }
    if (comm_linecount0 == PACKET_SIZE){
     comm_linebuf0[comm_linecount0++] = 0;
     comm_lineflag0 = STATE2;
   } 
 
#else   
   //Get character input
   indat = comm_getc0();

   //Is there room?
   if(comm_linecount0 > SCI_BUF_SIZE1)
   indat = 0x0D;              //No More Room, Force <CR>

   switch(indat)
   {
   case 0x08:  //BackSpace
               if(comm_linecount0 > 0)
               {
               comm_putc0(0x08);
               comm_putc0(0x20);
               comm_putc0(0x08);
               comm_linecount0--;
               }
               break;

   case 0x0D:  //Carriage Return
               comm_linebuf0[comm_linecount0++] = 0x00;
               comm_lineflag0 = STATE2;
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               break;

   case 0x0A:  //Line Feed - Ignore
               break;

   default:    //Normal Character Entry
               comm_putc0(indat);
               comm_linebuf0[comm_linecount0++] = indat;
               break;
   }
   
#endif
}

   
//comm_procline0
//This routine processes the line inputs
void comm_procline0(void)
{
   if(comm_procline0_state == STATE_IDLE)
   return;

   //Prepare to receive new line
   if(comm_lineflag0 == STATE2)
   {

   //Call Application Command Processor
   m3_procline0();

   if(comm_lineflag0 != STATE_IDLE)
   comm_lineflag0 = STATE0;
   comm_linecount0 = 0;
   }
}


//comm_putc0
//This routine write bytes to the output data buffer and updates the
//ring buffer pointers.  This routine is blocking, use comm_txtestc to
//determine if write space is available in the buffers.
void comm_putc0(unsigned char outdata)
{
   unsigned char temp;

   while(txring_count0 >= SCI_BUF_SIZE1);     //Wait for data buffer space

   __disable_interrupt();

   //Deal with first character and interrupts
   temp = USART0_INTENSET;
   if(!(temp & 0x00000004))      //This is first character!
   {
      USART0_TXDATA    =  outdata;
      USART0_INTENSET |= 0x04;
   }
   else
   {
      txring_count0++;                //Update TxRing Status
      *txring_inptr0++ = outdata;     //Write Data to the TxRing
      if(txring_inptr0 >= &sci_txbuffer0[SCI_BUF_SIZE1])
      txring_inptr0 = sci_txbuffer0;  //Update TxRing Pointer
   }
   __enable_interrupt();
}

//comm_testrx0
//This routine checks if the receive character buffer is Empty
unsigned char comm_testrx0(void)
{
   unsigned char result;

   result = 1;
   if(rxring_count0 == 0)
   result = 0;

   return(result);
}
 
#ifdef GUI_Interface 
//comm_testrx0
//This routine checks if the receive packet is there
unsigned char comm_testrx_packet(unsigned char num)
{
   unsigned char result;

   result = 0;
   if(rxring_count0 >= num )
   result = 1;

   return(result);
}
#endif

//comm_testtx0
//This routine checks if the transmit character buffer is Full
unsigned char comm_testtx0(void)
{
   unsigned char result;

   result = 1;
   if(txring_count0 == SCI_BUF_SIZE1)
   result = 0;

   return(result);
}


//comm_sprint0
//This routine prints a string to the RS232 Port
void comm_sprint0 (unsigned char *data)
{
   while(*data != 0x00)
   comm_putc0(*data++);
}

#if GUI_Interface
//This routine send data with a particular size to serial port
void comm_data_serial(FOC_TUNE *data_ptr,unsigned char size)
{
  unsigned char *data = (unsigned char *) data_ptr;
  while(size != 0x00){
   comm_putc0(*data++);
   size--;
  }
}

#endif

//comm_flushrx0
//This routine flushes the receive character buffer
void comm_flushrx0(void)
{
   rxring_inptr0  = sci_rxbuffer0;
   rxring_outptr0 = sci_rxbuffer0;
   rxring_count0  = 0x00;
}


// UART0_IRQHandler
// UART Interrupt Service Routine.  This routine places Rx Data
// into the Rxbuffer and sends data from the Txbuffer.
void UART0_IRQHandler(void)
{
   irq_sci_status0 = USART0_STAT;            //Get the UART Interrupt Status
   irq_sci_status0 = irq_sci_status0 & 0x05; //Mask Bits
   //Is Transmit Data Register Empty?
   if((irq_sci_status0 & 0x04) == 0x04)
   {
      //Do We have more data?
      if(txring_count0)
      {
         USART0_TXDATA = *txring_outptr0++;  //output next data byte
         txring_count0--;                    //Update TxRing Status
         if(txring_outptr0 >= &sci_txbuffer0[SCI_BUF_SIZE1])
         txring_outptr0 = sci_txbuffer0;     //Update TxRing Pointer
      }

      if(txring_count0 == 0)
      {
         USART0_INTENCLR = 0x04;             //Stop Xmit IRQ's
      }
   }   

   //Do the Receive Data
   if((irq_sci_status0 & 0x01) == 0x01)               //Is there valid data?
   {
      if(rxring_count0 < SCI_BUF_SIZE1)      //Is there a place to put it?
      {
         *rxring_inptr0++ = USART0_RXDATA;   //Store the RxData, Mask high data bit when running with parity!!
         rxring_count0++;                    //Update RxRing Status
         if(rxring_inptr0 >= &sci_rxbuffer0[SCI_BUF_SIZE1])
         rxring_inptr0 = sci_rxbuffer0;      //Update RxRing Pointer
      }
      else
      {
         irq_sci_status0 = USART0_RXDATA;    //Read Data, ignore it, flags clear
      }
   }
   else
   {
      irq_sci_status0 = USART0_RXDATA;       //Read Data, ignore it, flags clear
   }

   //Clear Interrupts
   NVIC_ClrPend(NVIC_UART0);
}
