/* 
* TITLE: NM1DEF.H
* Written and Developed by: 
* Orchid Technologies Engineering and Consulting, Inc. 
* 147 Main Street 
* Maynard, Ma.  01754 
* TEL: 978-461-2000  
* 
* This Source Code is the property of Orchid Technologies 
* Engineering and Consulting, Inc.  Copyright 2003, 2004, 2005, 
* 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 
* and NXP Semiconductors 2013.

* THIS SOFTWARE IS PROVIDED BY ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING INC. 
* AND NXP SEMICONDUCTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, 
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
* PARTICULAR PURPOSE, AND NON-INFRINGEMENT OF INTELLECTUAL PROPERTY RIGHTS ARE 
* DISCLAIMED. IN NO EVENT SHALL ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING, 
* INC. OR NXP SEMICONDUCTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
* BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
* IN CONTRACT, STRICT LIABILITY, OR TORT(INCLUDING NEGLIGENCE OR OTHERWISE) 
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
* POSSIBILITY OF SUCH DAMAGE. ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING INC. 
* AND NXP SEMICONDUCTORS RESERVE THE RIGHT TO MAKE CHANGES IN THE SOFTWARE 
* WITHOUT NOTIFICATION. 
*
* @par
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors' and its
* licensor's relevant copyrights in the software, without fee, provided that it
* is used in conjunction with NXP Semiconductors microcontrollers.  This
* copyright, permission, and disclaimer notice must appear in all copies of
* this code.
*/

//Defines for VERSION Number
#define VERSION 0x3130                 //ASCII Version Number - 10

//Define bit test macros
#define _bset(A, B)			(A |= (0x01<<(B)))
#define _bres(A, B)			(A &= ~(0x01<<(B)))
#define _btst(A, B)			((A) & (0x01<<(B)))

//SCI (UART) Definitions
#define  SCI_BUF_SIZE1           800   //Ring Buffer Size Tx and Rx
#define  SCI_BUF_SIZE2           100   //Ring Buffer Size Tx and Rx
#define  SCI_BUF_SIZE3           100   //Ring Buffer Size Tx and Rx
#define  SCI_TIE                 0x80
#define  SCI_TCIE                0x04
#define  SCI_RIE                 0x40

//SCCB Defines
#define SC_IDLE   0     //SCCB Idle
#define SC_WRITE  1     //SCCB Write
#define SC_READ   2     //SCCB Read

//LPC15xx Power, PLL API Definitions
#define rom_power_api 0x03000200
typedef void (*rom_set_pll)  (unsigned int [], unsigned int []);
typedef void (*rom_set_power)(unsigned int [], unsigned int []);

//FOC Motor Defines
#define  MOTOR_POLES    8        //Individual Poles
#define  MOTOR_PPAIRS   4        //Pole Pairs
#define  MOTOR_COUNTS   4000     //Counts per revolution
#define  MOTOR_COUNTSPP 1000     //Counts per Pole Pair
#define  MAX_PID        1023.0   //Max PID
#define  MAX_QPID       250.0    //Max QPID
#define  MAX_RPM        4.0      //MAX RPM Current Out

//Teknick Motor
#define  MOTOR_R        1.45     //Resistance in Ohms
#define  MOTOR_L        0.20000  //Inductance in Henry
#define  PIQ_SETPT      0.0      //Initial Value
#define  PIQ_PGAIN      5.0      //Initial Value
#define  PIQ_IGAIN      10.0     //Initial Value
#define  PIQ_TGAIN      500.0    //Initial Value
#define  PID_SETPT      0.0      //Initial Value
#define  PID_PGAIN      5.0      //Initial Value
#define  PID_IGAIN      10.0     //Initial Value
#define  PID_TGAIN      500.0    //Initial Value
#define  RPM_SETPT      0.0      //Initial Value
#define  RPM_PGAIN      0.01     //Initial Value
#define  RPM_IGAIN      0.02     //Initial Value
#define  RPM_TGAIN      10.0     //Initial Value


//Joystick
#define  KEY_UP         0x1E
#define  KEY_DN         0x1B
#define  KEY_CT         0x1D


#define PACKET_SIZE     5

//FOC Motor Control
typedef struct
   {
   char     su_flag; //Startup Flag, Startup Mode = 1
   char     adc_state;  //ADC Service State
   int      theta;   //Rotor Angle Input, Degrees 0 to 360 expressed as 0 to 1024 counts
   int      est_theta;  //Estimated Rotor Angle
   int      last_theta; //Last Theta for Speed Calculation
   float    sin_t;   //Sin Theta - This used to speed things up
   float    cos_t;   //Cos Theta - This used to speed things up
   float    vsdref;  //Reference Input D - To Inverse Park
   float    vsqref;  //Reference Input Q - To Inverse Park
   float    valpha;  //Output Alpha - From Inverse Park -> To SV_PWM
   float    vbeta;   //Output Beta  - From Inverse Park -> To SV_PWM
   int      pwma;    //SV PWM Values
   int      pwmb;    //SV PWM Values
   int      pwmc;    //SV PWM Values
   int      crnt_a;  //Phase Current A - ADC Values
   int      crnt_b;  //Phase Current B - ADC Values
   int      crnt_c;  //Phase Current C - ADC Values
   int      crnt_all;//Phase Current All - ADC Values
   float    ia;      //Phase Current A - Calibrated Current
   float    ib;      //Phase Current A - Calibrated Current
   float    ic;      //Phase Current A - Calibrated Current
   float    ialpha;  //Output Alpha from Clarke - Calibrated
   float    ibeta;   //Output Beta  from Clarke - Calibrated
   float    idout;   //Output iD    from Parke Transform - Calibrated
   float    iqout;   //Output iQ    from Parke Transform - Calibrated
   int      rpm;     //Revolutions per Minute
   int      rpm_cnts;//Theta Counts
   int      rpm_time;//Theta Time
   char     pi_flag;    //pi on = 1, off = 0;
   float    piq_setpt;  //Q Setpoint
   float    piq_pgain;  //Q Pterm Gain
   float    piq_igain;  //Q Iterm Gain
   float    piq_tgain;  //Q Time  Gain
   float    piq_sum;    //Q Integrator Sum
   float    piq_out;    //Q Output
   float    pid_setpt;  //D Setpoint
   float    pid_pgain;  //D Pterm Gain
   float    pid_igain;  //D Iterm Gain
   float    pid_tgain;  //D Time  Gain
   float    pid_sum;    //D Integrator Sum
   float    pid_out;    //D Output
   float    pid_setpt_save;   //saved for startup
   char     rpm_flag;   //Start RPM Calculations
   float    rpm_setpt;  //RPM Setpoint
   float    rpm_pgain;  //RPM Pterm Gain
   float    rpm_igain;  //RPM Iterm Gain
   float    rpm_tgain;  //RPM Time  Gain
   float    rpm_sum;    //RPM Integrator Sum
   float    rpm_out;    //RPM Output
   }PMSMotor;

//Estimator Structure
typedef struct
   {
   char     sp_flag;
   float    ia;      //Calibrated Current A
   float    ib;      //Calibrated Current B
   float    ic;      //Calibrated Current C
   float    ialpha;  //Clarke Transform Current in A
   float    ibeta;   //Clarke Transform Current in A
   float    valpha;  //Clarke Transform Voltage in V
   float    vbeta;   //Clarke Transform Voltage in V
   float    ssum_a;  //Flux Linkage Sum alpha
   float    ssum_b;  //Flux Linkage Sum beta
   float    sigma_a; //Flux Linkage alpha
   float    sigma_b; //Flux Linkage beta
   int      start_count;   //Startup Time Counter
   int      start_time;    //Startup Time Limit
   float    start_theta;   //Startup Angle
   float    start_incr;    //Startup Angle Increment
   float    start_accel;   //Startup Angle Acceleration - linear
   float    start_incrmax; //Startup max
   int      start_rpm;     //Startup RPM
   }ESTMotor;

#if GUI_Interface  
typedef union
{
  float com_float_var;
  unsigned char com_uchr_var[4];
}com_var;

typedef volatile struct foc_tune
{
   volatile unsigned long com_sync;
   volatile unsigned short com_size;
   volatile unsigned char com_mode;
  //volatile unsigned int measured_angle;
   volatile unsigned long deviceID[2];		// double DWORD DeviceID
   volatile int      com_theta;   //Rotor Angle Input, Degrees 0 to 360 expressed as 0 to 1024 counts
   volatile float    com_ialpha;  //Clarke Transform Current in A
   volatile float    com_ibeta;   //Clarke Transform Current in A
   volatile float    com_valpha;  //Clarke Transform Voltage in V
   volatile float    com_vbeta;   //Clarke Transform Voltage in V
   volatile float    com_idout;   //Output iD    from Parke Transform - Calibrated
   volatile float    com_iqout;   //Output iQ    from Parke Transform - Calibrated
   volatile float    com_piq_pgain;  //Q Pterm Gain
   volatile float    com_piq_igain;  //Q Iterm Gain
   volatile float    com_piq_tgain;  //Q Time  Gain
   volatile float    com_pid_pgain;  //D Pterm Gain
   volatile float    com_pid_igain;  //D Iterm Gain
   volatile float    com_pid_tgain;  //D Time  Gain
   volatile float    com_rpm_pgain;  //RPM Pterm Gain
   volatile float    com_rpm_igain;  //RPM Iterm Gain
   volatile float    com_rpm_tgain;  //RPM Time  Gain
   volatile float    com_rpm_setpt;  //RPM Setpoint
   volatile float    com_rpm;        //RPM out
  /* volatile float    com_start_accel;   //Startup Angle Acceleration - linear
   volatile float    com_start_incrmax; //Startup max
   volatile int    com_start_time;  
   volatile int      com_start_rpm;     //Startup RPM*/
}FOC_TUNE;

#endif

//Global State Machine STATES
#define  STATE0 0x00
#define  STATE1 0x01
#define  STATE2 0x02
#define  STATE3 0x03
#define  STATE4 0x04
#define  STATE5 0x05
#define  STATE6 0x06
#define  STATE7 0x07
#define  STATE8 0x08
#define  STATE9 0x09
#define  STATE10 0x10
#define  STATE11 0x11
#define  STATE12 0x12
#define  STATE13 0x13
#define  STATE14 0x14
#define  STATE15 0x15
#define  STATE16 0x16
#define  STATE17 0x17
#define  STATE18 0x18
#define  STATE19 0x19
#define  STATE20 0x20
#define  STATE21 0x21
#define  STATE22 0x22
#define  STATE23 0x23
#define  STATE24 0x24
#define  STATE25 0x25
#define  STATE26 0x26
#define  STATE27 0x27
#define  STATE28 0x28
#define  STATE29 0x29
#define  STATE30 0x30
#define  STATE31 0x31
#define  STATE32 0x32
#define  STATE33 0x33
#define  STATE34 0x34
#define  STATE35 0x35
#define  STATE36 0x36
#define  STATE37 0x37
#define  STATE38 0x38
#define  STATE39 0x39
#define  STATE40 0x40
#define  STATE41 0x41
#define  STATE42 0x42
#define  STATE43 0x43
#define  STATE44 0x44
#define  STATE45 0x45
#define  STATE46 0x46
#define  STATE47 0x47
#define  STATE48 0x48
#define  STATE49 0x49
#define  STATE50 0x50
#define  STATE51 0x51
#define  STATE52 0x52
#define  STATE53 0x53
#define  STATE54 0x54
#define  STATE55 0x55
#define  STATE56 0x56
#define  STATE57 0x57
#define  STATE58 0x58
#define  STATE59 0x59
#define  STATE_ERROR 0x98
#define  STATE_IDLE  0x99
#define  ESTATE_IDLE 0xFFF
