/***************************************************************************
 **
 **    This file defines the Special Function Registers for
 **    NXP LPC15xx
 **
 **    Used with ARM IAR C/C++ Compiler and Assembler.
 **
 **    (c) Copyright IAR Systems 2013
 **
 **    $Revision: 28 $
 **
 **    Note: Only little endian addressing of 8 bit registers.
 ***************************************************************************/

#ifndef __IOLPC15XX_H
#define __IOLPC15XX_H

#if (((__TID__ >> 8) & 0x7F) != 0x4F)     /* 0x4F = 79 dec */
#error This file should only be compiled by ARM IAR compiler and assembler
#endif

#include "io_macros.h"

/***************************************************************************
 ***************************************************************************
 **
 **    LPC15XX SPECIAL FUNCTION REGISTERS
 **
 ***************************************************************************
 ***************************************************************************
 ***************************************************************************/

/* C-compiler specific declarations  ***************************************/
#ifdef __IAR_SYSTEMS_ICC__

#ifndef _SYSTEM_BUILD
#pragma system_include
#endif

#if __LITTLE_ENDIAN__ == 0
#error This file should only be compiled in little endian mode
#endif

/* Interrupt Controller Type Register */
typedef struct {
  __REG32  INTLINESNUM    : 5;
  __REG32                 :27;
} __nvic_bits;

/* SysTick Control and Status Register */
typedef struct {
  __REG32  ENABLE         : 1;
  __REG32  TICKINT        : 1;
  __REG32  CLKSOURCE      : 1;
  __REG32                 :13;
  __REG32  COUNTFLAG      : 1;
  __REG32                 :15;
} __systickcsr_bits;

/* SysTick Reload Value Register */
typedef struct {
  __REG32  RELOAD         :24;
  __REG32                 : 8;
} __systickrvr_bits;

/* SysTick Current Value Register */
typedef struct {
  __REG32  CURRENT        :24;
  __REG32                 : 8;
} __systickcvr_bits;

/* SysTick Calibration Value Register */
typedef struct {
  __REG32  TENMS          :24;
  __REG32                 : 6;
  __REG32  SKEW           : 1;
  __REG32  NOREF          : 1;
} __systickcalvr_bits;

/* Interrupt Set-Enable Registers 0-31 */
typedef struct {
  __REG32  SETENA0        : 1;
  __REG32  SETENA1        : 1;
  __REG32  SETENA2        : 1;
  __REG32  SETENA3        : 1;
  __REG32  SETENA4        : 1;
  __REG32  SETENA5        : 1;
  __REG32  SETENA6        : 1;
  __REG32  SETENA7        : 1;
  __REG32  SETENA8        : 1;
  __REG32  SETENA9        : 1;
  __REG32  SETENA10       : 1;
  __REG32  SETENA11       : 1;
  __REG32  SETENA12       : 1;
  __REG32  SETENA13       : 1;
  __REG32  SETENA14       : 1;
  __REG32  SETENA15       : 1;
  __REG32  SETENA16       : 1;
  __REG32  SETENA17       : 1;
  __REG32  SETENA18       : 1;
  __REG32  SETENA19       : 1;
  __REG32  SETENA20       : 1;
  __REG32  SETENA21       : 1;
  __REG32  SETENA22       : 1;
  __REG32  SETENA23       : 1;
  __REG32  SETENA24       : 1;
  __REG32  SETENA25       : 1;
  __REG32  SETENA26       : 1;
  __REG32  SETENA27       : 1;
  __REG32  SETENA28       : 1;
  __REG32  SETENA29       : 1;
  __REG32  SETENA30       : 1;
  __REG32  SETENA31       : 1;
} __setena0_bits;

/* Interrupt Clear-Enable Registers 0-31 */
typedef struct {
  __REG32  CLRENA0        : 1;
  __REG32  CLRENA1        : 1;
  __REG32  CLRENA2        : 1;
  __REG32  CLRENA3        : 1;
  __REG32  CLRENA4        : 1;
  __REG32  CLRENA5        : 1;
  __REG32  CLRENA6        : 1;
  __REG32  CLRENA7        : 1;
  __REG32  CLRENA8        : 1;
  __REG32  CLRENA9        : 1;
  __REG32  CLRENA10       : 1;
  __REG32  CLRENA11       : 1;
  __REG32  CLRENA12       : 1;
  __REG32  CLRENA13       : 1;
  __REG32  CLRENA14       : 1;
  __REG32  CLRENA15       : 1;
  __REG32  CLRENA16       : 1;
  __REG32  CLRENA17       : 1;
  __REG32  CLRENA18       : 1;
  __REG32  CLRENA19       : 1;
  __REG32  CLRENA20       : 1;
  __REG32  CLRENA21       : 1;
  __REG32  CLRENA22       : 1;
  __REG32  CLRENA23       : 1;
  __REG32  CLRENA24       : 1;
  __REG32  CLRENA25       : 1;
  __REG32  CLRENA26       : 1;
  __REG32  CLRENA27       : 1;
  __REG32  CLRENA28       : 1;
  __REG32  CLRENA29       : 1;
  __REG32  CLRENA30       : 1;
  __REG32  CLRENA31       : 1;
} __clrena0_bits;

/* Interrupt Set-Pending Register 0-31 */
typedef struct {
  __REG32  SETPEND0       : 1;
  __REG32  SETPEND1       : 1;
  __REG32  SETPEND2       : 1;
  __REG32  SETPEND3       : 1;
  __REG32  SETPEND4       : 1;
  __REG32  SETPEND5       : 1;
  __REG32  SETPEND6       : 1;
  __REG32  SETPEND7       : 1;
  __REG32  SETPEND8       : 1;
  __REG32  SETPEND9       : 1;
  __REG32  SETPEND10      : 1;
  __REG32  SETPEND11      : 1;
  __REG32  SETPEND12      : 1;
  __REG32  SETPEND13      : 1;
  __REG32  SETPEND14      : 1;
  __REG32  SETPEND15      : 1;
  __REG32  SETPEND16      : 1;
  __REG32  SETPEND17      : 1;
  __REG32  SETPEND18      : 1;
  __REG32  SETPEND19      : 1;
  __REG32  SETPEND20      : 1;
  __REG32  SETPEND21      : 1;
  __REG32  SETPEND22      : 1;
  __REG32  SETPEND23      : 1;
  __REG32  SETPEND24      : 1;
  __REG32  SETPEND25      : 1;
  __REG32  SETPEND26      : 1;
  __REG32  SETPEND27      : 1;
  __REG32  SETPEND28      : 1;
  __REG32  SETPEND29      : 1;
  __REG32  SETPEND30      : 1;
  __REG32  SETPEND31      : 1;
} __setpend0_bits;

/* Interrupt Clear-Pending Register 0-31 */
typedef struct {
  __REG32  CLRPEND0       : 1;
  __REG32  CLRPEND1       : 1;
  __REG32  CLRPEND2       : 1;
  __REG32  CLRPEND3       : 1;
  __REG32  CLRPEND4       : 1;
  __REG32  CLRPEND5       : 1;
  __REG32  CLRPEND6       : 1;
  __REG32  CLRPEND7       : 1;
  __REG32  CLRPEND8       : 1;
  __REG32  CLRPEND9       : 1;
  __REG32  CLRPEND10      : 1;
  __REG32  CLRPEND11      : 1;
  __REG32  CLRPEND12      : 1;
  __REG32  CLRPEND13      : 1;
  __REG32  CLRPEND14      : 1;
  __REG32  CLRPEND15      : 1;
  __REG32  CLRPEND16      : 1;
  __REG32  CLRPEND17      : 1;
  __REG32  CLRPEND18      : 1;
  __REG32  CLRPEND19      : 1;
  __REG32  CLRPEND20      : 1;
  __REG32  CLRPEND21      : 1;
  __REG32  CLRPEND22      : 1;
  __REG32  CLRPEND23      : 1;
  __REG32  CLRPEND24      : 1;
  __REG32  CLRPEND25      : 1;
  __REG32  CLRPEND26      : 1;
  __REG32  CLRPEND27      : 1;
  __REG32  CLRPEND28      : 1;
  __REG32  CLRPEND29      : 1;
  __REG32  CLRPEND30      : 1;
  __REG32  CLRPEND31      : 1;
} __clrpend0_bits;

/* Active Bit Register 0-31 */
typedef struct {
  __REG32  ACTIVE0        : 1;
  __REG32  ACTIVE1        : 1;
  __REG32  ACTIVE2        : 1;
  __REG32  ACTIVE3        : 1;
  __REG32  ACTIVE4        : 1;
  __REG32  ACTIVE5        : 1;
  __REG32  ACTIVE6        : 1;
  __REG32  ACTIVE7        : 1;
  __REG32  ACTIVE8        : 1;
  __REG32  ACTIVE9        : 1;
  __REG32  ACTIVE10       : 1;
  __REG32  ACTIVE11       : 1;
  __REG32  ACTIVE12       : 1;
  __REG32  ACTIVE13       : 1;
  __REG32  ACTIVE14       : 1;
  __REG32  ACTIVE15       : 1;
  __REG32  ACTIVE16       : 1;
  __REG32  ACTIVE17       : 1;
  __REG32  ACTIVE18       : 1;
  __REG32  ACTIVE19       : 1;
  __REG32  ACTIVE20       : 1;
  __REG32  ACTIVE21       : 1;
  __REG32  ACTIVE22       : 1;
  __REG32  ACTIVE23       : 1;
  __REG32  ACTIVE24       : 1;
  __REG32  ACTIVE25       : 1;
  __REG32  ACTIVE26       : 1;
  __REG32  ACTIVE27       : 1;
  __REG32  ACTIVE28       : 1;
  __REG32  ACTIVE29       : 1;
  __REG32  ACTIVE30       : 1;
  __REG32  ACTIVE31       : 1;
} __active0_bits;

/* Interrupt Priority Registers 0-3 */
typedef struct {
  __REG32  PRI_0          : 8;
  __REG32  PRI_1          : 8;
  __REG32  PRI_2          : 8;
  __REG32  PRI_3          : 8;
} __pri0_bits;

/* Interrupt Priority Registers 4-7 */
typedef struct {
  __REG32  PRI_4          : 8;
  __REG32  PRI_5          : 8;
  __REG32  PRI_6          : 8;
  __REG32  PRI_7          : 8;
} __pri1_bits;

/* Interrupt Priority Registers 8-11 */
typedef struct {
  __REG32  PRI_8          : 8;
  __REG32  PRI_9          : 8;
  __REG32  PRI_10         : 8;
  __REG32  PRI_11         : 8;
} __pri2_bits;

/* Interrupt Priority Registers 12-15 */
typedef struct {
  __REG32  PRI_12         : 8;
  __REG32  PRI_13         : 8;
  __REG32  PRI_14         : 8;
  __REG32  PRI_15         : 8;
} __pri3_bits;

/* Interrupt Priority Registers 16-19 */
typedef struct {
  __REG32  PRI_16         : 8;
  __REG32  PRI_17         : 8;
  __REG32  PRI_18         : 8;
  __REG32  PRI_19         : 8;
} __pri4_bits;

/* Interrupt Priority Registers 20-23 */
typedef struct {
  __REG32  PRI_20         : 8;
  __REG32  PRI_21         : 8;
  __REG32  PRI_22         : 8;
  __REG32  PRI_23         : 8;
} __pri5_bits;

/* Interrupt Priority Registers 24-27 */
typedef struct {
  __REG32  PRI_24         : 8;
  __REG32  PRI_25         : 8;
  __REG32  PRI_26         : 8;
  __REG32  PRI_27         : 8;
} __pri6_bits;

/* Interrupt Priority Registers 28-31 */
typedef struct {
  __REG32  PRI_28         : 8;
  __REG32  PRI_29         : 8;
  __REG32  PRI_30         : 8;
  __REG32  PRI_31         : 8;
} __pri7_bits;

/* CPU ID Base Register */
typedef struct {
  __REG32  REVISION       : 4;
  __REG32  PARTNO         :12;
  __REG32                 : 4;
  __REG32  VARIANT        : 4;
  __REG32  IMPLEMENTER    : 8;
} __cpuidbr_bits;

/* Interrupt Control State Register */
typedef struct {
  __REG32  VECTACTIVE     :10;
  __REG32                 : 1;
  __REG32  RETTOBASE      : 1;
  __REG32  VECTPENDING    :10;
  __REG32  ISRPENDING     : 1;
  __REG32  ISRPREEMPT     : 1;
  __REG32                 : 1;
  __REG32  PENDSTCLR      : 1;
  __REG32  PENDSTSET      : 1;
  __REG32  PENDSVCLR      : 1;
  __REG32  PENDSVSET      : 1;
  __REG32                 : 2;
  __REG32  NMIPENDSET     : 1;
} __icsr_bits;

/* Vector Table Offset Register */
typedef struct {
  __REG32                 : 7;
  __REG32  TBLOFF         :22;
  __REG32  TBLBASE        : 1;
  __REG32                 : 2;
} __vtor_bits;

/* Application Interrupt and Reset Control Register */
typedef struct {
  __REG32  VECTRESET      : 1;
  __REG32  VECTCLRACTIVE  : 1;
  __REG32  SYSRESETREQ    : 1;
  __REG32                 : 5;
  __REG32  PRIGROUP       : 3;
  __REG32                 : 4;
  __REG32  ENDIANESS      : 1;
  __REG32  VECTKEY        :16;
} __aircr_bits;

/* System Control Register */
typedef struct {
  __REG32                 : 1;
  __REG32  SLEEPONEXIT    : 1;
  __REG32  SLEEPDEEP      : 1;
  __REG32                 : 1;
  __REG32  SEVONPEND      : 1;
  __REG32                 :27;
} __scr_bits;

/* Configuration Control Register */
typedef struct {
  __REG32  NONEBASETHRDENA: 1;
  __REG32  USERSETMPEND   : 1;
  __REG32                 : 1;
  __REG32  UNALIGN_TRP    : 1;
  __REG32  DIV_0_TRP      : 1;
  __REG32                 : 3;
  __REG32  BFHFNMIGN      : 1;
  __REG32  STKALIGN       : 1;
  __REG32                 :22;
} __ccr_bits;

/* System Handler Control and State Register */
typedef struct {
  __REG32  MEMFAULTACT    : 1;
  __REG32  BUSFAULTACT    : 1;
  __REG32                 : 1;
  __REG32  USGFAULTACT    : 1;
  __REG32                 : 3;
  __REG32  SVCALLACT      : 1;
  __REG32  MONITORACT     : 1;
  __REG32                 : 1;
  __REG32  PENDSVACT      : 1;
  __REG32  SYSTICKACT     : 1;
  __REG32                 : 1;
  __REG32  MEMFAULTPENDED : 1;
  __REG32  BUSFAULTPENDED : 1;
  __REG32  SVCALLPENDED   : 1;
  __REG32  MEMFAULTENA    : 1;
  __REG32  BUSFAULTENA    : 1;
  __REG32  USGFAULTENA    : 1;
  __REG32                 :13;
} __shcsr_bits;

/* Configurable Fault Status Registers */
typedef struct {
  __REG32  IACCVIOL       : 1;
  __REG32  DACCVIOL       : 1;
  __REG32                 : 1;
  __REG32  MUNSTKERR      : 1;
  __REG32  MSTKERR        : 1;
  __REG32                 : 2;
  __REG32  MMARVALID      : 1;
  __REG32  IBUSERR        : 1;
  __REG32  PRECISERR      : 1;
  __REG32  IMPRECISERR    : 1;
  __REG32  UNSTKERR       : 1;
  __REG32  STKERR         : 1;
  __REG32                 : 2;
  __REG32  BFARVALID      : 1;
  __REG32  UNDEFINSTR     : 1;
  __REG32  INVSTATE       : 1;
  __REG32  INVPC          : 1;
  __REG32  NOCP           : 1;
  __REG32                 : 4;
  __REG32  UNALIGNED      : 1;
  __REG32  DIVBYZERO      : 1;
  __REG32                 : 6;
} __cfsr_bits;

/* Hard Fault Status Register */
typedef struct {
  __REG32                 : 1;
  __REG32  VECTTBL        : 1;
  __REG32                 :28;
  __REG32  FORCED         : 1;
  __REG32  DEBUGEVT       : 1;
} __hfsr_bits;

/* Debug Fault Status Register */
typedef struct {
  __REG32  HALTED         : 1;
  __REG32  BKPT           : 1;
  __REG32  DWTTRAP        : 1;
  __REG32  VCATCH         : 1;
  __REG32  EXTERNAL       : 1;
  __REG32                 :27;
} __dfsr_bits;

/* Software Trigger Interrupt Register */
#define STIR_INTID_MASK	0x1FF

/* System memory remap register */
typedef struct {
  __REG32  MAP            : 2;
  __REG32                 :30;
} __sysmemremap_bits;

/* NMI source selection register */
typedef struct {
  __REG32  IRQN           : 6;
  __REG32                 :25;
  __REG32  NMIEN          : 1;
} __nmisrc_bits;

/* System reset status register */
typedef struct {
  __REG32  POR            : 1;
  __REG32  EXTRST         : 1;
  __REG32  WDT            : 1;
  __REG32  BOD            : 1;
  __REG32  SYSRST         : 1;
  __REG32                 :27;
} __sysrststat_bits;

/* Peripheral reset control register 0 */
typedef struct {
  __REG32  		            : 7;
  __REG32  FLASH_RST      : 1;
  __REG32  	              : 1;
  __REG32  EEPROM_RST     : 1;
  __REG32  	              : 1;
  __REG32  PMUX_RST       : 1;
  __REG32  	              : 1;
  __REG32  IOCON_RST      : 1;
  __REG32  GPIO0_RST      : 1;
  __REG32  GPIO1_RST      : 1;
  __REG32  GPIO2_RST      : 1;
  __REG32  					      : 1;
  __REG32  PINT_RST       : 1;
  __REG32  GINT_RST	      : 1;
  __REG32  DMA_RST 	      : 1;
  __REG32  CRC_RST 	      : 1;
  __REG32                 : 5;
  __REG32  ADC0_RST 	    : 1;
  __REG32  ADC1_RST 	    : 1;
  __REG32  DAC_RST  	    : 1;
  __REG32  ACMP_RST  	    : 1;
  __REG32                 : 1;
} __presetctrl0_bits;

/* Peripheral reset control register 1 */
typedef struct {
  __REG32  MRT_RST        : 1;
  __REG32  RIT_RST        : 1;
  __REG32  SCT0_RST 			: 1;
  __REG32  SCT1_RST 			: 1;
  __REG32  SCT2_RST 			: 1;
  __REG32  SCT3_RST 			: 1;
  __REG32  SCTIPU_RST 		: 1;
  __REG32  CCAN_RST       : 1;
  __REG32  	              : 1;
  __REG32  SPI0_RST       : 1;
  __REG32  SPI1_RST       : 1;
  __REG32  					      : 2;
  __REG32  I2C0_RST       : 1;
  __REG32  					      : 3;
  __REG32  UART0_RST      : 1;
  __REG32  UART1_RST      : 1;
  __REG32  UART2_RST      : 1;
  __REG32  					      : 1;
  __REG32  QEI0_RST       : 1;
  __REG32  					      : 1;
  __REG32  USB_RST 	      : 1;
  __REG32                 : 8;
} __presetctrl1_bits;

/* POR captured PIO status register 0  */
typedef struct {
  __REG32  PIO0_0         : 1;
  __REG32  PIO0_1         : 1;
  __REG32  PIO0_2         : 1;
  __REG32  PIO0_3         : 1;
  __REG32  PIO0_4         : 1;
  __REG32  PIO0_5         : 1;
  __REG32  PIO0_6         : 1;
  __REG32  PIO0_7         : 1;
  __REG32  PIO0_8         : 1;
  __REG32  PIO0_9         : 1;
  __REG32  PIO0_10        : 1;
  __REG32  PIO0_11        : 1;
  __REG32  PIO0_12        : 1;
  __REG32  PIO0_13        : 1;
  __REG32  PIO0_14        : 1;
  __REG32  PIO0_15        : 1;
  __REG32  PIO0_16        : 1;
  __REG32  PIO0_17        : 1;
  __REG32  PIO0_18        : 1;
  __REG32  PIO0_19        : 1;
  __REG32  PIO0_20        : 1;
  __REG32  PIO0_21        : 1;
  __REG32  PIO0_22        : 1;
  __REG32  PIO0_23        : 1;
  __REG32  PIO0_24        : 1;
  __REG32  PIO0_25        : 1;
  __REG32  PIO0_26        : 1;
  __REG32  PIO0_27        : 1;
  __REG32  PIO0_28        : 1;
  __REG32  PIO0_29        : 1;
  __REG32  PIO0_30        : 1;
  __REG32  PIO0_31        : 1;
} __pioporcap0_bits;

/* POR captured PIO status register 1  */
typedef struct {
  __REG32  PIO1_0         : 1;
  __REG32  PIO1_1         : 1;
  __REG32  PIO1_2         : 1;
  __REG32  PIO1_3         : 1;
  __REG32  PIO1_4         : 1;
  __REG32  PIO1_5         : 1;
  __REG32  PIO1_6         : 1;
  __REG32  PIO1_7         : 1;
  __REG32  PIO1_8         : 1;
  __REG32  PIO1_9         : 1;
  __REG32  PIO1_10        : 1;
  __REG32  PIO1_11        : 1;
  __REG32  PIO1_12        : 1;
  __REG32  PIO1_13        : 1;
  __REG32  PIO1_14        : 1;
  __REG32  PIO1_15        : 1;
  __REG32  PIO1_16        : 1;
  __REG32  PIO1_17        : 1;
  __REG32  PIO1_18        : 1;
  __REG32  PIO1_19        : 1;
  __REG32  PIO1_20        : 1;
  __REG32  PIO1_21        : 1;
  __REG32  PIO1_22        : 1;
  __REG32  PIO1_23        : 1;
  __REG32  PIO1_24        : 1;
  __REG32  PIO1_25        : 1;
  __REG32  PIO1_26        : 1;
  __REG32  PIO1_27        : 1;
  __REG32  PIO1_28        : 1;
  __REG32  PIO1_29        : 1;
  __REG32  PIO1_30        : 1;
  __REG32  PIO1_31        : 1;
} __pioporcap1_bits;

/* POR captured PIO status register 2  */
typedef struct {
  __REG32  PIO2_0         : 1;
  __REG32  PIO2_1         : 1;
  __REG32  PIO2_2         : 1;
  __REG32  PIO2_3         : 1;
  __REG32  PIO2_4         : 1;
  __REG32  PIO2_5         : 1;
  __REG32  PIO2_6         : 1;
  __REG32  PIO2_7         : 1;
  __REG32  PIO2_8         : 1;
  __REG32  PIO2_9         : 1;
  __REG32  PIO2_10        : 1;
  __REG32  PIO2_11        : 1;
  __REG32  				        :20;
} __pioporcap2_bits;

/* Main clock source select register A/B
   USB clock source select register
   ADC asynchronous clock source select register
   CLKOUT clock source select register A
   CLKOUT clock source select register B
   System PLL clock source select register
   USB PLL clock source select register
   SCT PLL clock source select register
*/
typedef struct {
  __REG32  SEL            : 2;
  __REG32                 :30;
} __mainclksel_bits;

/*  System clock divider register */
typedef struct {
  __REG32  DIV            : 8;
  __REG32                 :24;
} __sysahbclkdiv_bits;

/* System clock control register 0 */
typedef struct {
  __REG32  SYS            : 1;
  __REG32  ROM            : 1;
  __REG32  	              : 1;
  __REG32  SRAM1	        : 1;
  __REG32  SRAM2		      : 1;
  __REG32  		            : 2;
  __REG32  FLASH          : 1;
  __REG32  			          : 1;
  __REG32  EEPROM         : 1;
  __REG32  			          : 1;
  __REG32  PMUX           : 1;
  __REG32  SWM            : 1;
  __REG32  IOCON          : 1;
  __REG32  GPIO0          : 1;
  __REG32  GPIO1          : 1;
  __REG32  GPIO2          : 1;
  __REG32                 : 1;
  __REG32  PINT           : 1;
  __REG32  GINT           : 1;
  __REG32  DMA            : 1;
  __REG32  CRC            : 1;
  __REG32  WWDT           : 1;
  __REG32  RTC			      : 1;
  __REG32                 : 3;
  __REG32  ADC0			      : 1;
  __REG32  ADC1			      : 1;
  __REG32  DAC 			      : 1;
  __REG32  CMP            : 1;
  __REG32                 : 1;
} __sysahbclkctrl0_bits;

/* System clock control register 1 */
typedef struct {
  __REG32  MRT            : 1;
  __REG32  RIT            : 1;
  __REG32  SCT0           : 1;
  __REG32  SCT1  	        : 1;
  __REG32  SCT2 		      : 1;
  __REG32  SCT3           : 1;
  __REG32  SCTIPU         : 1;
  __REG32  CCAN           : 1;
  __REG32  			          : 1;
  __REG32  SPI0           : 1;
  __REG32  SPI1           : 1;
  __REG32  			          : 2;
  __REG32  I2C0           : 1;
  __REG32  			          : 3;
  __REG32  UART0          : 1;
  __REG32  UART1          : 1;
  __REG32  UART2          : 1;
  __REG32                 : 1;
  __REG32  QEI            : 1;
  __REG32  		            : 1;
  __REG32  USB            : 1;
  __REG32  		            : 8;
} __sysahbclkctrl1_bits;

/* SYSTICK clock divider register */
/* USART clock divider register  */
/* IOCON glitch filterclock divider register */
/* ARM trace clock divider register */
/* USB clock source divider register */
/* ADCASYNCCLKDIV clock source divider register */
/* CLKOUT clock divider register */
typedef struct {
  __REG32  DIV   		       : 8;
  __REG32  						     :24;
} __systickclkdiv_bits;

/* Frequency measure function control register */
typedef struct {
  __REG32  CAPVAL		       :14;
  __REG32  						     :17;
  __REG32  PROG 		       : 1;
} __freqmectrl_bits;

/* Flash configuration register */
typedef struct {
  __REG32  FLASHTIM        : 2;
  __REG32  						     :30;
} __flashcfg_bits;

/* USART fractional generator register */
typedef struct {
  __REG32  DIV   		       : 8;
  __REG32  MULT  		       : 8;
  __REG32  						     :16;
} __frgctrl_bits;

/* USB clock control register  */
typedef struct {
  __REG32  AP_CLK		       : 1;
  __REG32  POL_CLK	       : 1;
  __REG32  						     :30;
} __usbclkctrl_bits;

/* USB clock status register */
typedef struct {
  __REG32  AP_CLK		       : 1;
  __REG32  POL_CLK	       : 1;
  __REG32  						     :30;
} __usbclkst_bits;

/* BOD control register */
typedef struct {
  __REG32  BODRSTLEV       : 2;
  __REG32  BODINTVAL       : 2;
  __REG32  BODRSTENA       : 1;
  __REG32  						     :27;
} __bodctrl_bits;

/* System oscillator control register */
typedef struct {
  __REG32  BYPASS		       : 1;
  __REG32  FREQRANGE       : 1;
  __REG32  						     :30;
} __sysoscctrl_bits;

/* RTC oscillator control register */
typedef struct {
  __REG32  EN				       : 1;
  __REG32  						     :31;
} __rtcoscctrl_bits;

/* System PLL control register */
/* USB PLL control register */
/* SCT PLL control register */
typedef struct {
  __REG32  MSEL			       : 6;
  __REG32  PSEL			       : 2;
  __REG32  						     :24;
} __syspllctrl_bits;

/* System PLL status register */
/* USB PLL status register */
/* SCT PLL status register */
typedef struct {
  __REG32  LOCK			       : 1;
  __REG32  						     :31;
} __syspllstat_bits;

/* Wake-up configuration register  */
/* Power configuration register  */
typedef struct {
  __REG32  						     : 3;
  __REG32  IRCOUT_PD       : 1;
  __REG32  IRC		         : 1;
  __REG32  FLASH		       : 1;
  __REG32  EEPROM		       : 1;
  __REG32  					       : 1;
  __REG32  BOD_PD		       : 1;
  __REG32  USBPHY_PD       : 1;
  __REG32  ADC0_PD	       : 1;
  __REG32  ADC1_PD	       : 1;
  __REG32  DAC_PD 	       : 1;
  __REG32  ACMP0_PD	       : 1;
  __REG32  ACMP1_PD	       : 1;
  __REG32  ACMP2_PD	       : 1;
  __REG32  ACMP3_PD	       : 1;
  __REG32  IREF_PD	       : 1;
  __REG32  TS_PD  	       : 1;
  __REG32  VDDADIV_PD      : 1;
  __REG32  WDTOSC_PD       : 1;
  __REG32  SYSOSC_PD       : 1;
  __REG32  SYSPLL_PD       : 1;
  __REG32  USBPLL_PD       : 1;
  __REG32  SCTPLL_PD       : 1;
  __REG32  						     : 7;
} __pdawakecfg_bits;

/* Start logic 0 wake-up enable register  */
typedef struct {
  __REG32  WWDT				     : 1;
  __REG32  BOD			       : 1;
  __REG32  				         : 3;
  __REG32  GINT0		       : 1;
  __REG32  GINT1		       : 1;
  __REG32  PINT0		       : 1;
  __REG32  PINT1		       : 1;
  __REG32  PINT2		       : 1;
  __REG32  PINT3		       : 1;
  __REG32  PINT4		       : 1;
  __REG32  PINT5		       : 1;
  __REG32  PINT6		       : 1;
  __REG32  PINT7		       : 1;
  __REG32  					       : 6;
  __REG32  USART0		       : 1;
  __REG32  USART1		       : 1;
  __REG32  USART2		       : 1;
  __REG32  I2C			       : 1;
  __REG32  SPI0			       : 1;
  __REG32  SPI1			       : 1;
  __REG32  					       : 3;
  __REG32  USB_WAKEUP      : 1;
  __REG32  					       : 1;
} __starterp0_bits;

/* Start logic 1 wake-up enable register */
typedef struct {
  __REG32  				         : 8;
  __REG32  ACMP0			     : 1;
  __REG32  ACMP1		       : 1;
  __REG32  ACMP2	         : 1;
  __REG32  ACMP3		       : 1;
  __REG32  					       : 1;
  __REG32  RTCALARM	       : 1;
  __REG32  RTCWAKE	       : 1;
  __REG32  					       :17;
} __starterp1_bits;

/* Power control register */
typedef struct {
  __REG32  	              : 3;
  __REG32  NODPD          : 1;
  __REG32                 : 4;
  __REG32  SLEEPFLAG      : 1;
  __REG32                 : 2;
  __REG32  DPDFLAG        : 1;
  __REG32                 :20;
} __pcon_bits;

/* Deep power down control register */
typedef struct {
  __REG32  WAKEUPHYS      	: 1;
  __REG32  WAKEPAD_DISABLE	: 1;
  __REG32  LPOSCEN         	: 1;
  __REG32  LPOSCDPDEN      	: 1;
  __REG32  				         	:28;
} __dpdctrl_bits;

/* IOCON_x registers */
typedef struct {
  __REG32  		            : 3;
  __REG32  MODE           : 2;
  __REG32  HYS            : 1;
  __REG32  INV            : 1;
  __REG32                 : 3;
  __REG32  OD             : 1;
  __REG32  S_MODE         : 2;
  __REG32  CLKDIV         : 3;
  __REG32                 :16;
} __iocon_bits;

/* IOCON_PIO0_22 register */
/* IOCON_PIO0_23 register */
typedef struct {
  __REG32                 : 6;
  __REG32  INV            : 1;
  __REG32                 : 1;
  __REG32  I2CMODE        : 2;
  __REG32                 : 1;
  __REG32  S_MODE         : 2;
  __REG32  CLKDIV         : 3;
  __REG32                 :16;
} __iocon_pio0_22_bits;

/* PINASSIGN 0 register */
typedef struct {
  __REG32  UART0_TXD_O    : 8;
  __REG32  UART0_RXD_I    : 8;
  __REG32  UART0_RTS_O    : 8;
  __REG32  UART0_CTS_I    : 8;
} __pinassign0_bits;

/* PINASSIGN 1 register */
typedef struct {
  __REG32  UART0_SCLK_IO  : 8;
  __REG32  UART1_TXD_O    : 8;
  __REG32  UART1_RXD_I    : 8;
  __REG32  UART1_RTS_O    : 8;
} __pinassign1_bits;

/* PINASSIGN 2 register */
typedef struct {
  __REG32  UART1_CTS_I	  : 8;
  __REG32  UART1_SCLK_IO  : 8;
  __REG32  UART2_TXD_O    : 8;
  __REG32  UART2_RXD_I    : 8;
} __pinassign2_bits;

/* PINASSIGN 3 register */
typedef struct {
  __REG32  UART2_SCLK_IO  : 8;
  __REG32  SSP0_SCK_IO    : 8;
  __REG32  SSP0_MOSI_IO   : 8;
  __REG32  SSP0_MISO_IO   : 8;
} __pinassign3_bits;

/* PINASSIGN 4 register */
typedef struct {
  __REG32  SSP0_SSELSN_0_IO  : 8;
  __REG32  SSP0_SSELSN_1_IO  : 8;
  __REG32  SSP0_SSELSN_2_IO  : 8;
  __REG32  SSP0_SSELSN_3_IO  : 8;
} __pinassign4_bits;

/* PINASSIGN 5 register */
typedef struct {
  __REG32  SSP1_SCK_IO			 : 8;
  __REG32  SSP1_MOSI_IO			 : 8;
  __REG32  SSP1_MISO_IO	     : 8;
  __REG32  SSP1_SSELSN_0_IO  : 8;
} __pinassign5_bits;

/* PINASSIGN 6 register */
typedef struct {
  __REG32  SSP1_SSELSN_1_IO		: 8;
  __REG32  CAN_TD1_O				 	: 8;
  __REG32  CAN_RD1_I		     	: 8;
  __REG32  USB_CONNECTN_O  		: 8;
} __pinassign6_bits;

/* PINASSIGN 7 register */
typedef struct {
  __REG32  USB_VBUS_I					: 8;
  __REG32  SCT0_OUT0_O			 	: 8;
  __REG32  SCT0_OUT1_O	     	: 8;
  __REG32  SCT0_OUT2_O	  		: 8;
} __pinassign7_bits;

/* PINASSIGN 8 register */
typedef struct {
  __REG32  SCT1_OUT0_O				: 8;
  __REG32  SCT1_OUT1_O			 	: 8;
  __REG32  SCT1_OUT2_O	     	: 8;
  __REG32  SCT2_OUT0_O	  		: 8;
} __pinassign8_bits;

/* PINASSIGN 9 register */
typedef struct {
  __REG32  SCT2_OUT1_O				: 8;
  __REG32  SCT2_OUT2_O			 	: 8;
  __REG32  SCT3_OUT0_O	     	: 8;
  __REG32  SCT3_OUT1_O	  		: 8;
} __pinassign9_bits;

/* PINASSIGN 10 register */
typedef struct {
  __REG32  SCT3_OUT2_O				: 8;
  __REG32  SCT_ABORT0_I			 	: 8;
  __REG32  SCT_ABORT1_I	     	: 8;
  __REG32  ADC0_PIN_TRIG0_I	  : 8;
} __pinassign10_bits;

/* PINASSIGN 11 register */
typedef struct {
  __REG32  ADC0_PIN_TRIG1_I		: 8;
  __REG32  ADC1_PIN_TRIG0_I		: 8;
  __REG32  ADC1_PIN_TRIG1_I	  : 8;
  __REG32  DAC_PIN_TRIG_I 	  : 8;
} __pinassign11_bits;

/* PINASSIGN 12 register */
typedef struct {
  __REG32  DAC_SHUTOFF_I			: 8;
  __REG32  COMP0_OUT_O			 	: 8;
  __REG32  COMP1_OUT_O	     	: 8;
  __REG32  COMP2_OUT_O			  : 8;
} __pinassign12_bits;

/* PINASSIGN 13 register */
typedef struct {
  __REG32  COMP3_OUT_O				: 8;
  __REG32  CLK_OUT_O				 	: 8;
  __REG32  ROSC0_O			     	: 8;
  __REG32  ROSC_RST0_I			  : 8;
} __pinassign13_bits;

/* PINASSIGN 14 register */
typedef struct {
  __REG32  USB_FRAME_TOG_O		: 8;
  __REG32  QEI0_PHA_I			 		: 8;
  __REG32  QEI0_PHB_I		     	: 8;
  __REG32  QEI0_IDX_I				  : 8;
} __pinassign14_bits;

/* PINASSIGN 15 register */
typedef struct {
  __REG32  GPIO_INT_BMATCH_O	: 8;
  __REG32  SWO_O					 		: 8;
  __REG32  							     	:16;
} __pinassign15_bits;

/* PINENABLE 0 register */
typedef struct {
  __REG32  ADC0_0							: 1;
  __REG32  ADC0_1							: 1;
  __REG32  ADC0_2							: 1;
  __REG32  ADC0_3							: 1;
  __REG32  ADC0_4							: 1;
  __REG32  ADC0_5							: 1;
  __REG32  ADC0_6							: 1;
  __REG32  ADC0_7							: 1;
  __REG32  ADC0_8							: 1;
  __REG32  ADC0_9							: 1;
  __REG32  ADC0_10						: 1;
  __REG32  ADC0_11						: 1;
  __REG32  ADC1_0							: 1;
  __REG32  ADC1_1							: 1;
  __REG32  ADC1_2							: 1;
  __REG32  ADC1_3							: 1;
  __REG32  ADC1_4							: 1;
  __REG32  ADC1_5							: 1;
  __REG32  ADC1_6							: 1;
  __REG32  ADC1_7							: 1;
  __REG32  ADC1_8							: 1;
  __REG32  ADC1_9							: 1;
  __REG32  ADC1_10  					: 1;
  __REG32  ADC1_11						: 1;
  __REG32  DAC_OUT						: 1;
  __REG32  COMP_common_a			: 1;
  __REG32  COMP_common_b			: 1;
  __REG32  COMP_0a						: 1;
  __REG32  COMP_0b						: 1;
  __REG32  COMP_1a						: 1;
  __REG32  COMP_1b						: 1;
  __REG32  COMP_2a						: 1;
} __pinenable0_bits;

/* PINENABLE 1 register */
typedef struct {
  __REG32  COMP_2b						: 1;
  __REG32  COMP_3a						: 1;
  __REG32  COMP_3b						: 1;
  __REG32  I2C0_SDA						: 1;
  __REG32  I2C0_SCL						: 1;
  __REG32  SCT0_OUT3					: 1;
  __REG32  SCT0_OUT4					: 1;
  __REG32  SCT0_OUT5					: 1;
  __REG32  SCT0_OUT6					: 1;
  __REG32  SCT0_OUT7					: 1;
  __REG32  SCT1_OUT3					: 1;
  __REG32  SCT1_OUT4					: 1;
  __REG32  SCT1_OUT5					: 1;
  __REG32  SCT1_OUT6					: 1;
  __REG32  SCT1_OUT7					: 1;
  __REG32  SCT2_OUT3					: 1;
  __REG32  SCT2_OUT4					: 1;
  __REG32  SCT2_OUT5					: 1;
  __REG32  SCT3_OUT3					: 1;
  __REG32  SCT3_OUT4					: 1;
  __REG32  SCT3_OUT5					: 1;
  __REG32  RESETN							: 1;
  __REG32  SWCLK_TCK					: 1;
  __REG32  SWDIO							: 1;
  __REG32  										: 8;
} __pinenable1_bits;

/* SCTx pinmux registers */
typedef struct {
  __REG32  INP_N							: 5;
  __REG32  							     	:27;
} __sct_pinmux_bits;

/* Pin interrupt select registers  */
typedef struct {
  __REG32  INTPIN							: 8;
  __REG32  							     	:24;
} __pintsel_bits;

/* DMA input trigger pinmux registers 0 to 17  */
typedef struct {
  __REG32  INP_N							: 5;
  __REG32  							     	:27;
} __dma_itrig_pinmux_bits;

/* Frequency measure function reference clock select register */
/* Frequency measure function target clock select register */
typedef struct {
  __REG32  CLKIN							: 5;
  __REG32  							     	:27;
} __freqmeas_ref_bits;

/* GPIO0 pins */
typedef struct {
  __REG32 P0_0   : 1;
  __REG32 P0_1   : 1;
  __REG32 P0_2   : 1;
  __REG32 P0_3   : 1;
  __REG32 P0_4   : 1;
  __REG32 P0_5   : 1;
  __REG32 P0_6   : 1;
  __REG32 P0_7   : 1;
  __REG32 P0_8   : 1;
  __REG32 P0_9   : 1;
  __REG32 P0_10  : 1;
  __REG32 P0_11  : 1;
  __REG32 P0_12  : 1;
  __REG32 P0_13  : 1;
  __REG32 P0_14  : 1;
  __REG32 P0_15  : 1;
  __REG32 P0_16  : 1;
  __REG32 P0_17  : 1;
  __REG32 P0_18  : 1;
  __REG32 P0_19  : 1;
  __REG32 P0_20  : 1;
  __REG32 P0_21  : 1;
  __REG32 P0_22  : 1;
  __REG32 P0_23  : 1;
  __REG32 P0_24  : 1;
  __REG32 P0_25  : 1;
  __REG32 P0_26  : 1;
  __REG32 P0_27  : 1;
  __REG32 P0_28  : 1;
  __REG32 P0_29  : 1;
  __REG32 P0_30  : 1;
  __REG32 P0_31  : 1;
} __gpio0_bits;

/* GPIO1 pins */
typedef struct {
  __REG32 P1_0   : 1;
  __REG32 P1_1   : 1;
  __REG32 P1_2   : 1;
  __REG32 P1_3   : 1;
  __REG32 P1_4   : 1;
  __REG32 P1_5   : 1;
  __REG32 P1_6   : 1;
  __REG32 P1_7   : 1;
  __REG32 P1_8   : 1;
  __REG32 P1_9   : 1;
  __REG32 P1_10  : 1;
  __REG32 P1_11  : 1;
  __REG32 P1_12  : 1;
  __REG32 P1_13  : 1;
  __REG32 P1_14  : 1;
  __REG32 P1_15  : 1;
  __REG32 P1_16  : 1;
  __REG32 P1_17  : 1;
  __REG32 P1_18  : 1;
  __REG32 P1_19  : 1;
  __REG32 P1_20  : 1;
  __REG32 P1_21  : 1;
  __REG32 P1_22  : 1;
  __REG32 P1_23  : 1;
  __REG32 P1_24  : 1;
  __REG32 P1_25  : 1;
  __REG32 P1_26  : 1;
  __REG32 P1_27  : 1;
  __REG32 P1_28  : 1;
  __REG32 P1_29  : 1;
  __REG32 P1_30  : 1;
  __REG32 P1_31  : 1;
} __gpio1_bits;

/* GPIO2 pins */
typedef struct {
  __REG32 P2_0   : 1;
  __REG32 P2_1   : 1;
  __REG32 P2_2   : 1;
  __REG32 P2_3   : 1;
  __REG32 P2_4   : 1;
  __REG32 P2_5   : 1;
  __REG32 P2_6   : 1;
  __REG32 P2_7   : 1;
  __REG32 P2_8   : 1;
  __REG32 P2_9   : 1;
  __REG32 P2_10  : 1;
  __REG32 P2_11  : 1;
  __REG32 P2_12  : 1;
  __REG32 P2_13  : 1;
  __REG32 P2_14  : 1;
  __REG32 P2_15  : 1;
  __REG32 P2_16  : 1;
  __REG32 P2_17  : 1;
  __REG32 P2_18  : 1;
  __REG32 P2_19  : 1;
  __REG32 P2_20  : 1;
  __REG32 P2_21  : 1;
  __REG32 P2_22  : 1;
  __REG32 P2_23  : 1;
  __REG32 P2_24  : 1;
  __REG32 P2_25  : 1;
  __REG32 P2_26  : 1;
  __REG32 P2_27  : 1;
  __REG32 P2_28  : 1;
  __REG32 P2_29  : 1;
  __REG32 P2_30  : 1;
  __REG32 P2_31  : 1;
} __gpio2_bits;

/* Grouped interrupt control register */
typedef struct {
  __REG32 INT    : 1;
  __REG32 COMB   : 1;
  __REG32 TRIG   : 1;
  __REG32 		   :29;
} __gint_ctrl_bits;

/* GPIO grouped interrupt port polarity registers */
typedef struct {
  __REG32 POL0   : 1;
  __REG32 POL1   : 1;
  __REG32 POL2   : 1;
  __REG32 POL3   : 1;
  __REG32 POL4   : 1;
  __REG32 POL5   : 1;
  __REG32 POL6   : 1;
  __REG32 POL7   : 1;
  __REG32 POL8   : 1;
  __REG32 POL9   : 1;
  __REG32 POL10  : 1;
  __REG32 POL11  : 1;
  __REG32 POL12  : 1;
  __REG32 POL13  : 1;
  __REG32 POL14  : 1;
  __REG32 POL15  : 1;
  __REG32 POL16  : 1;
  __REG32 POL17  : 1;
  __REG32 POL18  : 1;
  __REG32 POL19  : 1;
  __REG32 POL20  : 1;
  __REG32 POL21  : 1;
  __REG32 POL22  : 1;
  __REG32 POL23  : 1;
  __REG32 POL24  : 1;
  __REG32 POL25  : 1;
  __REG32 POL26  : 1;
  __REG32 POL27  : 1;
  __REG32 POL28  : 1;
  __REG32 POL29  : 1;
  __REG32 POL30  : 1;
  __REG32 POL31  : 1;
} __gint_port_pol_bits;

/* GPIO grouped interrupt port polarity registers */
typedef struct {
  __REG32 ENA0   : 1;
  __REG32 ENA1   : 1;
  __REG32 ENA2   : 1;
  __REG32 ENA3   : 1;
  __REG32 ENA4   : 1;
  __REG32 ENA5   : 1;
  __REG32 ENA6   : 1;
  __REG32 ENA7   : 1;
  __REG32 ENA8   : 1;
  __REG32 ENA9   : 1;
  __REG32 ENA10  : 1;
  __REG32 ENA11  : 1;
  __REG32 ENA12  : 1;
  __REG32 ENA13  : 1;
  __REG32 ENA14  : 1;
  __REG32 ENA15  : 1;
  __REG32 ENA16  : 1;
  __REG32 ENA17  : 1;
  __REG32 ENA18  : 1;
  __REG32 ENA19  : 1;
  __REG32 ENA20  : 1;
  __REG32 ENA21  : 1;
  __REG32 ENA22  : 1;
  __REG32 ENA23  : 1;
  __REG32 ENA24  : 1;
  __REG32 ENA25  : 1;
  __REG32 ENA26  : 1;
  __REG32 ENA27  : 1;
  __REG32 ENA28  : 1;
  __REG32 ENA29  : 1;
  __REG32 ENA30  : 1;
  __REG32 ENA31  : 1;
} __gint_port_ena_bits;

/* Pin interrupt mode register */
typedef struct {
  __REG32 PMODE0    : 1;
  __REG32 PMODE1    : 1;
  __REG32 PMODE2    : 1;
  __REG32 PMODE3    : 1;
  __REG32 PMODE4    : 1;
  __REG32 PMODE5    : 1;
  __REG32 PMODE6    : 1;
  __REG32 PMODE7    : 1;
  __REG32 		   		:24;
} __pin_isel_bits;

/* Pin interrupt level or risingedge interrupt enable register */
typedef struct {
  __REG32 ENRL0    	: 1;
  __REG32 ENRL1    	: 1;
  __REG32 ENRL2    	: 1;
  __REG32 ENRL3    	: 1;
  __REG32 ENRL4    	: 1;
  __REG32 ENRL5    	: 1;
  __REG32 ENRL6    	: 1;
  __REG32 ENRL7    	: 1;
  __REG32 		   		:24;
} __pin_ienr_bits;

/* Pin interrupt active level or falling edge interrupt enable register */
typedef struct {
  __REG32 ENAF0    	: 1;
  __REG32 ENAF1    	: 1;
  __REG32 ENAF2    	: 1;
  __REG32 ENAF3    	: 1;
  __REG32 ENAF4    	: 1;
  __REG32 ENAF5    	: 1;
  __REG32 ENAF6    	: 1;
  __REG32 ENAF7    	: 1;
  __REG32 		   		:24;
} __pin_ienf_bits;

/* Pin interrupt rising edge register */
typedef struct {
  __REG32 RDET0    	: 1;
  __REG32 RDET1    	: 1;
  __REG32 RDET2    	: 1;
  __REG32 RDET3    	: 1;
  __REG32 RDET4    	: 1;
  __REG32 RDET5    	: 1;
  __REG32 RDET6    	: 1;
  __REG32 RDET7    	: 1;
  __REG32 		   		:24;
} __pin_rise_bits;

/* Pin interrupt falling edge register */
typedef struct {
  __REG32 FDET0    	: 1;
  __REG32 FDET1    	: 1;
  __REG32 FDET2    	: 1;
  __REG32 FDET3    	: 1;
  __REG32 FDET4    	: 1;
  __REG32 FDET5    	: 1;
  __REG32 FDET6    	: 1;
  __REG32 FDET7    	: 1;
  __REG32 		   		:24;
} __pin_fall_bits;

/* Pin interrupt falling edge register */
typedef struct {
  __REG32 PSTAT0    	: 1;
  __REG32 PSTAT1    	: 1;
  __REG32 PSTAT2    	: 1;
  __REG32 PSTAT3    	: 1;
  __REG32 PSTAT4    	: 1;
  __REG32 PSTAT5    	: 1;
  __REG32 PSTAT6    	: 1;
  __REG32 PSTAT7    	: 1;
  __REG32 		   			:24;
} __pin_ist_bits;

/* Pattern Match Interrupt Control Register */
typedef struct {
  __REG32 SEL_PMATCH	: 1;
  __REG32 ENA_RXEV		: 1;
  __REG32 			    	:22;
  __REG32 PMAT	    	: 8;
} __pin_pmctrl_bits;

/* Pattern Match Interrupt Bit-Slice Source register */
typedef struct {
  __REG32 			    	: 8;
  __REG32 SRC0				: 3;
  __REG32 SRC1				: 3;
  __REG32 SRC2				: 3;
  __REG32 SRC3				: 3;
  __REG32 SRC4				: 3;
  __REG32 SRC5				: 3;
  __REG32 SRC6				: 3;
  __REG32 SRC7				: 3;
} __pin_pmsrc_bits;

/* Pattern Match Interrupt Bit Slice Configuration register */
typedef struct {
  __REG32 PROD_ENDPTS	: 7;
  __REG32 						: 1;
  __REG32 CFG0				: 3;
  __REG32 CFG1				: 3;
  __REG32 CFG2				: 3;
  __REG32 CFG3				: 3;
  __REG32 CFG4				: 3;
  __REG32 CFG5				: 3;
  __REG32 CFG6				: 3;
  __REG32 CFG7				: 3;
} __pin_pmcfg_bits;

/* DMA Control register */
typedef struct {
  __REG32 ENABLE			: 1;
  __REG32 						:31;
} __dma_ctrl_bits;

/* DMA Interrupt Status register */
typedef struct {
  __REG32 							: 1;
  __REG32 ACTIVEINT			: 1;
  __REG32 ACTIVEERRINT	: 1;
  __REG32 							:29;
} __dma_intstat_bits;

/* DMA Enable read and Set registers */
typedef struct {
  __REG32 ENA0					: 1;
  __REG32 ENA1					: 1;
  __REG32 ENA2					: 1;
  __REG32 ENA3					: 1;
  __REG32 ENA4					: 1;
  __REG32 ENA5					: 1;
  __REG32 ENA6					: 1;
  __REG32 ENA7					: 1;
  __REG32 ENA8					: 1;
  __REG32 ENA9					: 1;
  __REG32 ENA10					: 1;
  __REG32 ENA11					: 1;
  __REG32 ENA12					: 1;
  __REG32 ENA13					: 1;
  __REG32 ENA14					: 1;
  __REG32 ENA15					: 1;
  __REG32 ENA16					: 1;
  __REG32 ENA17					: 1;
  __REG32 							:14;
} __dma_enableset_bits;

/* DMA Active status register */
typedef struct {
  __REG32 ACT0					: 1;
  __REG32 ACT1					: 1;
  __REG32 ACT2					: 1;
  __REG32 ACT3					: 1;
  __REG32 ACT4					: 1;
  __REG32 ACT5					: 1;
  __REG32 ACT6					: 1;
  __REG32 ACT7					: 1;
  __REG32 ACT8					: 1;
  __REG32 ACT9					: 1;
  __REG32 ACT10					: 1;
  __REG32 ACT11					: 1;
  __REG32 ACT12					: 1;
  __REG32 ACT13					: 1;
  __REG32 ACT14					: 1;
  __REG32 ACT15					: 1;
  __REG32 ACT16					: 1;
  __REG32 ACT17					: 1;
  __REG32 							:14;
} __dma_active_bits;

/* DMA Busy status register */
typedef struct {
  __REG32 BSY0					: 1;
  __REG32 BSY1					: 1;
  __REG32 BSY2					: 1;
  __REG32 BSY3					: 1;
  __REG32 BSY4					: 1;
  __REG32 BSY5					: 1;
  __REG32 BSY6					: 1;
  __REG32 BSY7					: 1;
  __REG32 BSY8					: 1;
  __REG32 BSY9					: 1;
  __REG32 BSY10					: 1;
  __REG32 BSY11					: 1;
  __REG32 BSY12					: 1;
  __REG32 BSY13					: 1;
  __REG32 BSY14					: 1;
  __REG32 BSY15					: 1;
  __REG32 BSY16					: 1;
  __REG32 BSY17					: 1;
  __REG32 							:14;
} __dma_busy_bits;

/* DMA Error Interrupt register */
typedef struct {
  __REG32 ERR0					: 1;
  __REG32 ERR1					: 1;
  __REG32 ERR2					: 1;
  __REG32 ERR3					: 1;
  __REG32 ERR4					: 1;
  __REG32 ERR5					: 1;
  __REG32 ERR6					: 1;
  __REG32 ERR7					: 1;
  __REG32 ERR8					: 1;
  __REG32 ERR9					: 1;
  __REG32 ERR10					: 1;
  __REG32 ERR11					: 1;
  __REG32 ERR12					: 1;
  __REG32 ERR13					: 1;
  __REG32 ERR14					: 1;
  __REG32 ERR15					: 1;
  __REG32 ERR16					: 1;
  __REG32 ERR17					: 1;
  __REG32 							:14;
} __dma_errint_bits;

/* DMA Interrupt Enable read and Set register */
typedef struct {
  __REG32 INTEN0					: 1;
  __REG32 INTEN1					: 1;
  __REG32 INTEN2					: 1;
  __REG32 INTEN3					: 1;
  __REG32 INTEN4					: 1;
  __REG32 INTEN5					: 1;
  __REG32 INTEN6					: 1;
  __REG32 INTEN7					: 1;
  __REG32 INTEN8					: 1;
  __REG32 INTEN9					: 1;
  __REG32 INTEN10					: 1;
  __REG32 INTEN11					: 1;
  __REG32 INTEN12					: 1;
  __REG32 INTEN13					: 1;
  __REG32 INTEN14					: 1;
  __REG32 INTEN15					: 1;
  __REG32 INTEN16					: 1;
  __REG32 INTEN17					: 1;
  __REG32 								:14;
} __dma_intenset_bits;

/* DMA Interrupt A register */
typedef struct {
  __REG32 IA0					: 1;
  __REG32 IA1					: 1;
  __REG32 IA2					: 1;
  __REG32 IA3					: 1;
  __REG32 IA4					: 1;
  __REG32 IA5					: 1;
  __REG32 IA6					: 1;
  __REG32 IA7					: 1;
  __REG32 IA8					: 1;
  __REG32 IA9					: 1;
  __REG32 IA10				: 1;
  __REG32 IA11				: 1;
  __REG32 IA12				: 1;
  __REG32 IA13				: 1;
  __REG32 IA14				: 1;
  __REG32 IA15				: 1;
  __REG32 IA16				: 1;
  __REG32 IA17				: 1;
  __REG32 						:14;
} __dma_inta_bits;

/* DMA Interrupt B register */
typedef struct {
  __REG32 IB0					: 1;
  __REG32 IB1					: 1;
  __REG32 IB2					: 1;
  __REG32 IB3					: 1;
  __REG32 IB4					: 1;
  __REG32 IB5					: 1;
  __REG32 IB6					: 1;
  __REG32 IB7					: 1;
  __REG32 IB8					: 1;
  __REG32 IB9					: 1;
  __REG32 IB10				: 1;
  __REG32 IB11				: 1;
  __REG32 IB12				: 1;
  __REG32 IB13				: 1;
  __REG32 IB14				: 1;
  __REG32 IB15				: 1;
  __REG32 IB16				: 1;
  __REG32 IB17				: 1;
  __REG32 						:14;
} __dma_intb_bits;

/* DMA Configuration register for channel n  */
typedef struct {
  __REG32 PERIPHREQEN		: 1;
  __REG32 HWTRIGEN			: 1;
  __REG32 							: 2;
  __REG32 TRIGPOL				: 1;
  __REG32 TRIGTYPE			: 1;
  __REG32 TRIGBURST			: 1;
  __REG32 							: 1;
  __REG32 BURSTPOWER		: 4;
  __REG32 							: 2;
  __REG32 SRCBURSTWRAP	: 1;
  __REG32 DSTBURSTWRAP	: 1;
  __REG32 CHPRIORITY		: 3;
  __REG32 							:13;
} __dma_cfg_bits;

/* DMA Control and Status register for channel n  */
typedef struct {
  __REG32 VALIDPENDING	: 1;
  __REG32 							: 1;
  __REG32 TRIG					: 1;
  __REG32 							:29;
} __dma_ctrlstat_bits;

/* Transfer Configuration register for channel n */
typedef struct {
  __REG32 CFGVALID			: 1;
  __REG32 RELOAD				: 1;
  __REG32 SWTRIG				: 1;
  __REG32 CLRTRIG				: 1;
  __REG32 SETINTA				: 1;
  __REG32 SETINTB				: 1;
  __REG32 							: 2;
  __REG32 WIDTH					: 2;
  __REG32 							: 2;
  __REG32 SRCINC				: 2;
  __REG32 DSTINC				: 2;
  __REG32 XFERCOUNT			:10;
  __REG32 							: 6;
} __dma_xfercfg_bits;

/* SCT IPU Sample control register */
typedef struct {
  __REG32 IN0SEL				: 1;
  __REG32 IN1SEL				: 1;
  __REG32 IN2SEL				: 1;
  __REG32 IN3SEL				: 1;
  __REG32 SAMPLE_EN0SEL	: 2;
  __REG32 SAMPLE_EN1SEL	: 2;
  __REG32 SAMPLE_EN2SEL	: 2;
  __REG32 SAMPLE_EN3SEL	: 2;
  __REG32 LATCHEN0			: 1;
  __REG32 LATCHEN1			: 1;
  __REG32 LATCHEN2			: 1;
  __REG32 LATCHEN3			: 1;
  __REG32 							:16;
} __sct_ipu_sample_ctrl_bits;

/* SCT Abort enable registers 0 to 3 */
typedef struct {
  __REG32 ENA0					: 1;
  __REG32 ENA1					: 1;
  __REG32 ENA2					: 1;
  __REG32 ENA3					: 1;
  __REG32 ENA4					: 1;
  __REG32 ENA5					: 1;
  __REG32 ENA6					: 1;
  __REG32 ENA7					: 1;
  __REG32 ENA8					: 1;
  __REG32 							:23;
} __sct_ipu_abort_enable_bits;

/* SCT Abort enable registers 0 to 3 */
typedef struct {
  __REG32 ACT0					: 1;
  __REG32 ACT1					: 1;
  __REG32 ACT2					: 1;
  __REG32 ACT3					: 1;
  __REG32 ACT4					: 1;
  __REG32 ACT5					: 1;
  __REG32 ACT6					: 1;
  __REG32 ACT7					: 1;
  __REG32 ACT8					: 1;
  __REG32 							:23;
} __sct_ipu_abort_source_bits;

/* SCT configuration register */
typedef struct {
  __REG32 UNIFY					: 1;
  __REG32 CLKMODE				: 2;
  __REG32 CLKSEL				: 4;
  __REG32 NORELAOD_L		: 1;
  __REG32 NORELOAD_H		: 1;
  __REG32 INSYNC				: 8;
  __REG32 AUTOLIMIT_L		: 1;
  __REG32 AUTOLIMIT_H		: 1;
  __REG32 							:13;
} __sct0_config_bits;

/* SCT configuration register */
typedef union {
	/*SCTx_CTRL*/
	struct {
  __REG32 DOWN_L				: 1;
  __REG32 STOP_L				: 1;
  __REG32 HALT_L				: 1;
  __REG32 CLRCTR_L			: 1;
  __REG32 BIDIR_L				: 1;
  __REG32 PRE_L					: 8;
  __REG32 							: 3;
  __REG32 DOWN_H				: 1;
  __REG32 STOP_H				: 1;
  __REG32 HALT_H				: 1;
  __REG32 CLRCTR_H			: 1;
  __REG32 BIDIR_H				: 1;
  __REG32 PRE_H					: 8;
  __REG32 							: 3;
  };
  struct
  {
    union
    {
			/*SCTx_CTRL_L*/
		  struct
		  {
		  __REG16 DOWN_L				: 1;
		  __REG16 STOP_L				: 1;
		  __REG16 HALT_L				: 1;
		  __REG16 CLRCTR_L			: 1;
		  __REG16 BIDIR_L				: 1;
		  __REG16 PRE_L					: 8;
		  __REG16 							: 3;
    	} __shortl_bit;
    	__REG16 __shortl;
		};
    union
    {
			/*SCTx_CTRL_H*/
		  struct
		  {
		  __REG16 DOWN_H				: 1;
		  __REG16 STOP_H				: 1;
		  __REG16 HALT_H				: 1;
		  __REG16 CLRCTR_H			: 1;
		  __REG16 BIDIR_H				: 1;
		  __REG16 PRE_H					: 8;
		  __REG16 							: 3;
    	} __shorth_bit;
    	__REG16 __shorth;
		};
	};
} __sct0_ctrl_bits;

/* SCT limit register */
typedef union {
	/*SCTx_LIMIT*/
	struct {
  __REG32 LIMMSK_L0			: 1;
  __REG32 LIMMSK_L1			: 1;
  __REG32 LIMMSK_L2			: 1;
  __REG32 LIMMSK_L3			: 1;
  __REG32 LIMMSK_L4			: 1;
  __REG32 LIMMSK_L5			: 1;
  __REG32 LIMMSK_L6			: 1;
  __REG32 LIMMSK_L7			: 1;
  __REG32 LIMMSK_L8			: 1;
  __REG32 LIMMSK_L9			: 1;
  __REG32 LIMMSK_L10		: 1;
  __REG32 LIMMSK_L11		: 1;
  __REG32 LIMMSK_L12		: 1;
  __REG32 LIMMSK_L13		: 1;
  __REG32 LIMMSK_L14		: 1;
  __REG32 LIMMSK_L15		: 1;
  __REG32 LIMMSK_H0			: 1;
  __REG32 LIMMSK_H1			: 1;
  __REG32 LIMMSK_H2			: 1;
  __REG32 LIMMSK_H3			: 1;
  __REG32 LIMMSK_H4			: 1;
  __REG32 LIMMSK_H5			: 1;
  __REG32 LIMMSK_H6			: 1;
  __REG32 LIMMSK_H7			: 1;
  __REG32 LIMMSK_H8			: 1;
  __REG32 LIMMSK_H9			: 1;
  __REG32 LIMMSK_H10		: 1;
  __REG32 LIMMSK_H11		: 1;
  __REG32 LIMMSK_H12		: 1;
  __REG32 LIMMSK_H13		: 1;
  __REG32 LIMMSK_H14		: 1;
  __REG32 LIMMSK_H15		: 1;
  };
  struct
  {
    union
    {
			/*SCTx_LIMIT_L*/
		  struct
		  {
		  __REG16 LIMMSK_L0			: 1;
		  __REG16 LIMMSK_L1			: 1;
		  __REG16 LIMMSK_L2			: 1;
		  __REG16 LIMMSK_L3			: 1;
		  __REG16 LIMMSK_L4			: 1;
		  __REG16 LIMMSK_L5			: 1;
		  __REG16 LIMMSK_L6			: 1;
		  __REG16 LIMMSK_L7			: 1;
		  __REG16 LIMMSK_L8			: 1;
		  __REG16 LIMMSK_L9			: 1;
		  __REG16 LIMMSK_L10		: 1;
		  __REG16 LIMMSK_L11		: 1;
		  __REG16 LIMMSK_L12		: 1;
		  __REG16 LIMMSK_L13		: 1;
		  __REG16 LIMMSK_L14		: 1;
		  __REG16 LIMMSK_L15		: 1;
    	} __shortl_bit;
    	__REG16 __shortl;
		};
    union
    {
			/*SCTx_LIMIT_H*/
		  struct
		  {
		  __REG16 LIMMSK_H0			: 1;
		  __REG16 LIMMSK_H1			: 1;
		  __REG16 LIMMSK_H2			: 1;
		  __REG16 LIMMSK_H3			: 1;
		  __REG16 LIMMSK_H4			: 1;
		  __REG16 LIMMSK_H5			: 1;
		  __REG16 LIMMSK_H6			: 1;
		  __REG16 LIMMSK_H7			: 1;
		  __REG16 LIMMSK_H8			: 1;
		  __REG16 LIMMSK_H9			: 1;
		  __REG16 LIMMSK_H10		: 1;
		  __REG16 LIMMSK_H11		: 1;
		  __REG16 LIMMSK_H12		: 1;
		  __REG16 LIMMSK_H13		: 1;
		  __REG16 LIMMSK_H14		: 1;
		  __REG16 LIMMSK_H15		: 1;
    	} __shorth_bit;
    	__REG16 __shorth;
		};
	};
} __sct0_limit_bits;

/* SCT halt condition register */
typedef union {
	/*SCTx_HALT*/
	struct {
  __REG32 HALTMSK_L0			: 1;
  __REG32 HALTMSK_L1			: 1;
  __REG32 HALTMSK_L2			: 1;
  __REG32 HALTMSK_L3			: 1;
  __REG32 HALTMSK_L4			: 1;
  __REG32 HALTMSK_L5			: 1;
  __REG32 HALTMSK_L6			: 1;
  __REG32 HALTMSK_L7			: 1;
  __REG32 HALTMSK_L8			: 1;
  __REG32 HALTMSK_L9			: 1;
  __REG32 HALTMSK_L10			: 1;
  __REG32 HALTMSK_L11			: 1;
  __REG32 HALTMSK_L12			: 1;
  __REG32 HALTMSK_L13			: 1;
  __REG32 HALTMSK_L14			: 1;
  __REG32 HALTMSK_L15			: 1;
  __REG32 HALTMSK_H0			: 1;
  __REG32 HALTMSK_H1			: 1;
  __REG32 HALTMSK_H2			: 1;
  __REG32 HALTMSK_H3			: 1;
  __REG32 HALTMSK_H4			: 1;
  __REG32 HALTMSK_H5			: 1;
  __REG32 HALTMSK_H6			: 1;
  __REG32 HALTMSK_H7			: 1;
  __REG32 HALTMSK_H8			: 1;
  __REG32 HALTMSK_H9			: 1;
  __REG32 HALTMSK_H10			: 1;
  __REG32 HALTMSK_H11			: 1;
  __REG32 HALTMSK_H12			: 1;
  __REG32 HALTMSK_H13			: 1;
  __REG32 HALTMSK_H14			: 1;
  __REG32 HALTMSK_H15			: 1;
  };
  struct
  {
    union
    {
			/*SCTx_HALT_L*/
		  struct
		  {
		  __REG16 HALTMSK_L0			: 1;
		  __REG16 HALTMSK_L1			: 1;
		  __REG16 HALTMSK_L2			: 1;
		  __REG16 HALTMSK_L3			: 1;
		  __REG16 HALTMSK_L4			: 1;
		  __REG16 HALTMSK_L5			: 1;
		  __REG16 HALTMSK_L6			: 1;
		  __REG16 HALTMSK_L7			: 1;
		  __REG16 HALTMSK_L8			: 1;
		  __REG16 HALTMSK_L9			: 1;
		  __REG16 HALTMSK_L10			: 1;
		  __REG16 HALTMSK_L11			: 1;
		  __REG16 HALTMSK_L12			: 1;
		  __REG16 HALTMSK_L13			: 1;
		  __REG16 HALTMSK_L14			: 1;
		  __REG16 HALTMSK_L15			: 1;
    	} __shortl_bit;
    	__REG16 __shortl;
		};
    union
    {
			/*SCTx_HALT_H*/
		  struct
		  {
		  __REG16 HALTMSK_H0			: 1;
		  __REG16 HALTMSK_H1			: 1;
		  __REG16 HALTMSK_H2			: 1;
		  __REG16 HALTMSK_H3			: 1;
		  __REG16 HALTMSK_H4			: 1;
		  __REG16 HALTMSK_H5			: 1;
		  __REG16 HALTMSK_H6			: 1;
		  __REG16 HALTMSK_H7			: 1;
		  __REG16 HALTMSK_H8			: 1;
		  __REG16 HALTMSK_H9			: 1;
		  __REG16 HALTMSK_H10			: 1;
		  __REG16 HALTMSK_H11			: 1;
		  __REG16 HALTMSK_H12			: 1;
		  __REG16 HALTMSK_H13			: 1;
		  __REG16 HALTMSK_H14			: 1;
		  __REG16 HALTMSK_H15			: 1;
    	} __shorth_bit;
    	__REG16 __shorth;
		};
	};
} __sct0_halt_bits;

/* SCT stop condition register */
typedef union {
	/*SCTx_STOP*/
	struct {
  __REG32 STOPMSK_L0			: 1;
  __REG32 STOPMSK_L1			: 1;
  __REG32 STOPMSK_L2			: 1;
  __REG32 STOPMSK_L3			: 1;
  __REG32 STOPMSK_L4			: 1;
  __REG32 STOPMSK_L5			: 1;
  __REG32 STOPMSK_L6			: 1;
  __REG32 STOPMSK_L7			: 1;
  __REG32 STOPMSK_L8			: 1;
  __REG32 STOPMSK_L9			: 1;
  __REG32 STOPMSK_L10			: 1;
  __REG32 STOPMSK_L11			: 1;
  __REG32 STOPMSK_L12			: 1;
  __REG32 STOPMSK_L13			: 1;
  __REG32 STOPMSK_L14			: 1;
  __REG32 STOPMSK_L15			: 1;
  __REG32 STOPMSK_H0			: 1;
  __REG32 STOPMSK_H1			: 1;
  __REG32 STOPMSK_H2			: 1;
  __REG32 STOPMSK_H3			: 1;
  __REG32 STOPMSK_H4			: 1;
  __REG32 STOPMSK_H5			: 1;
  __REG32 STOPMSK_H6			: 1;
  __REG32 STOPMSK_H7			: 1;
  __REG32 STOPMSK_H8			: 1;
  __REG32 STOPMSK_H9			: 1;
  __REG32 STOPMSK_H10			: 1;
  __REG32 STOPMSK_H11			: 1;
  __REG32 STOPMSK_H12			: 1;
  __REG32 STOPMSK_H13			: 1;
  __REG32 STOPMSK_H14			: 1;
  __REG32 STOPMSK_H15			: 1;
  };
  struct
  {
    union
    {
			/*SCTx_STOP_L*/
		  struct
		  {
		  __REG16 STOPMSK_L0			: 1;
		  __REG16 STOPMSK_L1			: 1;
		  __REG16 STOPMSK_L2			: 1;
		  __REG16 STOPMSK_L3			: 1;
		  __REG16 STOPMSK_L4			: 1;
		  __REG16 STOPMSK_L5			: 1;
		  __REG16 STOPMSK_L6			: 1;
		  __REG16 STOPMSK_L7			: 1;
		  __REG16 STOPMSK_L8			: 1;
		  __REG16 STOPMSK_L9			: 1;
		  __REG16 STOPMSK_L10			: 1;
		  __REG16 STOPMSK_L11			: 1;
		  __REG16 STOPMSK_L12			: 1;
		  __REG16 STOPMSK_L13			: 1;
		  __REG16 STOPMSK_L14			: 1;
		  __REG16 STOPMSK_L15			: 1;
    	} __shortl_bit;
    	__REG16 __shortl;
		};
    union
    {
			/*SCTx_STOP_H*/
		  struct
		  {
		  __REG16 STOPMSK_H0			: 1;
		  __REG16 STOPMSK_H1			: 1;
		  __REG16 STOPMSK_H2			: 1;
		  __REG16 STOPMSK_H3			: 1;
		  __REG16 STOPMSK_H4			: 1;
		  __REG16 STOPMSK_H5			: 1;
		  __REG16 STOPMSK_H6			: 1;
		  __REG16 STOPMSK_H7			: 1;
		  __REG16 STOPMSK_H8			: 1;
		  __REG16 STOPMSK_H9			: 1;
		  __REG16 STOPMSK_H10			: 1;
		  __REG16 STOPMSK_H11			: 1;
		  __REG16 STOPMSK_H12			: 1;
		  __REG16 STOPMSK_H13			: 1;
		  __REG16 STOPMSK_H14			: 1;
		  __REG16 STOPMSK_H15			: 1;
    	} __shorth_bit;
    	__REG16 __shorth;
		};
	};
} __sct0_stop_bits;

/* SCT stop condition register */
typedef union {
	/*SCTx_START*/
	struct {
  __REG32 STARTMSK_L0			: 1;
  __REG32 STARTMSK_L1			: 1;
  __REG32 STARTMSK_L2			: 1;
  __REG32 STARTMSK_L3			: 1;
  __REG32 STARTMSK_L4			: 1;
  __REG32 STARTMSK_L5			: 1;
  __REG32 STARTMSK_L6			: 1;
  __REG32 STARTMSK_L7			: 1;
  __REG32 STARTMSK_L8			: 1;
  __REG32 STARTMSK_L9			: 1;
  __REG32 STARTMSK_L10		: 1;
  __REG32 STARTMSK_L11		: 1;
  __REG32 STARTMSK_L12		: 1;
  __REG32 STARTMSK_L13		: 1;
  __REG32 STARTMSK_L14		: 1;
  __REG32 STARTMSK_L15		: 1;
  __REG32 STARTMSK_H0			: 1;
  __REG32 STARTMSK_H1			: 1;
  __REG32 STARTMSK_H2			: 1;
  __REG32 STARTMSK_H3			: 1;
  __REG32 STARTMSK_H4			: 1;
  __REG32 STARTMSK_H5			: 1;
  __REG32 STARTMSK_H6			: 1;
  __REG32 STARTMSK_H7			: 1;
  __REG32 STARTMSK_H8			: 1;
  __REG32 STARTMSK_H9			: 1;
  __REG32 STARTMSK_H10		: 1;
  __REG32 STARTMSK_H11		: 1;
  __REG32 STARTMSK_H12		: 1;
  __REG32 STARTMSK_H13		: 1;
  __REG32 STARTMSK_H14		: 1;
  __REG32 STARTMSK_H15		: 1;
  };
  struct
  {
    union
    {
			/*SCTx_START_L*/
		  struct
		  {
		  __REG16 STARTMSK_L0			: 1;
		  __REG16 STARTMSK_L1			: 1;
		  __REG16 STARTMSK_L2			: 1;
		  __REG16 STARTMSK_L3			: 1;
		  __REG16 STARTMSK_L4			: 1;
		  __REG16 STARTMSK_L5			: 1;
		  __REG16 STARTMSK_L6			: 1;
		  __REG16 STARTMSK_L7			: 1;
		  __REG16 STARTMSK_L8			: 1;
		  __REG16 STARTMSK_L9			: 1;
		  __REG16 STARTMSK_L10		: 1;
		  __REG16 STARTMSK_L11		: 1;
		  __REG16 STARTMSK_L12		: 1;
		  __REG16 STARTMSK_L13		: 1;
		  __REG16 STARTMSK_L14		: 1;
		  __REG16 STARTMSK_L15		: 1;
    	} __shortl_bit;
    	__REG16 __shortl;
		};
    union
    {
			/*SCTx_START_H*/
		  struct
		  {
		  __REG16 STARTMSK_H0			: 1;
		  __REG16 STARTMSK_H1			: 1;
		  __REG16 STARTMSK_H2			: 1;
		  __REG16 STARTMSK_H3			: 1;
		  __REG16 STARTMSK_H4			: 1;
		  __REG16 STARTMSK_H5			: 1;
		  __REG16 STARTMSK_H6			: 1;
		  __REG16 STARTMSK_H7			: 1;
		  __REG16 STARTMSK_H8			: 1;
		  __REG16 STARTMSK_H9			: 1;
		  __REG16 STARTMSK_H10		: 1;
		  __REG16 STARTMSK_H11		: 1;
		  __REG16 STARTMSK_H12		: 1;
		  __REG16 STARTMSK_H13		: 1;
		  __REG16 STARTMSK_H14		: 1;
		  __REG16 STARTMSK_H15		: 1;
    	} __shorth_bit;
    	__REG16 __shorth;
		};
	};
} __sct0_start_bits;

/* SCT dither condition register */
typedef union {
	/*SCTx_DITHER*/
	struct {
  __REG32 DITHMSK_L0			: 1;
  __REG32 DITHMSK_L1			: 1;
  __REG32 DITHMSK_L2			: 1;
  __REG32 DITHMSK_L3			: 1;
  __REG32 DITHMSK_L4			: 1;
  __REG32 DITHMSK_L5			: 1;
  __REG32 DITHMSK_L6			: 1;
  __REG32 DITHMSK_L7			: 1;
  __REG32 DITHMSK_L8			: 1;
  __REG32 DITHMSK_L9			: 1;
  __REG32 DITHMSK_L10			: 1;
  __REG32 DITHMSK_L11			: 1;
  __REG32 DITHMSK_L12			: 1;
  __REG32 DITHMSK_L13			: 1;
  __REG32 DITHMSK_L14			: 1;
  __REG32 DITHMSK_L15			: 1;
  __REG32 DITHMSK_H0			: 1;
  __REG32 DITHMSK_H1			: 1;
  __REG32 DITHMSK_H2			: 1;
  __REG32 DITHMSK_H3			: 1;
  __REG32 DITHMSK_H4			: 1;
  __REG32 DITHMSK_H5			: 1;
  __REG32 DITHMSK_H6			: 1;
  __REG32 DITHMSK_H7			: 1;
  __REG32 DITHMSK_H8			: 1;
  __REG32 DITHMSK_H9			: 1;
  __REG32 DITHMSK_H10			: 1;
  __REG32 DITHMSK_H11			: 1;
  __REG32 DITHMSK_H12			: 1;
  __REG32 DITHMSK_H13			: 1;
  __REG32 DITHMSK_H14			: 1;
  __REG32 DITHMSK_H15			: 1;
  };
  struct
  {
    union
    {
			/*SCTx_DITHER_L*/
		  struct
		  {
		  __REG16 DITHMSK_L0			: 1;
		  __REG16 DITHMSK_L1			: 1;
		  __REG16 DITHMSK_L2			: 1;
		  __REG16 DITHMSK_L3			: 1;
		  __REG16 DITHMSK_L4			: 1;
		  __REG16 DITHMSK_L5			: 1;
		  __REG16 DITHMSK_L6			: 1;
		  __REG16 DITHMSK_L7			: 1;
		  __REG16 DITHMSK_L8			: 1;
		  __REG16 DITHMSK_L9			: 1;
		  __REG16 DITHMSK_L10			: 1;
		  __REG16 DITHMSK_L11			: 1;
		  __REG16 DITHMSK_L12			: 1;
		  __REG16 DITHMSK_L13			: 1;
		  __REG16 DITHMSK_L14			: 1;
		  __REG16 DITHMSK_L15			: 1;
    	} __shortl_bit;
    	__REG16 __shortl;
		};
    union
    {
			/*SCTx_DITHER_H*/
		  struct
		  {
		  __REG16 DITHMSK_H0			: 1;
		  __REG16 DITHMSK_H1			: 1;
		  __REG16 DITHMSK_H2			: 1;
		  __REG16 DITHMSK_H3			: 1;
		  __REG16 DITHMSK_H4			: 1;
		  __REG16 DITHMSK_H5			: 1;
		  __REG16 DITHMSK_H6			: 1;
		  __REG16 DITHMSK_H7			: 1;
		  __REG16 DITHMSK_H8			: 1;
		  __REG16 DITHMSK_H9			: 1;
		  __REG16 DITHMSK_H10			: 1;
		  __REG16 DITHMSK_H11			: 1;
		  __REG16 DITHMSK_H12			: 1;
		  __REG16 DITHMSK_H13			: 1;
		  __REG16 DITHMSK_H14			: 1;
		  __REG16 DITHMSK_H15			: 1;
    	} __shorth_bit;
    	__REG16 __shorth;
		};
	};
} __sct0_dither_bits;

/* SCT counter register */
typedef union {
	/*SCTx_COUNT*/
	struct {
  __REG32 CTR_L						:16;
  __REG32 CTR_H						:16;
  };
  struct
  {  	
  	__REG16 __shortl;
  	__REG16 __shorth;
	};
} __sct0_count_bits;

/* SCT state register  */
typedef union {
	/*SCTx_STATE*/
	struct {
  __REG32  STATE_L	      	: 5;
  __REG32  					      	:11;
  __REG32  STATE_H		      : 5;
  __REG32  						      :11;
  };
  struct
  {
  	union { 	
		/*SCTx_STATE_L*/
	  	struct {
			  __REG16  STATE_L	      	: 5;
			  __REG16  					      	:11;
	  	} __shortl_bit;
	  	__REG16 __shortl;
  	};
  	union { 	
		/*SCTx_STATE_H*/
	  	struct {
			  __REG16  STATE_H	      	: 5;
			  __REG16  					      	:11;
	  	} __shorth_bit;
	  	__REG16 __shorth;
  	};
	};
} __sct0_state_bits;

/* SCT input register  */
typedef struct {
  __REG32  AIN0			      	: 1;
  __REG32  AIN1			      	: 1;
  __REG32  AIN2			      	: 1;
  __REG32  AIN3			      	: 1;
  __REG32  AIN4			      	: 1;
  __REG32  AIN5			      	: 1;
  __REG32  AIN6			      	: 1;
  __REG32  AIN7			      	: 1;
  __REG32  					      	: 8;
  __REG32  SIN0				      : 1;
  __REG32  SIN1				      : 1;
  __REG32  SIN2				      : 1;
  __REG32  SIN3				      : 1;
  __REG32  SIN4				      : 1;
  __REG32  SIN5				      : 1;
  __REG32  SIN6				      : 1;
  __REG32  SIN7				      : 1;
  __REG32  						      : 8;
} __sct0_input_bits;

/* SCT match/capture registers mode register  */
typedef union {
	/*SCTx_REGMODE*/
	struct {
	  __REG32  REGMOD_L0      	: 1;
	  __REG32  REGMOD_L1      	: 1;
	  __REG32  REGMOD_L2      	: 1;
	  __REG32  REGMOD_L3      	: 1;
	  __REG32  REGMOD_L4      	: 1;
	  __REG32  REGMOD_L5      	: 1;
	  __REG32  REGMOD_L6      	: 1;
	  __REG32  REGMOD_L7      	: 1;
	  __REG32  REGMOD_L8      	: 1;
	  __REG32  REGMOD_L9      	: 1;
	  __REG32  REGMOD_L10      	: 1;
	  __REG32  REGMOD_L11      	: 1;
	  __REG32  REGMOD_L12      	: 1;
	  __REG32  REGMOD_L13      	: 1;
	  __REG32  REGMOD_L14      	: 1;
	  __REG32  REGMOD_L15      	: 1;
	  __REG32  REGMOD_H0      	: 1;
	  __REG32  REGMOD_H1      	: 1;
	  __REG32  REGMOD_H2      	: 1;
	  __REG32  REGMOD_H3      	: 1;
	  __REG32  REGMOD_H4      	: 1;
	  __REG32  REGMOD_H5      	: 1;
	  __REG32  REGMOD_H6      	: 1;
	  __REG32  REGMOD_H7      	: 1;
	  __REG32  REGMOD_H8      	: 1;
	  __REG32  REGMOD_H9      	: 1;
	  __REG32  REGMOD_H10      	: 1;
	  __REG32  REGMOD_H11      	: 1;
	  __REG32  REGMOD_H12      	: 1;
	  __REG32  REGMOD_H13      	: 1;
	  __REG32  REGMOD_H14      	: 1;
	  __REG32  REGMOD_H15      	: 1;
	  };
  struct
  {
  	union { 	
		/*SCTx_REGMODE_L*/
	  	struct {
			  __REG16  REGMOD_L0      	: 1;
			  __REG16  REGMOD_L1      	: 1;
			  __REG16  REGMOD_L2      	: 1;
			  __REG16  REGMOD_L3      	: 1;
			  __REG16  REGMOD_L4      	: 1;
			  __REG16  REGMOD_L5      	: 1;
			  __REG16  REGMOD_L6      	: 1;
			  __REG16  REGMOD_L7      	: 1;
			  __REG16  REGMOD_L8      	: 1;
			  __REG16  REGMOD_L9      	: 1;
			  __REG16  REGMOD_L10      	: 1;
			  __REG16  REGMOD_L11      	: 1;
			  __REG16  REGMOD_L12      	: 1;
			  __REG16  REGMOD_L13      	: 1;
			  __REG16  REGMOD_L14      	: 1;
			  __REG16  REGMOD_L15      	: 1;
	  	} __shortl_bit;
	  	__REG16 __shortl;
  	};
  	union { 	
		/*SCTx_REGMODE_H*/
	  	struct {
			  __REG16  REGMOD_H0      	: 1;
			  __REG16  REGMOD_H1      	: 1;
			  __REG16  REGMOD_H2      	: 1;
			  __REG16  REGMOD_H3      	: 1;
			  __REG16  REGMOD_H4      	: 1;
			  __REG16  REGMOD_H5      	: 1;
			  __REG16  REGMOD_H6      	: 1;
			  __REG16  REGMOD_H7      	: 1;
			  __REG16  REGMOD_H8      	: 1;
			  __REG16  REGMOD_H9      	: 1;
			  __REG16  REGMOD_H10      	: 1;
			  __REG16  REGMOD_H11      	: 1;
			  __REG16  REGMOD_H12      	: 1;
			  __REG16  REGMOD_H13      	: 1;
			  __REG16  REGMOD_H14      	: 1;
			  __REG16  REGMOD_H15      	: 1;
	  	} __shorth_bit;
	  	__REG16 __shorth;
  	};
	};
} __sct0_regmode_bits;

/* SCT output register */
typedef struct {
  __REG32  OUT0			      	: 1;
  __REG32  OUT1			      	: 1;
  __REG32  OUT2			      	: 1;
  __REG32  OUT3			      	: 1;
  __REG32  OUT4			      	: 1;
  __REG32  OUT5			      	: 1;
  __REG32  OUT6			      	: 1;
  __REG32  OUT7			      	: 1;
  __REG32  OUT8			      	: 1;
  __REG32  OUT9			      	: 1;
  __REG32  					      	:22;
} __sct0_output_bits;

/* SCT bidirectional output control register */
typedef struct {
  __REG32  SETCLR0	      	: 2;
  __REG32  SETCLR1	      	: 2;
  __REG32  SETCLR2	      	: 2;
  __REG32  SETCLR3	      	: 2;
  __REG32  SETCLR4	      	: 2;
  __REG32  SETCLR5	      	: 2;
  __REG32  SETCLR6	      	: 2;
  __REG32  SETCLR7	      	: 2;
  __REG32  SETCLR8	      	: 2;
  __REG32  SETCLR9	      	: 2;
  __REG32  					      	:12;
} __sct0_outputdirctrl_bits;

/* SCT conflict resolution register */
typedef struct {
  __REG32  O0RES 		      	: 2;
  __REG32  O1RES		      	: 2;
  __REG32  O2RES		      	: 2;
  __REG32  O3RES		      	: 2;
  __REG32  O4RES		      	: 2;
  __REG32  O5RES		      	: 2;
  __REG32  O6RES		      	: 2;
  __REG32  O7RES		      	: 2;
  __REG32  O8RES		      	: 2;
  __REG32  O9RES		      	: 2;
  __REG32  					      	:12;
} __sct0_res_bits;

/* SCT DMA request 0 register */
typedef struct {
  __REG32  DEV_0 		      	:16;
  __REG32  					      	:14;
  __REG32  DRL0 		      	: 1;
  __REG32  DRQ0			      	: 1;
} __sct0_dmareq0_bits;

/* SCT DMA request 1 register */
typedef struct {
  __REG32  DEV_1 		      	:16;
  __REG32  					      	:14;
  __REG32  DRL1 		      	: 1;
  __REG32  DRQ1			      	: 1;
} __sct0_dmareq1_bits;

/* SCT flag enable register */
typedef struct {
  __REG32  IEN0	 		      	: 1;
  __REG32  IEN1	 		      	: 1;
  __REG32  IEN2	 		      	: 1;
  __REG32  IEN3	 		      	: 1;
  __REG32  IEN4	 		      	: 1;
  __REG32  IEN5	 		      	: 1;
  __REG32  IEN6	 		      	: 1;
  __REG32  IEN7	 		      	: 1;
  __REG32  IEN8	 		      	: 1;
  __REG32  IEN9	 		      	: 1;
  __REG32  IEN10 		      	: 1;
  __REG32  IEN11 		      	: 1;
  __REG32  IEN12 		      	: 1;
  __REG32  IEN13 		      	: 1;
  __REG32  IEN14 		      	: 1;
  __REG32  IEN15 		      	: 1;
  __REG32  					      	:16;
} __sct0_even_bits;

/* SCT event flag register */
typedef struct {
  __REG32  FLAG0	 		      	: 1;
  __REG32  FLAG1	 		      	: 1;
  __REG32  FLAG2	 		      	: 1;
  __REG32  FLAG3	 		      	: 1;
  __REG32  FLAG4	 		      	: 1;
  __REG32  FLAG5	 		      	: 1;
  __REG32  FLAG6	 		      	: 1;
  __REG32  FLAG7	 		      	: 1;
  __REG32  FLAG8	 		      	: 1;
  __REG32  FLAG9	 		      	: 1;
  __REG32  FLAG10 		      	: 1;
  __REG32  FLAG11 		      	: 1;
  __REG32  FLAG12 		      	: 1;
  __REG32  FLAG13 		      	: 1;
  __REG32  FLAG14 		      	: 1;
  __REG32  FLAG15 		      	: 1;
  __REG32  						      	:16;
} __sct0_evflag_bits;

/* SCT conflict enable register */
typedef struct {
  __REG32  NCEN0	 		      	: 1;
  __REG32  NCEN1	 		      	: 1;
  __REG32  NCEN2	 		      	: 1;
  __REG32  NCEN3	 		      	: 1;
  __REG32  NCEN4	 		      	: 1;
  __REG32  NCEN5	 		      	: 1;
  __REG32  NCEN6	 		      	: 1;
  __REG32  NCEN7	 		      	: 1;
  __REG32  NCEN8	 		      	: 1;
  __REG32  NCEN9	 		      	: 1;
  __REG32  						      	:22;
} __sct0_conen_bits;

/* SCT conflict flag register */
typedef struct {
  __REG32  NCFLAG0	 		      	: 1;
  __REG32  NCFLAG1	 		      	: 1;
  __REG32  NCFLAG2	 		      	: 1;
  __REG32  NCFLAG3	 		      	: 1;
  __REG32  NCFLAG4	 		      	: 1;
  __REG32  NCFLAG5	 		      	: 1;
  __REG32  NCFLAG6	 		      	: 1;
  __REG32  NCFLAG7	 		      	: 1;
  __REG32  NCFLAG8	 		      	: 1;
  __REG32  NCFLAG9	 		      	: 1;
  __REG32  							      	:20;
  __REG32  BUSERRL	 		      	: 1;
  __REG32  BUSERRH	 		      	: 1;
} __sct0_conflag_bits;

/* SCT match /capture registers */
typedef union {
	/*SCTx_MATCHy*/
	/*SCTx_MATCH1y*/
	struct {
  __REG32 MATCH_L						:16;
  __REG32 MATCH_H						:16;
  };
  struct
  {  	
  	__REG16 __shortl_m;
  	__REG16 __shorth_m;
	};
	/*SCTx_CAPy*/
	/*SCTx_CAP1y*/
	struct {
  __REG32 CAP_L						:16;
  __REG32 CAP_H						:16;
  };
  struct
  {  	
  	__REG16 __shortl_c;
  	__REG16 __shorth_c;
	};
} __sct0_match_bits;

/* SCT fractional match registers */
typedef union {
	/*SCTx_FRACMATy*/
	struct {
	  __REG32  FRACMAT_L      	: 4;
	  __REG32  					      	:12;
	  __REG32  FRACMAT_H      	: 4;
	  __REG32  					      	:12;
  };
  struct
  {
  	union { 	
		/*SCTx_FRACMATy_L*/
	  	struct {
			  __REG16  FRACMAT_L      	: 4;
			  __REG16  					      	:12;
	  	} __shortl_bit;
	  	__REG16 __shortl;
  	};
  	union { 	
		/*SCTx_FRACMATy_H*/
	  	struct {
			  __REG16  FRACMAT_H      	: 4;
			  __REG16  					      	:12;
	  	} __shorth_bit;
	  	__REG16 __shorth;
  	};
	};
} __sct0_fracmat_bits;

/* SCT match reload registers */
typedef union {
	/*SCTx_MATCHRELy*/
	/*SCTx_MATCHREL1y*/
	struct {
	  __REG32  RELOAD_L      		:16;
	  __REG32  RELOAD_H      		:16;
  };
  struct
  {
		__REG16 __shortl_m;
  	__REG16 __shorth_m;
	};
	/*SCTx_CAPCTRLy*/
	/*SCTx_CAPCTRL1y*/
	struct {
	  __REG32  CAPCON0_L     		: 1;
	  __REG32  CAPCON1_L     		: 1;
	  __REG32  CAPCON2_L     		: 1;
	  __REG32  CAPCON3_L     		: 1;
	  __REG32  CAPCON4_L     		: 1;
	  __REG32  CAPCON5_L     		: 1;
	  __REG32  CAPCON6_L     		: 1;
	  __REG32  CAPCON7_L     		: 1;
	  __REG32  CAPCON8_L     		: 1;
	  __REG32  CAPCON9_L     		: 1;
	  __REG32  CAPCON10_L    		: 1;
	  __REG32  CAPCON11_L    		: 1;
	  __REG32  CAPCON12_L    		: 1;
	  __REG32  CAPCON13_L    		: 1;
	  __REG32  CAPCON14_L    		: 1;
	  __REG32  CAPCON15_L    		: 1;
	  __REG32  CAPCON0_H     		: 1;
	  __REG32  CAPCON1_H     		: 1;
	  __REG32  CAPCON2_H     		: 1;
	  __REG32  CAPCON3_H     		: 1;
	  __REG32  CAPCON4_H     		: 1;
	  __REG32  CAPCON5_H     		: 1;
	  __REG32  CAPCON6_H     		: 1;
	  __REG32  CAPCON7_H     		: 1;
	  __REG32  CAPCON8_H     		: 1;
	  __REG32  CAPCON9_H     		: 1;
	  __REG32  CAPCON10_H    		: 1;
	  __REG32  CAPCON11_H    		: 1;
	  __REG32  CAPCON12_H    		: 1;
	  __REG32  CAPCON13_H    		: 1;
	  __REG32  CAPCON14_H    		: 1;
	  __REG32  CAPCON15_H    		: 1;
  };
  struct {
  	union {
	/*SCTx_CAPCTRLy_L*/
	/*SCTx_CAPCTRL1y_L*/
  		struct {
		  __REG16  CAPCON0_L     		: 1;
		  __REG16  CAPCON1_L     		: 1;
		  __REG16  CAPCON2_L     		: 1;
		  __REG16  CAPCON3_L     		: 1;
		  __REG16  CAPCON4_L     		: 1;
		  __REG16  CAPCON5_L     		: 1;
		  __REG16  CAPCON6_L     		: 1;
		  __REG16  CAPCON7_L     		: 1;
		  __REG16  CAPCON8_L     		: 1;
		  __REG16  CAPCON9_L     		: 1;
		  __REG16  CAPCON10_L    		: 1;
		  __REG16  CAPCON11_L    		: 1;
		  __REG16  CAPCON12_L    		: 1;
		  __REG16  CAPCON13_L    		: 1;
		  __REG16  CAPCON14_L    		: 1;
		  __REG16  CAPCON15_L    		: 1;
  		} __shortl_c_bit;
			__REG16 __shortl_c;
		};
		union {
	/*SCTx_CAPCTRLy_H*/
	/*SCTx_CAPCTRL1y_H*/
  		struct {
		  __REG16  CAPCON0_H     		: 1;
		  __REG16  CAPCON1_H     		: 1;
		  __REG16  CAPCON2_H     		: 1;
		  __REG16  CAPCON3_H     		: 1;
		  __REG16  CAPCON4_H     		: 1;
		  __REG16  CAPCON5_H     		: 1;
		  __REG16  CAPCON6_H     		: 1;
		  __REG16  CAPCON7_H     		: 1;
		  __REG16  CAPCON8_H     		: 1;
		  __REG16  CAPCON9_H     		: 1;
		  __REG16  CAPCON10_H    		: 1;
		  __REG16  CAPCON11_H    		: 1;
		  __REG16  CAPCON12_H    		: 1;
		  __REG16  CAPCON13_H    		: 1;
		  __REG16  CAPCON14_H    		: 1;
		  __REG16  CAPCON15_H    		: 1;
  		} __shorth_c_bit;
  		__REG16 __shorth_c;
  	};
	};
} __sct0_matchrel_bits;

/* SCT fractional match reload registers */
typedef union {
	/*SCTx_FRACMATRELy*/
	struct {
	  __REG32  RELFRAC_L      	: 4;
	  __REG32  					      	:12;
	  __REG32  RELFRAC_H      	: 4;
	  __REG32  					      	:12;
  };
  struct
  {
  	union { 	
		/*SCTx_FRACMATRELy_L*/
	  	struct {
			  __REG16  RELFRAC_L      	: 4;
			  __REG16  					      	:12;
	  	} __shortl_bit;
	  	__REG16 __shortl;
  	};
  	union { 	
		/*SCTx_FRACMATRELy_H*/
	  	struct {
			  __REG16  RELFRAC_H      	: 4;
			  __REG16  					      	:12;
	  	} __shorth_bit;
	  	__REG16 __shorth;
  	};
	};
} __sct0_fracmatrel_bits;

/* SCT event state mask registers  */
typedef struct {
  __REG32  STATEMSK0      : 1;
  __REG32  STATEMSK1      : 1;
  __REG32  STATEMSK2      : 1;
  __REG32  STATEMSK3      : 1;
  __REG32  STATEMSK4      : 1;
  __REG32  STATEMSK5      : 1;
  __REG32  STATEMSK6      : 1;
  __REG32  STATEMSK7      : 1;
  __REG32  STATEMSK8      : 1;
  __REG32  STATEMSK9      : 1;
  __REG32  STATEMSK10     : 1;
  __REG32  STATEMSK11     : 1;
  __REG32  STATEMSK12     : 1;
  __REG32  STATEMSK13     : 1;
  __REG32  STATEMSK14     : 1;
  __REG32  STATEMSK15     : 1;
  __REG32  STATEMSK16     : 1;
  __REG32  STATEMSK17     : 1;
  __REG32  STATEMSK18     : 1;
  __REG32  STATEMSK19     : 1;
  __REG32  STATEMSK20     : 1;
  __REG32  STATEMSK21     : 1;
  __REG32  STATEMSK22     : 1;
  __REG32  STATEMSK23     : 1;
  __REG32  STATEMSK24     : 1;
  __REG32  STATEMSK25     : 1;
  __REG32  STATEMSK26     : 1;
  __REG32  STATEMSK27     : 1;
  __REG32  STATEMSK28     : 1;
  __REG32  STATEMSK29     : 1;
  __REG32  STATEMSK30     : 1;
  __REG32  STATEMSK31     : 1;
} __sct0_ev_state_bits;

/* SCT event control registers */
typedef struct {
  __REG32  MATCHSEL	      : 4;
  __REG32  HEVENT		      : 1;
  __REG32  OUTSEL		      : 1;
  __REG32  IOSEL		      : 4;
  __REG32  IOCOND		      : 2;
  __REG32  COMBMODE	      : 2;
  __REG32  STATELD	      : 1;
  __REG32  STATEV		      : 5;
  __REG32  MATCHMEM	      : 1;
  __REG32  DIRECTION      : 2;
  __REG32  						    : 9;
} __sct0_ev_ctrl_bits;

/* SCT output set registers  */
typedef struct {
  __REG32  SET0      : 1;
  __REG32  SET1      : 1;
  __REG32  SET2      : 1;
  __REG32  SET3      : 1;
  __REG32  SET4      : 1;
  __REG32  SET5      : 1;
  __REG32  SET6      : 1;
  __REG32  SET7      : 1;
  __REG32  SET8      : 1;
  __REG32  SET9      : 1;
  __REG32  SET10     : 1;
  __REG32  SET11     : 1;
  __REG32  SET12     : 1;
  __REG32  SET13     : 1;
  __REG32  SET14     : 1;
  __REG32  SET15     : 1;
  __REG32  			     :16;
} __sct0_out_set_bits;

/* SCT output clear registers */
typedef struct {
  __REG32  CLR0      : 1;
  __REG32  CLR1      : 1;
  __REG32  CLR2      : 1;
  __REG32  CLR3      : 1;
  __REG32  CLR4      : 1;
  __REG32  CLR5      : 1;
  __REG32  CLR6      : 1;
  __REG32  CLR7      : 1;
  __REG32  CLR8      : 1;
  __REG32  CLR9      : 1;
  __REG32  CLR10     : 1;
  __REG32  CLR11     : 1;
  __REG32  CLR12     : 1;
  __REG32  CLR13     : 1;
  __REG32  CLR14     : 1;
  __REG32  CLR15     : 1;
  __REG32  			     :16;
} __sct0_out_clr_bits;

/* SCT input register  */
typedef struct {
  __REG32  AIN0			      	: 1;
  __REG32  AIN1			      	: 1;
  __REG32  AIN2			      	: 1;
  __REG32  AIN3			      	: 1;
  __REG32  					      	:12;
  __REG32  SIN0				      : 1;
  __REG32  SIN1				      : 1;
  __REG32  SIN2				      : 1;
  __REG32  SIN3				      : 1;
  __REG32  						      :12;
} __sct2_input_bits;

/* SCT output register */
typedef struct {
  __REG32  OUT0			      	: 1;
  __REG32  OUT1			      	: 1;
  __REG32  OUT2			      	: 1;
  __REG32  OUT3			      	: 1;
  __REG32  OUT4			      	: 1;
  __REG32  OUT5			      	: 1;
  __REG32  					      	:26;
} __sct2_output_bits;

/* SCT bidirectional output control register */
typedef struct {
  __REG32  SETCLR0	      	: 2;
  __REG32  SETCLR1	      	: 2;
  __REG32  SETCLR2	      	: 2;
  __REG32  SETCLR3	      	: 2;
  __REG32  SETCLR4	      	: 2;
  __REG32  SETCLR5	      	: 2;
  __REG32  					      	:20;
} __sct2_outputdirctrl_bits;

/* SCT conflict resolution register */
typedef struct {
  __REG32  O0RES 		      	: 2;
  __REG32  O1RES		      	: 2;
  __REG32  O2RES		      	: 2;
  __REG32  O3RES		      	: 2;
  __REG32  O4RES		      	: 2;
  __REG32  O5RES		      	: 2;
  __REG32  					      	:20;
} __sct2_res_bits;

/* SCT conflict enable register */
typedef struct {
  __REG32  NCEN0	 		      	: 1;
  __REG32  NCEN1	 		      	: 1;
  __REG32  NCEN2	 		      	: 1;
  __REG32  NCEN3	 		      	: 1;
  __REG32  NCEN4	 		      	: 1;
  __REG32  NCEN5	 		      	: 1;
  __REG32  NCEN6	 		      	: 1;
  __REG32  NCEN7	 		      	: 1;
  __REG32  NCEN8	 		      	: 1;
  __REG32  NCEN9	 		      	: 1;
  __REG32  NCEN10	 		      	: 1;
  __REG32  NCEN11	 		      	: 1;
  __REG32  NCEN12	 		      	: 1;
  __REG32  NCEN13	 		      	: 1;
  __REG32  NCEN14	 		      	: 1;
  __REG32  NCEN15	 		      	: 1;
  __REG32  						      	:16;
} __sct2_conen_bits;

/* SCT conflict flag register */
typedef struct {
  __REG32  NCFLAG0	 		      	: 1;
  __REG32  NCFLAG1	 		      	: 1;
  __REG32  NCFLAG2	 		      	: 1;
  __REG32  NCFLAG3	 		      	: 1;
  __REG32  NCFLAG4	 		      	: 1;
  __REG32  NCFLAG5	 		      	: 1;
  __REG32  							      	:24;
  __REG32  BUSERRL	 		      	: 1;
  __REG32  BUSERRH	 		      	: 1;
} __sct2_conflag_bits;

/* SCT match reload registers */
typedef union {
	/*SCTx_MATCHRELy*/
	/*SCTx_MATCHREL1y*/
	struct {
	  __REG32  RELOAD_L      		:16;
	  __REG32  RELOAD_H      		:16;
  };
  struct
  {
		__REG16 __shortl_m;
  	__REG16 __shorth_m;
	};
	/*SCTx_CAPCTRLy*/
	/*SCTx_CAPCTRL1y*/
	struct {
	  __REG32  CAPCON0_L     		: 1;
	  __REG32  CAPCON1_L     		: 1;
	  __REG32  CAPCON2_L     		: 1;
	  __REG32  CAPCON3_L     		: 1;
	  __REG32  CAPCON4_L     		: 1;
	  __REG32  CAPCON5_L     		: 1;
	  __REG32  CAPCON6_L     		: 1;
	  __REG32  CAPCON7_L     		: 1;
	  __REG32  CAPCON8_L     		: 1;
	  __REG32  CAPCON9_L     		: 1;
	  __REG32  					    		: 6;
	  __REG32  CAPCON0_H     		: 1;
	  __REG32  CAPCON1_H     		: 1;
	  __REG32  CAPCON2_H     		: 1;
	  __REG32  CAPCON3_H     		: 1;
	  __REG32  CAPCON4_H     		: 1;
	  __REG32  CAPCON5_H     		: 1;
	  __REG32  CAPCON6_H     		: 1;
	  __REG32  CAPCON7_H     		: 1;
	  __REG32  CAPCON8_H     		: 1;
	  __REG32  					    		: 7;
  };
  struct {
  	union {
	/*SCTx_CAPCTRLy_L*/
	/*SCTx_CAPCTRL1y_L*/
  		struct {
		  __REG16  CAPCON0_L     	: 1;
		  __REG16  CAPCON1_L     	: 1;
		  __REG16  CAPCON2_L     	: 1;
		  __REG16  CAPCON3_L     	: 1;
		  __REG16  CAPCON4_L     	: 1;
		  __REG16  CAPCON5_L     	: 1;
		  __REG16  CAPCON6_L     	: 1;
		  __REG16  CAPCON7_L     	: 1;
		  __REG16  CAPCON8_L     	: 1;
		  __REG16  CAPCON9_L     	: 1;
		  __REG16  				      	: 6;
  		} __shortl_c_bit;
			__REG16 __shortl_c;
		};
		union {
	/*SCTx_CAPCTRLy_H*/
	/*SCTx_CAPCTRL1y_H*/
  		struct {
		  __REG16  CAPCON0_H     	: 1;
		  __REG16  CAPCON1_H     	: 1;
		  __REG16  CAPCON2_H     	: 1;
		  __REG16  CAPCON3_H     	: 1;
		  __REG16  CAPCON4_H     	: 1;
		  __REG16  CAPCON5_H     	: 1;
		  __REG16  CAPCON6_H     	: 1;
		  __REG16  CAPCON7_H     	: 1;
		  __REG16  CAPCON8_H     	: 1;
		  __REG16  					    	: 7;
  		} __shorth_c_bit;
  		__REG16 __shorth_c;
  	};
	};
} __sct2_matchrel_bits;

/* SCT event state mask registers  */
typedef struct {
  __REG32  STATEMSK0      : 1;
  __REG32  STATEMSK1      : 1;
  __REG32  STATEMSK2      : 1;
  __REG32  STATEMSK3      : 1;
  __REG32  STATEMSK4      : 1;
  __REG32  STATEMSK5      : 1;
  __REG32  STATEMSK6      : 1;
  __REG32  STATEMSK7      : 1;
  __REG32  STATEMSK8      : 1;
  __REG32  STATEMSK9      : 1;
  __REG32  					      :22;
} __sct2_ev_state_bits;

/* SCT event control registers */
typedef struct {
  __REG32  MATCHSEL	      : 4;
  __REG32  HEVENT		      : 1;
  __REG32  OUTSEL		      : 1;
  __REG32  IOSEL		      : 4;
  __REG32  IOCOND		      : 2;
  __REG32  COMBMODE	      : 2;
  __REG32  STATELD	      : 1;
  __REG32  STATEV		      : 5;
  __REG32  MATCHMEM	      : 1;
  __REG32  DIRECTION      : 2;
  __REG32  						    : 9;
} __sct2_ev_ctrl_bits;

/* SCT output set registers  */
typedef struct {
  __REG32  SET0      : 1;
  __REG32  SET1      : 1;
  __REG32  SET2      : 1;
  __REG32  SET3      : 1;
  __REG32  SET4      : 1;
  __REG32  SET5      : 1;
  __REG32  SET6      : 1;
  __REG32  SET7      : 1;
  __REG32  SET8      : 1;
  __REG32  SET9      : 1;
  __REG32  			     :22;
} __sct2_out_set_bits;

/* SCT output clear registers */
typedef struct {
  __REG32  CLR0      : 1;
  __REG32  CLR1      : 1;
  __REG32  CLR2      : 1;
  __REG32  CLR3      : 1;
  __REG32  CLR4      : 1;
  __REG32  CLR5      : 1;
  __REG32  CLR6      : 1;
  __REG32  CLR7      : 1;
  __REG32  CLR8      : 1;
  __REG32  CLR9      : 1;
  __REG32  			     :22;
} __sct2_out_clr_bits;

/* Watchdog mode register */
typedef struct{
__REG32 WDEN      : 1;
__REG32 WDRESET   : 1;
__REG32 WDTOF     : 1;
__REG32 WDINT     : 1;
__REG32 WDPROTECT : 1;
__REG32 LOCK      : 1;
__REG32           :26;
} __wdmod_bits;

/* Watchdog Timer Constant register */
typedef struct{
__REG32 COUNT     :24;
__REG32           : 8;
} __wdtc_bits;

/* Watchdog Timer Warning Interrupt register */
typedef struct {
__REG32 WARNINT   :10;
__REG32           :22;
} __wdwarnint_bits;

/* Watchdog Timer Window register */
typedef struct {
__REG32 WINDOW    :24;
__REG32           : 8;
} __wdwindow_bits;

/* RTC control register */
typedef struct {
__REG32 SWRESET   	: 1;
__REG32 OFD			   	: 1;
__REG32 ALARM1HZ   	: 1;
__REG32 WAKE1KHZ   	: 1;
__REG32 ALARMDPD_EN	: 1;
__REG32 WAKEDPD_EN 	: 1;
__REG32 RTC1KHZ_EN 	: 1;
__REG32 RTC_EN		 	: 1;
__REG32           	:24;
} __rtc_ctrl_bits;

/* RTC high-resolution/wake-up register */
typedef struct {
__REG32 VAL			   	:16;
__REG32           	:16;
} __rtc_wake_bits;

/* MRT Time interval register */
typedef struct {
__REG32 IVALUE	   	:24;
__REG32           	: 7;
__REG32 LOAD		   	: 1;
} __mrt_intval_bits;

/* MRT Timer register */
typedef struct {
__REG32 VALUE		   	:24;
__REG32           	: 8;
} __mrt_timer_bits;

/* MRT Control register */
typedef struct {
__REG32 INTEN		   	: 1;
__REG32 MODE		   	: 2;
__REG32           	:29;
} __mrt_ctrl_bits;

/* MRT Status register */
typedef struct {
__REG32 INTFLAG	   	: 1;
__REG32 RUN			   	: 1;
__REG32           	:30;
} __mrt_stat_bits;

/* MRT Idle channel register */
typedef struct {
__REG32 				   	: 4;
__REG32 CHAN		   	: 4;
__REG32           	:24;
} __mrt_idle_ch_bits;

/* MRT Global interrupt flag register */
typedef struct {
__REG32 GFLAG0	   	: 1;
__REG32 GFLAG1	   	: 1;
__REG32 GFLAG2	   	: 1;
__REG32 GFLAG3	   	: 1;
__REG32           	:28;
} __mrt_irq_flag_bits;

/* RIT Control register */
typedef struct {
__REG32 RITINT	   	: 1;
__REG32 RITENCLR   	: 1;
__REG32 RITENBR	   	: 1;
__REG32 RITEN		   	: 1;
__REG32           	:28;
} __rit_ctrl_bits;

/* RIT Compare Value MSB register */
typedef struct {
__REG32 RICOMP	   	:16;
__REG32           	:16;
} __rit_compval_h_bits;

/* RIT Mask MSB register */
typedef struct {
__REG32 RIMASK	   	:16;
__REG32           	:16;
} __rit_mask_h_bits;

/* RIT Counter MSB register  */
typedef struct {
__REG32 RICOUNTER  	:16;
__REG32           	:16;
} __rit_counter_h_bits;

/* QEI Control register */
typedef struct{
__REG32 RESP        : 1;
__REG32 RESPI       : 1;
__REG32 RESV        : 1;
__REG32 RESI        : 1;
__REG32             :28;
} __qeicon_bits;

/* QEI Configuration register */
typedef struct{
__REG32 DIRINV      : 1;
__REG32 SIGMODE     : 1;
__REG32 CAPMODE     : 1;
__REG32 INVINX      : 1;
__REG32 CRESPI      : 1;
__REG32             :11;
__REG32 INXGATE     : 4;
__REG32             :12;
} __qeiconf_bits;

/* QEI Status register */
typedef struct{
__REG32 DIR         : 1;
__REG32             :31;
} __qeistat_bits;

/* QEI Interrupt Status register */
/* QEI Interrupt Enable register */
typedef struct{
__REG32 INX_INT     : 1;
__REG32 TIM_INT     : 1;
__REG32 VELC_INT    : 1;
__REG32 DIR_INT     : 1;
__REG32 ERR_INT     : 1;
__REG32 ENCLK_INT   : 1;
__REG32 POS0_INT    : 1;
__REG32 POS1_INT    : 1;
__REG32 POS2_INT    : 1;
__REG32 REV0_INT    : 1;
__REG32 POS0REV_INT : 1;
__REG32 POS1REV_INT : 1;
__REG32 POS2REV_INT : 1;
__REG32 REV1_INT    : 1;
__REG32 REV2_INT    : 1;
__REG32 MAXPOS_INT  : 1;
__REG32             :16;
} __qeiintstat_bits;

/* QEI Interrupt Enable Clear register */
#define QEIIEC_INX_EN				(1UL << 0)
#define QEIIEC_TIM_EN				(1UL << 1)
#define QEIIEC_VELC_EN			(1UL << 2)
#define QEIIEC_DIR_EN				(1UL << 3)
#define QEIIEC_ERR_EN				(1UL << 4)
#define QEIIEC_ENCLK_EN			(1UL << 5)
#define QEIIEC_POS0_INT			(1UL << 6)
#define QEIIEC_POS1_INT			(1UL << 7)
#define QEIIEC_POS2_INT			(1UL << 8)
#define QEIIEC_REV0_INT			(1UL << 9)
#define QEIIEC_POS0REV_INT	(1UL <<10)
#define QEIIEC_POS1REV_INT	(1UL <<11)
#define QEIIEC_POS2REV_INT	(1UL <<12)
#define QEIIEC_REV1_INT			(1UL <<13)
#define QEIIEC_REV2_INT			(1UL <<14)
#define QEIIEC_MAXPOS_INT		(1UL <<15)

/* QEI Interrupt Enable Set register */
#define QEIIES_INX_EN				(1UL << 0)
#define QEIIES_TIM_EN				(1UL << 1)
#define QEIIES_VELC_EN			(1UL << 2)
#define QEIIES_DIR_EN				(1UL << 3)
#define QEIIES_ERR_EN				(1UL << 4)
#define QEIIES_ENCLK_EN			(1UL << 5)
#define QEIIES_POS0_INT			(1UL << 6)
#define QEIIES_POS1_INT			(1UL << 7)
#define QEIIES_POS2_INT			(1UL << 8)
#define QEIIES_REV0_INT			(1UL << 9)
#define QEIIES_POS0REV_INT	(1UL <<10)
#define QEIIES_POS1REV_INT	(1UL <<11)
#define QEIIES_POS2REV_INT	(1UL <<12)
#define QEIIES_REV1_INT			(1UL <<13)
#define QEIIES_REV2_INT			(1UL <<14)
#define QEIIES_MAXPOS_INT		(1UL <<15)

/* QEI Interrupt Status Clear register */
#define QEICLR_INX_EN				(1UL << 0)
#define QEICLR_TIM_EN				(1UL << 1)
#define QEICLR_VELC_EN			(1UL << 2)
#define QEICLR_DIR_EN				(1UL << 3)
#define QEICLR_ERR_EN				(1UL << 4)
#define QEICLR_ENCLK_EN			(1UL << 5)
#define QEICLR_POS0_INT			(1UL << 6)
#define QEICLR_POS1_INT			(1UL << 7)
#define QEICLR_POS2_INT			(1UL << 8)
#define QEICLR_REV0_INT			(1UL << 9)
#define QEICLR_POS0REV_INT	(1UL <<10)
#define QEICLR_POS1REV_INT	(1UL <<11)
#define QEICLR_POS2REV_INT	(1UL <<12)
#define QEICLR_REV1_INT			(1UL <<13)
#define QEICLR_REV2_INT			(1UL <<14)
#define QEICLR_MAXPOS_INT		(1UL <<15)

/* QEI Interrupt Status Set register */
#define QEISET_INX_EN				(1UL << 0)
#define QEISET_TIM_EN				(1UL << 1)
#define QEISET_VELC_EN			(1UL << 2)
#define QEISET_DIR_EN				(1UL << 3)
#define QEISET_ERR_EN				(1UL << 4)
#define QEISET_ENCLK_EN			(1UL << 5)
#define QEISET_POS0_INT			(1UL << 6)
#define QEISET_POS1_INT			(1UL << 7)
#define QEISET_POS2_INT			(1UL << 8)
#define QEISET_REV0_INT			(1UL << 9)
#define QEISET_POS0REV_INT	(1UL <<10)
#define QEISET_POS1REV_INT	(1UL <<11)
#define QEISET_POS2REV_INT	(1UL <<12)
#define QEISET_REV1_INT			(1UL <<13)
#define QEISET_REV2_INT			(1UL <<14)
#define QEISET_MAXPOS_INT		(1UL <<15)

/* USB Device Command/Status register (DEVCMDSTAT) */
typedef struct {
  __REG32 DEV_ADDR             : 7;
  __REG32 DEV_EN               : 1;
  __REG32 SETUP                : 1;
  __REG32 PLL_ON               : 1;
  __REG32                      : 1;
  __REG32 LPM_SUP              : 1;
  __REG32 INTONNAK_AO          : 1;
  __REG32 INTONNAK_AI          : 1;
  __REG32 INTONNAK_CO          : 1;
  __REG32 INTONNAK_CI          : 1;
  __REG32 DCON                 : 1;
  __REG32 DSUS                 : 1;
  __REG32                      : 1;
  __REG32 LPM_SUS              : 1;
  __REG32 LPM_REWP             : 1;
  __REG32                      : 3;
  __REG32 DCON_C               : 1;
  __REG32 DSUS_C               : 1;
  __REG32 DRES_C               : 1;
  __REG32                      : 1;
  __REG32 VBUSDEBOUNCED        : 1;
  __REG32                      : 3;
} __usb_devcmdstat_bits;

/* USB Info register (INFO) */
typedef struct {
  __REG32 FRAME_NR             :11;
  __REG32 ERR_CODE             : 4;
  __REG32                      :17;
} __usb_info_bits;

/* USB Link Power Management register */
typedef struct {
  __REG32 HIRD_HW              : 4;
  __REG32 HIRD_SW	             : 4;
  __REG32 DATA_PENDING         : 1;
  __REG32                      :23;
} __usb_lpm_bits;

/* USB Endpoint skip (EPSKIP) */
typedef struct {
  __REG32 SKIP0                : 1;
  __REG32 SKIP1                : 1;
  __REG32 SKIP2                : 1;
  __REG32 SKIP3                : 1;
  __REG32 SKIP4                : 1;
  __REG32 SKIP5                : 1;
  __REG32 SKIP6                : 1;
  __REG32 SKIP7                : 1;
  __REG32 SKIP8                : 1;
  __REG32 SKIP9                : 1;
  __REG32 SKIP10               : 1;
  __REG32 SKIP11               : 1;
  __REG32 SKIP12               : 1;
  __REG32 SKIP13               : 1;
  __REG32 SKIP14               : 1;
  __REG32 SKIP15               : 1;
  __REG32 SKIP16               : 1;
  __REG32 SKIP17               : 1;
  __REG32 SKIP18               : 1;
  __REG32 SKIP19               : 1;
  __REG32 SKIP20               : 1;
  __REG32 SKIP21               : 1;
  __REG32 SKIP22               : 1;
  __REG32 SKIP23               : 1;
  __REG32 SKIP24               : 1;
  __REG32 SKIP25               : 1;
  __REG32 SKIP26               : 1;
  __REG32 SKIP27               : 1;
  __REG32 SKIP28               : 1;
  __REG32 SKIP29               : 1;
  __REG32                      : 2;
} __usb_epskip_bits;

/* USB Endpoint Buffer in use (EPINUSE) */
typedef struct {
  __REG32                      : 2;
  __REG32 BUF2                 : 1;
  __REG32 BUF3                 : 1;
  __REG32 BUF4                 : 1;
  __REG32 BUF5                 : 1;
  __REG32 BUF6                 : 1;
  __REG32 BUF7                 : 1;
  __REG32 BUF8                 : 1;
  __REG32 BUF9                 : 1;
  __REG32                      :22;
} __usb_epinuse_bits;

/* USB Endpoint Buffer Configuration (EPBUFCFG) */
typedef struct {
  __REG32                      : 2;
  __REG32 BUF_SB2              : 1;
  __REG32 BUF_SB3              : 1;
  __REG32 BUF_SB4              : 1;
  __REG32 BUF_SB5              : 1;
  __REG32 BUF_SB6              : 1;
  __REG32 BUF_SB7              : 1;
  __REG32 BUF_SB8              : 1;
  __REG32 BUF_SB9              : 1;
  __REG32                      :22;
} __usb_epbufcfg_bits;

/* USB interrupt status register (INTSTAT) */
typedef struct {
  __REG32 EP0OUT               : 1;
  __REG32 EP0IN                : 1;
  __REG32 EP1OUT               : 1;
  __REG32 EP1IN                : 1;
  __REG32 EP2OUT               : 1;
  __REG32 EP2IN                : 1;
  __REG32 EP3OUT               : 1;
  __REG32 EP3IN                : 1;
  __REG32 EP4OUT               : 1;
  __REG32 EP4IN                : 1;
  __REG32                      :20;
  __REG32 FRAME_INT            : 1;
  __REG32 DEV_INT              : 1;
} __usb_intstat_bits;

/* USB interrupt enable register (INTEN) */
typedef struct {
  __REG32 EP0OUT_INT_EN        : 1;
  __REG32 EP0IN_INT_EN         : 1;
  __REG32 EP1OUT_INT_EN        : 1;
  __REG32 EP1IN_INT_EN         : 1;
  __REG32 EP2OUT_INT_EN        : 1;
  __REG32 EP2IN_INT_EN         : 1;
  __REG32 EP3OUT_INT_EN        : 1;
  __REG32 EP3IN_INT_EN         : 1;
  __REG32 EP4OUT_INT_EN        : 1;
  __REG32 EP4IN_INT_EN         : 1;
  __REG32                      :20;
  __REG32 FRAME_INT_EN         : 1;
  __REG32 DEV_INT_EN           : 1;
} __usb_inten_bits;

/* USB set interrupt status register (INTSETSTAT) */
typedef struct {
  __REG32 EP0OUT_SET_INT       : 1;
  __REG32 EP0IN_SET_INT        : 1;
  __REG32 EP1OUT_SET_INT       : 1;
  __REG32 EP1IN_SET_INT        : 1;
  __REG32 EP2OUT_SET_INT       : 1;
  __REG32 EP2IN_SET_INT        : 1;
  __REG32 EP3OUT_SET_INT       : 1;
  __REG32 EP3IN_SET_INT        : 1;
  __REG32 EP4OUT_SET_INT       : 1;
  __REG32 EP4IN_SET_INT        : 1;
  __REG32                      :20;
  __REG32 FRAME_SET_INT        : 1;
  __REG32 DEV_SET_INT          : 1;
} __usb_intsetstat_bits;

/* USB interrupt routing register (INTROUTING) */
typedef struct {
  __REG32 EP0OUT_ROUTE_INT     : 1;
  __REG32 EP0IN_ROUTE_INT      : 1;
  __REG32 EP1OUT_ROUTE_INT     : 1;
  __REG32 EP1IN_ROUTE_INT      : 1;
  __REG32 EP2OUT_ROUTE_INT     : 1;
  __REG32 EP2IN_ROUTE_INT      : 1;
  __REG32 EP3OUT_ROUTE_INT     : 1;
  __REG32 EP3IN_ROUTE_INT      : 1;
  __REG32 EP4OUT_ROUTE_INT     : 1;
  __REG32 EP4IN_ROUTE_INT      : 1;
  __REG32                      :20;
  __REG32 FRAME_ROUTE_INT      : 1;
  __REG32 DEV_ROUTE_INT        : 1;
} __usb_introuting_bits;

/* USB interrupt routing register (INTROUTING) */
typedef struct {
  __REG32 EP0OUT_TOGGLE        : 1;
  __REG32 EP0IN_TOGGLE         : 1;
  __REG32 EP1OUT_TOGGLE        : 1;
  __REG32 EP1IN_TOGGLE         : 1;
  __REG32 EP2OUT_TOGGLE        : 1;
  __REG32 EP2IN_TOGGLE         : 1;
  __REG32 EP3OUT_TOGGLE        : 1;
  __REG32 EP3IN_TOGGLE         : 1;
  __REG32 EP4OUT_TOGGLE        : 1;
  __REG32 EP4IN_TOGGLE         : 1;
  __REG32                      :22;
} __usb_eptoggle_bits;

/* USART Configuration register */
typedef struct {
  __REG32 ENABLE			        : 1;
  __REG32 						       	: 1;
  __REG32 DATALEN			        : 2;
  __REG32 PARITYSEL	          : 2;
  __REG32 STOPLEN			        : 1;
  __REG32 MODE32K			        : 1;
  __REG32 					          : 1;
  __REG32 CTSEN			          : 1;
  __REG32 					          : 1;
  __REG32 SYNCEN			        : 1;
  __REG32 CLKPOL		          : 1;
  __REG32 					          : 1;
  __REG32 SYNCMST			        : 1;
  __REG32 LOOP				        : 1;
  __REG32                     :16;
} __usart_cfg_bits;

/* USART Control register */
typedef struct {
  __REG32 						       	: 1;
  __REG32 TXBRKEN			        : 1;
  __REG32 ADDRDET			        : 1;
  __REG32 						       	: 3;
  __REG32 TXDIS				        : 1;
  __REG32 						       	: 1;
  __REG32 CC				          : 1;
  __REG32 CLRCC				        : 1;
  __REG32 					          :22;
} __usart_ctrl_bits;

/* USART Status register */
typedef struct {
  __REG32 RXRDY				       	: 1;
  __REG32 RXIDLE			        : 1;
  __REG32 TXRDY				        : 1;
  __REG32 TXIDLE			       	: 1;
  __REG32 CTS					        : 1;
  __REG32 DELTACTS		        : 1;
  __REG32 TXDISINT		        : 1;
  __REG32 						       	: 1;
  __REG32 OVERRUNINT          : 1;
  __REG32 						       	: 1;
  __REG32 RXBRK				        : 1;
  __REG32 DELTARXBRK	        : 1;
  __REG32 START				        : 1;
  __REG32 FRAMERRINT	        : 1;
  __REG32 PARITYERRINT        : 1;
  __REG32 RXNOISEINT	        : 1;
  __REG32 					          :16;
} __usart_stat_bits;

/* USART Interrupt Enableread and set register */
typedef struct {
  __REG32 RXRDYEN			       	: 1;
  __REG32 		 			          : 1;
  __REG32 TXRDYEN			        : 1;
  __REG32 						       	: 2;
  __REG32 DELTACTSEN	        : 1;
  __REG32 TXDISINTEN	        : 1;
  __REG32 						       	: 1;
  __REG32 OVERRUNINTEN        : 1;
  __REG32 						       	: 2;
  __REG32 DELTARXBRKEN        : 1;
  __REG32 STARTEN			        : 1;
  __REG32 FRAMERREN        		: 1;
  __REG32 PARITYERREN      		: 1;
  __REG32 RXNOISEEN  	        : 1;
  __REG32 					          :16;
} __usart_intenset_bits;

/* USART Interrupt Enable Clear register */
typedef struct {
  __REG32 RXRDYCLR		       	: 1;
  __REG32 		 			          : 1;
  __REG32 TXRDYCLR		        : 1;
  __REG32 						       	: 2;
  __REG32 DELTACTSCLR         : 1;
  __REG32 TXDISINTCLR	        : 1;
  __REG32 						       	: 1;
  __REG32 OVERRUNINTCLR       : 1;
  __REG32 						       	: 2;
  __REG32 DELTARXBRKCLR       : 1;
  __REG32 STARTCLR		        : 1;
  __REG32 FRAMERRCLR       		: 1;
  __REG32 PARITYERRCLR     		: 1;
  __REG32 RXNOISECLR 	        : 1;
  __REG32 					          :16;
} __usart_intenclr_bits;

/* USART Receiver Data register */
typedef struct {
  __REG32 RXDAT				       	: 8;
  __REG32 		 			          :24;
} __usart_rxdata_bits;

/* USART Receiver Data with Status register */
typedef struct {
  __REG32 RXDAT				       	: 9;
  __REG32 		 			          : 4;
  __REG32 FRAMERR			       	: 1;
  __REG32 PARITYERR		       	: 1;
  __REG32 RXNOISE			       	: 1;
  __REG32 		 			          :16;
} __usart_rxdatastat_bits;

/* USART Transmitter Data Register */
typedef struct {
  __REG32 TXDAT				       	: 8;
  __REG32 		 			          :24;
} __usart_txdata_bits;

/* USART Baud Rate Generator register */
typedef struct {
  __REG32 BRGVAL			       	:16;
  __REG32 		 			          :16;
} __usart_brg_bits;

/* USART Interrupt Status register */
typedef struct {
  __REG32 RXRDY	 			       	: 1;
  __REG32 		 			          : 1;
  __REG32 TXRDY   		        : 1;
  __REG32 						       	: 2;
  __REG32 DELTACTS		        : 1;
  __REG32 TXDISINT		        : 1;
  __REG32 						       	: 1;
  __REG32 OVERRUNINT	        : 1;
  __REG32 						       	: 2;
  __REG32 DELTARXBRK	        : 1;
  __REG32 START				        : 1;
  __REG32 FRAMERRINT	     		: 1;
  __REG32 PARITYERRINT     		: 1;
  __REG32 RXNOISEINT 	        : 1;
  __REG32 					          :16;
} __usart_intstat_bits;

/* I2C Configuration register */
typedef struct {
  __REG32 MSTEN	 			       	: 1;
  __REG32 SLVEN			          : 1;
  __REG32 MONEN   		        : 1;
  __REG32 TIMEOUTEN		       	: 1;
  __REG32 MONCLKSTR		        : 1;
  __REG32 						       	:27;
} __i2c_cfg_bits;

/* I2C Status register */
typedef struct {
  __REG32 MSTPENDING	       	: 1;
  __REG32 MSTSTATE	          : 3;
  __REG32 MSTARBLOSS	        : 1;
  __REG32 						       	: 1;
  __REG32 MSTSTSTPERR	       	: 1;
  __REG32 						       	: 1;
  __REG32 SLVPENDING	        : 1;
  __REG32 SLVSTATE		        : 2;
  __REG32 SLVNOTSTR		        : 1;
  __REG32 SLVIDX			        : 2;
  __REG32 SLVSEL			        : 1;
  __REG32 SLVDESEL		        : 1;
  __REG32 MONRDY			        : 1;
  __REG32 MONOV				        : 1;
  __REG32 MONACTIVE		        : 1;
  __REG32 MONIDLE			        : 1;
  __REG32 						       	: 4;
  __REG32 EVENTTIMEOUT        : 1;
  __REG32 SCLTIMEOUT	        : 1;
  __REG32 						       	: 6;
} __i2c_stat_bits;

/* I2C Interrupt Enable Set and read register */
typedef struct {
  __REG32 MSTPENDINGEN       	: 1;
  __REG32 					          : 3;
  __REG32 MSTARBLOSSEN        : 1;
  __REG32 						       	: 1;
  __REG32 MSTSTSTPERREN      	: 1;
  __REG32 						       	: 1;
  __REG32 SLVPENDINGEN        : 1;
  __REG32 						        : 2;
  __REG32 SLVNOTSTREN	        : 1;
  __REG32 						        : 3;
  __REG32 SLVDESELEN	        : 1;
  __REG32 MONRDYEN		        : 1;
  __REG32 MONOVEN			        : 1;
  __REG32 						        : 1;
  __REG32 MONIDLEEN		        : 1;
  __REG32 						       	: 4;
  __REG32 EVENTTIMEOUTEN      : 1;
  __REG32 SCLTIMEOUTEN        : 1;
  __REG32 						       	: 6;
} __i2c_intenset_bits;

/* I2C Interrupt Enable Clear register */
#define I2C_INTENCLR_MSTPENDINGCLR      	(1UL << 0)
#define I2C_INTENCLR_MSTARBLOSSCLR      	(1UL << 4)
#define I2C_INTENCLR_MSTSTSTPERRCLR      	(1UL << 6)
#define I2C_INTENCLR_SLVPENDINGCLR      	(1UL << 8)
#define I2C_INTENCLR_SLVNOTSTRCLR	      	(1UL <<11)
#define I2C_INTENCLR_SLVDESELCLR	      	(1UL <<15)
#define I2C_INTENCLR_MONRDYCLR		      	(1UL <<16)
#define I2C_INTENCLR_MONOVCLR			      	(1UL <<17)
#define I2C_INTENCLR_MONIDLECLR		      	(1UL <<19)
#define I2C_INTENCLR_EVENTTIMEOUTCLR     	(1UL <<24)
#define I2C_INTENCLR_SCLTIMEOUTCLR	     	(1UL <<25)

/* I2C Time-out value register */
typedef struct {
  __REG32 TOMIN				      	: 4;
  __REG32 TO				          :12;
  __REG32 						       	:16;
} __i2c_timeout_bits;

/* I2C Clock Divider register */
typedef struct {
  __REG32 DIVVAL			      	:16;
  __REG32 						       	:16;
} __i2c_div_bits;

/* I2C Interrupt Status register */
typedef struct {
  __REG32 MSTPENDING	      	: 1;
  __REG32 					          : 3;
  __REG32 MSTARBLOSS		      : 1;
  __REG32 						       	: 1;
  __REG32 MSTSTSTPERR		     	: 1;
  __REG32 						       	: 1;
  __REG32 SLVPENDING		      : 1;
  __REG32 						        : 2;
  __REG32 SLVNOTSTR		        : 1;
  __REG32 						        : 3;
  __REG32 SLVDESEL		        : 1;
  __REG32 MONRDY			        : 1;
  __REG32 MONOV				        : 1;
  __REG32 						        : 1;
  __REG32 MONIDLE			        : 1;
  __REG32 						       	: 4;
  __REG32 EVENTTIMEOUT		    : 1;
  __REG32 SCLTIMEOUT	        : 1;
  __REG32 						       	: 6;
} __i2c_intstat_bits;

/* I2C Master Control register */
typedef struct {
  __REG32 MSTCONTINUE	      	: 1;
  __REG32 MSTSTART	          : 1;
  __REG32 MSTSTOP				      : 1;
  __REG32 						       	:29;
} __i2c_mstctl_bits;

/* I2C Master Time register */
typedef struct {
  __REG32 MSTSCLLOW		      	: 3;
  __REG32 						       	: 1;
  __REG32 MSTSCLHIGH          : 3;
  __REG32 						       	:25;
} __i2c_msttime_bits;

/* I2C Master Data register */
typedef struct {
  __REG32 DATA				      	: 8;
  __REG32 						       	:24;
} __i2c_mstdat_bits;

/* I2C Slave Control register */
typedef struct {
  __REG32 SLVCONTINUE	      	: 1;
  __REG32 SLVNACK			      	: 1;
  __REG32 						       	:30;
} __i2c_slvctl_bits;

/* I2C Slave Data register */
typedef struct {
  __REG32 DATA				      	: 8;
  __REG32 						       	:24;
} __i2c_slvdat_bits;

/* I2C Slave Address registers */
typedef struct {
  __REG32 SADISABLE		      	: 1;
  __REG32 SLVADR			      	: 7;
  __REG32 						       	:24;
} __i2c_slvadr_bits;

/* I2C Slave address Qualifier 0 register */
typedef struct {
  __REG32 QUALMODE0		      	: 1;
  __REG32 SLVQUAL0		      	: 7;
  __REG32 						       	:24;
} __i2c_slvqual_bits;

/* I2C Slave address Qualifier 0 register */
typedef struct {
  __REG32 MONRXDAT		      	: 8;
  __REG32 MONSTART		      	: 1;
  __REG32 MONRESTART	      	: 1;
  __REG32 MONNACK			      	: 1;
  __REG32 						       	:21;
} __i2c_monrxdat_bits;

/* SPI Configuration register */
typedef struct {
  __REG32 Enable			      	: 1;
  __REG32 						       	: 1;
  __REG32 Master			      	: 1;
  __REG32 LSBF				      	: 1;
  __REG32 CPHA				      	: 1;
  __REG32 CPOL				      	: 1;
  __REG32 						       	: 1;
  __REG32 LOOP				      	: 1;
  __REG32 SPOL0				      	: 1;
  __REG32 SPOL1				      	: 1;
  __REG32 SPOL2				      	: 1;
  __REG32 SPOL3				      	: 1;
  __REG32 						       	:20;
} __spi_cfg_bits;

/* SPI Delay register */
typedef struct {
  __REG32 PRE_DELAY		      	: 4;
  __REG32 POST_DELAY	      	: 4;
  __REG32 FRAME_DELAY	      	: 4;
  __REG32 TRANSFER_DELAY     	: 4;
  __REG32 						       	:16;
} __spi_dly_bits;

/* SPI Status register */
typedef struct {
  __REG32 RXRDY				      	: 1;
  __REG32 TXRDY				      	: 1;
  __REG32 RXOV				      	: 1;
  __REG32 TXUR				      	: 1;
  __REG32 SSA					      	: 1;
  __REG32 SSD					      	: 1;
  __REG32 STALLED			      	: 1;
  __REG32 ENDTRANSFER	      	: 1;
  __REG32 IDLE				      	: 1;
  __REG32 						       	:23;
} __spi_stat_bits;

/* SPI Interrupt Enable read and Set register */
typedef struct {
  __REG32 RXRDYEN			      	: 1;
  __REG32 TXRDYEN			      	: 1;
  __REG32 RXOVEN			      	: 1;
  __REG32 TXUREN			      	: 1;
  __REG32 SSAEN				      	: 1;
  __REG32 SSDEN				      	: 1;
  __REG32 						       	:26;
} __spi_intenset_bits;

/* SPI Interrupt Enable Clear register */
#define SPI_INTENCLR_RXRDYEN		(1UL << 0)
#define SPI_INTENCLR_TXRDYEN		(1UL << 1)
#define SPI_INTENCLR_RXOVEN			(1UL << 2)
#define SPI_INTENCLR_TXUREN			(1UL << 3)
#define SPI_INTENCLR_SSAEN			(1UL << 4)
#define SPI_INTENCLR_SSDEN			(1UL << 5)

/* SPI Receiver Data register */
typedef struct {
  __REG32 RXDAT				      	:16;
  __REG32 RXSSEL0			      	: 1;
  __REG32 RXSSEL1			      	: 1;
  __REG32 RXSSEL2			      	: 1;
  __REG32 RXSSEL3			      	: 1;
  __REG32 SOT					      	: 1;
  __REG32 						       	:11;
} __spi_rxdat_bits;

/* SPI Transmitter Data and Control register */
typedef struct {
  __REG32 TXDAT				      	:16;
  __REG32 TXSSEL0			      	: 1;
  __REG32 TXSSEL1			      	: 1;
  __REG32 TXSSEL2			      	: 1;
  __REG32 TXSSEL3			      	: 1;
  __REG32 EOT					      	: 1;
  __REG32 _EOF					      : 1;
  __REG32 RXIGNORE		      	: 1;
  __REG32 						       	: 1;
  __REG32 FLEN				      	: 4;
  __REG32 						       	: 4;
} __spi_txdatctl_bits;

/* SPI Transmitter Data Register */
typedef struct {
  __REG32 DATA				      	:16;
  __REG32 						       	:16;
} __spi_txdat_bits;

/* SPI Transmitter Control register */
typedef struct {
  __REG32 						       	:16;
  __REG32 TXSSEL0			      	: 1;
  __REG32 TXSSEL1			      	: 1;
  __REG32 TXSSEL2			      	: 1;
  __REG32 TXSSEL3			      	: 1;
  __REG32 EOT					      	: 1;
  __REG32 _EOF					      : 1;
  __REG32 RXIGNORE		      	: 1;
  __REG32 						       	: 1;
  __REG32 FLEN				      	: 4;
  __REG32 						       	: 4;
} __spi_txctl_bits;

/* SPI Divider register */
typedef struct {
  __REG32 DIVVAL			      	:16;
  __REG32 						       	:16;
} __spi_div_bits;

/* SPI Interrupt Status register */
typedef struct {
  __REG32 RXRDY				      	: 1;
  __REG32 TXRDY				      	: 1;
  __REG32 RXOV				      	: 1;
  __REG32 TXUR				      	: 1;
  __REG32 SSA					      	: 1;
  __REG32 SSD					      	: 1;
  __REG32 						       	:26;
} __spi_intstat_bits;

/* CAN control register */
typedef struct{
__REG32 INIT      : 1;
__REG32 IE        : 1;
__REG32 SIE       : 1;
__REG32 EIE       : 1;
__REG32           : 1;
__REG32 DAR       : 1;
__REG32 CCE       : 1;
__REG32 TEST      : 1;
__REG32           :24;
} __cancntl_bits;

/* CAN status register */
typedef struct{
__REG32 LEC       : 3;
__REG32 TXOK      : 1;
__REG32 RXOK      : 1;
__REG32 EPASS     : 1;
__REG32 EWARN     : 1;
__REG32 BOFF      : 1;
__REG32           :24;
} __canstat_bits;

/* CAN error counter */
typedef struct{
__REG32 TEC       : 8;
__REG32 REC       : 7;
__REG32 RP        : 1;
__REG32           :16;
} __canec_bits;

/* CAN bit timing register */
typedef struct{
__REG32 BRP       : 6;
__REG32 SJW       : 2;
__REG32 TSEG1     : 4;
__REG32 TSEG2     : 3;
__REG32           :17;
} __canbt_bits;

/* CAN interrupt register */
typedef struct{
__REG32 INTID     :16;
__REG32           :16;
} __canint_bits;

/* CAN test register */
typedef struct{
__REG32           : 2;
__REG32 BASIC     : 1;
__REG32 SILENT    : 1;
__REG32 LBACK     : 1;
__REG32 TX        : 2;
__REG32 RX        : 1;
__REG32           :24;
} __cantest_bits;

/* CAN baud rate prescaler extension register */
typedef struct{
__REG32 BRPE      : 4;
__REG32           :28;
} __canbrpe_bits;

/* CAN message interface command request registers */
typedef struct{
__REG32 MN						 : 6;
__REG32                : 9;
__REG32 BUSY           : 1;
__REG32                :16;
} __canifx_cmdreq_bits;

/*CAN message interface command mask registers */
typedef struct{
__REG32 DATA_B         : 1;
__REG32 DATA_A         : 1;
__REG32 TXRQST_NEWDAT  : 1;
__REG32 CLRINTPND      : 1;
__REG32 CTRL           : 1;
__REG32 ARB            : 1;
__REG32 MASK           : 1;
__REG32 WR_RD          : 1;
__REG32                :24;
} __canifx_cmdmsk_bits;

/* CAN message interface command mask 1 registers */
typedef struct{
__REG32 MSK0           : 1;
__REG32 MSK1           : 1;
__REG32 MSK2           : 1;
__REG32 MSK3           : 1;
__REG32 MSK4           : 1;
__REG32 MSK5           : 1;
__REG32 MSK6           : 1;
__REG32 MSK7           : 1;
__REG32 MSK8           : 1;
__REG32 MSK9           : 1;
__REG32 MSK10          : 1;
__REG32 MSK11          : 1;
__REG32 MSK12          : 1;
__REG32 MSK13          : 1;
__REG32 MSK14          : 1;
__REG32 MSK15          : 1;
__REG32                :16;
} __canifx_msk1_bits;

/* CAN message interface command mask 1 registers */
typedef struct{
__REG32 MSK16          : 1;
__REG32 MSK17          : 1;
__REG32 MSK18          : 1;
__REG32 MSK19          : 1;
__REG32 MSK20          : 1;
__REG32 MSK21          : 1;
__REG32 MSK22          : 1;
__REG32 MSK23          : 1;
__REG32 MSK24          : 1;
__REG32 MSK25          : 1;
__REG32 MSK26          : 1;
__REG32 MSK27          : 1;
__REG32 MSK28          : 1;
__REG32                : 1;
__REG32 MDIR           : 1;
__REG32 MXTD           : 1;
__REG32                :16;
} __canifx_msk2_bits;

/* CAN message interface command arbitration 1 registers */
typedef struct{
__REG32  ID             :16;
__REG32                 :16;
} __canifx_arb1_bits;

/* CAN message interface command arbitration 2 registers */
typedef struct{
__REG32  ID             :13;
__REG32  DIR            : 1;
__REG32  XTD            : 1;
__REG32  MSGVAL         : 1;
__REG32                 :16;
} __canifx_arb2_bits;

/* CAN message interface message control registers */
typedef struct{
__REG32  DLC            : 4;
__REG32                 : 3;
__REG32  EOB            : 1;
__REG32  TXRQST         : 1;
__REG32  RMTEN          : 1;
__REG32  RXIE           : 1;
__REG32  TXIE           : 1;
__REG32  UMASK          : 1;
__REG32  INTPND         : 1;
__REG32  MSGLST         : 1;
__REG32  NEWDAT         : 1;
__REG32                 :16;
} __canifx_mctrl_bits;

/* CAN message interface data A1 registers */
typedef struct{
__REG32  DATA0          : 8;
__REG32  DATA1          : 8;
__REG32                 :16;
} __canifx_da1_bits;

/* CAN message interface data A2 registers */
typedef struct{
__REG32  DATA2          : 8;
__REG32  DATA3          : 8;
__REG32                 :16;
} __canifx_da2_bits;

/* CAN message interface data B1 registers */
typedef struct{
__REG32  DATA4          : 8;
__REG32  DATA5          : 8;
__REG32                 :16;
} __canifx_db1_bits;

/* CAN message interface data B2 registers */
typedef struct{
__REG32  DATA6          : 8;
__REG32  DATA7          : 8;
__REG32                 :16;
} __canifx_db2_bits;

/* CAN transmission request 1 register */
typedef struct{
__REG32  TXRQST1        : 1;
__REG32  TXRQST2        : 1;
__REG32  TXRQST3        : 1;
__REG32  TXRQST4        : 1;
__REG32  TXRQST5        : 1;
__REG32  TXRQST6        : 1;
__REG32  TXRQST7        : 1;
__REG32  TXRQST8        : 1;
__REG32  TXRQST9        : 1;
__REG32  TXRQST10       : 1;
__REG32  TXRQST11       : 1;
__REG32  TXRQST12       : 1;
__REG32  TXRQST13       : 1;
__REG32  TXRQST14       : 1;
__REG32  TXRQST15       : 1;
__REG32  TXRQST16       : 1;
__REG32                 :16;
} __cantxreq1_bits;

/* CAN transmission request 2 register */
typedef struct{
__REG32  TXRQST17       : 1;
__REG32  TXRQST18       : 1;
__REG32  TXRQST19       : 1;
__REG32  TXRQST20       : 1;
__REG32  TXRQST21       : 1;
__REG32  TXRQST22       : 1;
__REG32  TXRQST23       : 1;
__REG32  TXRQST24       : 1;
__REG32  TXRQST25       : 1;
__REG32  TXRQST26       : 1;
__REG32  TXRQST27       : 1;
__REG32  TXRQST28       : 1;
__REG32  TXRQST29       : 1;
__REG32  TXRQST30       : 1;
__REG32  TXRQST31       : 1;
__REG32  TXRQST32       : 1;
__REG32                 :16;
} __cantxreq2_bits;

/* CAN new data 1 register */
typedef struct{
__REG32  NEWDAT1        : 1;
__REG32  NEWDAT2        : 1;
__REG32  NEWDAT3        : 1;
__REG32  NEWDAT4        : 1;
__REG32  NEWDAT5        : 1;
__REG32  NEWDAT6        : 1;
__REG32  NEWDAT7        : 1;
__REG32  NEWDAT8        : 1;
__REG32  NEWDAT9        : 1;
__REG32  NEWDAT10       : 1;
__REG32  NEWDAT11       : 1;
__REG32  NEWDAT12       : 1;
__REG32  NEWDAT13       : 1;
__REG32  NEWDAT14       : 1;
__REG32  NEWDAT15       : 1;
__REG32  NEWDAT16       : 1;
__REG32                 :16;
} __cannd1_bits;

/* CAN new data 2 register */
typedef struct{
__REG32  NEWDAT17       : 1;
__REG32  NEWDAT18       : 1;
__REG32  NEWDAT19       : 1;
__REG32  NEWDAT20       : 1;
__REG32  NEWDAT21       : 1;
__REG32  NEWDAT22       : 1;
__REG32  NEWDAT23       : 1;
__REG32  NEWDAT24       : 1;
__REG32  NEWDAT25       : 1;
__REG32  NEWDAT26       : 1;
__REG32  NEWDAT27       : 1;
__REG32  NEWDAT28       : 1;
__REG32  NEWDAT29       : 1;
__REG32  NEWDAT30       : 1;
__REG32  NEWDAT31       : 1;
__REG32  NEWDAT32       : 1;
__REG32                 :16;
} __cannd2_bits;

/* CAN interrupt pending 1 register */
typedef struct{
__REG32  INTPND1        : 1;
__REG32  INTPND2        : 1;
__REG32  INTPND3        : 1;
__REG32  INTPND4        : 1;
__REG32  INTPND5        : 1;
__REG32  INTPND6        : 1;
__REG32  INTPND7        : 1;
__REG32  INTPND8        : 1;
__REG32  INTPND9        : 1;
__REG32  INTPND10       : 1;
__REG32  INTPND11       : 1;
__REG32  INTPND12       : 1;
__REG32  INTPND13       : 1;
__REG32  INTPND14       : 1;
__REG32  INTPND15       : 1;
__REG32  INTPND16       : 1;
__REG32                 :16;
} __canir1_bits;

/* CAN interrupt pending 2 register */
typedef struct{
__REG32  INTPND17       : 1;
__REG32  INTPND18       : 1;
__REG32  INTPND19       : 1;
__REG32  INTPND20       : 1;
__REG32  INTPND21       : 1;
__REG32  INTPND22       : 1;
__REG32  INTPND23       : 1;
__REG32  INTPND24       : 1;
__REG32  INTPND25       : 1;
__REG32  INTPND26       : 1;
__REG32  INTPND27       : 1;
__REG32  INTPND28       : 1;
__REG32  INTPND29       : 1;
__REG32  INTPND30       : 1;
__REG32  INTPND31       : 1;
__REG32  INTPND32       : 1;
__REG32                 :16;
} __canir2_bits;

/* CAN message valid 1 register */
typedef struct{
__REG32  MSGVAL1        : 1;
__REG32  MSGVAL2        : 1;
__REG32  MSGVAL3        : 1;
__REG32  MSGVAL4        : 1;
__REG32  MSGVAL5        : 1;
__REG32  MSGVAL6        : 1;
__REG32  MSGVAL7        : 1;
__REG32  MSGVAL8        : 1;
__REG32  MSGVAL9        : 1;
__REG32  MSGVAL10       : 1;
__REG32  MSGVAL11       : 1;
__REG32  MSGVAL12       : 1;
__REG32  MSGVAL13       : 1;
__REG32  MSGVAL14       : 1;
__REG32  MSGVAL15       : 1;
__REG32  MSGVAL16       : 1;
__REG32                 :16;
} __canmsgv1_bits;

/* CAN message valid 2 register */
typedef struct{
__REG32  MSGVAL17       : 1;
__REG32  MSGVAL18       : 1;
__REG32  MSGVAL19       : 1;
__REG32  MSGVAL20       : 1;
__REG32  MSGVAL21       : 1;
__REG32  MSGVAL22       : 1;
__REG32  MSGVAL23       : 1;
__REG32  MSGVAL24       : 1;
__REG32  MSGVAL25       : 1;
__REG32  MSGVAL26       : 1;
__REG32  MSGVAL27       : 1;
__REG32  MSGVAL28       : 1;
__REG32  MSGVAL29       : 1;
__REG32  MSGVAL30       : 1;
__REG32  MSGVAL31       : 1;
__REG32  MSGVAL32       : 1;
__REG32                 :16;
} __canmsgv2_bits;

/* CAN clock divider register */
typedef struct{
__REG32  CLKDIVVAL      : 4;
__REG32                 :28;
} __canclkdiv_bits;

/* ADC Control Register */
typedef struct{
__REG32  CLKDIV		      : 8;
__REG32  ASYNMODE	      : 1;
__REG32  MODE10BIT      : 1;
__REG32  LPWRMODE	      : 1;
__REG32  					      :19;
__REG32  CAL_MODE	      : 1;
__REG32                 : 1;
} __adc_ctrl_bits;

/* ADC Input Select Register */
typedef struct{
__REG32  AD0SEL		      : 4;
__REG32  					      :26;
__REG32  WRAPEN	      	: 2;
} __adc_insel_bits;

/* ADC Conversion Sequence A Control Register  */
/* ADC Conversion Sequence B Control Register  */
typedef struct{
__REG32  CHANNELS	      :12;
__REG32  TRIGGER	      : 6;
__REG32  TRIGPOL	      : 1;
__REG32  SYNCBYPASS     : 1;
__REG32  					      : 6;
__REG32  START			    : 1;
__REG32  BURST			    : 1;
__REG32  SINGLESTEP	    : 1;
__REG32  LOWPRIO		    : 1;
__REG32  MODE				    : 1;
__REG32  SEQ_ENA		    : 1;
} __adc_seqa_ctrl_bits;

/* ADC Sequence A Global Data Register  */
typedef struct{
__REG32  					      : 4;
__REG32  RESULT		      :12;
__REG32  THCMPRANGE     : 2;
__REG32  THCMPCROSS     : 2;
__REG32  					      : 6;
__REG32  CHN				    : 4;
__REG32  OVERRUN		    : 1;
__REG32  DATAVALID	    : 1;
} __adc_seqa_gdat_bits;

/* ADC Compare Low Threshold Registers 0 and 1 */
typedef struct{
__REG32  					      : 4;
__REG32  THRLOW		      :12;
__REG32  					      :16;
} __adc_thr_low_bits;

/* ADC Compare High Threshold Registers 0 and 1 */
typedef struct{
__REG32  					      : 4;
__REG32  THRHIGH		    :12;
__REG32  					      :16;
} __adc_thr_high_bits;

/* ADC Channel Threshold Select register */
typedef struct{
__REG32  CH0_THRSEL     : 1;
__REG32  CH1_THRSEL     : 1;
__REG32  CH2_THRSEL     : 1;
__REG32  CH3_THRSEL     : 1;
__REG32  CH4_THRSEL     : 1;
__REG32  CH5_THRSEL     : 1;
__REG32  CH6_THRSEL     : 1;
__REG32  CH7_THRSEL     : 1;
__REG32  CH8_THRSEL     : 1;
__REG32  CH9_THRSEL     : 1;
__REG32  CH10_THRSEL    : 1;
__REG32  CH11_THRSEL    : 1;
__REG32  					      :20;
} __adc_chan_thrsel_bits;

/* ADC Interrrupt Enable Register */
typedef struct{
__REG32  SEQA_INTEN     : 1;
__REG32  SEQB_INTEN     : 1;
__REG32  OVR_INTEN      : 1;
__REG32  ADCMPINTEN0    : 2;
__REG32  ADCMPINTEN1    : 2;
__REG32  ADCMPINTEN2    : 2;
__REG32  ADCMPINTEN3    : 2;
__REG32  ADCMPINTEN4    : 2;
__REG32  ADCMPINTEN5    : 2;
__REG32  ADCMPINTEN6    : 2;
__REG32  ADCMPINTEN7    : 2;
__REG32  ADCMPINTEN8    : 2;
__REG32  ADCMPINTEN9    : 2;
__REG32  ADCMPINTEN10   : 2;
__REG32  ADCMPINTEN11   : 2;
__REG32  					      : 5;
} __adc_inten_bits;

/* ADC Flag register */
typedef struct{
__REG32  THCMP0			    : 1;
__REG32  THCMP1			    : 1;
__REG32  THCMP2			    : 1;
__REG32  THCMP3			    : 1;
__REG32  THCMP4			    : 1;
__REG32  THCMP5			    : 1;
__REG32  THCMP6			    : 1;
__REG32  THCMP7			    : 1;
__REG32  THCMP8			    : 1;
__REG32  THCMP9			    : 1;
__REG32  THCMP10		    : 1;
__REG32  THCMP11		    : 1;
__REG32  OVERRUN0	     	: 1;
__REG32  OVERRUN1	     	: 1;
__REG32  OVERRUN2	     	: 1;
__REG32  OVERRUN3	     	: 1;
__REG32  OVERRUN4	     	: 1;
__REG32  OVERRUN5	     	: 1;
__REG32  OVERRUN6	     	: 1;
__REG32  OVERRUN7	     	: 1;
__REG32  OVERRUN8	     	: 1;
__REG32  OVERRUN9	     	: 1;
__REG32  OVERRUN10     	: 1;
__REG32  OVERRUN11     	: 1;
__REG32  SEQA_OVR	     	: 1;
__REG32  SEQB_OVR	     	: 1;
__REG32  					      : 2;
__REG32  SEQA_INT		    : 1;
__REG32  SEQB_INT	      : 1;
__REG32  THCMP_INT      : 1;
__REG32  OVR_INT        : 1;
} __adc_flags_bits;

/* D/A Converter Value Register */
typedef struct{
__REG32  					      : 4;
__REG32  VALUE			    :12;
__REG32  					      :16;
} __dac_val_bits;

/* D/A Converter Control register */
typedef struct{
__REG32  INT_DMA_FLAG		: 1;
__REG32  TRIG_SRC				: 3;
__REG32  POLARITY				: 1;
__REG32  SYNC_BYPASS		: 1;
__REG32  TIMER_ENA			: 1;
__REG32  DBLBUF_ENA	    : 1;
__REG32  SHUTOFF_ENA    : 1;
__REG32  SHUTOFF_FLAG   : 1;
__REG32  BIAS				    : 3;
__REG32  					      :19;
} __dac_ctrl_bits;

/* D/A Converter Counter Value register */
typedef struct{
__REG32  CNTVAL			    :16;
__REG32  					      :16;
} __dac_cntval_bits;

/* COMP control register */
typedef struct{
__REG32  					      : 8;
__REG32  ROSCCTL		    : 1;
__REG32  EXT_RESET	    : 1;
__REG32  					      :22;
} __comp_ctrl_bits;

/* COMP Comparator x register */
typedef struct{
__REG32  EN					    : 1;
__REG32  					      : 1;
__REG32  INTEN			    : 1;
__REG32  STAT				    : 1;
__REG32  VM	  			    : 3;
__REG32  					      : 1;
__REG32  VP					    : 3;
__REG32  					      : 2;
__REG32  HYS				    : 2;
__REG32  INTPOL			    : 1;
__REG32  INTTYPE		    : 1;
__REG32  INTEDGE		    : 2;
__REG32  INTFLAG		    : 1;
__REG32  VLADEN			    : 1;
__REG32  						    : 1;
__REG32  VLADREF		    : 1;
__REG32  						    : 1;
__REG32  VSEL				    : 5;
__REG32  DLY				    : 2;
__REG32  					      : 1;
} __comp_cmp_bits;

/* COMP pin filter registers */
typedef struct{
__REG32  S_MODE			    : 2;
__REG32  CLKDIV			    : 3;
__REG32  					      :27;
} __comp_cmpfiltr_bits;

/* CRC mode register */
typedef struct{
__REG32 CRC_POLY      : 2;
__REG32 BIT_RVS_WR    : 1;
__REG32 CMPL_WR       : 1;
__REG32 BIT_RVS_SUM   : 1;
__REG32 CMPL_SUM      : 1;
__REG32               :26;
} __crc_mode_bits;

/* Flash Module Signature Start register */
typedef struct{
__REG32 START       :17;
__REG32             :15;
} __fmsstart_bits;

/* Flash Module Signature Stop register */
typedef struct{
__REG32 STOPA       :17;
__REG32             :14;
__REG32 STRTBIST	  : 1;
} __fmsstop_bits;

#endif    /* __IAR_SYSTEMS_ICC__ */

/* Declarations common to compiler and assembler **************************/

/***************************************************************************
 **
 ** NVIC
 **
 ***************************************************************************/
__IO_REG32_BIT(NVIC,                  0xE000E004,__READ       ,__nvic_bits);
__IO_REG32_BIT(SYSTICKCSR,            0xE000E010,__READ_WRITE ,__systickcsr_bits);
__IO_REG32_BIT(SYSTICKRVR,            0xE000E014,__READ_WRITE ,__systickrvr_bits);
__IO_REG32_BIT(SYSTICKCVR,            0xE000E018,__READ_WRITE ,__systickcvr_bits);
__IO_REG32_BIT(SYSTICKCALVR,          0xE000E01C,__READ       ,__systickcalvr_bits);
__IO_REG32_BIT(SETENA0,               0xE000E100,__READ_WRITE ,__setena0_bits);
__IO_REG32_BIT(CLRENA0,               0xE000E180,__READ_WRITE ,__clrena0_bits);
__IO_REG32_BIT(SETPEND0,              0xE000E200,__READ_WRITE ,__setpend0_bits);
__IO_REG32_BIT(CLRPEND0,              0xE000E280,__READ_WRITE ,__clrpend0_bits);
__IO_REG32_BIT(ACTIVE0,               0xE000E300,__READ       ,__active0_bits);
__IO_REG32_BIT(IP0,                   0xE000E400,__READ_WRITE ,__pri0_bits);
__IO_REG32_BIT(IP1,                   0xE000E404,__READ_WRITE ,__pri1_bits);
__IO_REG32_BIT(IP2,                   0xE000E408,__READ_WRITE ,__pri2_bits);
__IO_REG32_BIT(IP3,                   0xE000E40C,__READ_WRITE ,__pri3_bits);
__IO_REG32_BIT(IP4,                   0xE000E410,__READ_WRITE ,__pri4_bits);
__IO_REG32_BIT(IP5,                   0xE000E414,__READ_WRITE ,__pri5_bits);
__IO_REG32_BIT(IP6,                   0xE000E418,__READ_WRITE ,__pri6_bits);
__IO_REG32_BIT(IP7,                   0xE000E41C,__READ_WRITE ,__pri7_bits);
__IO_REG32_BIT(CPUIDBR,               0xE000ED00,__READ       ,__cpuidbr_bits);
__IO_REG32_BIT(ICSR,                  0xE000ED04,__READ_WRITE ,__icsr_bits);
__IO_REG32_BIT(VTOR,                  0xE000ED08,__READ_WRITE ,__vtor_bits);
__IO_REG32_BIT(AIRCR,                 0xE000ED0C,__READ_WRITE ,__aircr_bits);
__IO_REG32_BIT(SCR,                   0xE000ED10,__READ_WRITE ,__scr_bits);
__IO_REG32_BIT(CCR,                   0xE000ED14,__READ_WRITE ,__ccr_bits);
__IO_REG32_BIT(SHPR0,                 0xE000ED18,__READ_WRITE ,__pri1_bits);
__IO_REG32_BIT(SHPR1,                 0xE000ED1C,__READ_WRITE ,__pri2_bits);
__IO_REG32_BIT(SHPR2,                 0xE000ED20,__READ_WRITE ,__pri3_bits);
__IO_REG32_BIT(SHCSR,                 0xE000ED24,__READ_WRITE ,__shcsr_bits);
__IO_REG32_BIT(CFSR,                  0xE000ED28,__READ_WRITE ,__cfsr_bits);
__IO_REG32_BIT(HFSR,                  0xE000ED2C,__READ_WRITE ,__hfsr_bits);
__IO_REG32_BIT(DFSR,                  0xE000ED30,__READ_WRITE ,__dfsr_bits);
__IO_REG32(    MMFAR,                 0xE000ED34,__READ_WRITE);
__IO_REG32(    BFAR,                  0xE000ED38,__READ_WRITE);
__IO_REG32(		 STIR,                  0xE000EF00,__WRITE     );

/***************************************************************************
 **
 ** System control block
 **
 ***************************************************************************/
__IO_REG32_BIT(SYSMEMREMAP,           0x40074000,__READ_WRITE ,__sysmemremap_bits);
//__IO_REG32_BIT(AHBMATPRIO,            0x40074004,__READ_WRITE ,__ahbmatprio_bits);
//__IO_REG32_BIT(AHBFUNPRIO,            0x40074008,__READ_WRITE ,__ahbfunprio_bits);
//__IO_REG32_BIT(AHBBUFEN0,            	0x4007400C,__READ_WRITE	,__ahbbufen0_bits);
//__IO_REG32_BIT(AHBBUFEN1,            	0x40074010,__READ_WRITE ,__ahbbufen1_bits);
//__IO_REG32_BIT(SYSTCKCAL,            	0x40074014,__READ_WRITE	,__systckcal_bits);
__IO_REG32_BIT(NMISRC,            		0x4007401C,__READ_WRITE	,__nmisrc_bits);
__IO_REG32_BIT(SYSRSTSTAT,          	0x40074040,__READ_WRITE ,__sysrststat_bits);
__IO_REG32_BIT(PRESETCTRL0,          	0x40074044,__READ_WRITE ,__presetctrl0_bits);
__IO_REG32_BIT(PRESETCTRL1,          	0x40074048,__READ_WRITE ,__presetctrl1_bits);
__IO_REG32_BIT(PIOPORCAP0,          	0x4007404C,__READ				,__pioporcap0_bits);
__IO_REG32_BIT(PIOPORCAP1,          	0x40074050,__READ				,__pioporcap1_bits);
__IO_REG32_BIT(PIOPORCAP2,          	0x40074054,__READ				,__pioporcap2_bits);
__IO_REG32_BIT(MAINCLKSELA,           0x40074080,__READ_WRITE ,__mainclksel_bits);
__IO_REG32_BIT(MAINCLKSELB,           0x40074084,__READ_WRITE ,__mainclksel_bits);
__IO_REG32_BIT(USBCLKSEL,          		0x40074088,__READ_WRITE ,__mainclksel_bits);
__IO_REG32_BIT(ADCASYNCCLKSEL,        0x4007408C,__READ_WRITE ,__mainclksel_bits);
__IO_REG32_BIT(CLKOUTSELA,            0x40074094,__READ_WRITE ,__mainclksel_bits);
__IO_REG32_BIT(CLKOUTSELB,            0x40074098,__READ_WRITE ,__mainclksel_bits);
__IO_REG32_BIT(SYSPLLCLKSEL,          0x400740A0,__READ_WRITE ,__mainclksel_bits);
__IO_REG32_BIT(USBPLLCLKSEL,          0x400740A4,__READ_WRITE ,__mainclksel_bits);
__IO_REG32_BIT(SCTPLLCLKSEL,          0x400740A8,__READ_WRITE ,__mainclksel_bits);
__IO_REG32_BIT(SYSAHBCLKDIV,         	0x400740C0,__READ_WRITE ,__sysahbclkdiv_bits);
__IO_REG32_BIT(SYSAHBCLKCTRL0,        0x400740C4,__READ_WRITE ,__sysahbclkctrl0_bits);
__IO_REG32_BIT(SYSAHBCLKCTRL1,        0x400740C8,__READ_WRITE ,__sysahbclkctrl1_bits);
__IO_REG32_BIT(SYSTICKCLKDIV,         0x400740CC,__READ_WRITE ,__systickclkdiv_bits);
__IO_REG32_BIT(UARTCLKDIV,            0x400740D0,__READ_WRITE ,__systickclkdiv_bits);
__IO_REG32_BIT(IOCONCLKDIV,           0x400740D4,__READ_WRITE ,__systickclkdiv_bits);
__IO_REG32_BIT(TRACECLKDIV,           0x400740D8,__READ_WRITE ,__systickclkdiv_bits);
__IO_REG32_BIT(USBCLKDIV,           	0x400740EC,__READ_WRITE ,__systickclkdiv_bits);
__IO_REG32_BIT(ADCASYNCCLKDIV,        0x400740F0,__READ_WRITE ,__systickclkdiv_bits);
__IO_REG32_BIT(CLKOUTDIV,           	0x400740F8,__READ_WRITE ,__systickclkdiv_bits);
__IO_REG32_BIT(FREQMECTRL,           	0x40074120,__READ_WRITE ,__freqmectrl_bits);
__IO_REG32_BIT(FLASHCFG,           		0x40074124,__READ_WRITE ,__flashcfg_bits);
__IO_REG32_BIT(FRGCTRL,           		0x40074128,__READ_WRITE ,__frgctrl_bits);
__IO_REG32_BIT(USBCLKCTRL,           	0x4007412C,__READ_WRITE ,__usbclkctrl_bits);
__IO_REG32_BIT(USBCLKST,           		0x40074130,__READ_WRITE ,__usbclkst_bits);
__IO_REG32_BIT(BODCTRL,           		0x40074180,__READ_WRITE ,__bodctrl_bits);
//__IO_REG32_BIT(IRCCTRL,           		0x40074184,__READ_WRITE ,__ircctrl_bits);
__IO_REG32_BIT(SYSOSCCTRL,            0x40074188,__READ_WRITE ,__sysoscctrl_bits);
__IO_REG32_BIT(RTCOSCCTRL,            0x40074190,__READ_WRITE	,__rtcoscctrl_bits);
__IO_REG32_BIT(SYSPLLCTRL,            0x40074198,__READ_WRITE ,__syspllctrl_bits);
__IO_REG32_BIT(SYSPLLSTAT,            0x4007419C,__READ				,__syspllstat_bits);
__IO_REG32_BIT(USBPLLCTRL,            0x400741A0,__READ_WRITE ,__syspllctrl_bits);
__IO_REG32_BIT(USBPLLSTAT,            0x400741A4,__READ				,__syspllstat_bits);
__IO_REG32_BIT(SCTPLLCTRL,            0x400741A8,__READ_WRITE ,__syspllctrl_bits);
__IO_REG32_BIT(SCTPLLSTAT,            0x400741AC,__READ				,__syspllstat_bits);
__IO_REG32_BIT(PDAWAKECFG,            0x40074204,__READ_WRITE ,__pdawakecfg_bits);
__IO_REG32_BIT(PDRUNCFG,              0x40074208,__READ_WRITE ,__pdawakecfg_bits);
__IO_REG32_BIT(STARTERP0,             0x40074218,__READ_WRITE ,__starterp0_bits);
__IO_REG32_BIT(STARTERP1,             0x4007421C,__READ_WRITE ,__starterp1_bits);
//__IO_REG32_BIT(JTAG_IDCODE,           0x400743F4,__READ_WRITE ,__jtag_idcode_bits);
//__IO_REG32_BIT(DEVICE_ID0,           	0x400743F8,__READ_WRITE ,__device_id0_bits);
//__IO_REG32_BIT(DEVICE_ID1,           	0x400743FC,__READ_WRITE ,__device_id1_bits);

/***************************************************************************
 **
 ** PMU
 **
 ***************************************************************************/
__IO_REG32_BIT(PCON,                  0x4003C000,__READ_WRITE ,__pcon_bits);
__IO_REG32(		 GPREG0,                0x4003C004,__READ_WRITE );
__IO_REG32(		 GPREG1,                0x4003C008,__READ_WRITE );
__IO_REG32(		 GPREG2,                0x4003C00C,__READ_WRITE );
__IO_REG32(		 GPREG3,                0x4003C010,__READ_WRITE );
__IO_REG32_BIT(DPDCTRL,               0x4003C014,__READ_WRITE ,__dpdctrl_bits);

/***************************************************************************
 **
 ** I/O configuration
 **
 ***************************************************************************/
__IO_REG32_BIT(IOCON_PIO0_0,    			0x400F8000,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_1,          0x400F8004,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_2,          0x400F8008,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_3,          0x400F800C,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_4,          0x400F8010,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_5,          0x400F8014,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_6,          0x400F8018,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_7,          0x400F801C,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_8,          0x400F8020,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_9,          0x400F8024,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_10,   			0x400F8028,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_11,     		0x400F802C,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_12,     		0x400F8030,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_13,     		0x400F8034,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_14,    			0x400F8038,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_15,   			0x400F803C,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_16,         0x400F8040,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_17,         0x400F8044,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_18,         0x400F8048,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_19,         0x400F804C,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_20,         0x400F8050,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_21,         0x400F8054,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_22,         0x400F8058,__READ_WRITE ,__iocon_pio0_22_bits);
__IO_REG32_BIT(IOCON_PIO0_23,         0x400F805C,__READ_WRITE ,__iocon_pio0_22_bits);
__IO_REG32_BIT(IOCON_PIO0_24,         0x400F8060,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_25,         0x400F8064,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_26,         0x400F8068,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_27,         0x400F806C,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_28,         0x400F8070,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_29,         0x400F8074,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_30,         0x400F8078,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO0_31,         0x400F807C,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_0,          0x400F8080,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_1,          0x400F8084,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_2,          0x400F8088,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_3,          0x400F808C,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_4,          0x400F8090,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_5,          0x400F8094,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_6,          0x400F8098,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_7,          0x400F809C,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_8,          0x400F80A0,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_9,          0x400F80A4,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_10,         0x400F80A8,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_11,         0x400F80AC,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_12,         0x400F80B0,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_13,         0x400F80B4,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_14,         0x400F80B8,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_15,         0x400F80BC,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_16,         0x400F80C0,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_17,         0x400F80C4,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_18,         0x400F80C8,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_19,         0x400F80CC,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_20,         0x400F80D0,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_21,         0x400F80D4,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_22,         0x400F80D8,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_23,         0x400F80DC,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_24,         0x400F80E0,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_25,         0x400F80E4,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_26,         0x400F80E8,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_27,         0x400F80EC,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_28,         0x400F80F0,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_29,         0x400F80F4,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO1_31,         0x400F80FC,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO2_0,         	0x400F8100,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO2_1,         	0x400F8104,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO2_2,         	0x400F8108,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO2_3,         	0x400F810C,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO2_4,         	0x400F8110,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO2_5,         	0x400F8114,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO2_6,         	0x400F8118,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO2_7,         	0x400F811C,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO2_8,         	0x400F8120,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO2_9,         	0x400F8124,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO2_10,        	0x400F8128,__READ_WRITE ,__iocon_bits);
__IO_REG32_BIT(IOCON_PIO2_11,        	0x400F812C,__READ_WRITE ,__iocon_bits);

/***************************************************************************
 **
 ** SM (Switch matrix)
 **
 ***************************************************************************/
__IO_REG32_BIT(PINASSIGN0,          	0x40038000,__READ_WRITE ,__pinassign0_bits);
__IO_REG32_BIT(PINASSIGN1,          	0x40038004,__READ_WRITE ,__pinassign1_bits);
__IO_REG32_BIT(PINASSIGN2,          	0x40038008,__READ_WRITE ,__pinassign2_bits);
__IO_REG32_BIT(PINASSIGN3,          	0x4003800C,__READ_WRITE ,__pinassign3_bits);
__IO_REG32_BIT(PINASSIGN4,          	0x40038010,__READ_WRITE ,__pinassign4_bits);
__IO_REG32_BIT(PINASSIGN5,          	0x40038014,__READ_WRITE ,__pinassign5_bits);
__IO_REG32_BIT(PINASSIGN6,          	0x40038018,__READ_WRITE ,__pinassign6_bits);
__IO_REG32_BIT(PINASSIGN7,          	0x4003801C,__READ_WRITE ,__pinassign7_bits);
__IO_REG32_BIT(PINASSIGN8,          	0x40038020,__READ_WRITE ,__pinassign8_bits);
__IO_REG32_BIT(PINASSIGN9,          	0x40038024,__READ_WRITE ,__pinassign9_bits);
__IO_REG32_BIT(PINASSIGN10,          	0x40038028,__READ_WRITE ,__pinassign10_bits);
__IO_REG32_BIT(PINASSIGN11,          	0x4003802C,__READ_WRITE ,__pinassign11_bits);
__IO_REG32_BIT(PINASSIGN12,          	0x40038030,__READ_WRITE ,__pinassign12_bits);
__IO_REG32_BIT(PINASSIGN13,          	0x40038034,__READ_WRITE ,__pinassign13_bits);
__IO_REG32_BIT(PINASSIGN14,          	0x40038038,__READ_WRITE ,__pinassign14_bits);
__IO_REG32_BIT(PINASSIGN15,          	0x4003803C,__READ_WRITE ,__pinassign15_bits);
__IO_REG32_BIT(PINENABLE0,          	0x400381C0,__READ_WRITE ,__pinenable0_bits);
__IO_REG32_BIT(PINENABLE1,          	0x400381C4,__READ_WRITE ,__pinenable1_bits);

/***************************************************************************
 **
 ** PINMUX
 **
 ***************************************************************************/
__IO_REG32_BIT(SCT0_PINMUX0,          0x40014000,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT0_PINMUX1,          0x40014004,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT0_PINMUX2,          0x40014008,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT0_PINMUX3,          0x4001400C,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT0_PINMUX4,          0x40014010,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT0_PINMUX5,          0x40014014,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT0_PINMUX6,          0x40014018,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT1_PINMUX0,          0x4001401C,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT1_PINMUX1,          0x40014020,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT1_PINMUX2,          0x40014024,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT1_PINMUX3,          0x40014028,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT1_PINMUX4,          0x4001402C,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT1_PINMUX5,          0x40014030,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT2_PINMUX0,          0x40014040,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT2_PINMUX1,          0x40014044,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT2_PINMUX2,          0x40014048,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT3_PINMUX0,          0x40014060,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT3_PINMUX1,          0x40014064,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(SCT3_PINMUX2,          0x40014068,__READ_WRITE ,__sct_pinmux_bits);
__IO_REG32_BIT(PINTSEL0,          		0x400140C0,__READ_WRITE ,__pintsel_bits);
__IO_REG32_BIT(PINTSEL1,          		0x400140C4,__READ_WRITE ,__pintsel_bits);
__IO_REG32_BIT(PINTSEL2,          		0x400140C8,__READ_WRITE ,__pintsel_bits);
__IO_REG32_BIT(PINTSEL3,          		0x400140CC,__READ_WRITE ,__pintsel_bits);
__IO_REG32_BIT(PINTSEL4,          		0x400140D0,__READ_WRITE ,__pintsel_bits);
__IO_REG32_BIT(PINTSEL5,          		0x400140D4,__READ_WRITE ,__pintsel_bits);
__IO_REG32_BIT(PINTSEL6,          		0x400140D8,__READ_WRITE ,__pintsel_bits);
__IO_REG32_BIT(PINTSEL7,          		0x400140DC,__READ_WRITE ,__pintsel_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX0,     0x400140E0,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX1,     0x400140E4,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX2,     0x400140E8,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX3,     0x400140EC,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX4,     0x400140F0,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX5,     0x400140F4,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX6,     0x400140F8,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX7,     0x400140FC,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX8,     0x40014100,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX9,     0x40014104,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX10,    0x40014108,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX11,    0x4001410C,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX12,    0x40014110,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX13,    0x40014114,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX14,    0x40014118,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX15,    0x4001411C,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX16,    0x40014120,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(DMA_ITRIG_PINMUX17,    0x40014124,__READ_WRITE ,__dma_itrig_pinmux_bits);
__IO_REG32_BIT(FREQMEAS_REF,    			0x40014160,__READ_WRITE ,__freqmeas_ref_bits);
__IO_REG32_BIT(FREQMEAS_TARGET,    		0x40014164,__READ_WRITE ,__freqmeas_ref_bits);

/***************************************************************************
 **
 ** GPIO
 **
 ***************************************************************************/
__IO_REG8(     GPIO_B0,           0x1C000000,__READ_WRITE );
__IO_REG8(     GPIO_B1,           0x1C000001,__READ_WRITE );
__IO_REG8(     GPIO_B2,           0x1C000002,__READ_WRITE );
__IO_REG8(     GPIO_B3,           0x1C000003,__READ_WRITE );
__IO_REG8(     GPIO_B4,           0x1C000004,__READ_WRITE );
__IO_REG8(     GPIO_B5,           0x1C000005,__READ_WRITE );
__IO_REG8(     GPIO_B6,           0x1C000006,__READ_WRITE );
__IO_REG8(     GPIO_B7,           0x1C000007,__READ_WRITE );
__IO_REG8(     GPIO_B8,           0x1C000008,__READ_WRITE );
__IO_REG8(     GPIO_B9,           0x1C000009,__READ_WRITE );
__IO_REG8(     GPIO_B10,          0x1C00000A,__READ_WRITE );
__IO_REG8(     GPIO_B11,          0x1C00000B,__READ_WRITE );
__IO_REG8(     GPIO_B12,          0x1C00000C,__READ_WRITE );
__IO_REG8(     GPIO_B13,          0x1C00000D,__READ_WRITE );
__IO_REG8(     GPIO_B14,          0x1C00000E,__READ_WRITE );
__IO_REG8(     GPIO_B15,          0x1C00000F,__READ_WRITE );
__IO_REG8(     GPIO_B16,          0x1C000010,__READ_WRITE );
__IO_REG8(     GPIO_B17,          0x1C000011,__READ_WRITE );
__IO_REG8(     GPIO_B18,          0x1C000012,__READ_WRITE );
__IO_REG8(     GPIO_B19,          0x1C000013,__READ_WRITE );
__IO_REG8(     GPIO_B20,          0x1C000014,__READ_WRITE );
__IO_REG8(     GPIO_B21,          0x1C000015,__READ_WRITE );
__IO_REG8(     GPIO_B22,          0x1C000016,__READ_WRITE );
__IO_REG8(     GPIO_B23,          0x1C000017,__READ_WRITE );
__IO_REG8(     GPIO_B24,          0x1C000018,__READ_WRITE );
__IO_REG8(     GPIO_B25,          0x1C000019,__READ_WRITE );
__IO_REG8(     GPIO_B26,          0x1C00001A,__READ_WRITE );
__IO_REG8(     GPIO_B27,          0x1C00001B,__READ_WRITE );
__IO_REG8(     GPIO_B28,          0x1C00001C,__READ_WRITE );
__IO_REG8(     GPIO_B29,          0x1C00001D,__READ_WRITE );
__IO_REG8(     GPIO_B30,          0x1C00001E,__READ_WRITE );
__IO_REG8(     GPIO_B31,          0x1C00001F,__READ_WRITE );
__IO_REG8(     GPIO_B32,          0x1C000020,__READ_WRITE );
__IO_REG8(     GPIO_B33,          0x1C000021,__READ_WRITE );
__IO_REG8(     GPIO_B34,          0x1C000022,__READ_WRITE );
__IO_REG8(     GPIO_B35,          0x1C000023,__READ_WRITE );
__IO_REG8(     GPIO_B36,          0x1C000024,__READ_WRITE );
__IO_REG8(     GPIO_B37,          0x1C000025,__READ_WRITE );
__IO_REG8(     GPIO_B38,          0x1C000026,__READ_WRITE );
__IO_REG8(     GPIO_B39,          0x1C000027,__READ_WRITE );
__IO_REG8(     GPIO_B40,          0x1C000028,__READ_WRITE );
__IO_REG8(     GPIO_B41,          0x1C000029,__READ_WRITE );
__IO_REG8(     GPIO_B42,          0x1C00002A,__READ_WRITE );
__IO_REG8(     GPIO_B43,          0x1C00002B,__READ_WRITE );
__IO_REG8(     GPIO_B44,          0x1C00002C,__READ_WRITE );
__IO_REG8(     GPIO_B45,          0x1C00002D,__READ_WRITE );
__IO_REG8(     GPIO_B46,          0x1C00002E,__READ_WRITE );
__IO_REG8(     GPIO_B47,          0x1C00002F,__READ_WRITE );
__IO_REG8(     GPIO_B48,          0x1C000030,__READ_WRITE );
__IO_REG8(     GPIO_B49,          0x1C000031,__READ_WRITE );
__IO_REG8(     GPIO_B50,          0x1C000032,__READ_WRITE );
__IO_REG8(     GPIO_B51,          0x1C000033,__READ_WRITE );
__IO_REG8(     GPIO_B52,          0x1C000034,__READ_WRITE );
__IO_REG8(     GPIO_B53,          0x1C000035,__READ_WRITE );
__IO_REG8(     GPIO_B54,          0x1C000036,__READ_WRITE );
__IO_REG8(     GPIO_B55,          0x1C000037,__READ_WRITE );
__IO_REG8(     GPIO_B56,          0x1C000038,__READ_WRITE );
__IO_REG8(     GPIO_B57,          0x1C000039,__READ_WRITE );
__IO_REG8(     GPIO_B58,          0x1C00003A,__READ_WRITE );
__IO_REG8(     GPIO_B59,          0x1C00003B,__READ_WRITE );
__IO_REG8(     GPIO_B60,          0x1C00003C,__READ_WRITE );
__IO_REG8(     GPIO_B61,          0x1C00003D,__READ_WRITE );
__IO_REG8(     GPIO_B62,          0x1C00003E,__READ_WRITE );
__IO_REG8(     GPIO_B63,          0x1C00003F,__READ_WRITE );
__IO_REG8(     GPIO_B64,          0x1C000040,__READ_WRITE );
__IO_REG8(     GPIO_B65,          0x1C000041,__READ_WRITE );
__IO_REG8(     GPIO_B66,          0x1C000042,__READ_WRITE );
__IO_REG8(     GPIO_B67,          0x1C000043,__READ_WRITE );
__IO_REG8(     GPIO_B68,          0x1C000044,__READ_WRITE );
__IO_REG8(     GPIO_B69,          0x1C000045,__READ_WRITE );
__IO_REG8(     GPIO_B70,          0x1C000046,__READ_WRITE );
__IO_REG8(     GPIO_B71,          0x1C000047,__READ_WRITE );
__IO_REG8(     GPIO_B72,          0x1C000048,__READ_WRITE );
__IO_REG8(     GPIO_B73,          0x1C000049,__READ_WRITE );
__IO_REG8(     GPIO_B74,          0x1C00004A,__READ_WRITE );
__IO_REG8(     GPIO_B75,          0x1C00004B,__READ_WRITE );
__IO_REG32(    GPIO_W0,           0x1C001000,__READ_WRITE );
__IO_REG32(    GPIO_W1,           0x1C001004,__READ_WRITE );
__IO_REG32(    GPIO_W2,           0x1C001008,__READ_WRITE );
__IO_REG32(    GPIO_W3,           0x1C00100C,__READ_WRITE );
__IO_REG32(    GPIO_W4,           0x1C001010,__READ_WRITE );
__IO_REG32(    GPIO_W5,           0x1C001014,__READ_WRITE );
__IO_REG32(    GPIO_W6,           0x1C001018,__READ_WRITE );
__IO_REG32(    GPIO_W7,           0x1C00101C,__READ_WRITE );
__IO_REG32(    GPIO_W8,           0x1C001020,__READ_WRITE );
__IO_REG32(    GPIO_W9,           0x1C001024,__READ_WRITE );
__IO_REG32(    GPIO_W10,          0x1C001028,__READ_WRITE );
__IO_REG32(    GPIO_W11,          0x1C00102C,__READ_WRITE );
__IO_REG32(    GPIO_W12,          0x1C001030,__READ_WRITE );
__IO_REG32(    GPIO_W13,          0x1C001034,__READ_WRITE );
__IO_REG32(    GPIO_W14,          0x1C001038,__READ_WRITE );
__IO_REG32(    GPIO_W15,          0x1C00103C,__READ_WRITE );
__IO_REG32(    GPIO_W16,          0x1C001040,__READ_WRITE );
__IO_REG32(    GPIO_W17,          0x1C001044,__READ_WRITE );
__IO_REG32(    GPIO_W18,          0x1C001048,__READ_WRITE );
__IO_REG32(    GPIO_W19,          0x1C00104C,__READ_WRITE );
__IO_REG32(    GPIO_W20,          0x1C001050,__READ_WRITE );
__IO_REG32(    GPIO_W21,          0x1C001054,__READ_WRITE );
__IO_REG32(    GPIO_W22,          0x1C001058,__READ_WRITE );
__IO_REG32(    GPIO_W23,          0x1C00105C,__READ_WRITE );
__IO_REG32(    GPIO_W24,          0x1C001060,__READ_WRITE );
__IO_REG32(    GPIO_W25,          0x1C001064,__READ_WRITE );
__IO_REG32(    GPIO_W26,          0x1C001068,__READ_WRITE );
__IO_REG32(    GPIO_W27,          0x1C00106C,__READ_WRITE );
__IO_REG32(    GPIO_W28,          0x1C001070,__READ_WRITE );
__IO_REG32(    GPIO_W29,          0x1C001074,__READ_WRITE );
__IO_REG32(    GPIO_W30,          0x1C001078,__READ_WRITE );
__IO_REG32(    GPIO_W31,          0x1C00107C,__READ_WRITE );
__IO_REG32(    GPIO_W32,          0x1C001080,__READ_WRITE );
__IO_REG32(    GPIO_W33,          0x1C001084,__READ_WRITE );
__IO_REG32(    GPIO_W34,          0x1C001088,__READ_WRITE );
__IO_REG32(    GPIO_W35,          0x1C00108C,__READ_WRITE );
__IO_REG32(    GPIO_W36,          0x1C001090,__READ_WRITE );
__IO_REG32(    GPIO_W37,          0x1C001094,__READ_WRITE );
__IO_REG32(    GPIO_W38,          0x1C001098,__READ_WRITE );
__IO_REG32(    GPIO_W39,          0x1C00109C,__READ_WRITE );
__IO_REG32(    GPIO_W40,          0x1C0010A0,__READ_WRITE );
__IO_REG32(    GPIO_W41,          0x1C0010A4,__READ_WRITE );
__IO_REG32(    GPIO_W42,          0x1C0010A8,__READ_WRITE );
__IO_REG32(    GPIO_W43,          0x1C0010AC,__READ_WRITE );
__IO_REG32(    GPIO_W44,          0x1C0010B0,__READ_WRITE );
__IO_REG32(    GPIO_W45,          0x1C0010B4,__READ_WRITE );
__IO_REG32(    GPIO_W46,          0x1C0010B8,__READ_WRITE );
__IO_REG32(    GPIO_W47,          0x1C0010BC,__READ_WRITE );
__IO_REG32(    GPIO_W48,          0x1C0010C0,__READ_WRITE );
__IO_REG32(    GPIO_W49,          0x1C0010C4,__READ_WRITE );
__IO_REG32(    GPIO_W50,          0x1C0010C8,__READ_WRITE );
__IO_REG32(    GPIO_W51,          0x1C0010CC,__READ_WRITE );
__IO_REG32(    GPIO_W52,          0x1C0010D0,__READ_WRITE );
__IO_REG32(    GPIO_W53,          0x1C0010D4,__READ_WRITE );
__IO_REG32(    GPIO_W54,          0x1C0010D8,__READ_WRITE );
__IO_REG32(    GPIO_W55,          0x1C0010DC,__READ_WRITE );
__IO_REG32(    GPIO_W56,          0x1C0010E0,__READ_WRITE );
__IO_REG32(    GPIO_W57,          0x1C0010E4,__READ_WRITE );
__IO_REG32(    GPIO_W58,          0x1C0010E8,__READ_WRITE );
__IO_REG32(    GPIO_W59,          0x1C0010EC,__READ_WRITE );
__IO_REG32(    GPIO_W60,          0x1C0010F0,__READ_WRITE );
__IO_REG32(    GPIO_W61,          0x1C0010F4,__READ_WRITE );
__IO_REG32(    GPIO_W62,          0x1C0010F8,__READ_WRITE );
__IO_REG32(    GPIO_W63,          0x1C0010FC,__READ_WRITE );
__IO_REG32(    GPIO_W64,          0x1C001100,__READ_WRITE );
__IO_REG32(    GPIO_W65,          0x1C001104,__READ_WRITE );
__IO_REG32(    GPIO_W66,          0x1C001108,__READ_WRITE );
__IO_REG32(    GPIO_W67,          0x1C00110C,__READ_WRITE );
__IO_REG32(    GPIO_W68,          0x1C001110,__READ_WRITE );
__IO_REG32(    GPIO_W69,          0x1C001114,__READ_WRITE );
__IO_REG32(    GPIO_W70,          0x1C001118,__READ_WRITE );
__IO_REG32(    GPIO_W71,          0x1C00111C,__READ_WRITE );
__IO_REG32(    GPIO_W72,          0x1C001120,__READ_WRITE );
__IO_REG32(    GPIO_W73,          0x1C001124,__READ_WRITE );
__IO_REG32(    GPIO_W74,          0x1C001128,__READ_WRITE );
__IO_REG32(    GPIO_W75,          0x1C00112C,__READ_WRITE );
__IO_REG32_BIT(GPIO_DIR0,         0x1C002000,__READ_WRITE ,__gpio0_bits);
__IO_REG32_BIT(GPIO_DIR1,         0x1C002004,__READ_WRITE ,__gpio1_bits);
__IO_REG32_BIT(GPIO_DIR2,         0x1C002008,__READ_WRITE ,__gpio2_bits);
__IO_REG32_BIT(GPIO_MASK0,        0x1C002080,__READ_WRITE ,__gpio0_bits);
__IO_REG32_BIT(GPIO_MASK1,        0x1C002084,__READ_WRITE ,__gpio1_bits);
__IO_REG32_BIT(GPIO_MASK2,        0x1C002088,__READ_WRITE ,__gpio2_bits);
__IO_REG32_BIT(GPIO_PIN0,         0x1C002100,__READ_WRITE ,__gpio0_bits);
__IO_REG32_BIT(GPIO_PIN1,         0x1C002104,__READ_WRITE ,__gpio1_bits);
__IO_REG32_BIT(GPIO_PIN2,         0x1C002108,__READ_WRITE ,__gpio2_bits);
__IO_REG32_BIT(GPIO_MPIN0,        0x1C002180,__READ_WRITE ,__gpio0_bits);
__IO_REG32_BIT(GPIO_MPIN1,        0x1C002184,__READ_WRITE ,__gpio1_bits);
__IO_REG32_BIT(GPIO_MPIN2,        0x1C002188,__READ_WRITE ,__gpio2_bits);
__IO_REG32_BIT(GPIO_SET0,         0x1C002200,__READ_WRITE ,__gpio0_bits);
__IO_REG32_BIT(GPIO_SET1,         0x1C002204,__READ_WRITE ,__gpio1_bits);
__IO_REG32_BIT(GPIO_SET2,         0x1C002208,__READ_WRITE ,__gpio2_bits);
__IO_REG32(    GPIO_CLR0,         0x1C002280,__WRITE );
__IO_REG32(    GPIO_CLR1,         0x1C002284,__WRITE );
__IO_REG32(    GPIO_CLR2,         0x1C002288,__WRITE );
__IO_REG32(    GPIO_NOT0,         0x1C002300,__WRITE );
__IO_REG32(    GPIO_NOT1,         0x1C002304,__WRITE );
__IO_REG32(    GPIO_NOT2,         0x1C002308,__WRITE );

/***************************************************************************
 **
 ** GINT0
 **
 ***************************************************************************/
__IO_REG32_BIT(GINT0_CTRL,        0x400A8000,__READ_WRITE ,__gint_ctrl_bits);
__IO_REG32_BIT(GINT0_PORT_POL0,   0x400A8020,__READ_WRITE ,__gint_port_pol_bits);
__IO_REG32_BIT(GINT0_PORT_POL1,   0x400A8024,__READ_WRITE ,__gint_port_pol_bits);
__IO_REG32_BIT(GINT0_PORT_POL2,   0x400A8028,__READ_WRITE ,__gint_port_pol_bits);
__IO_REG32_BIT(GINT0_PORT_ENA0,   0x400A8040,__READ_WRITE ,__gint_port_ena_bits);
__IO_REG32_BIT(GINT0_PORT_ENA1,   0x400A8044,__READ_WRITE ,__gint_port_ena_bits);
__IO_REG32_BIT(GINT0_PORT_ENA2,   0x400A8048,__READ_WRITE ,__gint_port_ena_bits);

/***************************************************************************
 **
 ** GINT1
 **
 ***************************************************************************/
__IO_REG32_BIT(GINT1_CTRL,        0x400AC000,__READ_WRITE ,__gint_ctrl_bits);
__IO_REG32_BIT(GINT1_PORT_POL0,   0x400AC020,__READ_WRITE ,__gint_port_pol_bits);
__IO_REG32_BIT(GINT1_PORT_POL1,   0x400AC024,__READ_WRITE ,__gint_port_pol_bits);
__IO_REG32_BIT(GINT1_PORT_POL2,   0x400AC028,__READ_WRITE ,__gint_port_pol_bits);
__IO_REG32_BIT(GINT1_PORT_ENA0,   0x400AC040,__READ_WRITE ,__gint_port_ena_bits);
__IO_REG32_BIT(GINT1_PORT_ENA1,   0x400AC044,__READ_WRITE ,__gint_port_ena_bits);
__IO_REG32_BIT(GINT1_PORT_ENA2,   0x400AC048,__READ_WRITE ,__gint_port_ena_bits);

/***************************************************************************
 **
 ** PIN
 **
 ***************************************************************************/
__IO_REG32_BIT(PIN_ISEL,        	0x400A4000,__READ_WRITE ,__pin_isel_bits);
__IO_REG32_BIT(PIN_IENR,        	0x400A4004,__READ_WRITE ,__pin_ienr_bits);
__IO_REG32(		 PIN_SIENR,        	0x400A4008,__WRITE 			);
__IO_REG32(		 PIN_CIENR,        	0x400A400C,__WRITE 			);
__IO_REG32_BIT(PIN_IENF,        	0x400A4010,__READ_WRITE ,__pin_ienf_bits);
__IO_REG32(		 PIN_SIENF,        	0x400A4014,__WRITE 			);
__IO_REG32(		 PIN_CIENF,        	0x400A4018,__WRITE 			);
__IO_REG32_BIT(PIN_RISE,        	0x400A401C,__READ_WRITE ,__pin_rise_bits);
__IO_REG32_BIT(PIN_FALL,        	0x400A4020,__READ_WRITE ,__pin_fall_bits);
__IO_REG32_BIT(PIN_IST,        		0x400A4024,__READ_WRITE ,__pin_ist_bits);
__IO_REG32_BIT(PIN_PMCTRL,        0x400A4028,__READ_WRITE ,__pin_pmctrl_bits);
__IO_REG32_BIT(PIN_PMSRC,        	0x400A402C,__READ_WRITE ,__pin_pmsrc_bits);
__IO_REG32_BIT(PIN_PMCFG,        	0x400A4030,__READ_WRITE ,__pin_pmcfg_bits);

/***************************************************************************
 **
 ** DMA
 **
 ***************************************************************************/
__IO_REG32_BIT(DMA_CTRL,         	0x1C004000,__READ_WRITE ,__dma_ctrl_bits);
__IO_REG32_BIT(DMA_INTSTAT,       0x1C004004,__READ				,__dma_intstat_bits);
__IO_REG32(		 DMA_SRAMBASE,      0x1C004008,__READ_WRITE );
__IO_REG32_BIT(DMA_ENABLESET0,    0x1C004020,__READ_WRITE ,__dma_enableset_bits);
__IO_REG32(		 DMA_ENABLECLR0,    0x1C004028,__WRITE 			);
__IO_REG32_BIT(DMA_ACTIVE0,       0x1C004030,__READ				,__dma_active_bits);
__IO_REG32_BIT(DMA_BUSY0,         0x1C004038,__READ				,__dma_busy_bits);
__IO_REG32_BIT(DMA_ERRINT0,       0x1C004040,__READ_WRITE ,__dma_errint_bits);
__IO_REG32_BIT(DMA_INTENSET0,     0x1C004048,__READ_WRITE ,__dma_intenset_bits);
__IO_REG32(		 DMA_INTENCLR0,     0x1C004050,__WRITE 			);
__IO_REG32_BIT(DMA_INTA0,     		0x1C004058,__READ_WRITE ,__dma_inta_bits);
__IO_REG32_BIT(DMA_INTB0,     		0x1C004060,__READ_WRITE ,__dma_intb_bits);
__IO_REG32(		 DMA_SETVALID0,     0x1C004068,__WRITE 			);
__IO_REG32(		 DMA_SETTRIG0,     	0x1C004070,__WRITE 			);
__IO_REG32(		 DMA_ABORT0,     		0x1C004078,__WRITE 			);
//__IO_REG32_BIT(DMA_CFG0,     			0x1C004400,__READ_WRITE ,__dma_cfg_bits);
//__IO_REG32_BIT(DMA_CTRLSTAT0,    	0x1C004400,__READ_WRITE ,__dma_ctrlstat_bits);
//__IO_REG32_BIT(DMA_XFERCFG0,    	0x1C004400,__READ_WRITE ,__dma_xfercfg_bits);

/***************************************************************************
 **
 ** SCT IPU
 **
 ***************************************************************************/
__IO_REG32_BIT(SCT_IPU_SAMPLE_CTRL,			0x400B8000,__READ_WRITE ,__sct_ipu_sample_ctrl_bits);
__IO_REG32_BIT(SCT_IPU_ABORT_ENABLE0,		0x400B8020,__READ_WRITE ,__sct_ipu_abort_enable_bits);
__IO_REG32_BIT(SCT_IPU_ABORT_SOURCE0,		0x400B8024,__READ_WRITE ,__sct_ipu_abort_source_bits);
__IO_REG32_BIT(SCT_IPU_ABORT_ENABLE1,		0x400B8040,__READ_WRITE ,__sct_ipu_abort_enable_bits);
__IO_REG32_BIT(SCT_IPU_ABORT_SOURCE1,		0x400B8044,__READ_WRITE ,__sct_ipu_abort_source_bits);
__IO_REG32_BIT(SCT_IPU_ABORT_ENABLE2,		0x400B8060,__READ_WRITE ,__sct_ipu_abort_enable_bits);
__IO_REG32_BIT(SCT_IPU_ABORT_SOURCE2,		0x400B8064,__READ_WRITE ,__sct_ipu_abort_source_bits);
__IO_REG32_BIT(SCT_IPU_ABORT_ENABLE3,		0x400B8080,__READ_WRITE ,__sct_ipu_abort_enable_bits);
__IO_REG32_BIT(SCT_IPU_ABORT_SOURCE3,		0x400B8084,__READ_WRITE ,__sct_ipu_abort_source_bits);

/***************************************************************************
 **
 ** SCT0
 **
 ***************************************************************************/
__IO_REG32_BIT(SCT0_CONFIG,				0x1C018000,__READ_WRITE ,__sct0_config_bits);
__IO_REG32_BIT(SCT0_CTRL,					0x1C018004,__READ_WRITE ,__sct0_ctrl_bits);
__IO_REG32_BIT(SCT0_LIMIT,				0x1C018008,__READ_WRITE ,__sct0_limit_bits);
__IO_REG32_BIT(SCT0_HALT,					0x1C01800C,__READ_WRITE ,__sct0_halt_bits);
__IO_REG32_BIT(SCT0_STOP,					0x1C018010,__READ_WRITE ,__sct0_stop_bits);
__IO_REG32_BIT(SCT0_START,				0x1C018014,__READ_WRITE ,__sct0_start_bits);
__IO_REG32_BIT(SCT0_DITHER,				0x1C018018,__READ_WRITE ,__sct0_dither_bits);
__IO_REG32_BIT(SCT0_COUNT,				0x1C018040,__READ_WRITE ,__sct0_count_bits);
__IO_REG32_BIT(SCT0_STATE,				0x1C018044,__READ_WRITE ,__sct0_state_bits);
__IO_REG32_BIT(SCT0_INPUT,				0x1C018048,__READ				,__sct0_input_bits);
__IO_REG32_BIT(SCT0_REGMODE,			0x1C01804C,__READ_WRITE ,__sct0_regmode_bits);
__IO_REG32_BIT(SCT0_OUTPUT,				0x1C018050,__READ_WRITE ,__sct0_output_bits);
__IO_REG32_BIT(SCT0_OUTPUTDIRCTRL,0x1C018054,__READ_WRITE ,__sct0_outputdirctrl_bits);
__IO_REG32_BIT(SCT0_RES,					0x1C018058,__READ_WRITE ,__sct0_res_bits);
__IO_REG32_BIT(SCT0_DMAREQ0,			0x1C01805C,__READ_WRITE ,__sct0_dmareq0_bits);
__IO_REG32_BIT(SCT0_DMAREQ1,			0x1C018060,__READ_WRITE ,__sct0_dmareq1_bits);
__IO_REG32_BIT(SCT0_EVEN,					0x1C0180F0,__READ_WRITE ,__sct0_even_bits);
__IO_REG32_BIT(SCT0_EVFLAG,				0x1C0180F4,__READ_WRITE ,__sct0_evflag_bits);
__IO_REG32_BIT(SCT0_CONEN,				0x1C0180F8,__READ_WRITE ,__sct0_conen_bits);
__IO_REG32_BIT(SCT0_CONFLAG,			0x1C0180FC,__READ_WRITE ,__sct0_conflag_bits);
__IO_REG32_BIT(SCT0_MATCH0,				0x1C018100,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH1,				0x1C018104,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH2,				0x1C018108,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH3,				0x1C01810C,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH4,				0x1C018110,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH5,				0x1C018114,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH6,				0x1C018118,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH7,				0x1C01811C,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH8,				0x1C018120,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH9,				0x1C018124,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH10,			0x1C018128,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH11,			0x1C01812C,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH12,			0x1C018130,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH13,			0x1C018134,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH14,			0x1C018138,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_MATCH15,			0x1C01813C,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT0_FRACMAT0,			0x1C018140,__READ_WRITE ,__sct0_fracmat_bits);
__IO_REG32_BIT(SCT0_FRACMAT1,			0x1C018144,__READ_WRITE ,__sct0_fracmat_bits);
__IO_REG32_BIT(SCT0_FRACMAT2,			0x1C018148,__READ_WRITE ,__sct0_fracmat_bits);
__IO_REG32_BIT(SCT0_FRACMAT3,			0x1C01814C,__READ_WRITE ,__sct0_fracmat_bits);
__IO_REG32_BIT(SCT0_FRACMAT4,			0x1C018150,__READ_WRITE ,__sct0_fracmat_bits);
__IO_REG32_BIT(SCT0_FRACMAT5,			0x1C018154,__READ_WRITE ,__sct0_fracmat_bits);
__IO_REG32_BIT(SCT0_MATCHREL0,		0x1C018200,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL1,		0x1C018204,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL2,		0x1C018208,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL3,		0x1C01820C,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL4,		0x1C018210,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL5,		0x1C018214,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL6,		0x1C018218,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL7,		0x1C01821C,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL8,		0x1C018220,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL9,		0x1C018224,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL10,		0x1C018228,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL11,		0x1C01822C,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL12,		0x1C018230,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL13,		0x1C018234,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL14,		0x1C018238,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_MATCHREL15,		0x1C01823C,__READ_WRITE ,__sct0_matchrel_bits);
__IO_REG32_BIT(SCT0_FRACMATREL0,	0x1C018240,__READ_WRITE ,__sct0_fracmatrel_bits);
__IO_REG32_BIT(SCT0_FRACMATREL1,	0x1C018244,__READ_WRITE ,__sct0_fracmatrel_bits);
__IO_REG32_BIT(SCT0_FRACMATREL2,	0x1C018248,__READ_WRITE ,__sct0_fracmatrel_bits);
__IO_REG32_BIT(SCT0_FRACMATREL3,	0x1C01824C,__READ_WRITE ,__sct0_fracmatrel_bits);
__IO_REG32_BIT(SCT0_FRACMATREL4,	0x1C018250,__READ_WRITE ,__sct0_fracmatrel_bits);
__IO_REG32_BIT(SCT0_FRACMATREL5,	0x1C018254,__READ_WRITE ,__sct0_fracmatrel_bits);
__IO_REG32_BIT(SCT0_EV0_STATE,		0x1C018300,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV0_CTRL,			0x1C018304,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV1_STATE,		0x1C018308,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV1_CTRL,			0x1C01830C,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV2_STATE,		0x1C018310,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV2_CTRL,			0x1C018314,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV3_STATE,		0x1C018318,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV3_CTRL,			0x1C01831C,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV4_STATE,		0x1C018320,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV4_CTRL,			0x1C018324,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV5_STATE,		0x1C018328,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV5_CTRL,			0x1C01832C,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV6_STATE,		0x1C018330,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV6_CTRL,			0x1C018334,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV7_STATE,		0x1C018338,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV7_CTRL,			0x1C01833C,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV8_STATE,		0x1C018340,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV8_CTRL,			0x1C018344,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV9_STATE,		0x1C018348,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV9_CTRL,			0x1C01834C,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV10_STATE,		0x1C018350,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV10_CTRL,		0x1C018354,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV11_STATE,		0x1C018358,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV11_CTRL,		0x1C01835C,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV12_STATE,		0x1C018360,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV12_CTRL,		0x1C018364,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV13_STATE,		0x1C018368,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV13_CTRL,		0x1C01836C,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV14_STATE,		0x1C018370,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV14_CTRL,		0x1C018374,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_EV15_STATE,		0x1C018378,__READ_WRITE ,__sct0_ev_state_bits);
__IO_REG32_BIT(SCT0_EV15_CTRL,		0x1C01837C,__READ_WRITE ,__sct0_ev_ctrl_bits);
__IO_REG32_BIT(SCT0_OUT0_SET,			0x1C018500,__READ_WRITE ,__sct0_out_set_bits);
__IO_REG32_BIT(SCT0_OUT0_CLR,			0x1C018504,__READ_WRITE ,__sct0_out_clr_bits);
__IO_REG32_BIT(SCT0_OUT1_SET,			0x1C018508,__READ_WRITE ,__sct0_out_set_bits);
__IO_REG32_BIT(SCT0_OUT1_CLR,			0x1C01850C,__READ_WRITE ,__sct0_out_clr_bits);
__IO_REG32_BIT(SCT0_OUT2_SET,			0x1C018510,__READ_WRITE ,__sct0_out_set_bits);
__IO_REG32_BIT(SCT0_OUT2_CLR,			0x1C018514,__READ_WRITE ,__sct0_out_clr_bits);
__IO_REG32_BIT(SCT0_OUT3_SET,			0x1C018518,__READ_WRITE ,__sct0_out_set_bits);
__IO_REG32_BIT(SCT0_OUT3_CLR,			0x1C01851C,__READ_WRITE ,__sct0_out_clr_bits);
__IO_REG32_BIT(SCT0_OUT4_SET,			0x1C018520,__READ_WRITE ,__sct0_out_set_bits);
__IO_REG32_BIT(SCT0_OUT4_CLR,			0x1C018524,__READ_WRITE ,__sct0_out_clr_bits);
__IO_REG32_BIT(SCT0_OUT5_SET,			0x1C018528,__READ_WRITE ,__sct0_out_set_bits);
__IO_REG32_BIT(SCT0_OUT5_CLR,			0x1C01852C,__READ_WRITE ,__sct0_out_clr_bits);
__IO_REG32_BIT(SCT0_OUT6_SET,			0x1C018530,__READ_WRITE ,__sct0_out_set_bits);
__IO_REG32_BIT(SCT0_OUT6_CLR,			0x1C018534,__READ_WRITE ,__sct0_out_clr_bits);
__IO_REG32_BIT(SCT0_OUT7_SET,			0x1C018538,__READ_WRITE ,__sct0_out_set_bits);
__IO_REG32_BIT(SCT0_OUT7_CLR,			0x1C01853C,__READ_WRITE ,__sct0_out_clr_bits);
__IO_REG32_BIT(SCT0_OUT8_SET,			0x1C018540,__READ_WRITE ,__sct0_out_set_bits);
__IO_REG32_BIT(SCT0_OUT8_CLR,			0x1C018544,__READ_WRITE ,__sct0_out_clr_bits);
__IO_REG32_BIT(SCT0_OUT9_SET,			0x1C018548,__READ_WRITE ,__sct0_out_set_bits);
__IO_REG32_BIT(SCT0_OUT9_CLR,			0x1C01854C,__READ_WRITE ,__sct0_out_clr_bits);
#define 			 SCT0_CTRL_L										SCT0_CTRL_bit.__shortl
#define 			 SCT0_CTRL_L_bit								SCT0_CTRL_bit.__shortl_bit
#define 			 SCT0_CTRL_H										SCT0_CTRL_bit.__shorth
#define 			 SCT0_CTRL_H_bit								SCT0_CTRL_bit.__shorth_bit
#define 			 SCT0_LIMIT_L										SCT0_LIMIT_bit.__shortl
#define 			 SCT0_LIMIT_L_bit								SCT0_LIMIT_bit.__shortl_bit
#define 			 SCT0_LIMIT_H										SCT0_LIMIT_bit.__shorth
#define 			 SCT0_LIMIT_H_bit								SCT0_LIMIT_bit.__shorth_bit
#define 			 SCT0_HALT_L										SCT0_HALT_bit.__shortl
#define 			 SCT0_HALT_L_bit								SCT0_HALT_bit.__shortl_bit
#define 			 SCT0_HALT_H										SCT0_HALT_bit.__shorth
#define 			 SCT0_HALT_H_bit								SCT0_HALT_bit.__shorth_bit
#define 			 SCT0_STOP_L										SCT0_STOP_bit.__shortl
#define 			 SCT0_STOP_L_bit								SCT0_STOP_bit.__shortl_bit
#define 			 SCT0_STOP_H										SCT0_STOP_bit.__shorth
#define 			 SCT0_STOP_H_bit								SCT0_STOP_bit.__shorth_bit
#define 			 SCT0_START_L										SCT0_START_bit.__shortl
#define 			 SCT0_START_L_bit								SCT0_START_bit.__shortl_bit
#define 			 SCT0_START_H										SCT0_START_bit.__shorth
#define 			 SCT0_START_H_bit								SCT0_START_bit.__shorth_bit
#define 			 SCT0_DITHER_L									SCT0_DITHER_bit.__shortl
#define 			 SCT0_DITHER_L_bit							SCT0_DITHER_bit.__shortl_bit
#define 			 SCT0_DITHER_H									SCT0_DITHER_bit.__shorth
#define 			 SCT0_DITHER_H_bit							SCT0_DITHER_bit.__shorth_bit
#define 			 SCT0_COUNT_L										SCT0_COUNT_bit.__shortl
#define 			 SCT0_COUNT_H										SCT0_COUNT_bit.__shorth
#define 			 SCT0_STATE_L										SCT0_STATE_bit.__shortl
#define 			 SCT0_STATE_L_bit								SCT0_STATE_bit.__shortl_bit
#define 			 SCT0_STATE_H										SCT0_STATE_bit.__shorth
#define 			 SCT0_STATE_H_bit								SCT0_STATE_bit.__shorth_bit
#define 			 SCT0_REGMODE_L									SCT0_REGMODE_bit.__shortl
#define 			 SCT0_REGMODE_L_bit							SCT0_REGMODE_bit.__shortl_bit
#define 			 SCT0_REGMODE_H									SCT0_REGMODE_bit.__shorth
#define 			 SCT0_REGMODE_H_bit							SCT0_REGMODE_bit.__shorth_bit
#define 			 SCT0_MATCH0_L									SCT0_MATCH0_bit.__shortl_m
#define 			 SCT0_MATCH0_H									SCT0_MATCH0_bit.__shorth_m
#define 			 SCT0_CAP0											SCT0_MATCH0
#define 			 SCT0_CAP0_L										SCT0_MATCH0_bit.__shortl_c
#define 			 SCT0_CAP0_H										SCT0_MATCH0_bit.__shorth_c
#define 			 SCT0_MATCH1_L									SCT0_MATCH1_bit.__shortl_m
#define 			 SCT0_MATCH1_H									SCT0_MATCH1_bit.__shorth_m
#define 			 SCT0_CAP1											SCT0_MATCH1
#define 			 SCT0_CAP1_L										SCT0_MATCH1_bit.__shortl_c
#define 			 SCT0_CAP1_H										SCT0_MATCH1_bit.__shorth_c
#define 			 SCT0_MATCH2_L									SCT0_MATCH2_bit.__shortl_m
#define 			 SCT0_MATCH2_H									SCT0_MATCH2_bit.__shorth_m
#define 			 SCT0_CAP2											SCT0_MATCH2
#define 			 SCT0_CAP2_L										SCT0_MATCH2_bit.__shortl_c
#define 			 SCT0_CAP2_H										SCT0_MATCH2_bit.__shorth_c
#define 			 SCT0_MATCH3_L									SCT0_MATCH3_bit.__shortl_m
#define 			 SCT0_MATCH3_H									SCT0_MATCH3_bit.__shorth_m
#define 			 SCT0_CAP3											SCT0_MATCH3
#define 			 SCT0_CAP3_L										SCT0_MATCH3_bit.__shortl_c
#define 			 SCT0_CAP3_H										SCT0_MATCH3_bit.__shorth_c
#define 			 SCT0_MATCH4_L									SCT0_MATCH4_bit.__shortl_m
#define 			 SCT0_MATCH4_H									SCT0_MATCH4_bit.__shorth_m
#define 			 SCT0_CAP4											SCT0_MATCH4
#define 			 SCT0_CAP4_L										SCT0_MATCH4_bit.__shortl_c
#define 			 SCT0_CAP4_H										SCT0_MATCH4_bit.__shorth_c
#define 			 SCT0_MATCH5_L									SCT0_MATCH5_bit.__shortl_m
#define 			 SCT0_MATCH5_H									SCT0_MATCH5_bit.__shorth_m
#define 			 SCT0_CAP5											SCT0_MATCH5
#define 			 SCT0_CAP5_L										SCT0_MATCH5_bit.__shortl_c
#define 			 SCT0_CAP5_H										SCT0_MATCH5_bit.__shorth_c
#define 			 SCT0_MATCH6_L									SCT0_MATCH6_bit.__shortl_m
#define 			 SCT0_MATCH6_H									SCT0_MATCH6_bit.__shorth_m
#define 			 SCT0_CAP6											SCT0_MATCH6
#define 			 SCT0_CAP6_L										SCT0_MATCH6_bit.__shortl_c
#define 			 SCT0_CAP6_H										SCT0_MATCH6_bit.__shorth_c
#define 			 SCT0_MATCH7_L									SCT0_MATCH7_bit.__shortl_m
#define 			 SCT0_MATCH7_H									SCT0_MATCH7_bit.__shorth_m
#define 			 SCT0_CAP7											SCT0_MATCH7
#define 			 SCT0_CAP7_L										SCT0_MATCH7_bit.__shortl_c
#define 			 SCT0_CAP7_H										SCT0_MATCH7_bit.__shorth_c
#define 			 SCT0_MATCH8_L									SCT0_MATCH8_bit.__shortl_m
#define 			 SCT0_MATCH8_H									SCT0_MATCH8_bit.__shorth_m
#define 			 SCT0_CAP8											SCT0_MATCH8
#define 			 SCT0_CAP8_L										SCT0_MATCH8_bit.__shortl_c
#define 			 SCT0_CAP8_H										SCT0_MATCH8_bit.__shorth_c
#define 			 SCT0_MATCH9_L									SCT0_MATCH9_bit.__shortl_m
#define 			 SCT0_MATCH9_H									SCT0_MATCH9_bit.__shorth_m
#define 			 SCT0_CAP9											SCT0_MATCH9
#define 			 SCT0_CAP9_L										SCT0_MATCH9_bit.__shortl_c
#define 			 SCT0_CAP9_H										SCT0_MATCH9_bit.__shorth_c
#define 			 SCT0_MATCH10_L									SCT0_MATCH10_bit.__shortl_m
#define 			 SCT0_MATCH10_H									SCT0_MATCH10_bit.__shorth_m
#define 			 SCT0_CAP10											SCT0_MATCH10
#define 			 SCT0_CAP10_L										SCT0_MATCH10_bit.__shortl_c
#define 			 SCT0_CAP10_H										SCT0_MATCH10_bit.__shorth_c
#define 			 SCT0_MATCH11_L									SCT0_MATCH11_bit.__shortl_m
#define 			 SCT0_MATCH11_H									SCT0_MATCH11_bit.__shorth_m
#define 			 SCT0_CAP11											SCT0_MATCH11
#define 			 SCT0_CAP11_L										SCT0_MATCH11_bit.__shortl_c
#define 			 SCT0_CAP11_H										SCT0_MATCH11_bit.__shorth_c
#define 			 SCT0_MATCH12_L									SCT0_MATCH12_bit.__shortl_m
#define 			 SCT0_MATCH12_H									SCT0_MATCH12_bit.__shorth_m
#define 			 SCT0_CAP12											SCT0_MATCH12
#define 			 SCT0_CAP12_L										SCT0_MATCH12_bit.__shortl_c
#define 			 SCT0_CAP12_H										SCT0_MATCH12_bit.__shorth_c
#define 			 SCT0_MATCH13_L									SCT0_MATCH13_bit.__shortl_m
#define 			 SCT0_MATCH13_H									SCT0_MATCH13_bit.__shorth_m
#define 			 SCT0_CAP13											SCT0_MATCH13
#define 			 SCT0_CAP13_L										SCT0_MATCH13_bit.__shortl_c
#define 			 SCT0_CAP13_H										SCT0_MATCH13_bit.__shorth_c
#define 			 SCT0_MATCH14_L									SCT0_MATCH14_bit.__shortl_m
#define 			 SCT0_MATCH14_H									SCT0_MATCH14_bit.__shorth_m
#define 			 SCT0_CAP14											SCT0_MATCH14
#define 			 SCT0_CAP14_L										SCT0_MATCH14_bit.__shortl_c
#define 			 SCT0_CAP14_H										SCT0_MATCH14_bit.__shorth_c
#define 			 SCT0_MATCH15_L									SCT0_MATCH15_bit.__shortl_m
#define 			 SCT0_MATCH15_H									SCT0_MATCH15_bit.__shorth_m
#define 			 SCT0_CAP15											SCT0_MATCH15
#define 			 SCT0_CAP15_L										SCT0_MATCH15_bit.__shortl_c
#define 			 SCT0_CAP15_H										SCT0_MATCH15_bit.__shorth_c
#define 			 SCT0_FRACMAT0_L								SCT0_FRACMAT0_bit.__shortl
#define 			 SCT0_FRACMAT0_L_bit						SCT0_FRACMAT0_bit.__shortl_bit
#define 			 SCT0_FRACMAT0_H								SCT0_FRACMAT0_bit.__shorth
#define 			 SCT0_FRACMAT0_H_bit						SCT0_FRACMAT0_bit.__shorth_bit
#define 			 SCT0_FRACMAT1_L								SCT0_FRACMAT1_bit.__shortl
#define 			 SCT0_FRACMAT1_L_bit						SCT0_FRACMAT1_bit.__shortl_bit
#define 			 SCT0_FRACMAT1_H								SCT0_FRACMAT1_bit.__shorth
#define 			 SCT0_FRACMAT1_H_bit						SCT0_FRACMAT1_bit.__shorth_bit
#define 			 SCT0_FRACMAT2_L								SCT0_FRACMAT2_bit.__shortl
#define 			 SCT0_FRACMAT2_L_bit						SCT0_FRACMAT2_bit.__shortl_bit
#define 			 SCT0_FRACMAT2_H								SCT0_FRACMAT2_bit.__shorth
#define 			 SCT0_FRACMAT2_H_bit						SCT0_FRACMAT2_bit.__shorth_bit
#define 			 SCT0_FRACMAT3_L								SCT0_FRACMAT3_bit.__shortl
#define 			 SCT0_FRACMAT3_L_bit						SCT0_FRACMAT3_bit.__shortl_bit
#define 			 SCT0_FRACMAT3_H								SCT0_FRACMAT3_bit.__shorth
#define 			 SCT0_FRACMAT3_H_bit						SCT0_FRACMAT3_bit.__shorth_bit
#define 			 SCT0_FRACMAT4_L								SCT0_FRACMAT4_bit.__shortl
#define 			 SCT0_FRACMAT4_L_bit						SCT0_FRACMAT4_bit.__shortl_bit
#define 			 SCT0_FRACMAT4_H								SCT0_FRACMAT4_bit.__shorth
#define 			 SCT0_FRACMAT4_H_bit						SCT0_FRACMAT4_bit.__shorth_bit
#define 			 SCT0_FRACMAT5_L								SCT0_FRACMAT5_bit.__shortl
#define 			 SCT0_FRACMAT5_L_bit						SCT0_FRACMAT5_bit.__shortl_bit
#define 			 SCT0_FRACMAT5_H								SCT0_FRACMAT5_bit.__shorth
#define 			 SCT0_FRACMAT5_H_bit						SCT0_FRACMAT5_bit.__shorth_bit
#define 			 SCT0_MATCHREL0_L								SCT0_MATCHREL0_bit.__shortl_m
#define 			 SCT0_MATCHREL0_H								SCT0_MATCHREL0_bit.__shorth_m
#define 			 SCT0_CAPCTRL0									SCT0_MATCHREL0
#define 			 SCT0_CAPCTRL0_L								SCT0_MATCHREL0_bit.__shortl_c
#define 			 SCT0_CAPCTRL0_L_bit						SCT0_MATCHREL0_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL0_H								SCT0_MATCHREL0_bit.__shorth_c
#define 			 SCT0_CAPCTRL0_H_bit						SCT0_MATCHREL0_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL1_L								SCT0_MATCHREL1_bit.__shortl_m
#define 			 SCT0_MATCHREL1_H								SCT0_MATCHREL1_bit.__shorth_m
#define 			 SCT0_CAPCTRL1									SCT0_MATCHREL1
#define 			 SCT0_CAPCTRL1_L								SCT0_MATCHREL1_bit.__shortl_c
#define 			 SCT0_CAPCTRL1_L_bit						SCT0_MATCHREL1_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL1_H								SCT0_MATCHREL1_bit.__shorth_c
#define 			 SCT0_CAPCTRL1_H_bit						SCT0_MATCHREL1_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL2_L								SCT0_MATCHREL2_bit.__shortl_m
#define 			 SCT0_MATCHREL2_H								SCT0_MATCHREL2_bit.__shorth_m
#define 			 SCT0_CAPCTRL2									SCT0_MATCHREL2
#define 			 SCT0_CAPCTRL2_L								SCT0_MATCHREL2_bit.__shortl_c
#define 			 SCT0_CAPCTRL2_L_bit						SCT0_MATCHREL2_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL2_H								SCT0_MATCHREL2_bit.__shorth_c
#define 			 SCT0_CAPCTRL2_H_bit						SCT0_MATCHREL2_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL3_L								SCT0_MATCHREL3_bit.__shortl_m
#define 			 SCT0_MATCHREL3_H								SCT0_MATCHREL3_bit.__shorth_m
#define 			 SCT0_CAPCTRL3									SCT0_MATCHREL3
#define 			 SCT0_CAPCTRL3_L								SCT0_MATCHREL3_bit.__shortl_c
#define 			 SCT0_CAPCTRL3_L_bit						SCT0_MATCHREL3_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL3_H								SCT0_MATCHREL3_bit.__shorth_c
#define 			 SCT0_CAPCTRL3_H_bit						SCT0_MATCHREL3_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL4_L								SCT0_MATCHREL4_bit.__shortl_m
#define 			 SCT0_MATCHREL4_H								SCT0_MATCHREL4_bit.__shorth_m
#define 			 SCT0_CAPCTRL4									SCT0_MATCHREL4
#define 			 SCT0_CAPCTRL4_L								SCT0_MATCHREL4_bit.__shortl_c
#define 			 SCT0_CAPCTRL4_L_bit						SCT0_MATCHREL4_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL4_H								SCT0_MATCHREL4_bit.__shorth_c
#define 			 SCT0_CAPCTRL4_H_bit						SCT0_MATCHREL4_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL5_L								SCT0_MATCHREL5_bit.__shortl_m
#define 			 SCT0_MATCHREL5_H								SCT0_MATCHREL5_bit.__shorth_m
#define 			 SCT0_CAPCTRL5									SCT0_MATCHREL5
#define 			 SCT0_CAPCTRL5_L								SCT0_MATCHREL5_bit.__shortl_c
#define 			 SCT0_CAPCTRL5_L_bit						SCT0_MATCHREL5_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL5_H								SCT0_MATCHREL5_bit.__shorth_c
#define 			 SCT0_CAPCTRL5_H_bit						SCT0_MATCHREL5_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL6_L								SCT0_MATCHREL6_bit.__shortl_m
#define 			 SCT0_MATCHREL6_H								SCT0_MATCHREL6_bit.__shorth_m
#define 			 SCT0_CAPCTRL6									SCT0_MATCHREL6
#define 			 SCT0_CAPCTRL6_L								SCT0_MATCHREL6_bit.__shortl_c
#define 			 SCT0_CAPCTRL6_L_bit						SCT0_MATCHREL6_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL6_H								SCT0_MATCHREL6_bit.__shorth_c
#define 			 SCT0_CAPCTRL6_H_bit						SCT0_MATCHREL6_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL7_L								SCT0_MATCHREL7_bit.__shortl_m
#define 			 SCT0_MATCHREL7_H								SCT0_MATCHREL7_bit.__shorth_m
#define 			 SCT0_CAPCTRL7									SCT0_MATCHREL7
#define 			 SCT0_CAPCTRL7_L								SCT0_MATCHREL7_bit.__shortl_c
#define 			 SCT0_CAPCTRL7_L_bit						SCT0_MATCHREL7_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL7_H								SCT0_MATCHREL7_bit.__shorth_c
#define 			 SCT0_CAPCTRL7_H_bit						SCT0_MATCHREL7_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL8_L								SCT0_MATCHREL8_bit.__shortl_m
#define 			 SCT0_MATCHREL8_H								SCT0_MATCHREL8_bit.__shorth_m
#define 			 SCT0_CAPCTRL8									SCT0_MATCHREL8
#define 			 SCT0_CAPCTRL8_L								SCT0_MATCHREL8_bit.__shortl_c
#define 			 SCT0_CAPCTRL8_L_bit						SCT0_MATCHREL8_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL8_H								SCT0_MATCHREL8_bit.__shorth_c
#define 			 SCT0_CAPCTRL8_H_bit						SCT0_MATCHREL8_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL9_L								SCT0_MATCHREL9_bit.__shortl_m
#define 			 SCT0_MATCHREL9_H								SCT0_MATCHREL9_bit.__shorth_m
#define 			 SCT0_CAPCTRL9									SCT0_MATCHREL9
#define 			 SCT0_CAPCTRL9_L								SCT0_MATCHREL9_bit.__shortl_c
#define 			 SCT0_CAPCTRL9_L_bit						SCT0_MATCHREL9_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL9_H								SCT0_MATCHREL9_bit.__shorth_c
#define 			 SCT0_CAPCTRL9_H_bit						SCT0_MATCHREL9_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL10_L							SCT0_MATCHREL10_bit.__shortl_m
#define 			 SCT0_MATCHREL10_H							SCT0_MATCHREL10_bit.__shorth_m
#define 			 SCT0_CAPCTRL10									SCT0_MATCHREL10
#define 			 SCT0_CAPCTRL10_L								SCT0_MATCHREL10_bit.__shortl_c
#define 			 SCT0_CAPCTRL10_L_bit						SCT0_MATCHREL10_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL10_H								SCT0_MATCHREL10_bit.__shorth_c
#define 			 SCT0_CAPCTRL10_H_bit						SCT0_MATCHREL10_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL11_L							SCT0_MATCHREL11_bit.__shortl_m
#define 			 SCT0_MATCHREL11_H							SCT0_MATCHREL11_bit.__shorth_m
#define 			 SCT0_CAPCTRL11									SCT0_MATCHREL11
#define 			 SCT0_CAPCTRL11_L								SCT0_MATCHREL11_bit.__shortl_c
#define 			 SCT0_CAPCTRL11_L_bit						SCT0_MATCHREL11_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL11_H								SCT0_MATCHREL11_bit.__shorth_c
#define 			 SCT0_CAPCTRL11_H_bit						SCT0_MATCHREL11_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL12_L							SCT0_MATCHREL12_bit.__shortl_m
#define 			 SCT0_MATCHREL12_H							SCT0_MATCHREL12_bit.__shorth_m
#define 			 SCT0_CAPCTRL12									SCT0_MATCHREL12
#define 			 SCT0_CAPCTRL12_L								SCT0_MATCHREL12_bit.__shortl_c
#define 			 SCT0_CAPCTRL12_L_bit						SCT0_MATCHREL12_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL12_H								SCT0_MATCHREL12_bit.__shorth_c
#define 			 SCT0_CAPCTRL12_H_bit						SCT0_MATCHREL12_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL13_L							SCT0_MATCHREL13_bit.__shortl_m
#define 			 SCT0_MATCHREL13_H							SCT0_MATCHREL13_bit.__shorth_m
#define 			 SCT0_CAPCTRL13									SCT0_MATCHREL13
#define 			 SCT0_CAPCTRL13_L								SCT0_MATCHREL13_bit.__shortl_c
#define 			 SCT0_CAPCTRL13_L_bit						SCT0_MATCHREL13_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL13_H								SCT0_MATCHREL13_bit.__shorth_c
#define 			 SCT0_CAPCTRL13_H_bit						SCT0_MATCHREL13_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL14_L							SCT0_MATCHREL14_bit.__shortl_m
#define 			 SCT0_MATCHREL14_H							SCT0_MATCHREL14_bit.__shorth_m
#define 			 SCT0_CAPCTRL14									SCT0_MATCHREL14
#define 			 SCT0_CAPCTRL14_L								SCT0_MATCHREL14_bit.__shortl_c
#define 			 SCT0_CAPCTRL14_L_bit						SCT0_MATCHREL14_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL14_H								SCT0_MATCHREL14_bit.__shorth_c
#define 			 SCT0_CAPCTRL14_H_bit						SCT0_MATCHREL14_bit.__shorth_c_bit
#define 			 SCT0_MATCHREL15_L							SCT0_MATCHREL15_bit.__shortl_m
#define 			 SCT0_MATCHREL15_H							SCT0_MATCHREL15_bit.__shorth_m
#define 			 SCT0_CAPCTRL15									SCT0_MATCHREL15
#define 			 SCT0_CAPCTRL15_L								SCT0_MATCHREL15_bit.__shortl_c
#define 			 SCT0_CAPCTRL15_L_bit						SCT0_MATCHREL15_bit.__shortl_c_bit
#define 			 SCT0_CAPCTRL15_H								SCT0_MATCHREL15_bit.__shorth_c
#define 			 SCT0_CAPCTRL15_H_bit						SCT0_MATCHREL15_bit.__shorth_c_bit
#define 			 SCT0_FRACMATREL0_L							SCT0_FRACMATREL0_bit.__shortl
#define 			 SCT0_FRACMATREL0_L_bit					SCT0_FRACMATREL0_bit.__shortl_bit
#define 			 SCT0_FRACMATREL0_H							SCT0_FRACMATREL0_bit.__shorth
#define 			 SCT0_FRACMATREL0_H_bit					SCT0_FRACMATREL0_bit.__shorth_bit
#define 			 SCT0_FRACMATREL1_L							SCT0_FRACMATREL1_bit.__shortl
#define 			 SCT0_FRACMATREL1_L_bit					SCT0_FRACMATREL1_bit.__shortl_bit
#define 			 SCT0_FRACMATREL1_H							SCT0_FRACMATREL1_bit.__shorth
#define 			 SCT0_FRACMATREL1_H_bit					SCT0_FRACMATREL1_bit.__shorth_bit
#define 			 SCT0_FRACMATREL2_L							SCT0_FRACMATREL2_bit.__shortl
#define 			 SCT0_FRACMATREL2_L_bit					SCT0_FRACMATREL2_bit.__shortl_bit
#define 			 SCT0_FRACMATREL2_H							SCT0_FRACMATREL2_bit.__shorth
#define 			 SCT0_FRACMATREL2_H_bit					SCT0_FRACMATREL2_bit.__shorth_bit
#define 			 SCT0_FRACMATREL3_L							SCT0_FRACMATREL3_bit.__shortl
#define 			 SCT0_FRACMATREL3_L_bit					SCT0_FRACMATREL3_bit.__shortl_bit
#define 			 SCT0_FRACMATREL3_H							SCT0_FRACMATREL3_bit.__shorth
#define 			 SCT0_FRACMATREL3_H_bit					SCT0_FRACMATREL3_bit.__shorth_bit
#define 			 SCT0_FRACMATREL4_L							SCT0_FRACMATREL4_bit.__shortl
#define 			 SCT0_FRACMATREL4_L_bit					SCT0_FRACMATREL4_bit.__shortl_bit
#define 			 SCT0_FRACMATREL4_H							SCT0_FRACMATREL4_bit.__shorth
#define 			 SCT0_FRACMATREL4_H_bit					SCT0_FRACMATREL4_bit.__shorth_bit
#define 			 SCT0_FRACMATREL5_L							SCT0_FRACMATREL5_bit.__shortl
#define 			 SCT0_FRACMATREL5_L_bit					SCT0_FRACMATREL5_bit.__shortl_bit
#define 			 SCT0_FRACMATREL5_H							SCT0_FRACMATREL5_bit.__shorth
#define 			 SCT0_FRACMATREL5_H_bit					SCT0_FRACMATREL5_bit.__shorth_bit

/***************************************************************************
 **
 ** SCT2
 **
 ***************************************************************************/
__IO_REG32_BIT(SCT2_CONFIG,				0x1C020000,__READ_WRITE ,__sct0_config_bits);
__IO_REG32_BIT(SCT2_CTRL,					0x1C020004,__READ_WRITE ,__sct0_ctrl_bits);
__IO_REG32_BIT(SCT2_LIMIT,				0x1C020008,__READ_WRITE ,__sct0_limit_bits);
__IO_REG32_BIT(SCT2_HALT,					0x1C02000C,__READ_WRITE ,__sct0_halt_bits);
__IO_REG32_BIT(SCT2_STOP,					0x1C020010,__READ_WRITE ,__sct0_stop_bits);
__IO_REG32_BIT(SCT2_START,				0x1C020014,__READ_WRITE ,__sct0_start_bits);
__IO_REG32_BIT(SCT2_COUNT,				0x1C020040,__READ_WRITE ,__sct0_count_bits);
__IO_REG32_BIT(SCT2_STATE,				0x1C020044,__READ_WRITE ,__sct0_state_bits);
__IO_REG32_BIT(SCT2_INPUT,				0x1C020048,__READ				,__sct2_input_bits);
__IO_REG32_BIT(SCT2_REGMODE,			0x1C02004C,__READ_WRITE ,__sct0_regmode_bits);
__IO_REG32_BIT(SCT2_OUTPUT,				0x1C020050,__READ_WRITE ,__sct2_output_bits);
__IO_REG32_BIT(SCT2_OUTPUTDIRCTRL,0x1C020054,__READ_WRITE ,__sct2_outputdirctrl_bits);
__IO_REG32_BIT(SCT2_RES,					0x1C020058,__READ_WRITE ,__sct2_res_bits);
__IO_REG32_BIT(SCT2_DMAREQ0,			0x1C02005C,__READ_WRITE ,__sct0_dmareq0_bits);
__IO_REG32_BIT(SCT2_DMAREQ1,			0x1C020060,__READ_WRITE ,__sct0_dmareq1_bits);
__IO_REG32_BIT(SCT2_EVEN,					0x1C0200F0,__READ_WRITE ,__sct0_even_bits);
__IO_REG32_BIT(SCT2_EVFLAG,				0x1C0200F4,__READ_WRITE ,__sct0_evflag_bits);
__IO_REG32_BIT(SCT2_CONEN,				0x1C0200F8,__READ_WRITE ,__sct2_conen_bits);
__IO_REG32_BIT(SCT2_CONFLAG,			0x1C0200FC,__READ_WRITE ,__sct2_conflag_bits);
__IO_REG32_BIT(SCT2_MATCH0,				0x1C020100,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT2_MATCH1,				0x1C020104,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT2_MATCH2,				0x1C020108,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT2_MATCH3,				0x1C02010C,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT2_MATCH4,				0x1C020110,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT2_MATCH5,				0x1C020114,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT2_MATCH6,				0x1C020118,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT2_MATCH7,				0x1C02011C,__READ_WRITE ,__sct0_match_bits);
__IO_REG32_BIT(SCT2_MATCHREL0,		0x1C020200,__READ_WRITE ,__sct2_matchrel_bits);
__IO_REG32_BIT(SCT2_MATCHREL1,		0x1C020204,__READ_WRITE ,__sct2_matchrel_bits);
__IO_REG32_BIT(SCT2_MATCHREL2,		0x1C020208,__READ_WRITE ,__sct2_matchrel_bits);
__IO_REG32_BIT(SCT2_MATCHREL3,		0x1C02020C,__READ_WRITE ,__sct2_matchrel_bits);
__IO_REG32_BIT(SCT2_MATCHREL4,		0x1C020210,__READ_WRITE ,__sct2_matchrel_bits);
__IO_REG32_BIT(SCT2_MATCHREL5,		0x1C020214,__READ_WRITE ,__sct2_matchrel_bits);
__IO_REG32_BIT(SCT2_MATCHREL6,		0x1C020218,__READ_WRITE ,__sct2_matchrel_bits);
__IO_REG32_BIT(SCT2_MATCHREL7,		0x1C02021C,__READ_WRITE ,__sct2_matchrel_bits);
__IO_REG32_BIT(SCT2_EV0_STATE,		0x1C020300,__READ_WRITE ,__sct2_ev_state_bits);
__IO_REG32_BIT(SCT2_EV0_CTRL,			0x1C020304,__READ_WRITE ,__sct2_ev_ctrl_bits);
__IO_REG32_BIT(SCT2_EV1_STATE,		0x1C020308,__READ_WRITE ,__sct2_ev_state_bits);
__IO_REG32_BIT(SCT2_EV1_CTRL,			0x1C02030C,__READ_WRITE ,__sct2_ev_ctrl_bits);
__IO_REG32_BIT(SCT2_EV2_STATE,		0x1C020310,__READ_WRITE ,__sct2_ev_state_bits);
__IO_REG32_BIT(SCT2_EV2_CTRL,			0x1C020314,__READ_WRITE ,__sct2_ev_ctrl_bits);
__IO_REG32_BIT(SCT2_EV3_STATE,		0x1C020318,__READ_WRITE ,__sct2_ev_state_bits);
__IO_REG32_BIT(SCT2_EV3_CTRL,			0x1C02031C,__READ_WRITE ,__sct2_ev_ctrl_bits);
__IO_REG32_BIT(SCT2_EV4_STATE,		0x1C020320,__READ_WRITE ,__sct2_ev_state_bits);
__IO_REG32_BIT(SCT2_EV4_CTRL,			0x1C020324,__READ_WRITE ,__sct2_ev_ctrl_bits);
__IO_REG32_BIT(SCT2_EV5_STATE,		0x1C020328,__READ_WRITE ,__sct2_ev_state_bits);
__IO_REG32_BIT(SCT2_EV5_CTRL,			0x1C02032C,__READ_WRITE ,__sct2_ev_ctrl_bits);
__IO_REG32_BIT(SCT2_EV6_STATE,		0x1C020330,__READ_WRITE ,__sct2_ev_state_bits);
__IO_REG32_BIT(SCT2_EV6_CTRL,			0x1C020334,__READ_WRITE ,__sct2_ev_ctrl_bits);
__IO_REG32_BIT(SCT2_EV7_STATE,		0x1C020338,__READ_WRITE ,__sct2_ev_state_bits);
__IO_REG32_BIT(SCT2_EV7_CTRL,			0x1C02033C,__READ_WRITE ,__sct2_ev_ctrl_bits);
__IO_REG32_BIT(SCT2_EV8_STATE,		0x1C020340,__READ_WRITE ,__sct2_ev_state_bits);
__IO_REG32_BIT(SCT2_EV8_CTRL,			0x1C020344,__READ_WRITE ,__sct2_ev_ctrl_bits);
__IO_REG32_BIT(SCT2_EV9_STATE,		0x1C020348,__READ_WRITE ,__sct2_ev_state_bits);
__IO_REG32_BIT(SCT2_EV9_CTRL,			0x1C02034C,__READ_WRITE ,__sct2_ev_ctrl_bits);
__IO_REG32_BIT(SCT2_OUT0_SET,			0x1C020500,__READ_WRITE ,__sct2_out_set_bits);
__IO_REG32_BIT(SCT2_OUT0_CLR,			0x1C020504,__READ_WRITE ,__sct2_out_clr_bits);
__IO_REG32_BIT(SCT2_OUT1_SET,			0x1C020508,__READ_WRITE ,__sct2_out_set_bits);
__IO_REG32_BIT(SCT2_OUT1_CLR,			0x1C02050C,__READ_WRITE ,__sct2_out_clr_bits);
__IO_REG32_BIT(SCT2_OUT2_SET,			0x1C020510,__READ_WRITE ,__sct2_out_set_bits);
__IO_REG32_BIT(SCT2_OUT2_CLR,			0x1C020514,__READ_WRITE ,__sct2_out_clr_bits);
__IO_REG32_BIT(SCT2_OUT3_SET,			0x1C020518,__READ_WRITE ,__sct2_out_set_bits);
__IO_REG32_BIT(SCT2_OUT3_CLR,			0x1C02051C,__READ_WRITE ,__sct2_out_clr_bits);
__IO_REG32_BIT(SCT2_OUT4_SET,			0x1C020520,__READ_WRITE ,__sct2_out_set_bits);
__IO_REG32_BIT(SCT2_OUT4_CLR,			0x1C020524,__READ_WRITE ,__sct2_out_clr_bits);
__IO_REG32_BIT(SCT2_OUT5_SET,			0x1C020528,__READ_WRITE ,__sct2_out_set_bits);
__IO_REG32_BIT(SCT2_OUT5_CLR,			0x1C02052C,__READ_WRITE ,__sct2_out_clr_bits);
#define 			 SCT2_CTRL_L										SCT2_CTRL_bit.__shortl
#define 			 SCT2_CTRL_L_bit								SCT2_CTRL_bit.__shortl_bit
#define 			 SCT2_CTRL_H										SCT2_CTRL_bit.__shorth
#define 			 SCT2_CTRL_H_bit								SCT2_CTRL_bit.__shorth_bit
#define 			 SCT2_LIMIT_L										SCT2_LIMIT_bit.__shortl
#define 			 SCT2_LIMIT_L_bit								SCT2_LIMIT_bit.__shortl_bit
#define 			 SCT2_LIMIT_H										SCT2_LIMIT_bit.__shorth
#define 			 SCT2_LIMIT_H_bit								SCT2_LIMIT_bit.__shorth_bit
#define 			 SCT2_HALT_L										SCT2_HALT_bit.__shortl
#define 			 SCT2_HALT_L_bit								SCT2_HALT_bit.__shortl_bit
#define 			 SCT2_HALT_H										SCT2_HALT_bit.__shorth
#define 			 SCT2_HALT_H_bit								SCT2_HALT_bit.__shorth_bit
#define 			 SCT2_STOP_L										SCT2_STOP_bit.__shortl
#define 			 SCT2_STOP_L_bit								SCT2_STOP_bit.__shortl_bit
#define 			 SCT2_STOP_H										SCT2_STOP_bit.__shorth
#define 			 SCT2_STOP_H_bit								SCT2_STOP_bit.__shorth_bit
#define 			 SCT2_START_L										SCT2_START_bit.__shortl
#define 			 SCT2_START_L_bit								SCT2_START_bit.__shortl_bit
#define 			 SCT2_START_H										SCT2_START_bit.__shorth
#define 			 SCT2_START_H_bit								SCT2_START_bit.__shorth_bit
#define 			 SCT2_COUNT_L										SCT2_COUNT_bit.__shortl
#define 			 SCT2_COUNT_H										SCT2_COUNT_bit.__shorth
#define 			 SCT2_STATE_L										SCT2_STATE_bit.__shortl
#define 			 SCT2_STATE_L_bit								SCT2_STATE_bit.__shortl_bit
#define 			 SCT2_STATE_H										SCT2_STATE_bit.__shorth
#define 			 SCT2_STATE_H_bit								SCT2_STATE_bit.__shorth_bit
#define 			 SCT2_REGMODE_L									SCT2_REGMODE_bit.__shortl
#define 			 SCT2_REGMODE_L_bit							SCT2_REGMODE_bit.__shortl_bit
#define 			 SCT2_REGMODE_H									SCT2_REGMODE_bit.__shorth
#define 			 SCT2_REGMODE_H_bit							SCT2_REGMODE_bit.__shorth_bit
#define 			 SCT2_MATCH0_L									SCT2_MATCH0_bit.__shortl_m
#define 			 SCT2_MATCH0_H									SCT2_MATCH0_bit.__shorth_m
#define 			 SCT2_CAP0											SCT2_MATCH0
#define 			 SCT2_CAP0_L										SCT2_MATCH0_bit.__shortl_c
#define 			 SCT2_CAP0_H										SCT2_MATCH0_bit.__shorth_c
#define 			 SCT2_MATCH1_L									SCT2_MATCH1_bit.__shortl_m
#define 			 SCT2_MATCH1_H									SCT2_MATCH1_bit.__shorth_m
#define 			 SCT2_CAP1											SCT2_MATCH1
#define 			 SCT2_CAP1_L										SCT2_MATCH1_bit.__shortl_c
#define 			 SCT2_CAP1_H										SCT2_MATCH1_bit.__shorth_c
#define 			 SCT2_MATCH2_L									SCT2_MATCH2_bit.__shortl_m
#define 			 SCT2_MATCH2_H									SCT2_MATCH2_bit.__shorth_m
#define 			 SCT2_CAP2											SCT2_MATCH2
#define 			 SCT2_CAP2_L										SCT2_MATCH2_bit.__shortl_c
#define 			 SCT2_CAP2_H										SCT2_MATCH2_bit.__shorth_c
#define 			 SCT2_MATCH3_L									SCT2_MATCH3_bit.__shortl_m
#define 			 SCT2_MATCH3_H									SCT2_MATCH3_bit.__shorth_m
#define 			 SCT2_CAP3											SCT2_MATCH3
#define 			 SCT2_CAP3_L										SCT2_MATCH3_bit.__shortl_c
#define 			 SCT2_CAP3_H										SCT2_MATCH3_bit.__shorth_c
#define 			 SCT2_MATCH4_L									SCT2_MATCH4_bit.__shortl_m
#define 			 SCT2_MATCH4_H									SCT2_MATCH4_bit.__shorth_m
#define 			 SCT2_CAP4											SCT2_MATCH4
#define 			 SCT2_CAP4_L										SCT2_MATCH4_bit.__shortl_c
#define 			 SCT2_CAP4_H										SCT2_MATCH4_bit.__shorth_c
#define 			 SCT2_MATCH5_L									SCT2_MATCH5_bit.__shortl_m
#define 			 SCT2_MATCH5_H									SCT2_MATCH5_bit.__shorth_m
#define 			 SCT2_CAP5											SCT2_MATCH5
#define 			 SCT2_CAP5_L										SCT2_MATCH5_bit.__shortl_c
#define 			 SCT2_CAP5_H										SCT2_MATCH5_bit.__shorth_c
#define 			 SCT2_MATCH6_L									SCT2_MATCH6_bit.__shortl_m
#define 			 SCT2_MATCH6_H									SCT2_MATCH6_bit.__shorth_m
#define 			 SCT2_CAP6											SCT2_MATCH6
#define 			 SCT2_CAP6_L										SCT2_MATCH6_bit.__shortl_c
#define 			 SCT2_CAP6_H										SCT2_MATCH6_bit.__shorth_c
#define 			 SCT2_MATCH7_L									SCT2_MATCH7_bit.__shortl_m
#define 			 SCT2_MATCH7_H									SCT2_MATCH7_bit.__shorth_m
#define 			 SCT2_CAP7											SCT2_MATCH7
#define 			 SCT2_CAP7_L										SCT2_MATCH7_bit.__shortl_c
#define 			 SCT2_CAP7_H										SCT2_MATCH7_bit.__shorth_c
#define 			 SCT2_MATCHREL0_L								SCT2_FRACMAT0_bit.__shortl_m
#define 			 SCT2_MATCHREL0_H								SCT2_FRACMAT0_bit.__shorth_m
#define 			 SCT2_CAPCTRL0									SCT2_FRACMAT0
#define 			 SCT2_CAPCTRL0_L								SCT2_FRACMAT0_bit.__shortl_c
#define 			 SCT2_CAPCTRL0_L_bit						SCT2_FRACMAT0_bit.__shortl_c_bit
#define 			 SCT2_CAPCTRL0_H								SCT2_FRACMAT0_bit.__shorth_c
#define 			 SCT2_CAPCTRL0_H_bit						SCT2_FRACMAT0_bit.__shorth_c_bit
#define 			 SCT2_MATCHREL1_L								SCT2_FRACMAT1_bit.__shortl_m
#define 			 SCT2_MATCHREL1_H								SCT2_FRACMAT1_bit.__shorth_m
#define 			 SCT2_CAPCTRL1									SCT2_FRACMAT1
#define 			 SCT2_CAPCTRL1_L								SCT2_FRACMAT1_bit.__shortl_c
#define 			 SCT2_CAPCTRL1_L_bit						SCT2_FRACMAT1_bit.__shortl_c_bit
#define 			 SCT2_CAPCTRL1_H								SCT2_FRACMAT1_bit.__shorth_c
#define 			 SCT2_CAPCTRL1_H_bit						SCT2_FRACMAT1_bit.__shorth_c_bit
#define 			 SCT2_MATCHREL2_L								SCT2_FRACMAT2_bit.__shortl_m
#define 			 SCT2_MATCHREL2_H								SCT2_FRACMAT2_bit.__shorth_m
#define 			 SCT2_CAPCTRL2									SCT2_FRACMAT2
#define 			 SCT2_CAPCTRL2_L								SCT2_FRACMAT2_bit.__shortl_c
#define 			 SCT2_CAPCTRL2_L_bit						SCT2_FRACMAT2_bit.__shortl_c_bit
#define 			 SCT2_CAPCTRL2_H								SCT2_FRACMAT2_bit.__shorth_c
#define 			 SCT2_CAPCTRL2_H_bit						SCT2_FRACMAT2_bit.__shorth_c_bit
#define 			 SCT2_MATCHREL3_L								SCT2_FRACMAT3_bit.__shortl_m
#define 			 SCT2_MATCHREL3_H								SCT2_FRACMAT3_bit.__shorth_m
#define 			 SCT2_CAPCTRL3									SCT2_FRACMAT3
#define 			 SCT2_CAPCTRL3_L								SCT2_FRACMAT3_bit.__shortl_c
#define 			 SCT2_CAPCTRL3_L_bit						SCT2_FRACMAT3_bit.__shortl_c_bit
#define 			 SCT2_CAPCTRL3_H								SCT2_FRACMAT3_bit.__shorth_c
#define 			 SCT2_CAPCTRL3_H_bit						SCT2_FRACMAT3_bit.__shorth_c_bit
#define 			 SCT2_MATCHREL4_L								SCT2_FRACMAT4_bit.__shortl_m
#define 			 SCT2_MATCHREL4_H								SCT2_FRACMAT4_bit.__shorth_m
#define 			 SCT2_CAPCTRL4									SCT2_FRACMAT4
#define 			 SCT2_CAPCTRL4_L								SCT2_FRACMAT4_bit.__shortl_c
#define 			 SCT2_CAPCTRL4_L_bit						SCT2_FRACMAT4_bit.__shortl_c_bit
#define 			 SCT2_CAPCTRL4_H								SCT2_FRACMAT4_bit.__shorth_c
#define 			 SCT2_CAPCTRL4_H_bit						SCT2_FRACMAT4_bit.__shorth_c_bit
#define 			 SCT2_MATCHREL5_L								SCT2_FRACMAT5_bit.__shortl_m
#define 			 SCT2_MATCHREL5_H								SCT2_FRACMAT5_bit.__shorth_m
#define 			 SCT2_CAPCTRL5									SCT2_FRACMAT5
#define 			 SCT2_CAPCTRL5_L								SCT2_FRACMAT5_bit.__shortl_c
#define 			 SCT2_CAPCTRL5_L_bit						SCT2_FRACMAT5_bit.__shortl_c_bit
#define 			 SCT2_CAPCTRL5_H								SCT2_FRACMAT5_bit.__shorth_c
#define 			 SCT2_CAPCTRL5_H_bit						SCT2_FRACMAT5_bit.__shorth_c_bit
#define 			 SCT2_MATCHREL6_L								SCT2_FRACMAT6_bit.__shortl_m
#define 			 SCT2_MATCHREL6_H								SCT2_FRACMAT6_bit.__shorth_m
#define 			 SCT2_CAPCTRL6									SCT2_FRACMAT6
#define 			 SCT2_CAPCTRL6_L								SCT2_FRACMAT6_bit.__shortl_c
#define 			 SCT2_CAPCTRL6_L_bit						SCT2_FRACMAT6_bit.__shortl_c_bit
#define 			 SCT2_CAPCTRL6_H								SCT2_FRACMAT6_bit.__shorth_c
#define 			 SCT2_CAPCTRL6_H_bit						SCT2_FRACMAT6_bit.__shorth_c_bit
#define 			 SCT2_MATCHREL7_L								SCT2_FRACMAT7_bit.__shortl_m
#define 			 SCT2_MATCHREL7_H								SCT2_FRACMAT7_bit.__shorth_m
#define 			 SCT2_CAPCTRL7									SCT2_FRACMAT7
#define 			 SCT2_CAPCTRL7_L								SCT2_FRACMAT7_bit.__shortl_c
#define 			 SCT2_CAPCTRL7_L_bit						SCT2_FRACMAT7_bit.__shortl_c_bit
#define 			 SCT2_CAPCTRL7_H								SCT2_FRACMAT7_bit.__shorth_c
#define 			 SCT2_CAPCTRL7_H_bit						SCT2_FRACMAT7_bit.__shorth_c_bit

/***************************************************************************
 **
 ** Watchdog
 **
 ***************************************************************************/
__IO_REG32_BIT(WDMOD,                 0x4002C000,__READ_WRITE ,__wdmod_bits);
__IO_REG32_BIT(WDTC,                  0x4002C004,__READ_WRITE ,__wdtc_bits);
__IO_REG32(		 WDFEED,                0x4002C008,__WRITE      );
__IO_REG32_BIT(WDTV,                  0x4002C00C,__READ       ,__wdtc_bits);
__IO_REG32_BIT(WDWARNINT,             0x4002C014,__READ_WRITE ,__wdwarnint_bits);
__IO_REG32_BIT(WDWINDOW,              0x4002C018,__READ_WRITE ,__wdwindow_bits);

/***************************************************************************
 **
 ** RTC (Real-Time Clock)
 **
 ***************************************************************************/
__IO_REG32_BIT(RTC_CTRL,              0x40028000,__READ_WRITE ,__rtc_ctrl_bits);
__IO_REG32(		 RTC_MATCH,             0x40028004,__READ_WRITE );
__IO_REG32(		 RTC_COUNT,             0x40028008,__READ_WRITE );
__IO_REG32_BIT(RTC_WAKE,              0x4002800C,__READ_WRITE ,__rtc_wake_bits);

/***************************************************************************
 **
 ** MRT (Multi-Rate Timer)
 **
 ***************************************************************************/
__IO_REG32_BIT(MRT_INTVAL0,           0x400A0000,__READ_WRITE ,__mrt_intval_bits);
__IO_REG32_BIT(MRT_TIMER0,           	0x400A0004,__READ				,__mrt_timer_bits);
__IO_REG32_BIT(MRT_CTRL0,           	0x400A0008,__READ_WRITE ,__mrt_ctrl_bits);
__IO_REG32_BIT(MRT_STAT0,           	0x400A000C,__READ_WRITE ,__mrt_stat_bits);
__IO_REG32_BIT(MRT_INTVAL1,           0x400A0010,__READ_WRITE ,__mrt_intval_bits);
__IO_REG32_BIT(MRT_TIMER1,           	0x400A0014,__READ				,__mrt_timer_bits);
__IO_REG32_BIT(MRT_CTRL1,           	0x400A0018,__READ_WRITE ,__mrt_ctrl_bits);
__IO_REG32_BIT(MRT_STAT1,           	0x400A001C,__READ_WRITE ,__mrt_stat_bits);
__IO_REG32_BIT(MRT_INTVAL2,           0x400A0020,__READ_WRITE ,__mrt_intval_bits);
__IO_REG32_BIT(MRT_TIMER2,           	0x400A0024,__READ				,__mrt_timer_bits);
__IO_REG32_BIT(MRT_CTRL2,           	0x400A0028,__READ_WRITE ,__mrt_ctrl_bits);
__IO_REG32_BIT(MRT_STAT2,           	0x400A002C,__READ_WRITE ,__mrt_stat_bits);
__IO_REG32_BIT(MRT_INTVAL3,           0x400A0030,__READ_WRITE ,__mrt_intval_bits);
__IO_REG32_BIT(MRT_TIMER3,           	0x400A0034,__READ				,__mrt_timer_bits);
__IO_REG32_BIT(MRT_CTRL3,           	0x400A0038,__READ_WRITE ,__mrt_ctrl_bits);
__IO_REG32_BIT(MRT_STAT3,           	0x400A003C,__READ_WRITE ,__mrt_stat_bits);
__IO_REG32_BIT(MRT_IDLE_CH,           0x400A00F4,__READ_WRITE ,__mrt_idle_ch_bits);
__IO_REG32_BIT(MRT_IRQ_FLAG,          0x400A00F8,__READ				,__mrt_irq_flag_bits);

/***************************************************************************
 **
 ** RIT (Repetitive Interrupt Timer)
 **
 ***************************************************************************/
__IO_REG32(		 RIT_COMPVAL,           0x400B4000,__READ_WRITE );
__IO_REG32(		 RIT_MASK,           		0x400B4004,__READ_WRITE );
__IO_REG32_BIT(RIT_CTRL,           		0x400B4008,__READ_WRITE ,__rit_ctrl_bits);
__IO_REG32(		 RIT_COUNTER,           0x400B400C,__READ_WRITE );
__IO_REG32_BIT(RIT_COMPVAL_H,         0x400B4010,__READ_WRITE ,__rit_compval_h_bits);
__IO_REG32_BIT(RIT_MASK_H,           	0x400B4014,__READ_WRITE ,__rit_mask_h_bits);
__IO_REG32_BIT(RIT_COUNTER_H,         0x400B401C,__READ_WRITE ,__rit_counter_h_bits);

/***************************************************************************
 **
 ** Quadrature Encoder Interface
 **
 ***************************************************************************/
__IO_REG32_BIT(QEICON,                0x40058000,__WRITE      ,__qeicon_bits);
__IO_REG32_BIT(QEISTAT,               0x40058004,__READ       ,__qeistat_bits);
__IO_REG32_BIT(QEICONF,               0x40058008,__READ_WRITE ,__qeiconf_bits);
__IO_REG32(    QEIPOS,                0x4005800C,__READ       );
__IO_REG32(    QEIMAXPSOS,            0x40058010,__READ_WRITE );
__IO_REG32(    CMPOS0,                0x40058014,__READ_WRITE );
__IO_REG32(    CMPOS1,                0x40058018,__READ_WRITE );
__IO_REG32(    CMPOS2,                0x4005801C,__READ_WRITE );
__IO_REG32(    INXCNT,                0x40058020,__READ       );
__IO_REG32(    INXCMP,                0x40058024,__READ_WRITE );
__IO_REG32(    QEILOAD,               0x40058028,__READ_WRITE );
__IO_REG32(    QEITIME,               0x4005802C,__READ       );
__IO_REG32(    QEIVEL,                0x40058030,__READ       );
__IO_REG32(    QEICAP,                0x40058034,__READ       );
__IO_REG32(    VELCOMP,               0x40058038,__READ_WRITE );
__IO_REG32(    FILTERPHA,             0x4005803C,__READ_WRITE );
__IO_REG32(    FILTERPHB,             0x40058040,__READ_WRITE );
__IO_REG32(    FILTERINX,             0x40058044,__READ_WRITE );
__IO_REG32(    WINDOW,             		0x40058048,__READ_WRITE );
__IO_REG32(    INXCMP1,             	0x4005804C,__READ_WRITE );
__IO_REG32(    INXCMP2,             	0x40058050,__READ_WRITE );
__IO_REG32(		 QEIIEC,                0x40058FD8,__WRITE      );
__IO_REG32(		 QEIIES,                0x40058FDC,__WRITE      );
__IO_REG32_BIT(QEIINTSTAT,            0x40058FE0,__READ       ,__qeiintstat_bits);
__IO_REG32_BIT(QEIIE,                 0x40058FE4,__READ       ,__qeiintstat_bits);
__IO_REG32(		 QEICLR,                0x40058FE8,__WRITE      );
__IO_REG32(		 QEISET,                0x40058FEC,__WRITE      );

/***************************************************************************
**
** USB
**
***************************************************************************/
__IO_REG32_BIT(USB_DEVCMDSTAT,    0x1C00C000,__READ_WRITE ,__usb_devcmdstat_bits);
__IO_REG32_BIT(USB_INFO,          0x1C00C004,__READ_WRITE ,__usb_info_bits);
__IO_REG32(		 USB_EPLISTSTART,   0x1C00C008,__READ_WRITE );
__IO_REG32(		 USB_DATABUFSTART,  0x1C00C00C,__READ_WRITE );
__IO_REG32_BIT(USB_LPM,  					0x1C00C010,__READ_WRITE ,__usb_lpm_bits);
__IO_REG32_BIT(USB_EPSKIP,        0x1C00C014,__READ_WRITE ,__usb_epskip_bits);
__IO_REG32_BIT(USB_EPINUSE,       0x1C00C018,__READ_WRITE ,__usb_epinuse_bits);
__IO_REG32_BIT(USB_EPBUFCFG,      0x1C00C01C,__READ_WRITE ,__usb_epbufcfg_bits);
__IO_REG32_BIT(USB_INTSTAT,       0x1C00C020,__READ_WRITE ,__usb_intstat_bits);
__IO_REG32_BIT(USB_INTEN,         0x1C00C024,__READ_WRITE ,__usb_inten_bits);
__IO_REG32_BIT(USB_INTSETSTAT,    0x1C00C028,__READ_WRITE ,__usb_intsetstat_bits);
__IO_REG32_BIT(USB_INTROUTING,    0x1C00C02C,__READ_WRITE ,__usb_introuting_bits);
__IO_REG32_BIT(USB_EPTOGGLE,      0x1C00C034,__READ       ,__usb_eptoggle_bits);

/***************************************************************************
 **
 **  USART0
 **
 ***************************************************************************/
__IO_REG32_BIT(USART0_CFG,    		0x40040000,__READ_WRITE ,__usart_cfg_bits);
__IO_REG32_BIT(USART0_CTRL,    		0x40040004,__READ_WRITE ,__usart_ctrl_bits);
__IO_REG32_BIT(USART0_STAT,    		0x40040008,__READ_WRITE ,__usart_stat_bits);
__IO_REG32_BIT(USART0_INTENSET,   0x4004000C,__READ_WRITE ,__usart_intenset_bits);
__IO_REG32_BIT(USART0_INTENCLR,   0x40040010,__READ_WRITE ,__usart_intenclr_bits);
__IO_REG32_BIT(USART0_RXDATA,    	0x40040014,__READ				,__usart_rxdata_bits);
__IO_REG32_BIT(USART0_RXDATASTAT, 0x40040018,__READ_WRITE ,__usart_rxdatastat_bits);
__IO_REG32_BIT(USART0_TXDATA,    	0x4004001C,__READ_WRITE ,__usart_txdata_bits);
__IO_REG32_BIT(USART0_BRG,    		0x40040020,__READ_WRITE ,__usart_brg_bits);
__IO_REG32_BIT(USART0_INTSTAT,   	0x40040024,__READ				,__usart_intstat_bits);

/***************************************************************************
 **
 **  USART1
 **
 ***************************************************************************/
__IO_REG32_BIT(USART1_CFG,    		0x40044000,__READ_WRITE ,__usart_cfg_bits);
__IO_REG32_BIT(USART1_CTRL,    		0x40044004,__READ_WRITE ,__usart_ctrl_bits);
__IO_REG32_BIT(USART1_STAT,    		0x40044008,__READ_WRITE ,__usart_stat_bits);
__IO_REG32_BIT(USART1_INTENSET,   0x4004400C,__READ_WRITE ,__usart_intenset_bits);
__IO_REG32_BIT(USART1_INTENCLR,   0x40044010,__READ_WRITE ,__usart_intenclr_bits);
__IO_REG32_BIT(USART1_RXDATA,    	0x40044014,__READ				,__usart_rxdata_bits);
__IO_REG32_BIT(USART1_RXDATASTAT, 0x40044018,__READ_WRITE ,__usart_rxdatastat_bits);
__IO_REG32_BIT(USART1_TXDATA,    	0x4004401C,__READ_WRITE ,__usart_txdata_bits);
__IO_REG32_BIT(USART1_BRG,    		0x40044020,__READ_WRITE ,__usart_brg_bits);
__IO_REG32_BIT(USART1_INTSTAT,   	0x40044024,__READ				,__usart_intstat_bits);

/***************************************************************************
 **
 **  USART2
 **
 ***************************************************************************/
__IO_REG32_BIT(USART2_CFG,    		0x400C0000,__READ_WRITE ,__usart_cfg_bits);
__IO_REG32_BIT(USART2_CTRL,    		0x400C0004,__READ_WRITE ,__usart_ctrl_bits);
__IO_REG32_BIT(USART2_STAT,    		0x400C0008,__READ_WRITE ,__usart_stat_bits);
__IO_REG32_BIT(USART2_INTENSET,   0x400C000C,__READ_WRITE ,__usart_intenset_bits);
__IO_REG32_BIT(USART2_INTENCLR,   0x400C0010,__READ_WRITE ,__usart_intenclr_bits);
__IO_REG32_BIT(USART2_RXDATA,    	0x400C0014,__READ				,__usart_rxdata_bits);
__IO_REG32_BIT(USART2_RXDATASTAT, 0x400C0018,__READ_WRITE ,__usart_rxdatastat_bits);
__IO_REG32_BIT(USART2_TXDATA,    	0x400C001C,__READ_WRITE ,__usart_txdata_bits);
__IO_REG32_BIT(USART2_BRG,    		0x400C0020,__READ_WRITE ,__usart_brg_bits);
__IO_REG32_BIT(USART2_INTSTAT,   	0x400C0024,__READ				,__usart_intstat_bits);

/***************************************************************************
 **
 **  I2C
 **
 ***************************************************************************/
__IO_REG32_BIT(I2C_CFG,    				0x40050000,__READ_WRITE ,__i2c_cfg_bits);
__IO_REG32_BIT(I2C_STAT,    			0x40050004,__READ_WRITE ,__i2c_stat_bits);
__IO_REG32_BIT(I2C_INTENSET,    	0x40050008,__READ_WRITE ,__i2c_intenset_bits);
__IO_REG32(		 I2C_INTENCLR,    	0x4005000C,__WRITE 			);
__IO_REG32_BIT(I2C_TIMEOUT,    		0x40050010,__READ_WRITE ,__i2c_timeout_bits);
__IO_REG32_BIT(I2C_DIV,    				0x40050014,__READ_WRITE ,__i2c_div_bits);
__IO_REG32_BIT(I2C_INTSTAT,    		0x40050018,__READ				,__i2c_intstat_bits);
__IO_REG32_BIT(I2C_MSTCTL,    		0x40050020,__READ_WRITE ,__i2c_mstctl_bits);
__IO_REG32_BIT(I2C_MSTTIME,    		0x40050024,__READ_WRITE ,__i2c_msttime_bits);
__IO_REG32_BIT(I2C_MSTDAT,    		0x40050028,__READ_WRITE ,__i2c_mstdat_bits);
__IO_REG32_BIT(I2C_SLVCTL,    		0x40050040,__READ_WRITE ,__i2c_slvctl_bits);
__IO_REG32_BIT(I2C_SLVDAT,    		0x40050044,__READ_WRITE ,__i2c_slvdat_bits);
__IO_REG32_BIT(I2C_SLVADR0,    		0x40050048,__READ_WRITE ,__i2c_slvadr_bits);
__IO_REG32_BIT(I2C_SLVADR1,    		0x4005004C,__READ_WRITE ,__i2c_slvadr_bits);
__IO_REG32_BIT(I2C_SLVADR2,    		0x40050050,__READ_WRITE ,__i2c_slvadr_bits);
__IO_REG32_BIT(I2C_SLVADR3,    		0x40050054,__READ_WRITE ,__i2c_slvadr_bits);
__IO_REG32_BIT(I2C_SLVQUAL0,    	0x40050058,__READ_WRITE ,__i2c_slvqual_bits);
__IO_REG32_BIT(I2C_MONRXDAT,    	0x40050080,__READ				,__i2c_monrxdat_bits);

/***************************************************************************
 **
 **  SPI0
 **
 ***************************************************************************/
__IO_REG32_BIT(SPI0_CFG,    			0x40048000,__READ_WRITE ,__spi_cfg_bits);
__IO_REG32_BIT(SPI0_DLY,    			0x40048004,__READ_WRITE ,__spi_dly_bits);
__IO_REG32_BIT(SPI0_STAT,    			0x40048008,__READ_WRITE ,__spi_stat_bits);
__IO_REG32_BIT(SPI0_INTENSET,    	0x4004800C,__READ_WRITE ,__spi_intenset_bits);
__IO_REG32(		 SPI0_INTENCLR,    	0x40048010,__WRITE 			);
__IO_REG32_BIT(SPI0_RXDAT,    	  0x40048014,__READ				,__spi_rxdat_bits);
__IO_REG32_BIT(SPI0_TXDATCTL,    	0x40048018,__READ_WRITE ,__spi_txdatctl_bits);
__IO_REG32_BIT(SPI0_TXDAT,    		0x4004801C,__READ_WRITE ,__spi_txdat_bits);
__IO_REG32_BIT(SPI0_TXCTL,    		0x40048020,__READ_WRITE ,__spi_txctl_bits);
__IO_REG32_BIT(SPI0_DIV,    			0x40048024,__READ_WRITE ,__spi_div_bits);
__IO_REG32_BIT(SPI0_INTSTAT,    	0x40048028,__READ				,__spi_intstat_bits);

/***************************************************************************
 **
 **  SPI1
 **
 ***************************************************************************/
__IO_REG32_BIT(SPI1_CFG,    			0x4004C000,__READ_WRITE ,__spi_cfg_bits);
__IO_REG32_BIT(SPI1_DLY,    			0x4004C004,__READ_WRITE ,__spi_dly_bits);
__IO_REG32_BIT(SPI1_STAT,    			0x4004C008,__READ_WRITE ,__spi_stat_bits);
__IO_REG32_BIT(SPI1_INTENSET,    	0x4004C00C,__READ_WRITE ,__spi_intenset_bits);
__IO_REG32(		 SPI1_INTENCLR,    	0x4004C010,__WRITE 			);
__IO_REG32_BIT(SPI1_RXDAT,    	  0x4004C014,__READ				,__spi_rxdat_bits);
__IO_REG32_BIT(SPI1_TXDATCTL,    	0x4004C018,__READ_WRITE ,__spi_txdatctl_bits);
__IO_REG32_BIT(SPI1_TXDAT,    		0x4004C01C,__READ_WRITE ,__spi_txdat_bits);
__IO_REG32_BIT(SPI1_TXCTL,    		0x4004C020,__READ_WRITE ,__spi_txctl_bits);
__IO_REG32_BIT(SPI1_DIV,    			0x4004C024,__READ_WRITE ,__spi_div_bits);
__IO_REG32_BIT(SPI1_INTSTAT,    	0x4004C028,__READ				,__spi_intstat_bits);

/***************************************************************************
 **
 ** CAN
 **
 ***************************************************************************/
__IO_REG32_BIT(CANCNTL,               0x400F0000,__READ_WRITE ,__cancntl_bits);
__IO_REG32_BIT(CANSTAT,               0x400F0004,__READ_WRITE ,__canstat_bits);
__IO_REG32_BIT(CANEC,                 0x400F0008,__READ       ,__canec_bits);
__IO_REG32_BIT(CANBT,                 0x400F000C,__READ_WRITE ,__canbt_bits);
__IO_REG32_BIT(CANINT,                0x400F0010,__READ       ,__canint_bits);
__IO_REG32_BIT(CANTEST,               0x400F0014,__READ_WRITE ,__cantest_bits);
__IO_REG32_BIT(CANBRPE,               0x400F0018,__READ_WRITE ,__canbrpe_bits);
__IO_REG32_BIT(CANIF1_CMDREQ,         0x400F0020,__READ_WRITE ,__canifx_cmdreq_bits);
__IO_REG32_BIT(CANIF1_CMDMSK,         0x400F0024,__READ_WRITE ,__canifx_cmdmsk_bits);
__IO_REG32_BIT(CANIF1_MSK1,           0x400F0028,__READ_WRITE ,__canifx_msk1_bits);
__IO_REG32_BIT(CANIF1_MSK2,           0x400F002C,__READ_WRITE ,__canifx_msk2_bits);
__IO_REG32_BIT(CANIF1_ARB1,           0x400F0030,__READ_WRITE ,__canifx_arb1_bits);
__IO_REG32_BIT(CANIF1_ARB2,           0x400F0034,__READ_WRITE ,__canifx_arb2_bits);
__IO_REG32_BIT(CANIF1_MCTRL,          0x400F0038,__READ_WRITE ,__canifx_mctrl_bits);
__IO_REG32_BIT(CANIF1_DA1,            0x400F003C,__READ_WRITE ,__canifx_da1_bits);
__IO_REG32_BIT(CANIF1_DA2,            0x400F0040,__READ_WRITE ,__canifx_da2_bits);
__IO_REG32_BIT(CANIF1_DB1,            0x400F0044,__READ_WRITE ,__canifx_db1_bits);
__IO_REG32_BIT(CANIF1_DB2,            0x400F0048,__READ_WRITE ,__canifx_db2_bits);
__IO_REG32_BIT(CANIF2_CMDREQ,         0x400F0080,__READ_WRITE ,__canifx_cmdreq_bits);
__IO_REG32_BIT(CANIF2_CMDMSK,         0x400F0084,__READ_WRITE ,__canifx_cmdmsk_bits);
__IO_REG32_BIT(CANIF2_MSK1,           0x400F0088,__READ_WRITE ,__canifx_msk1_bits);
__IO_REG32_BIT(CANIF2_MSK2,           0x400F008C,__READ_WRITE ,__canifx_msk2_bits);
__IO_REG32_BIT(CANIF2_ARB1,           0x400F0090,__READ_WRITE ,__canifx_arb1_bits);
__IO_REG32_BIT(CANIF2_ARB2,           0x400F0094,__READ_WRITE ,__canifx_arb2_bits);
__IO_REG32_BIT(CANIF2_MCTRL,          0x400F0098,__READ_WRITE ,__canifx_mctrl_bits);
__IO_REG32_BIT(CANIF2_DA1,            0x400F009C,__READ_WRITE ,__canifx_da1_bits);
__IO_REG32_BIT(CANIF2_DA2,            0x400F00A0,__READ_WRITE ,__canifx_da2_bits);
__IO_REG32_BIT(CANIF2_DB1,            0x400F00A4,__READ_WRITE ,__canifx_db1_bits);
__IO_REG32_BIT(CANIF2_DB2,            0x400F00A8,__READ_WRITE ,__canifx_db2_bits);
__IO_REG32_BIT(CANTXREQ1,             0x400F0100,__READ       ,__cantxreq1_bits);
__IO_REG32_BIT(CANTXREQ2,             0x400F0104,__READ       ,__cantxreq2_bits);
__IO_REG32_BIT(CANND1,                0x400F0120,__READ       ,__cannd1_bits);
__IO_REG32_BIT(CANND2,                0x400F0124,__READ       ,__cannd2_bits);
__IO_REG32_BIT(CANIR1,                0x400F0140,__READ       ,__canir1_bits);
__IO_REG32_BIT(CANIR2,                0x400F0144,__READ       ,__canir2_bits);
__IO_REG32_BIT(CANMSGV1,              0x400F0160,__READ       ,__canmsgv1_bits);
__IO_REG32_BIT(CANMSGV2,              0x400F0164,__READ       ,__canmsgv2_bits);
__IO_REG32_BIT(CANCLKDIV,             0x400F0180,__READ_WRITE ,__canclkdiv_bits);

/***************************************************************************
 **
 ** ADC0
 **
 ***************************************************************************/
__IO_REG32_BIT(ADC0_CTRL,             0x40000000,__READ_WRITE ,__adc_ctrl_bits);
__IO_REG32_BIT(ADC0_INSEL,            0x40000004,__READ_WRITE ,__adc_insel_bits);
__IO_REG32_BIT(ADC0_SEQA_CTRL,        0x40000008,__READ_WRITE ,__adc_seqa_ctrl_bits);
__IO_REG32_BIT(ADC0_SEQB_CTRL,        0x4000000C,__READ_WRITE ,__adc_seqa_ctrl_bits);
__IO_REG32_BIT(ADC0_SSEQA_GDAT,       0x40000010,__READ_WRITE ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_SEQB_GDAT,        0x40000014,__READ_WRITE ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_DAT0,             0x40000020,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_DAT1,             0x40000024,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_DAT2,             0x40000028,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_DAT3,             0x4000002C,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_DAT4,             0x40000030,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_DAT5,             0x40000034,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_DAT6,             0x40000038,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_DAT7,             0x4000003C,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_DAT8,             0x40000040,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_DAT9,             0x40000044,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_DAT10,            0x40000048,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_DAT11,            0x4000004C,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC0_THR0_LOW,         0x40000050,__READ_WRITE ,__adc_thr_low_bits);
__IO_REG32_BIT(ADC0_THR1_LOW,         0x40000054,__READ_WRITE ,__adc_thr_low_bits);
__IO_REG32_BIT(ADC0_THR0_HIGH,        0x40000058,__READ_WRITE ,__adc_thr_high_bits);
__IO_REG32_BIT(ADC0_THR1_HIGH,        0x4000005C,__READ_WRITE ,__adc_thr_high_bits);
__IO_REG32_BIT(ADC0_CHAN_THRSEL,      0x40000060,__READ	 ,__adc_chan_thrsel_bits);
__IO_REG32_BIT(ADC0_INTEN,            0x40000064,__READ_WRITE ,__adc_inten_bits);
__IO_REG32_BIT(ADC0_FLAGS,            0x40000068,__READ_WRITE,__adc_flags_bits);
//__IO_REG32_BIT(ADC0_TRM,             	0x4000006C,__READ_WRITE ,__adc_trm_bits);

/***************************************************************************
 **
 ** ADC1
 **
 ***************************************************************************/
__IO_REG32_BIT(ADC1_CTRL,             0x40080000,__READ_WRITE ,__adc_ctrl_bits);
__IO_REG32_BIT(ADC1_INSEL,            0x40080004,__READ_WRITE ,__adc_insel_bits);
__IO_REG32_BIT(ADC1_SEQA_CTRL,        0x40080008,__READ_WRITE ,__adc_seqa_ctrl_bits);
__IO_REG32_BIT(ADC1_SEQB_CTRL,        0x4008000C,__READ_WRITE ,__adc_seqa_ctrl_bits);
__IO_REG32_BIT(ADC1_SSEQA_GDAT,       0x40080010,__READ_WRITE ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_SEQB_GDAT,        0x40080014,__READ_WRITE ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_DAT0,             0x40080020,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_DAT1,             0x40080024,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_DAT2,             0x40080028,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_DAT3,             0x4008002C,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_DAT4,             0x40080030,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_DAT5,             0x40080034,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_DAT6,             0x40080038,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_DAT7,             0x4008003C,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_DAT8,             0x40080040,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_DAT9,             0x40080044,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_DAT10,            0x40080048,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_DAT11,            0x4008004C,__READ       ,__adc_seqa_gdat_bits);
__IO_REG32_BIT(ADC1_THR0_LOW,         0x40080050,__READ_WRITE ,__adc_thr_low_bits);
__IO_REG32_BIT(ADC1_THR1_LOW,         0x40080054,__READ_WRITE ,__adc_thr_low_bits);
__IO_REG32_BIT(ADC1_THR0_HIGH,        0x40080058,__READ_WRITE ,__adc_thr_high_bits);
__IO_REG32_BIT(ADC1_THR1_HIGH,        0x4008005C,__READ_WRITE ,__adc_thr_high_bits);
__IO_REG32_BIT(ADC1_CHAN_THRSEL,      0x40080060,__READ				,__adc_chan_thrsel_bits);
__IO_REG32_BIT(ADC1_INTEN,            0x40080064,__READ_WRITE ,__adc_inten_bits);
__IO_REG32_BIT(ADC1_FLAGS,            0x40080068,__READ				,__adc_flags_bits);
//__IO_REG32_BIT(ADC1_TRM,             	0x4008006C,__READ_WRITE ,__adc_trm_bits);

/***************************************************************************
 **
 ** DAC
 **
 ***************************************************************************/
__IO_REG32_BIT(DAC_VAL,             	0x40004000,__READ_WRITE ,__dac_val_bits);
__IO_REG32_BIT(DAC_CTRL,             	0x40004004,__READ_WRITE ,__dac_ctrl_bits);
__IO_REG32_BIT(DAC_CNTVAL,            0x40004008,__READ_WRITE ,__dac_cntval_bits);

/***************************************************************************
 **
 ** COMP
 **
 ***************************************************************************/
__IO_REG32_BIT(COMP_CTRL,             0x40008000,__READ_WRITE ,__comp_ctrl_bits);
__IO_REG32_BIT(COMP_CMP0,             0x40008004,__READ_WRITE ,__comp_cmp_bits);
__IO_REG32_BIT(COMP_CMPFILTR0,        0x40008008,__READ_WRITE ,__comp_cmpfiltr_bits);
__IO_REG32_BIT(COMP_CMP1,             0x4000800C,__READ_WRITE ,__comp_cmp_bits);
__IO_REG32_BIT(COMP_CMPFILTR1,        0x40008010,__READ_WRITE ,__comp_cmpfiltr_bits);
__IO_REG32_BIT(COMP_CMP2,             0x40008014,__READ_WRITE ,__comp_cmp_bits);
__IO_REG32_BIT(COMP_CMPFILTR2,        0x40008018,__READ_WRITE ,__comp_cmpfiltr_bits);
__IO_REG32_BIT(COMP_CMP3,             0x4000801C,__READ_WRITE ,__comp_cmp_bits);
__IO_REG32_BIT(COMP_CMPFILTR3,        0x40008020,__READ_WRITE ,__comp_cmpfiltr_bits);

/***************************************************************************
 **
 ** CRC
 **
 ***************************************************************************/
__IO_REG32_BIT(CRC_MODE,              0x1C010000,__READ_WRITE ,__crc_mode_bits);
__IO_REG32(    CRC_SEED,              0x1C010004,__READ_WRITE );
__IO_REG32(    CRC_SUM,               0x1C010008,__READ_WRITE );
#define CRC_WR_DATA   CRC_SUM

/***************************************************************************
 **
 ** Flash signature generation
 **
 ***************************************************************************/
__IO_REG32_BIT(FMSSTART,              0x400BC020,__READ_WRITE ,__fmsstart_bits);
__IO_REG32_BIT(FMSSTOP,               0x400BC024,__READ_WRITE ,__fmsstop_bits);
__IO_REG32(    FMSW0,                 0x400BC02C,__READ       );

/***************************************************************************
 **  Assembler-specific declarations
 ***************************************************************************/

#ifdef __IAR_SYSTEMS_ASM__
#endif    /* __IAR_SYSTEMS_ASM__ */

/***************************************************************************
 **
 **  DMA channels
 **
 ***************************************************************************/
#define USART0_RX_DMA  					0
#define USART0_TX_DMA  					1
#define USART1_RX_DMA  					2
#define USART1_TX_DMA  					3
#define USART2_RX_DMA  					4
#define USART2_TX_DMA  					5
#define SPI0_RX_DMA    					6
#define SPI0_TX_DMA    					7
#define SPI1_RX_DMA    					8
#define SPI1_TX_DMA    					9
#define I2C0_RX_DMA	  					10
#define I2C0_TX_DMA	  					11
#define I2C0_MONITOR_DMA				12
#define DAC_IRQ									13

/***************************************************************************
 **
 **  NVIC Interrupt channels
 **
 ***************************************************************************/
#define MAIN_STACK            						 0  /* Main Stack                         */
#define RESETI                						 1  /* Reset                              */
#define NMII                  						 2  /* Non-maskable Interrupt             */
#define HFI                   						 3  /* Hard Fault                         */
#define MMI                   						 4  /* Memory Management                  */
#define BFI                   						 5  /* Bus Fault                          */
#define UFI                   						 6  /* Usage Fault                        */
#define SVCI                  						11  /* SVCall                             */
#define DMI                   						12  /* Debug Monitor                      */
#define PSI                   						14  /* PendSV                             */
#define STI                   						15  /* SysTick                            */
#define NVIC_INTR			     								16
#define NVIC_WDT_IRQ	     		(NVIC_INTR+ 0) 	/* Windowed watchdog timer interrupt  */
#define NVIC_BOD_IRQ       		(NVIC_INTR+ 1) 	/* BOD interrupt				              */
#define NVIC_DMA		          (NVIC_INTR+ 4) 	/* DMA interrupt                      */
#define NVIC_GINT0        		(NVIC_INTR+ 5) 	/* GPIO group 0 interrupt             */
#define NVIC_GINT1        		(NVIC_INTR+ 6) 	/* GPIO group 1 interrupt             */
#define NVIC_PININT0	        (NVIC_INTR+ 7) 	/* Pin interrupt 0                    */
#define NVIC_PININT1          (NVIC_INTR+ 8) 	/* Pin interrupt 1                    */
#define NVIC_PININT2          (NVIC_INTR+ 9) 	/* Pin interrupt 2                    */
#define NVIC_PININT3          (NVIC_INTR+10) 	/* Pin interrupt 3                    */
#define NVIC_PININT4          (NVIC_INTR+11) 	/* Pin interrupt 4                    */
#define NVIC_PININT5          (NVIC_INTR+12) 	/* Pin interrupt 5                    */
#define NVIC_PININT6          (NVIC_INTR+13) 	/* Pin interrupt 6                    */
#define NVIC_PININT7          (NVIC_INTR+14) 	/* Pin interrupt 7                    */
#define NVIC_SCT0          		(NVIC_INTR+16) 	/* State configurable timer interrupt */
#define NVIC_SCT1          		(NVIC_INTR+17) 	/* State configurable timer interrupt */
#define NVIC_SCT2          		(NVIC_INTR+18) 	/* State configurable timer interrupt */
#define NVIC_SCT3          		(NVIC_INTR+19) 	/* State configurable timer interrupt */
#define NVIC_MRT          		(NVIC_INTR+20) 	/* Multi-rate timer interrupt 				*/
#define NVIC_UART0         		(NVIC_INTR+21) 	/* USART0 interrupt 		 							*/
#define NVIC_UART1         		(NVIC_INTR+22) 	/* USART1 interrupt 		 							*/
#define NVIC_UART2         		(NVIC_INTR+23) 	/* USART2 interrupt 		 							*/
#define NVIC_I2C0         		(NVIC_INTR+24) 	/* I2C0 interrupt  			 							*/
#define NVIC_SPI0          		(NVIC_INTR+25) 	/* SPI0 interrupt 			 							*/
#define NVIC_SPI1          		(NVIC_INTR+26) 	/* SPI1 interrupt 			 							*/
#define NVIC_C_CAN0        		(NVIC_INTR+27) 	/* C_CAN0 interrupt 		 							*/
#define NVIC_USB_LP        		(NVIC_INTR+28) 	/* USB LP interrupt 		 							*/
#define NVIC_USB_HP        		(NVIC_INTR+29) 	/* USB HP interrupt 		 							*/
#define NVIC_USB_WAKE      		(NVIC_INTR+30) 	/* USB wake up interrupt 							*/
#define NVIC_ADC0_SEQA     		(NVIC_INTR+31) 	/* ADC0 sequence A completion 				*/
#define NVIC_ADC0_SEQB     		(NVIC_INTR+32) 	/* ADC0 sequence B completion 				*/
#define NVIC_ADC0_THCMP    		(NVIC_INTR+33) 	/* ADC0 threshold compare 			 			*/
#define NVIC_ADC0_OVR    			(NVIC_INTR+34) 	/* ADC0 overrun 								 			*/
#define NVIC_ADC1_SEQA    		(NVIC_INTR+35) 	/* ADC1 sequence A completion 	 			*/
#define NVIC_ADC1_SEQB    		(NVIC_INTR+36) 	/* ADC1 sequence B completion 	 			*/
#define NVIC_ADC1_THCMP    		(NVIC_INTR+37) 	/* ADC1 threshold compare 			 			*/
#define NVIC_ADC1_OVR    			(NVIC_INTR+38) 	/* ADC1 overrun	 								 			*/
#define NVIC_DAC    					(NVIC_INTR+39) 	/* DAC interrupt 								 			*/
#define NVIC_CMP0        			(NVIC_INTR+40) 	/* Analog comparator 0 interrupt 			*/
#define NVIC_CMP1		    			(NVIC_INTR+41) 	/* Analog comparator 1 interrupt 			*/
#define NVIC_CMP2		    			(NVIC_INTR+42) 	/* Analog comparator 2 interrupt 			*/
#define NVIC_CMP3		    			(NVIC_INTR+43) 	/* Analog comparator 3 interrupt 			*/
#define NVIC_QEI		    			(NVIC_INTR+44) 	/* QEI interrupt 											*/
#define NVIC_RTC_ALARM  			(NVIC_INTR+45) 	/* RTC alarm interrupt 								*/
#define NVIC_RTC_WAKE   			(NVIC_INTR+46) 	/* RTC wake-up interrut 							*/

#endif    /* __IOLPC15XX_H */

/*###DDF-INTERRUPT-BEGIN###
Interrupt0   = NMI            	0x08
Interrupt1   = HardFault      	0x0C
Interrupt2   = MemManage      	0x10
Interrupt3   = BusFault       	0x14
Interrupt4   = UsageFault     	0x18
Interrupt5   = SVC            	0x2C
Interrupt6   = DebugMon       	0x30
Interrupt7   = PendSV         	0x38
Interrupt8   = SysTick        	0x3C
Interrupt9   = NVIC_WDT_IRQ	  	0x40
Interrupt10  = NVIC_BOD_IRQ   	0x44
Interrupt11  = NVIC_DMA		    	0x50
Interrupt12  = NVIC_GINT0     	0x54
Interrupt13  = NVIC_GINT1     	0x58
Interrupt14  = NVIC_PININT0	  	0x5C
Interrupt15  = NVIC_PININT1   	0x60
Interrupt16  = NVIC_PININT2   	0x64
Interrupt17  = NVIC_PININT3   	0x68
Interrupt18  = NVIC_PININT4   	0x6C
Interrupt19  = NVIC_PININT5   	0x70
Interrupt20  = NVIC_PININT6   	0x74
Interrupt21  = NVIC_PININT7   	0x78
Interrupt22  = NVIC_SCT0      	0x80
Interrupt23  = NVIC_SCT1      	0x84
Interrupt24  = NVIC_SCT2      	0x88
Interrupt25  = NVIC_SCT3      	0x8C
Interrupt26  = NVIC_MRT       	0x90
Interrupt27  = NVIC_UART0     	0x94
Interrupt28  = NVIC_UART1     	0x98
Interrupt29  = NVIC_UART2     	0x9C
Interrupt30  = NVIC_I2C0      	0xA0
Interrupt31  = NVIC_SPI0      	0xA4
Interrupt32  = NVIC_SPI1      	0xA8
Interrupt33  = NVIC_C_CAN0    	0xAC    		
Interrupt34  = NVIC_USB_LP    	0xB0    		
Interrupt35  = NVIC_USB_HP    	0xB4
Interrupt36  = NVIC_USB_WAKE  	0xB8
Interrupt37  = NVIC_ADC0_SEQA 	0xBC
Interrupt38  = NVIC_ADC0_SEQB 	0xC0
Interrupt39  = NVIC_ADC0_THCMP  0xC4  		
Interrupt40  = NVIC_ADC0_OVR    0xC8			
Interrupt41  = NVIC_ADC1_SEQA   0xCC 		
Interrupt42  = NVIC_ADC1_SEQB   0xD0
Interrupt43  = NVIC_ADC1_THCMP  0xD4
Interrupt44  = NVIC_ADC1_OVR    0xD8			
Interrupt45  = NVIC_DAC    			0xDC		
Interrupt46  = NVIC_CMP0        0xE0			
Interrupt47  = NVIC_CMP1		    0xE4			
Interrupt48  = NVIC_CMP2		    0xE8			
Interrupt49  = NVIC_CMP3		    0xEC			
Interrupt50  = NVIC_QEI		    	0xF0		
Interrupt51  = NVIC_RTC_ALARM  	0xF4		
Interrupt52  = NVIC_RTC_WAKE   	0xF8		

###DDF-INTERRUPT-END###*/
