/****************************************************************************
 *   $Id:: sct_ctouch.c 8974 2014-03-23					$
 *   Project: NXP LPC8xx CMP example
 *
 *   Description:
 *     This file contains Capacitive Touch SCT initialization code
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.

 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors'
 * relevant copyright in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers. This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
****************************************************************************/

#include <stdint.h>
#include "cmsis.h"
#include "core_cm0plus.h"
#include "chip.h"
#include "sct_8xx.h"

#include "sct_ctouch.h"

	/* This file was originally derived from the State-Red SCT Tool and was	 */
	/* edited to show how the register-setup would be without using the tool */
	/* the commented sections are remainders from the State-Red SCT Tool	 */

void sct_ctouch_init (void)
{
/*LPC_SCT->CONFIG = (LPC_SCT->CONFIG & ~0x00060001) | 0x00000000 ;	 * SPLIT	*/
  LPC_SCT->CONFIG = (LPC_SCT->CONFIG & ~(eNoReloadL | eNoReloadH | eUnify))
				     |  0x00000000 ;			/* SPLIT	*/

	/* MATCH / CAPTURE registers	*/
/*LPC_SCT->REGMODE_L = 0x0002 ;			 * L: 0x MATCH, 1x CAPTURE, 4 unused	*/
  LPC_SCT->REGMODE_L = bCap1 ;			/* L: 0x MATCH, 1x CAPTURE, 4 unused	*/

/*LPC_SCT->REGMODE_H = 0x0000 ;			 * H: 2x MATCH, 0x CAPTURE, 3 unused	*/

/*LPC_SCT->MATCH_H   [0			] = eVal_IntervalTimer ;  * inIntervalTimer	*/
/*LPC_SCT->MATCHREL_H[0			] = eVal_IntervalTimer ; */
  LPC_SCT->MATCH_H   [eReg_IntervalTimer] = eVal_IntervalTimer ; /* inIntervalTimer	*/
  LPC_SCT->MATCHREL_H[eReg_IntervalTimer] = eVal_IntervalTimer ;

/*LPC_SCT->MATCH_H   [1			] = eVal_StartSample ;	 * inStartSample	*/
/*LPC_SCT->MATCHREL_H[1			] = eVal_StartSample ;	*/
  LPC_SCT->MATCH_H   [eReg_EnaLowTimer  ] = eVal_StartSample ;	/* inStartSample	*/
  LPC_SCT->MATCHREL_H[eReg_EnaLowTimer  ] = eVal_StartSample ;

/*LPC_SCT->MATCH_L   [0			] = eVal_MinValue ;	 * inMinValue		*/
/*LPC_SCT->MATCHREL_L[0			] = eVal_MinValue ;	*/
  LPC_SCT->MATCH_L   [eReg_MatchPressed ] = eVal_MinValue ;	/* inMinValue		*/
  LPC_SCT->MATCHREL_L[eReg_MatchPressed ] = eVal_MinValue ;

/*LPC_SCT->CAPCTRL_L [1		        ] = 0x0010 ;		*/
  LPC_SCT->CAPCTRL_L [eReg_EventWidth   ] = bEvt_MeasurePeriod ;

	/* OUTPUT registers	*/
  /* OUTPUT registers */
/*LPC_SCT->OUT[1	       ].SET = 0x00000010 ;		 * outButtonPress	*/
/*LPC_SCT->OUT[1	       ].CLR = 0x00000000 ;		 */
  LPC_SCT->OUT[eOut_ButtonPress].SET = eEvt_MeasurePeriod ;	/* outButtonPress	*/

  /* Unused outputs must not be affected by any event	*/
/*LPC_SCT->OUT[0].SET = 0 ;	*/
/*LPC_SCT->OUT[0].CLR = 0 ;	*/
/*LPC_SCT->OUT[2].SET = 0 ;	*/
/*LPC_SCT->OUT[2].CLR = 0 ;	*/
/*LPC_SCT->OUT[3].SET = 0 ;	*/
/*LPC_SCT->OUT[3].CLR = 0 ;	*/

  LPC_SCT->OUTPUT |= bOut_ButtonPress ;

	/* Conflict resolution register		*/

	/* EVENT registers */
/*LPC_SCT->EVENT[0		   ].CTRL  = 0x00001010 ;	 * H:	*/
  LPC_SCT->EVENT[eEvt_IntervalTimer].CTRL  = eCtrl_IntervalTimer
					   | eCtrl_EventH
					   | eCtrl_Comb_Match ;

/*LPC_SCT->EVENT[0		   ].STATE = 0xFFFFFFFF ;	*/
  LPC_SCT->EVENT[eEvt_IntervalTimer].STATE = bStates ;

/*LPC_SCT->EVENT[1		   ].CTRL  = 0x00001011 ;	 * H:	*/
  LPC_SCT->EVENT[eEvt_EnaLowTimer  ].CTRL  = eCtrl_EnaLowTimer
					   | eCtrl_EventH
					   | eCtrl_Comb_Match ;

/*LPC_SCT->EVENT[1		   ].STATE = 0xFFFFFFFF ;	*/
  LPC_SCT->EVENT[eEvt_EnaLowTimer  ].STATE = bStates ;

/*LPC_SCT->EVENT[2		   ].CTRL  = 0x00006400 ;	 * L: --> state L_ENTRY	*/
  LPC_SCT->EVENT[eEvt_ResetCounter ].CTRL  = eCtrl_EventL
					   | eCtrl_InSel
					   | eCtrl_PwmInput
					   | eCtrl_IO_Rise
					   | eCtrl_Comb_IO
					   | eCtrl_Load
					   | eCtrl_Entry ;

/*LPC_SCT->EVENT[2		   ].STATE = 0x00000001 ;	*/
  LPC_SCT->EVENT[eEvt_ResetCounter ].STATE = bEntry ;

/*LPC_SCT->EVENT[3		   ].CTRL  = 0x0000D000 ;	 * L: --> state State_1	*/
  LPC_SCT->EVENT[eEvt_MatchPressed ].CTRL  = eCtrl_MatchPressed
					   | eCtrl_EventL
					   | eCtrl_Comb_Match
					   | eCtrl_Load
					   | eCtrl_State1 ;

/*LPC_SCT->EVENT[3		   ].STATE = 0x00000001 ;	*/
  LPC_SCT->EVENT[eEvt_MatchPressed ].STATE = bEntry ;

/*LPC_SCT->EVENT[4		   ].CTRL  = 0x00006400 ;	 * L: --> state L_ENTRY	*/
  LPC_SCT->EVENT[eEvt_MeasurePeriod].CTRL  = eCtrl_EventL
					   | eCtrl_InSel
					   | eCtrl_PwmInput
					   | eCtrl_IO_Rise
					   | eCtrl_Comb_IO
					   | eCtrl_Load
					   | eCtrl_Entry ;

/*LPC_SCT->EVENT[4		   ].STATE = 0x00000002 ;	*/
  LPC_SCT->EVENT[eEvt_MeasurePeriod].STATE = bState1 ;

	/* Unused events must not have any effect	*/
/*LPC_SCT->EVENT[5    ].STATE = 0 ;	*/
/*LPC_SCT->EVENT[eEvt5].STATE = 0 ;	*/

	/* STATE registers	*/
/*LPC_SCT->STATE_L = 0 ;	*/
/*LPC_SCT->STATE_H = 0 ;	 * implicit value	*/

	/* state names assignment:	*/
  /* State L 0: L_ENTRY */
  /* State L 1: state_1 */

	/* CORE registers	*/
/*LPC_SCT->START_L = 0x0002 ;	*/
  LPC_SCT->START_L = bEvt_EnaLowTimer ;

/*LPC_SCT->STOP_L  = 0x0000 ;	*/

/*LPC_SCT->HALT_L  = 0x0011 ;	*/
  LPC_SCT->HALT_L  = bEvt_MeasurePeriod | bEvt_IntervalTimer ;

/*LPC_SCT->LIMIT_L = 0x0014 ;	*/
  LPC_SCT->LIMIT_L = bEvt_MeasurePeriod | bEvt_ResetCounter ;

/*LPC_SCT->START_H = 0x0000 ;	*/
/*LPC_SCT->STOP_H  = 0x0000 ;	*/
/*LPC_SCT->HALT_H  = 0x0000 ;	*/

/*LPC_SCT->LIMIT_H = 0x0001 ;	*/
  LPC_SCT->LIMIT_H = bEvt_IntervalTimer ;

/*LPC_SCT->EVEN	   = 0x00000001 ; */
  LPC_SCT->EVEN	   = bEvt_IntervalTimer ;	/* ena IRQ	*/
}
