/****************************************************************************
 *   $Id:: sct_defs.h 8974 2014-03-23					$
 *   Project: NXP LPC8xx CMP example
 *
 *   Description:
 *     This file contains the SCT register and register-bits definitions.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.

 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors'
 * relevant copyright in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers. This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
****************************************************************************/

#ifndef __SCT_DEFS_H__
#define __SCT_DEFS_H__

enum {		/* config reg defs	*/
  eUnify     = 0x00 <<  0,

  eClkMode00 = 0x00 <<  1,
  eClkMode01 = 0x01 <<  1,
  eClkMode10 = 0x10 <<  1,
  eClkMode11 = 0x11 <<  1,

  eClkRise0  = 0x00 <<  3,
  eClkFall0  = 0x01 <<  3,
  eClkRise1  = 0x02 <<  3,
  eClkFall1  = 0x03 <<  3,
  eClkRise2  = 0x04 <<  3,
  eClkFall2  = 0x05 <<  3,
  eClkRise3  = 0x06 <<  3,
  eClkFall3  = 0x07 <<  3,

  eNoReloadL = 0x01 <<  7,
  eNoReloadH = 0x01 <<  8,

  eInSync0   = 0x01 <<  9,
  eInSync1   = 0x01 << 10,
  eInSync2   = 0x01 << 11,
  eInSync3   = 0x01 << 12,
  eInSync4   = 0x01 << 13,
  eInSync5   = 0x01 << 14,
  eInSync6   = 0x01 << 15,
  eInSync7   = 0x01 << 16,

  eAutoLimL  = 0x01 << 17,
  eAutoLimH  = 0x01 << 18,
} ;

enum {		/* conrol reg defs	*/
  eSct_Down    = 0x01 <<  0,
  eSct_Stop    = 0x01 <<  1,
  eSct_Halt    = 0x01 <<  2,
  eSct_ClrCtr  = 0x01 <<  3,
  eSct_BiDir   = 0x01 <<  4,
  eSct_Pre     = 5,

  eSct_DownL   = 0x01 <<  0,
  eSct_StopL   = 0x01 <<  1,
  eSct_HaltL   = 0x01 <<  2,
  eSct_ClrCtrL = 0x01 <<  3,
  eSct_BiDirL  = 0x01 <<  4,
  eSct_PreL    = 5,

  eSct_DownH   = 0x01 << 16,
  eSct_StopH   = 0x01 << 17,
  eSct_HaltH   = 0x01 << 18,
  eSct_ClrCtrH = 0x01 << 19,
  eSct_BiDirH  = 0x01 << 20,
  eSct_PreH    = 21
} ;

enum {		/* global sct defs	*/
  eEvt0 = 0,
  eEvt1,
  eEvt2,
  eEvt3,
  eEvt4,
  eEvt5,

  bEvt0 = 0x01 << eEvt0,
  bEvt1 = 0x01 << eEvt1,
  bEvt2 = 0x01 << eEvt2,
  bEvt3 = 0x01 << eEvt3,
  bEvt4 = 0x01 << eEvt4,
  bEvt5 = 0x01 << eEvt5,
  bEvts = 0x3f,

  eReg0 = 0,
  eReg1,
  eReg2,
  eReg3,
  eReg4,

  bCap0 = 0x01 << eReg0,
  bCap1 = 0x01 << eReg1,
  bCap2 = 0x01 << eReg2,
  bCap3 = 0x01 << eReg3,
  bCap4 = 0x01 << eReg4,

  ePin0 = 0x00,
  ePin1,
  ePin2,
  ePin3,

  bPin0 = 0x01 << ePin0,
  bPin1 = 0x01 << ePin1,
  bPin2 = 0x01 << ePin2,
  bPin3 = 0x01 << ePin3,

  eEntry  = 0x00,
  eState0 = eEntry,
  eState1,

  bEntry  = 0x01 << eEntry,
  bState0 = 0x01 << eState0,
  bState1 = 0x01 << eState1,
  bStates = 0x03
} ;

enum {		/* event ctrl defs	*/
  eCtrl_Match0	   = eReg0   <<  0,
  eCtrl_Match1	   = eReg1   <<  0,
  eCtrl_Match2	   = eReg2   <<  0,
  eCtrl_Match3	   = eReg3   <<  0,
  eCtrl_Match4	   = eReg4   <<  0,

  eCtrl_EventL	   = 0x00    <<  4,
  eCtrl_EventH	   = 0x01    <<  4,

  eCtrl_InSel	   = 0x00    <<  5,
  eCtrl_OutSel	   = 0x01    <<  5,

  eCtrl_IOSel0	   = ePin0   <<  6,
  eCtrl_IOSel1	   = ePin1   <<  6,
  eCtrl_IOSel2	   = ePin2   <<  6,
  eCtrl_IOSel3	   = ePin3   <<  6,

  eCtrl_IO_Low	   = 0x00    << 10,
  eCtrl_IO_Rise	   = 0x01    << 10,
  eCtrl_IO_Fall	   = 0x02    << 10,
  eCtrl_IO_High	   = 0x03    << 10,

  eCtrl_Comb_OR	   = 0x00    << 12,
  eCtrl_Comb_Match = 0x01    << 12,
  eCtrl_Comb_IO	   = 0x02    << 12,
  eCtrl_Comb_AND   = 0x03    << 12,

  eCtrl_Add	   = 0x00    << 14,
  eCtrl_Load	   = 0x01    << 14,

  eCtrl_Entry	   = eState0 << 15,
  eCtrl_State0	   = eState0 << 15,
  eCtrl_State1	   = eState1 << 15,

  eCtrl_MatchMem   = 0x01    << 20,

  eCtrl_DirBi	   = 0x00    << 21,
  eCtrl_DirUp	   = 0x01    << 21,
  eCtrl_DirDown	   = 0x02    << 21
} ;

#endif	/*__SCT_DEFS_H__	*/
