/****************************************************************************
 *   $Id:: lpc8xx_gpio.h 5137 2010-10-07 00:15:18Z nxp28433                        $
 *   Project: NXP LPC8xx software example
 *
 *   Description:
 *     This file contains definition and prototype for GPIO.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#ifndef __LPC8XX_GPIO_H 
#define __LPC8XX_GPIO_H

#define CHANNEL0	0
#define CHANNEL1	1
#define CHANNEL2	2
#define CHANNEL3	3
#define CHANNEL4	4
#define CHANNEL5	5
#define CHANNEL6	6
#define CHANNEL7	7

#define SLICE0	0
#define SLICE1	1
#define SLICE2	2
#define SLICE3	3
#define SLICE4	4
#define SLICE5	5
#define SLICE6	6
#define SLICE7	7

#define SEL_PMATCH				(0x1<<0)
#define ENA_PXEV					(0x1<<1)

#define BIT_SLICE0	8
#define BIT_SLICE1	11
#define BIT_SLICE2	14
#define BIT_SLICE3	17
#define BIT_SLICE4	20
#define BIT_SLICE5	23
#define BIT_SLICE6	26
#define BIT_SLICE7	29

#define PATTERN_CONST_1		(0x0UL)
#define PATTERN_RISING		(0x1UL)
#define PATTERN_FALLING		(0x2UL)
#define PATTERN_R_OR_F		(0x3UL)
#define PATTERN_LEVEL_HI	(0x4UL)
#define PATTERN_LEVEL_LO	(0x5UL)
#define PATTERN_CONST_0		(0x6UL)
#define PATTERN_EVENT			(0x7UL)

#define INT_CHANNEL_NUM		8

#define PORT0			0

#define DGF_CHANNEL0	6
#define DGF_CHANNEL1	5
#define DGF_CHANNEL2	4
#define DGF_CHANNEL3	3
#define DGF_CHANNEL4	2
#define DGF_CHANNEL5	1
#define DGF_CHANNEL6	0

#define DGF_CHANNEL_NUM		7

/////////////////////////////////////////////////////////////////////////////////////

// navigation control buttons		
#define BUTTEN_GREENSTART		0x840D
#define BUTTEN_UP		0x841E
#define BUTTEN_DOWN		0x841F
#define BUTTEN_LEFT		0x8420
#define BUTTEN_RIGHT		0x8421
#define BUTTEN_OK		0x8422
#define BUTTEN_BACK		0x8423
#define BUTTEN_MORE		0x840F

// transport control buttons		
#define BUTTEN_PLAY		0x8416
#define BUTTEN_PAUSE		0x8418
#define BUTTEN_STOP		0x8419
#define BUTTEN_RECORD		0x8417
#define BUTTEN_FASTFORWARD		0x8414
#define BUTTEN_REWIND		0x8415
#define BUTTEN_SKIPFORWARD		0x841A
#define BUTTEN_SKIPBACKWARD		0x841B

// audio and video control buttons		
#define BUTTEN_SLEEPTOGGLE		0x840C
#define BUTTEN_VOLUMEUP		0x8410
#define BUTTEN_VOLUMEDOWN		0x8411
#define BUTTEN_CHANNELUP		0x8412
#define BUTTEN_CHANNELDOWN		0x8413
#define BUTTEN_MUTE		0x840E
	
// numeric buttons		
#define BUTTEN_0		0x8400
#define BUTTEN_1		0x8401
#define BUTTEN_2		0x8402
#define BUTTEN_3		0x8403
#define BUTTEN_4		0x8404
#define BUTTEN_5		0x8405
#define BUTTEN_6		0x8406
#define BUTTEN_7		0x8407
#define BUTTEN_8		0x8408
#define BUTTEN_9		0x8409
#define BUTTEN_SHARP		0x841C
#define BUTTEN_STAR		0x841D
#define BUTTEN_CLEAR		0x840A
#define BUTTEN_ENTER		0x840B
	
// shortcupt buttons		
#define BUTTEN_GUIDE		0x8426
#define BUTTEN_LIVETV		0x8425
#define BUTTEN_RECORDEDTV		0x8448
#define BUTTEN_MUSIC		0x8447
#define BUTTEN_PICTURES		0x8449
#define BUTTEN_VIDEOS		0x844A
#define BUTTEN_TV		0x8446
		
// DVD buttons		
#define BUTTEN_DVDMENU		0x8424


#define BUTTEN_IDLE	0

#define PINT0_BIT	0
#define PINT1_BIT	1
#define PINT2_BIT	6
#define PINT3_BIT	7
#define PINT4_BIT	14



//////////////////////////////////////////////////////////////////////////////////////

void FLEX_INT_Handler ( uint32_t irq_num );
void FLEX_INT0_IRQHandler(void);
void FLEX_INT1_IRQHandler(void);
void FLEX_INT2_IRQHandler(void);
void FLEX_INT3_IRQHandler(void);
void FLEX_INT4_IRQHandler(void);
void FLEX_INT5_IRQHandler(void);
void FLEX_INT6_IRQHandler(void);
void FLEX_INT7_IRQHandler(void);

void GPIOInit( void );
void GPIOSetFlexInterrupt( uint32_t channelNum, uint32_t portNum, uint32_t bitPosi,
		uint32_t sense, uint32_t event );
void GPIOFlexIntEnable( uint32_t channelNum, uint32_t event );
void GPIOFlexIntDisable( uint32_t channelNum, uint32_t event );
uint32_t GPIOFlexIntStatus( uint32_t channelNum );
void GPIOFlexIntClear( uint32_t channelNum );

uint32_t GPIOGetPinValue( uint32_t portNum, uint32_t bitPosi );
void GPIOSetBitValue( uint32_t portNum, uint32_t bitPosi, uint32_t bitVal );
void GPIOSetDir( uint32_t portNum, uint32_t bitPosi, uint32_t dir );

void GPIOPatternMatchInit( void );
void GPIOSetPatternMatchInput( uint32_t channelNum, uint32_t portNum, uint32_t bitPosi );
void GPIOSetPatternMatchSlice( uint32_t channelNum, uint32_t sliceNum, uint32_t condition, uint32_t isLast );		
void GPIOPatternMatchEnable( uint32_t PMatchSel, uint32_t RxEvEna );

#endif /* end __LPC8XX_GPIO_H */
/*****************************************************************************
**                            End Of File
******************************************************************************/
