/*----------------------------------------------------------------------------
 * Name:    demo.c
 * Purpose: USB HID Demo
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2009 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#include <LPC13xx.H>                        /* LPC13xx definitions */

#include "type.h"

#include "usb.h"
#include "usbhw_LPC13xx.h"

#include "demo.h"

#include "timer.h"
#include "gpio.h"

U8 INPORT_NUM = 0;
U8 INPORT[10];
U8 InReport;                                /* HID Input Report    */
                                            /*   Bit0   : Buttons  */
                                            /*   Bit1..7: Reserved */

U8 OutReport;                               /* HID Out Report      */
                                            /*   Bit0..7: LEDs     */

/*------------------------------------------------------------------------------
  Get HID Input Report -> InReport
 *------------------------------------------------------------------------------*/
void GetInReport (void) {
  uint32_t kbd_val;

  kbd_val = LPC_GPIO0->DATA & KBD_MASK;

  InReport = 0x00;
  if ((kbd_val & KBD_BOOT) == 0) InReport |= 0x01;  /* key pressed */


}

/*------------------------------------------------------------------------------
  Main Program
 *------------------------------------------------------------------------------*/
int main (void) {
  uint32_t i;
  LPC_SYSCON->SYSAHBCLKCTRL |= 1 << 6;        /* Enable clock for GPIO              */
  LPC_GPIO0->DIR &= ~KBD_MASK;                /* Push Button on P0.1 is input       */

  SystemInit();                               /* initialize clocks */

  USB_Init();                                 /* USB Initialization */
  USB_Connect(__TRUE);                        /* USB Connect */

	GPIO_Init();
	Timer32B0_Init();
	Reset_IR();

  while (1);                                  /* Loop forever */
}
