/*
 * @brief UART interrupt example with ring buffers
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2012
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "chip.h"
#include "board.h"
#include "string.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/
#define WKT_FLAG (0x1<<1)

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/

/*****************************************************************************
 * Public functions
 ****************************************************************************/
void WKT_IRQHandler(void)
{
  if (LPC_WKT->CTRL & WKT_FLAG )
  {
  Chip_WKT_ClearIntStatus(LPC_WKT);		/* clear interrupt flag */
  }
  return;
}


void delay (void) {
  unsigned int i;

  for (i = 0; i < 0x80000; i++) {
  }
}

/**
 * @brief	main routine for blinky example
 * @return	Function should not exit.
 */

int main(void)
{

  uint32_t regVal;

  SystemCoreClockUpdate();
  Board_Init();

  /* Setup FLASH access to 1 CPU clock  */
  Chip_FMC_SetFLASHAccess(FLASHTIM_20MHZ_CPU);

  Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_GPIO);	

  Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);

  /*Enable clock to SWM*/
  Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_SWM);

  /*Peripheral reset control to GPIO and GPIO INT, a "1" bring it out of reset. */
  Chip_SYSCTL_PeriphReset(RESET_GPIO);

  /*Check deep power down bits. If deep power down mode is entered, clear the PCON bits. */
  if ( (LPC_PMU->PCON & (0x1<<11)) != 0x0 )
  {
    regVal = LPC_PMU->PCON;
    regVal |= (0x1<<11);
    LPC_PMU->PCON = regVal;

  /*check if general purpose retained data*/
  if 	((Chip_PMU_ReadGPREG(LPC_PMU,0) != 0x12345678)||
        (Chip_PMU_ReadGPREG(LPC_PMU, 1) != 0x87654321)||
        (Chip_PMU_ReadGPREG(LPC_PMU, 2) != 0x56781234)||
        (Chip_PMU_ReadGPREG(LPC_PMU, 3) != 0x43218765) )
    {
      while (1);
    }
  }		

  else
  {
  /*Store critical data in general purpose registers*/
    Chip_PMU_WriteGPREG(LPC_PMU, 0, 0x12345678);
    Chip_PMU_WriteGPREG(LPC_PMU, 1, 0x87654321);
    Chip_PMU_WriteGPREG(LPC_PMU, 2, 0x56781234);
    Chip_PMU_WriteGPREG(LPC_PMU, 3, 0x43218765);

  /*enable the wake-up timer and disable the wakeup pin functionality on PIO0_4*/

    Chip_PMU_SetPowerDownControl(LPC_PMU, 0xF);			
    
    Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_WKT);
    Chip_SYSCTL_PeriphReset(RESET_WKT);
    
    Chip_WKT_Start(LPC_WKT, WKT_CLKSRC_10KHZ, 10000 * 10);
    
    NVIC_EnableIRQ(WKT_IRQn);
                  
   /*set the deep sleep bit*/
  //SCB->SCR |= 0x4;
                  
   /*set deep power-down mode*/
   //LPC_PMU->PCON = 0x3;

   /*call ARM WFI instruction*/
  //__WFI();
                  
   Chip_PMU_DeepPowerDownState(LPC_PMU);
                  
   }

  /* Set port p0.7 to output */
  Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 7);

  while (1)                             
  {
    for (;;) 
     { 		
       Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 7); 
       delay();
       Chip_GPIO_SetPinOutLow(LPC_GPIO_PORT, 0, 7); 
       delay();
     }
  }

}

