/******************************************************************************
*  Gesture_Recognition.h
*
*   This file has declarations of gesture recognition library routines and
*   data structures that are used by user applications.
*   These routines and structures activate/deactivate the Gesture Recognition
*   library under control of a host application layer.
*
*    copyright NXP Semiconductors 2015 (C)
*
******************************************************************************/

typedef struct {
	uint16_t index;                                 // position index number
        uint8_t  x;                                     // x coordinate
	uint8_t  y;                                     // y coordinate
} TOUCH_DAT_T;

typedef struct {
	uint16_t version;                               // gesture library version number
        uint8_t  nr_of_gestures;                        // number of gestures inside training set
	uint8_t  *trs;                                  // pointer to training set memory location
} GESTURE_T;

extern GESTURE_T  gr;                                   // pointer to gesture recogniton configuration

extern void       Gesture_Init(void);
extern uint8_t    Gesture_Task(TOUCH_DAT_T *td);
