/***********************************************************************
 * $Id::       $
 *
 * Project:
 *
 * Description:
 *     This file contains CRC32 routines.
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *********************************************************************/

#ifndef CRC_DRV_H
#define CRC_DRV_H
/*************************************************************************
* INCLUDES
*************************************************************************/
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Global & Module includes */

/* Other includes */

/*************************************************************************
* DEFINES
*************************************************************************/

/*************************************************************************
* TYPEDEFS
*************************************************************************/

/*************************************************************************
* GLOBALS
*************************************************************************/

/*************************************************************************
* STATICS
*************************************************************************/

/*************************************************************************
* Function            : CRC32_Initialise
* Description         : Initialize a CRC computation
* input parameters    : Pointer to CRC storage location
*                       length of block
* return parameter    : CRC
*
*************************************************************************/

extern void CRC32_Initialise (uint32_t *CRC);

/*************************************************************************
* Function            : CRC32_Generate
* Description         : compute a CRC on memory block
* input parameters    : Pointer to CRC storage location
*                       Pointer to starting of memory block
*                       length of block
* return parameter    : CRC
*
*************************************************************************/

extern void CRC32_Generate   (uint32_t *CRC, unsigned char *Data, int Length);

/*************************************************************************
* Function            : CRC32_Complete
* Description         : Completes a CRC computation
* input parameters    :
*
* return parameter    : CRC
*
*************************************************************************/
extern void CRC32_Complete   (uint32_t *CRC);

/*************************************************************************
* Function            : CRC32_Compute
* Description         : compute a CRC on memory block
*                       Initialise/Generate/Completes
* input parameters    : Pointer to starting of memory block
*                       length of block
* return parameter    : CRC
*
*************************************************************************/
extern uint32_t  CRC32_Compute(uint8_t *StartingPoint, int size);

#ifdef __cplusplus
}
#endif

#endif	// CRC_DRV_H
