/*
 * @brief LPC Secondary boot loader FLASH support functions
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2017
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licenser disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */
#ifndef __SBL_LPC_H__
#define __SBL_LPC_H__

#include <stdint.h>

extern volatile uint32_t gLPCFlashSize;
extern volatile uint32_t gLPCdualImageBoundary;
extern volatile uint32_t gLPCflashOffset;

extern uint32_t LPC_SBL_GetFlashSize(void);
extern uint32_t LPC_SBL_GetDualImgBoundary(void);
extern uint32_t LPC_SBL_VectCheckSum(uint32_t *vector);
extern void     LPC_SBL_BootImageCheck(void);
extern void     LPC_SBL_CalFlashSize(void);

extern void     LPC_SBL_CleanUpSystem(void);

#endif
// __SBL_LPC_H__ end 
// end file
