/*
 * @brief Secondary loader protocol structures and manifest constants
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */
#ifndef _SL_PROTOCOL_H_
#define _SL_PROTOCOL_H_

#include <stdint.h>
#include <string.h>

#include "sl_common.h"
#include "app_usbd_cfg.h"

#ifdef __cplusplus
extern "C" {
#endif


/** @defgroup SL_PROTOCOL : Secondary Loader Protocol structures
 * @ingroup SENSOR_HUB
 * @{
 */
// define for LPC11U6X
/* Address of where the boot-able application is located in FLASH */
#define SL_APP_START_ADDR			0x00002000

#define SL_FLASH_BLOCK_SZ           0x200		/*!< Block size */
#define SL_FLASH_PAGE_SZ            0x100		/*!< Size of the flash page. */

#define SL_FLASH_SECT_SZ			(4*1024)
#define SL_FLASH_SECTLRG_SZ			(32*1024)
#define SL_FLASH_SECT_CNT			24			/* count of small (4kB) sectors */
#define SL_FLASH_LRGSECT_ADDR		0x18000		/* (SL_FLASH_SECT_SZ * SL_FLASH_SECT_CNT) */
#define SL_FLASH_END                0x40000		/*!< Total size of the flash. */

/* Offset in application where the IMG_HEADER_T is stored */
#define SL_BOOTAPP_IMGHDR_OFS       0x100
#define IMG_HEADER_MARKER           0xFEEDA5A5

/** Image type enum */
typedef enum {
	IMG_NORMAL     = 0,		                 /*!< Normal image check IRQ line to halt boot. */
	IMG_NO_CRC,			                     /*!< No CRC checks needed. Used during development. */
	DFU_SBL_UPDATE = 0x99,
} SL_IMAGE_T;

/** Image header structure. All application images should define this structure at of offset 0x100.
 *	Adding it to the start-up file is recommended.
 */
typedef struct _IMG_HEADER_T {
	uint32_t header_marker;						/*!< Image header marker should always be set to 0xFEEDA5A5 */
	uint32_t img_type;                          /*!< Image type  */
	uint32_t reserve;                           /*!< reserve */
	const uint32_t crc_len;						/*!< Image length or the length of image CRC check should be done. For faster boot application could set a smaller length than actual image */
	const uint32_t crc_value;					/*!< CRC vale  */
	const uint32_t userFmwrVersion;	            /*!< Image version */
} IMG_HEADER_T;

#ifdef WIN32
typedef void (*IAP_ENTRY_T)(uint32_t[5], uint32_t[4]);
typedef unsigned char bool_8;
#define STATIC static
#define INLINE
#endif

/* Address of indtrect boot table */
#define SL_INDIRECT_FUNC_TABLE      (0x0000D000) // (0x00001F00)
#define SL_IAP_ENTRY                (SL_INDIRECT_FUNC_TABLE + 0x4)

/* Placement addresses for app call flag and app supplied config data
   for host interface pins. Note these addresses may be used in the
   startup code source and may need values changed there also. */
// define for LPC11U6x
#define SL_ADDRESS_APPCALLEDFL      (0x10000000)
#define SL_ADDRESS_APPPINDATA       (0x10000004)


/**
 * @}
 */

#ifdef __cplusplus
}
#endif

#endif  /* _SL_PROTOCOL_H_ */
