/*
*
* brief: vector_redirection.c
* This file contains the routine to redirect each vector from SBL to the application image's vector table
*
*/


#include "chip.h"

#include "sl_common.h"
#include "sl_protocol.h"

#include "sbl_lpc.h"

/* Function to redirect every vector in the vector table */
void vector_redirect(void)
{
  typedef  void (*pFunction)(void);

  pFunction Jump_To_Application;
  volatile uint32_t JumpAddress;
  volatile uint32_t i;

  /* Getting interrupt status from Interrupt Program and Status register */
  i = __get_IPSR();   
  /* Based on the value of 'i' the corresponding vector is redirected to Application  Image vector table */
  JumpAddress = *(__IO uint32_t *)(Chip_PMU_ReadGPREG(LPC_PMU, 3) + (4 * i));
  Jump_To_Application = (pFunction) JumpAddress;
  Jump_To_Application();
  /* Should not come back here */
}

/* Function to common handler in the vector table */
void Common_Handler(void)
{
  typedef  void (*pFunction)(void);

  pFunction Jump_To_Application;
  volatile uint32_t JumpAddress;
  volatile uint32_t i;

  /* Getting interrupt status from Interrupt Program and Status register */
  i = __get_IPSR();
  /* Based on the value of 'i' the corresponding vector is redirected to Application  Image vector table */
  JumpAddress = *(__IO uint32_t *)(Chip_PMU_ReadGPREG(LPC_PMU, 3) + (4 * i));
  Jump_To_Application = (pFunction) JumpAddress;
  Jump_To_Application();
  /* Should not come back here */
}

// end file
