/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v3.0
processor: LPC54114J256
package_id: LPC54114J256BD64
mcu_data: ksdk2_0
processor_version: 2.0.0
board: LPCXpresso54114
pin_labels:
- {pin_num: '11', pin_signal: PIO0_29/FC1_RXD_SDA_MOSI/SCT0_OUT2/CTIMER0_MAT3/CTIMER0_CAP1/CTIMER0_MAT1/ADC0_0, label: 'J2[5]/D2[1]/P0_29-CT32B0_MAT3-RED', identifier: UART1_RX}
- {pin_num: '12', pin_signal: PIO0_30/FC1_TXD_SCL_MISO/SCT0_OUT3/CTIMER0_MAT2/CTIMER0_CAP2/ADC0_1, label: 'J9[2]/P0_30-ADC1', identifier: UART1_TX}
- {pin_num: '15', pin_signal: PIO1_1/SWO/SCT0_OUT4/FC5_SSEL2/FC4_TXD_SCL_MISO/ADC0_4, label: 'J1[15]/P1_1-FC5_SSEL2', identifier: UART4_TX}
- {pin_num: '16', pin_signal: PIO1_2/MCLK/FC7_SSEL3/SCT0_OUT5/FC5_SSEL3/FC4_RXD_SDA_MOSI/ADC0_5, label: 'J9[7]/JS8[1]/U5[1]/P1_2-FC5_SSEL3', identifier: UART4_RX}
- {pin_num: '27', pin_signal: PIO1_7/FC7_RXD_SDA_MOSI_DATA/CTIMER1_MAT2/CTIMER1_CAP2/ADC0_10, label: 'J1[10]/P1_7-FC7_RXD_SDA_MOSI_DATA', identifier: UART7_RX}
- {pin_num: '28', pin_signal: PIO1_8/FC7_TXD_SCL_MISO_WS/CTIMER1_MAT3/CTIMER1_CAP3/ADC0_11, label: 'J1[12]/J9[6]/P1_8-ADC11-FC7_TXD_SCL_MISO_FRAME', identifier: UART7_TX}
- {pin_num: '30', pin_signal: PIO1_10/FC6_TXD_SCL_MISO_WS/SCT0_OUT4/FC1_SCK/USB0_FRAME, label: 'J9[8]/D2[4]/P1_10-SCT4-LED_GREEN', identifier: UART6_TX}
- {pin_num: '44', pin_signal: PIO0_9/FC2_TXD_SCL_MISO/SCT0_OUT2/CTIMER3_CAP0/FC3_CTS_SDA_SSEL0, label: 'J2[13]/P0_9-FC2_TXD_SCL_MISO', identifier: UART2_TX}
- {pin_num: '46', pin_signal: PIO0_11/FC3_SCK/FC6_RXD_SDA_MOSI_DATA/CTIMER2_MAT1, label: 'J4[4]/U9[13]/BRIDGE_T_SCK', identifier: UART6_RX}
- {pin_num: '47', pin_signal: PIO0_12/FC3_RXD_SDA_MOSI/FC6_TXD_SCL_MISO_WS/CTIMER2_MAT3, label: 'J4[2]/U9[11]/BRIDGE_T_MOSI', identifier: UART3_RX}
- {pin_num: '48', pin_signal: PIO0_13/FC3_TXD_SCL_MISO/SCT0_OUT4/CTIMER2_MAT0, label: 'J4[3]/U15[4]/BRIDGE_T_MISO', identifier: UART3_TX}
- {pin_num: '51', pin_signal: PIO1_12/FC5_RXD_SDA_MOSI/CTIMER1_MAT0/FC7_SCK/UTICK_CAP2, label: 'J2[9]/P1_12-CT32B1_MAT0-ACCl_INT1', identifier: UART5_RX}
- {pin_num: '54', pin_signal: PIO1_13/FC5_TXD_SCL_MISO/CTIMER1_MAT1/FC7_RXD_SDA_MOSI_DATA, label: 'J2[7]/P1_13-CT32B1_MAT1', identifier: UART5_TX}
- {pin_num: '57', pin_signal: PIO1_14/FC2_RXD_SDA_MOSI/SCT0_OUT7/FC7_TXD_SCL_MISO_WS, label: 'J2[1]/P1_14-SCTO7', identifier: UART2_RX}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

#include "fsl_common.h"
#include "pin_mux.h"

/*FUNCTION**********************************************************************
 * 
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 * 
 *END**************************************************************************/
void BOARD_InitBootPins(void) {
    BOARD_InitPins();
}

#define PIO00_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO00_FUNC_ALT1               0x01u   /*!< Selects pin function.: Alternative connection 1. */
#define PIO00_MODE_INACTIVE           0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO011_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO011_FUNC_ALT2              0x02u   /*!< Selects pin function.: Alternative connection 2. */
#define PIO011_MODE_INACTIVE          0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO012_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO012_FUNC_ALT1              0x01u   /*!< Selects pin function.: Alternative connection 1. */
#define PIO012_MODE_INACTIVE          0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO013_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO013_FUNC_ALT1              0x01u   /*!< Selects pin function.: Alternative connection 1. */
#define PIO013_MODE_INACTIVE          0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO01_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO01_FUNC_ALT1               0x01u   /*!< Selects pin function.: Alternative connection 1. */
#define PIO01_MODE_INACTIVE           0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO029_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO029_FUNC_ALT1              0x01u   /*!< Selects pin function.: Alternative connection 1. */
#define PIO029_MODE_INACTIVE          0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO030_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO030_FUNC_ALT1              0x01u   /*!< Selects pin function.: Alternative connection 1. */
#define PIO030_MODE_INACTIVE          0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO09_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO09_FUNC_ALT1               0x01u   /*!< Selects pin function.: Alternative connection 1. */
#define PIO09_MODE_INACTIVE           0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO110_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO110_FUNC_ALT2              0x02u   /*!< Selects pin function.: Alternative connection 2. */
#define PIO110_MODE_INACTIVE          0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO112_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO112_FUNC_ALT2              0x02u   /*!< Selects pin function.: Alternative connection 2. */
#define PIO112_MODE_INACTIVE          0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO113_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO113_FUNC_ALT2              0x02u   /*!< Selects pin function.: Alternative connection 2. */
#define PIO113_MODE_INACTIVE          0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO114_DIGIMODE_DIGITAL       0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO114_FUNC_ALT2              0x02u   /*!< Selects pin function.: Alternative connection 2. */
#define PIO114_MODE_INACTIVE          0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO11_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO11_FUNC_ALT5               0x05u   /*!< Selects pin function.: Alternative connection 5. */
#define PIO11_MODE_INACTIVE           0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO12_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO12_FUNC_ALT5               0x05u   /*!< Selects pin function.: Alternative connection 5. */
#define PIO12_MODE_INACTIVE           0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO17_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO17_FUNC_ALT2               0x02u   /*!< Selects pin function.: Alternative connection 2. */
#define PIO17_MODE_INACTIVE           0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
#define PIO18_DIGIMODE_DIGITAL        0x01u   /*!< Select Analog/Digital mode.: Digital mode. */
#define PIO18_FUNC_ALT2               0x02u   /*!< Selects pin function.: Alternative connection 2. */
#define PIO18_MODE_INACTIVE           0x00u   /*!< Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm4, enableClock: 'true'}
- pin_list:
  - {pin_num: '31', peripheral: FLEXCOMM0, signal: RXD_SDA_MOSI, pin_signal: PIO0_0/FC0_RXD_SDA_MOSI/FC3_CTS_SDA_SSEL0/CTIMER0_CAP0/SCT0_OUT3, mode: inactive}
  - {pin_num: '11', peripheral: FLEXCOMM1, signal: RXD_SDA_MOSI, pin_signal: PIO0_29/FC1_RXD_SDA_MOSI/SCT0_OUT2/CTIMER0_MAT3/CTIMER0_CAP1/CTIMER0_MAT1/ADC0_0, mode: inactive}
  - {pin_num: '12', peripheral: FLEXCOMM1, signal: TXD_SCL_MISO, pin_signal: PIO0_30/FC1_TXD_SCL_MISO/SCT0_OUT3/CTIMER0_MAT2/CTIMER0_CAP2/ADC0_1, mode: inactive}
  - {pin_num: '44', peripheral: FLEXCOMM2, signal: TXD_SCL_MISO, pin_signal: PIO0_9/FC2_TXD_SCL_MISO/SCT0_OUT2/CTIMER3_CAP0/FC3_CTS_SDA_SSEL0, mode: inactive}
  - {pin_num: '57', peripheral: FLEXCOMM2, signal: RXD_SDA_MOSI, pin_signal: PIO1_14/FC2_RXD_SDA_MOSI/SCT0_OUT7/FC7_TXD_SCL_MISO_WS, mode: inactive}
  - {pin_num: '47', peripheral: FLEXCOMM3, signal: RXD_SDA_MOSI, pin_signal: PIO0_12/FC3_RXD_SDA_MOSI/FC6_TXD_SCL_MISO_WS/CTIMER2_MAT3, mode: inactive}
  - {pin_num: '48', peripheral: FLEXCOMM3, signal: TXD_SCL_MISO, pin_signal: PIO0_13/FC3_TXD_SCL_MISO/SCT0_OUT4/CTIMER2_MAT0, mode: inactive}
  - {pin_num: '16', peripheral: FLEXCOMM4, signal: RXD_SDA_MOSI, pin_signal: PIO1_2/MCLK/FC7_SSEL3/SCT0_OUT5/FC5_SSEL3/FC4_RXD_SDA_MOSI/ADC0_5, mode: inactive}
  - {pin_num: '15', peripheral: FLEXCOMM4, signal: TXD_SCL_MISO, pin_signal: PIO1_1/SWO/SCT0_OUT4/FC5_SSEL2/FC4_TXD_SCL_MISO/ADC0_4, mode: inactive}
  - {pin_num: '51', peripheral: FLEXCOMM5, signal: RXD_SDA_MOSI, pin_signal: PIO1_12/FC5_RXD_SDA_MOSI/CTIMER1_MAT0/FC7_SCK/UTICK_CAP2, mode: inactive}
  - {pin_num: '54', peripheral: FLEXCOMM5, signal: TXD_SCL_MISO, pin_signal: PIO1_13/FC5_TXD_SCL_MISO/CTIMER1_MAT1/FC7_RXD_SDA_MOSI_DATA, mode: inactive}
  - {pin_num: '46', peripheral: FLEXCOMM6, signal: RXD_SDA_MOSI_DATA, pin_signal: PIO0_11/FC3_SCK/FC6_RXD_SDA_MOSI_DATA/CTIMER2_MAT1, mode: inactive}
  - {pin_num: '30', peripheral: FLEXCOMM6, signal: TXD_SCL_MISO_WS, pin_signal: PIO1_10/FC6_TXD_SCL_MISO_WS/SCT0_OUT4/FC1_SCK/USB0_FRAME, mode: inactive}
  - {pin_num: '27', peripheral: FLEXCOMM7, signal: RXD_SDA_MOSI_DATA, pin_signal: PIO1_7/FC7_RXD_SDA_MOSI_DATA/CTIMER1_MAT2/CTIMER1_CAP2/ADC0_10, mode: inactive}
  - {pin_num: '28', peripheral: FLEXCOMM7, signal: TXD_SCL_MISO_WS, pin_signal: PIO1_8/FC7_TXD_SCL_MISO_WS/CTIMER1_MAT3/CTIMER1_CAP3/ADC0_11, mode: inactive}
  - {pin_num: '32', peripheral: FLEXCOMM0, signal: TXD_SCL_MISO, pin_signal: PIO0_1/FC0_TXD_SCL_MISO/FC3_RTS_SCL_SSEL1/CTIMER0_CAP1/SCT0_OUT1, mode: inactive}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/*FUNCTION**********************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 *END**************************************************************************/
void BOARD_InitPins(void) { /* Function assigned for the Cortex-M0P */
  CLOCK_EnableClock(kCLOCK_Iocon);                           /* Enables the clock for the IOCON block. 0 = Disable; 1 = Enable.: 0x01u */

  IOCON->PIO[0][0] = ((IOCON->PIO[0][0] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO00_FUNC_ALT1)                      /* Selects pin function.: PORT00 (pin 31) is configured as FC0_RXD_SDA_MOSI */
      | IOCON_PIO_MODE(PIO00_MODE_INACTIVE)                  /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO00_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][1] = ((IOCON->PIO[0][1] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO01_FUNC_ALT1)                      /* Selects pin function.: PORT01 (pin 32) is configured as FC0_TXD_SCL_MISO */
      | IOCON_PIO_MODE(PIO01_MODE_INACTIVE)                  /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO01_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][11] = ((IOCON->PIO[0][11] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO011_FUNC_ALT2)                     /* Selects pin function.: PORT011 (pin 46) is configured as FC6_RXD_SDA_MOSI_DATA */
      | IOCON_PIO_MODE(PIO011_MODE_INACTIVE)                 /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO011_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][12] = ((IOCON->PIO[0][12] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO012_FUNC_ALT1)                     /* Selects pin function.: PORT012 (pin 47) is configured as FC3_RXD_SDA_MOSI */
      | IOCON_PIO_MODE(PIO012_MODE_INACTIVE)                 /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO012_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][13] = ((IOCON->PIO[0][13] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO013_FUNC_ALT1)                     /* Selects pin function.: PORT013 (pin 48) is configured as FC3_TXD_SCL_MISO */
      | IOCON_PIO_MODE(PIO013_MODE_INACTIVE)                 /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO013_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][29] = ((IOCON->PIO[0][29] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO029_FUNC_ALT1)                     /* Selects pin function.: PORT029 (pin 11) is configured as FC1_RXD_SDA_MOSI */
      | IOCON_PIO_MODE(PIO029_MODE_INACTIVE)                 /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO029_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][30] = ((IOCON->PIO[0][30] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO030_FUNC_ALT1)                     /* Selects pin function.: PORT030 (pin 12) is configured as FC1_TXD_SCL_MISO */
      | IOCON_PIO_MODE(PIO030_MODE_INACTIVE)                 /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO030_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[0][9] = ((IOCON->PIO[0][9] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO09_FUNC_ALT1)                      /* Selects pin function.: PORT09 (pin 44) is configured as FC2_TXD_SCL_MISO */
      | IOCON_PIO_MODE(PIO09_MODE_INACTIVE)                  /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO09_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][1] = ((IOCON->PIO[1][1] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO11_FUNC_ALT5)                      /* Selects pin function.: PORT11 (pin 15) is configured as FC4_TXD_SCL_MISO */
      | IOCON_PIO_MODE(PIO11_MODE_INACTIVE)                  /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO11_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][10] = ((IOCON->PIO[1][10] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO110_FUNC_ALT2)                     /* Selects pin function.: PORT110 (pin 30) is configured as FC6_TXD_SCL_MISO_WS */
      | IOCON_PIO_MODE(PIO110_MODE_INACTIVE)                 /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO110_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][12] = ((IOCON->PIO[1][12] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO112_FUNC_ALT2)                     /* Selects pin function.: PORT112 (pin 51) is configured as FC5_RXD_SDA_MOSI */
      | IOCON_PIO_MODE(PIO112_MODE_INACTIVE)                 /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO112_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][13] = ((IOCON->PIO[1][13] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO113_FUNC_ALT2)                     /* Selects pin function.: PORT113 (pin 54) is configured as FC5_TXD_SCL_MISO */
      | IOCON_PIO_MODE(PIO113_MODE_INACTIVE)                 /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO113_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][14] = ((IOCON->PIO[1][14] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO114_FUNC_ALT2)                     /* Selects pin function.: PORT114 (pin 57) is configured as FC2_RXD_SDA_MOSI */
      | IOCON_PIO_MODE(PIO114_MODE_INACTIVE)                 /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO114_DIGIMODE_DIGITAL)          /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][2] = ((IOCON->PIO[1][2] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO12_FUNC_ALT5)                      /* Selects pin function.: PORT12 (pin 16) is configured as FC4_RXD_SDA_MOSI */
      | IOCON_PIO_MODE(PIO12_MODE_INACTIVE)                  /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO12_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][7] = ((IOCON->PIO[1][7] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO17_FUNC_ALT2)                      /* Selects pin function.: PORT17 (pin 27) is configured as FC7_RXD_SDA_MOSI_DATA */
      | IOCON_PIO_MODE(PIO17_MODE_INACTIVE)                  /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO17_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
  IOCON->PIO[1][8] = ((IOCON->PIO[1][8] &
    (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK))) /* Mask bits to zero which are setting */
      | IOCON_PIO_FUNC(PIO18_FUNC_ALT2)                      /* Selects pin function.: PORT18 (pin 28) is configured as FC7_TXD_SCL_MISO_WS */
      | IOCON_PIO_MODE(PIO18_MODE_INACTIVE)                  /* Selects function mode (on-chip pull-up/pull-down resistor control).: Inactive. Inactive (no pull-down/pull-up resistor enabled). */
      | IOCON_PIO_DIGIMODE(PIO18_DIGIMODE_DIGITAL)           /* Select Analog/Digital mode.: Digital mode. */
    );
}

/*******************************************************************************
 * EOF
 ******************************************************************************/
