#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_


/*******************************************************************************
 * Definitions
 ******************************************************************************/  

/*! @brief Direction type  */
typedef enum _pin_mux_direction
{
  kPIN_MUX_DirectionInput = 0U,         /* Input direction */
  kPIN_MUX_DirectionOutput = 1U,        /* Output direction */
  kPIN_MUX_DirectionInputOrOutput = 2U  /* Input or output direction */
} pin_mux_direction_t;

/*!
 * @addtogroup pin_mux
 * @{
 */

/*******************************************************************************
 * API
 ******************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Calls initialization functions.
 *
 */
void BOARD_InitBootPins(void);

/* FC0_RXD_SDA_MOSI (number 31), U18[4]/TO_MUX_P0_0-ISP_RX */
#define BOARD_INITPINS_DEBUG_UART_RX_PERIPHERAL                        FLEXCOMM0   /*!< Device name: FLEXCOMM0 */
#define BOARD_INITPINS_DEBUG_UART_RX_SIGNAL                         RXD_SDA_MOSI   /*!< FLEXCOMM0 signal: RXD_SDA_MOSI */
#define BOARD_INITPINS_DEBUG_UART_RX_PIN_NAME                   FC0_RXD_SDA_MOSI   /*!< Pin name */
#define BOARD_INITPINS_DEBUG_UART_RX_LABEL           "U18[4]/TO_MUX_P0_0-ISP_RX"   /*!< Label */
#define BOARD_INITPINS_DEBUG_UART_RX_NAME                        "DEBUG_UART_RX"   /*!< Identifier name */

/* FC1_RXD_SDA_MOSI (number 11), J2[5]/D2[1]/P0_29-CT32B0_MAT3-RED */
#define BOARD_INITPINS_UART1_RX_PERIPHERAL                             FLEXCOMM1   /*!< Device name: FLEXCOMM1 */
#define BOARD_INITPINS_UART1_RX_SIGNAL                              RXD_SDA_MOSI   /*!< FLEXCOMM1 signal: RXD_SDA_MOSI */
#define BOARD_INITPINS_UART1_RX_PIN_NAME                        FC1_RXD_SDA_MOSI   /*!< Pin name */
#define BOARD_INITPINS_UART1_RX_LABEL        "J2[5]/D2[1]/P0_29-CT32B0_MAT3-RED"   /*!< Label */
#define BOARD_INITPINS_UART1_RX_NAME                                  "UART1_RX"   /*!< Identifier name */

/* FC1_TXD_SCL_MISO (number 12), J9[2]/P0_30-ADC1 */
#define BOARD_INITPINS_UART1_TX_PERIPHERAL                             FLEXCOMM1   /*!< Device name: FLEXCOMM1 */
#define BOARD_INITPINS_UART1_TX_SIGNAL                              TXD_SCL_MISO   /*!< FLEXCOMM1 signal: TXD_SCL_MISO */
#define BOARD_INITPINS_UART1_TX_PIN_NAME                        FC1_TXD_SCL_MISO   /*!< Pin name */
#define BOARD_INITPINS_UART1_TX_LABEL                         "J9[2]/P0_30-ADC1"   /*!< Label */
#define BOARD_INITPINS_UART1_TX_NAME                                  "UART1_TX"   /*!< Identifier name */

/* FC2_TXD_SCL_MISO (number 44), J2[13]/P0_9-FC2_TXD_SCL_MISO */
#define BOARD_INITPINS_UART2_TX_PERIPHERAL                             FLEXCOMM2   /*!< Device name: FLEXCOMM2 */
#define BOARD_INITPINS_UART2_TX_SIGNAL                              TXD_SCL_MISO   /*!< FLEXCOMM2 signal: TXD_SCL_MISO */
#define BOARD_INITPINS_UART2_TX_PIN_NAME                        FC2_TXD_SCL_MISO   /*!< Pin name */
#define BOARD_INITPINS_UART2_TX_LABEL             "J2[13]/P0_9-FC2_TXD_SCL_MISO"   /*!< Label */
#define BOARD_INITPINS_UART2_TX_NAME                                  "UART2_TX"   /*!< Identifier name */

/* FC2_RXD_SDA_MOSI (number 57), J2[1]/P1_14-SCTO7 */
#define BOARD_INITPINS_UART2_RX_PERIPHERAL                             FLEXCOMM2   /*!< Device name: FLEXCOMM2 */
#define BOARD_INITPINS_UART2_RX_SIGNAL                              RXD_SDA_MOSI   /*!< FLEXCOMM2 signal: RXD_SDA_MOSI */
#define BOARD_INITPINS_UART2_RX_PIN_NAME                        FC2_RXD_SDA_MOSI   /*!< Pin name */
#define BOARD_INITPINS_UART2_RX_LABEL                        "J2[1]/P1_14-SCTO7"   /*!< Label */
#define BOARD_INITPINS_UART2_RX_NAME                                  "UART2_RX"   /*!< Identifier name */

/* FC3_RXD_SDA_MOSI (number 47), J4[2]/U9[11]/BRIDGE_T_MOSI */
#define BOARD_INITPINS_UART3_RX_PERIPHERAL                             FLEXCOMM3   /*!< Device name: FLEXCOMM3 */
#define BOARD_INITPINS_UART3_RX_SIGNAL                              RXD_SDA_MOSI   /*!< FLEXCOMM3 signal: RXD_SDA_MOSI */
#define BOARD_INITPINS_UART3_RX_PIN_NAME                        FC3_RXD_SDA_MOSI   /*!< Pin name */
#define BOARD_INITPINS_UART3_RX_LABEL               "J4[2]/U9[11]/BRIDGE_T_MOSI"   /*!< Label */
#define BOARD_INITPINS_UART3_RX_NAME                                  "UART3_RX"   /*!< Identifier name */

/* FC3_TXD_SCL_MISO (number 48), J4[3]/U15[4]/BRIDGE_T_MISO */
#define BOARD_INITPINS_UART3_TX_PERIPHERAL                             FLEXCOMM3   /*!< Device name: FLEXCOMM3 */
#define BOARD_INITPINS_UART3_TX_SIGNAL                              TXD_SCL_MISO   /*!< FLEXCOMM3 signal: TXD_SCL_MISO */
#define BOARD_INITPINS_UART3_TX_PIN_NAME                        FC3_TXD_SCL_MISO   /*!< Pin name */
#define BOARD_INITPINS_UART3_TX_LABEL               "J4[3]/U15[4]/BRIDGE_T_MISO"   /*!< Label */
#define BOARD_INITPINS_UART3_TX_NAME                                  "UART3_TX"   /*!< Identifier name */

/* FC4_RXD_SDA_MOSI (number 16), J9[7]/JS8[1]/U5[1]/P1_2-FC5_SSEL3 */
#define BOARD_INITPINS_UART4_RX_PERIPHERAL                             FLEXCOMM4   /*!< Device name: FLEXCOMM4 */
#define BOARD_INITPINS_UART4_RX_SIGNAL                              RXD_SDA_MOSI   /*!< FLEXCOMM4 signal: RXD_SDA_MOSI */
#define BOARD_INITPINS_UART4_RX_PIN_NAME                        FC4_RXD_SDA_MOSI   /*!< Pin name */
#define BOARD_INITPINS_UART4_RX_LABEL        "J9[7]/JS8[1]/U5[1]/P1_2-FC5_SSEL3"   /*!< Label */
#define BOARD_INITPINS_UART4_RX_NAME                                  "UART4_RX"   /*!< Identifier name */

/* FC4_TXD_SCL_MISO (number 15), J1[15]/P1_1-FC5_SSEL2 */
#define BOARD_INITPINS_UART4_TX_PERIPHERAL                             FLEXCOMM4   /*!< Device name: FLEXCOMM4 */
#define BOARD_INITPINS_UART4_TX_SIGNAL                              TXD_SCL_MISO   /*!< FLEXCOMM4 signal: TXD_SCL_MISO */
#define BOARD_INITPINS_UART4_TX_PIN_NAME                        FC4_TXD_SCL_MISO   /*!< Pin name */
#define BOARD_INITPINS_UART4_TX_LABEL                    "J1[15]/P1_1-FC5_SSEL2"   /*!< Label */
#define BOARD_INITPINS_UART4_TX_NAME                                  "UART4_TX"   /*!< Identifier name */

/* FC5_RXD_SDA_MOSI (number 51), J2[9]/P1_12-CT32B1_MAT0-ACCl_INT1 */
#define BOARD_INITPINS_UART5_RX_PERIPHERAL                             FLEXCOMM5   /*!< Device name: FLEXCOMM5 */
#define BOARD_INITPINS_UART5_RX_SIGNAL                              RXD_SDA_MOSI   /*!< FLEXCOMM5 signal: RXD_SDA_MOSI */
#define BOARD_INITPINS_UART5_RX_PIN_NAME                        FC5_RXD_SDA_MOSI   /*!< Pin name */
#define BOARD_INITPINS_UART5_RX_LABEL        "J2[9]/P1_12-CT32B1_MAT0-ACCl_INT1"   /*!< Label */
#define BOARD_INITPINS_UART5_RX_NAME                                  "UART5_RX"   /*!< Identifier name */

/* FC5_TXD_SCL_MISO (number 54), J2[7]/P1_13-CT32B1_MAT1 */
#define BOARD_INITPINS_UART5_TX_PERIPHERAL                             FLEXCOMM5   /*!< Device name: FLEXCOMM5 */
#define BOARD_INITPINS_UART5_TX_SIGNAL                              TXD_SCL_MISO   /*!< FLEXCOMM5 signal: TXD_SCL_MISO */
#define BOARD_INITPINS_UART5_TX_PIN_NAME                        FC5_TXD_SCL_MISO   /*!< Pin name */
#define BOARD_INITPINS_UART5_TX_LABEL                  "J2[7]/P1_13-CT32B1_MAT1"   /*!< Label */
#define BOARD_INITPINS_UART5_TX_NAME                                  "UART5_TX"   /*!< Identifier name */

/* FC6_RXD_SDA_MOSI_DATA (number 46), J4[4]/U9[13]/BRIDGE_T_SCK */
#define BOARD_INITPINS_UART6_RX_PERIPHERAL                             FLEXCOMM6   /*!< Device name: FLEXCOMM6 */
#define BOARD_INITPINS_UART6_RX_SIGNAL                         RXD_SDA_MOSI_DATA   /*!< FLEXCOMM6 signal: RXD_SDA_MOSI_DATA */
#define BOARD_INITPINS_UART6_RX_PIN_NAME                   FC6_RXD_SDA_MOSI_DATA   /*!< Pin name */
#define BOARD_INITPINS_UART6_RX_LABEL                "J4[4]/U9[13]/BRIDGE_T_SCK"   /*!< Label */
#define BOARD_INITPINS_UART6_RX_NAME                                  "UART6_RX"   /*!< Identifier name */

/* FC6_TXD_SCL_MISO_WS (number 30), J9[8]/D2[4]/P1_10-SCT4-LED_GREEN */
#define BOARD_INITPINS_UART6_TX_PERIPHERAL                             FLEXCOMM6   /*!< Device name: FLEXCOMM6 */
#define BOARD_INITPINS_UART6_TX_SIGNAL                           TXD_SCL_MISO_WS   /*!< FLEXCOMM6 signal: TXD_SCL_MISO_WS */
#define BOARD_INITPINS_UART6_TX_PIN_NAME                     FC6_TXD_SCL_MISO_WS   /*!< Pin name */
#define BOARD_INITPINS_UART6_TX_LABEL         "J9[8]/D2[4]/P1_10-SCT4-LED_GREEN"   /*!< Label */
#define BOARD_INITPINS_UART6_TX_NAME                                  "UART6_TX"   /*!< Identifier name */

/* FC7_RXD_SDA_MOSI_DATA (number 27), J1[10]/P1_7-FC7_RXD_SDA_MOSI_DATA */
#define BOARD_INITPINS_UART7_RX_PERIPHERAL                             FLEXCOMM7   /*!< Device name: FLEXCOMM7 */
#define BOARD_INITPINS_UART7_RX_SIGNAL                         RXD_SDA_MOSI_DATA   /*!< FLEXCOMM7 signal: RXD_SDA_MOSI_DATA */
#define BOARD_INITPINS_UART7_RX_PIN_NAME                   FC7_RXD_SDA_MOSI_DATA   /*!< Pin name */
#define BOARD_INITPINS_UART7_RX_LABEL        "J1[10]/P1_7-FC7_RXD_SDA_MOSI_DATA"   /*!< Label */
#define BOARD_INITPINS_UART7_RX_NAME                                  "UART7_RX"   /*!< Identifier name */

/* FC7_TXD_SCL_MISO_WS (number 28), J1[12]/J9[6]/P1_8-ADC11-FC7_TXD_SCL_MISO_FRAME */
#define BOARD_INITPINS_UART7_TX_PERIPHERAL                             FLEXCOMM7   /*!< Device name: FLEXCOMM7 */
#define BOARD_INITPINS_UART7_TX_SIGNAL                           TXD_SCL_MISO_WS   /*!< FLEXCOMM7 signal: TXD_SCL_MISO_WS */
#define BOARD_INITPINS_UART7_TX_PIN_NAME                     FC7_TXD_SCL_MISO_WS   /*!< Pin name */
#define BOARD_INITPINS_UART7_TX_LABEL "J1[12]/J9[6]/P1_8-ADC11-FC7_TXD_SCL_MISO_FRAME" /*!< Label */
#define BOARD_INITPINS_UART7_TX_NAME                                  "UART7_TX"   /*!< Identifier name */

/* FC0_TXD_SCL_MISO (number 32), U6[4]/U22[3]/P0_1-ISP_TX */
#define BOARD_INITPINS_DEBUG_UART_TX_PERIPHERAL                        FLEXCOMM0   /*!< Device name: FLEXCOMM0 */
#define BOARD_INITPINS_DEBUG_UART_TX_SIGNAL                         TXD_SCL_MISO   /*!< FLEXCOMM0 signal: TXD_SCL_MISO */
#define BOARD_INITPINS_DEBUG_UART_TX_PIN_NAME                   FC0_TXD_SCL_MISO   /*!< Pin name */
#define BOARD_INITPINS_DEBUG_UART_TX_LABEL            "U6[4]/U22[3]/P0_1-ISP_TX"   /*!< Label */
#define BOARD_INITPINS_DEBUG_UART_TX_NAME                        "DEBUG_UART_TX"   /*!< Identifier name */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void); /* Function assigned for the Cortex-M0P */

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/*******************************************************************************
 * EOF
 ******************************************************************************/
