/*****************************************************************************
 *
 * MODULE:             JN-AN-1158 (Remote)
 *
 * COMPONENT:          ZRC.c
 *
 * AUTHOR:             JV
 *
 * DESCRIPTION:        ZigBee Remote Control profile functionalities
 *
 * $HeadURL $
 *
 * $Revision: 9934 $
 *
 * $LastChangedBy: nxp46755 $
 *
 * $LastChangedDate: 2012-11-15 05:11:17 +0000 (Thu, 15 Nov 2012) $
 *
 * $Id: ZRC.c 9934 2012-11-15 05:11:17Z nxp46755 $
 *
 *
 ****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5148, JN5142,
 * JN5139]. You, and any third parties must reproduce the copyright and
 * warranty notice and any other legend of ownership on each copy or partial
 * copy of the software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2012. All rights reserved
 *
 ***************************************************************************/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
#include "ZRC.h"
#include "printf.h"
#include "RF4CE_API.h"
/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
#define NSDU_MAX_LEN 34
#define CMDS_SUPPORTED_FIELD_LEN 32
/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/


/****************************************************************************/
/***        Local Function Prototypes                                     ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

/****************************************************************************/
/***        Local Variables                                               ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

//Note: (Application Specific) Before sending this command eState in app can be made to E_TRANSMITTING;

/**
 * Sends one User Control Pressed ZRC command to u8ReceiverPairingRef.
 * Note: For broadcast transmission, change u8TxOptions accordingly.
 */
PUBLIC void vZRC_SendUserControlPressed(uint8 u8ReceiverPairingRef, teRC_CmdCode eRC_CmdCode, uint8 u8RC_CmdPayloadLen, uint8 *pau8RC_CmdPayload)
{
    uint8 au8Nsdu[NSDU_MAX_LEN];
    uint8 u8DataLen;
    uint8 u8TxOptions;
    uint8 u8PayloadCount = 0;

    /* ZRC header fill with User Control Pressed command id */
    au8Nsdu[0] = E_ZRC_USER_CONTROL_PRESSED;

    /* RC Command Code*/
    au8Nsdu[1] = eRC_CmdCode;

    /* Variable RC Command payload*/
    u8PayloadCount=0;
    while( (u8PayloadCount < u8RC_CmdPayloadLen) && (u8PayloadCount < (NSDU_MAX_LEN - 2)) )
    {
        au8Nsdu[2+u8PayloadCount] = pau8RC_CmdPayload[u8PayloadCount];
        u8PayloadCount++;
    }

    u8DataLen = 2 + u8PayloadCount;

    u8TxOptions = RF4CE_TX_OPT_ACKNOWLEDGE | RF4CE_TX_OPT_SINGLE_CHAN;

    vRF4CE_NldeDataReq(u8ReceiverPairingRef, ZRC_PROFILE_ID, 0x0000,
                       u8DataLen, au8Nsdu, u8TxOptions);
}


/**
 * Sends one User Control Repeated ZRC command to u8ReceiverPairingRef.
 * Note: (Application Specific) Before sending this command eState in app can be made to E_TRANSMITTING;
 * Note: For broadcast transmission, u8TxOptions need change accordingly.
 */
PUBLIC void vZRC_SendUserControlRepeated(uint8 u8ReceiverPairingRef, teRC_CmdCode eRC_CmdCode, uint8 u8RC_CmdPayloadLen, uint8 *pau8RC_CmdPayload)
{
    uint8 au8Nsdu[NSDU_MAX_LEN];
    uint8 u8DataLen;
    uint8 u8TxOptions;
    uint8 u8PayloadCount = 0;

    /* ZRC header fill with User Control Repeated command id */
    au8Nsdu[0] = E_ZRC_USER_CONTROL_REPEATED;

    /* RC Command Code*/
    au8Nsdu[1] = eRC_CmdCode;

    /* Variable RC Command payload*/
    u8PayloadCount=0;
    while( (u8PayloadCount < u8RC_CmdPayloadLen) && (u8PayloadCount < (NSDU_MAX_LEN - 2)) )
    {
        au8Nsdu[2+u8PayloadCount] = pau8RC_CmdPayload[u8PayloadCount];
        u8PayloadCount++;
    }

    u8DataLen = 2 + u8PayloadCount;

    u8TxOptions = RF4CE_TX_OPT_ACKNOWLEDGE | RF4CE_TX_OPT_SINGLE_CHAN;

    vRF4CE_NldeDataReq(u8ReceiverPairingRef, ZRC_PROFILE_ID, 0x0000,
                       u8DataLen, au8Nsdu, u8TxOptions);
}


/**
 * Sends one User Control Released ZRC command to u8ReceiverPairingRef.
 * Note: (Application Specific) Before sending this command eState in app can be made to E_TRANSMITTING;
 * Note: For broadcast transmission, u8TxOptions need change accordingly.
 */
PUBLIC void vZRC_SendUserControlReleased(uint8 u8ReceiverPairingRef, teRC_CmdCode eRC_CmdCode)
{
    uint8 au8Nsdu[NSDU_MAX_LEN];
    uint8 u8DataLen;
    uint8 u8TxOptions;

    /* ZRC header fill with User Control Released command id */
    au8Nsdu[0] = E_ZRC_USER_CONTROL_RELEASED;

    /* RC Command Code*/
    au8Nsdu[1] = eRC_CmdCode;

    u8DataLen = 2;
    u8TxOptions = RF4CE_TX_OPT_ACKNOWLEDGE | RF4CE_TX_OPT_SINGLE_CHAN;

    vRF4CE_NldeDataReq(u8ReceiverPairingRef, ZRC_PROFILE_ID, 0x0000,
                       u8DataLen, au8Nsdu, u8TxOptions);
}


/**
 * Sends Command discovery request ZRC command to u8ReceiverPairingRef.
 * Note: (Application Specific) Before sending this command eState in app can be made to E_TRANSMITTING;
 */
PUBLIC void vZRC_SendCmdDiscRequest(uint8 u8ReceiverPairingRef)
{
    uint8 au8Nsdu[NSDU_MAX_LEN];
    uint8 u8DataLen;
    uint8 u8TxOptions;

    /* ZRC header fill with User Control Released command id */
    au8Nsdu[0] = E_ZRC_CMD_DISCOVERY_REQUEST;

    /* Reserved ZRC payload*/
    au8Nsdu[1] = 0x00;

    u8DataLen = 2;
    u8TxOptions = RF4CE_TX_OPT_ACKNOWLEDGE | RF4CE_TX_OPT_SINGLE_CHAN;

    vRF4CE_NldeDataReq(u8ReceiverPairingRef, ZRC_PROFILE_ID, 0x0000,
                       u8DataLen, au8Nsdu, u8TxOptions);
}

/**
 * Sends Command Discovery Response ZRC command to u8ReceiverPairingRef.
 * Note: (Application Specific) Before sending this command eState in app can be made to E_TRANSMITTING;
 * Note: For broadcast transmission, u8TxOptions need change accordingly.
 */
PUBLIC void vZRC_SendCmdDiscResponse(uint8 u8ReceiverPairingRef, uint8 *pau8CmdsSupported)
{
    uint8 au8Nsdu[NSDU_MAX_LEN];
    uint8 u8DataLen;
    uint8 u8TxOptions;
    uint8 u8PayloadCount = 0;

    /* ZRC header fill with User Control Pressed command id */
    au8Nsdu[0] = E_ZRC_CMD_DISCOVERY_RESPONSE;

    /* Reserved Byte*/
    au8Nsdu[1] = 0x000;

    /* Commands supported */
    u8PayloadCount=0;
    while( u8PayloadCount < CMDS_SUPPORTED_FIELD_LEN )
    {
        au8Nsdu[2+u8PayloadCount] = pau8CmdsSupported[u8PayloadCount];
        u8PayloadCount++;
    }

    u8DataLen = 2 + u8PayloadCount;

    u8TxOptions = RF4CE_TX_OPT_ACKNOWLEDGE | RF4CE_TX_OPT_SINGLE_CHAN;

    vRF4CE_NldeDataReq(u8ReceiverPairingRef, ZRC_PROFILE_ID, 0x0000,
                       u8DataLen, au8Nsdu, u8TxOptions);
}
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
