/*****************************************************************************
 *
 * MODULE:             JN-AN-1158 (Remote)
 *
 * COMPONENT:          ZRC.h
 *
 * AUTHOR:             JV
 *
 * DESCRIPTION:        ZigBee Remote Control profile functionalities
 *
 * $HeadURL $
 *
 * $Revision: 9934 $
 *
 * $LastChangedBy: nxp46755 $
 *
 * $LastChangedDate: 2012-11-15 05:11:17 +0000 (Thu, 15 Nov 2012) $
 *
 * $Id: ZRC.h 9934 2012-11-15 05:11:17Z nxp46755 $
 *
 *
 ****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5148, JN5142,
 * JN5139]. You, and any third parties must reproduce the copyright and
 * warranty notice and any other legend of ownership on each copy or partial
 * copy of the software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2012. All rights reserved
 *
 ***************************************************************************/

#ifndef ZRC_INCLUDED
#define ZRC_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/
#include "jendefs.h"
/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
//#define MAX_ZRC_PAYLOAD 9


/* ZRC Profile Initial NIB attribute settings */

#define ZRC_NIB_ATTR_ACTIVE_PERIOD           (0)         /* Implementation specific */
#define ZRC_NIB_ATTR_DISC_LQI_THRESHOLD      (0)         /* Implementation specific */
#define ZRC_NIB_ATTR_DISP_REP_INTERVAL       (0x00f424)  /* 1 second   */
#define ZRC_NIB_ATTR_DUTY_CYCLE              (0)         /* Implementation specific */
#define ZRC_NIB_ATTR_MAX_DISC_REPETITIONS    (0x1e)
#define ZRC_NIB_ATTR_MAX_REPORTED_NODE_DESCS (1)

/* ZRC Profile constants */

#define ZRC_DISCOVERY_DURATION               (0x0000186a)  /* 100ms on controller */
#define ZRC_AUTO_DISCOVERY_DURATION          (0x001c9c38)  /* 30s on target */
#define ZRC_PROFILE_ID                        (0x01)        /*               */

#define APLC_MAX_KEY_REPEAT_INTERVAL          100           /* In mS */

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

typedef enum
{
    E_ZRC_USER_CONTROL_PRESSED     = 0x01,
    E_ZRC_USER_CONTROL_REPEATED    = 0x02,
    E_ZRC_USER_CONTROL_RELEASED    = 0x03,
    E_ZRC_CMD_DISCOVERY_REQUEST    = 0x04,
    E_ZRC_CMD_DISCOVERY_RESPONSE   = 0x05,
} teZRC_CmdCode;

// CEC Table 27 User Control Codes

typedef enum
{
    SELECT,
    UP,
    DOWN,
    LEFT,
    RIGHT,
    RIGHT_UP,
    RIGHT_DOWN,
    LEFT_UP,
    LEFT_DOWN,
    ROOT_MENU,
    SETUP_MENU,
    CONTENTS_MENU,
    FAVORITE_MENU,
    EXIT,

    ZERO_DIGIT = 0x20,
    ONE_DIGIT,
    TWO_DIGIT,
    THREE_DIGIT,
    FOUR_DIGIT,
    FIVE_DIGIT,
    SIX_DIGIT,
    SEVEN_DIGIT,
    EIGHT_DIGIT,
    NINE_DIGIT,
    DOT,
    ENTER,
    CLEAR,

    NEXT_FAVORITE = 0x2F,
    CHANNEL_UP,
    CHANNEL_DOWN,
    PREVIOUS_CHANNEL,
    SOUND_SELECT,
    INPUT_SELECT,
    DISPLAY_INFO,
    HELP,
    PAGE_UP,
    PAGE_DOWN,

    POWER = 0x40,
    VOLUME_UP,
    VOLUME_DOWN,
    MUTE,
    PLAY,
    STOP,
    PAUSE,
    RECORD,
    REWIND,
    FAST_FORWARD,
    EJECT,
    FORWARD,
    BACKWARD,
    STOP_RECORD,
    PAUSE_RECORD,

    ANGLE = 0x50,
    SUB_PICTURE,
    VIDEO_ON_DEMAND,
    PROGRAM_GUIDE,
    TIMER_PROGRAMMING,
    INITIAL_CONFIGURATION,
    PLAY_FUNCTION = 0x60,
    PAUSE_PLAY_FUNCTION,
    RECORD_FUNCTION,
    PAUSE_RECORD_FUNCTION,
    STOP_FUNCTION,
    MUTE_FUNCTION,
    RESTORE_VOLUME_FUNCTION,
    TUNE_FUNCTION,
    SELECT_MEDIA_FUNCTION,
    SELECT_AV_INPUT_FUNCTION,
    SELECT_AUDIO_INPUT_FUNCTION,
    POWER_TOGGLE_FUNCTION,
    POWER_OFF_FUNCTION,
    POWER_ON_FUNCTION,

    F1_BLUE = 0x71,
    F2_RED,
    F3_GREEN,
    F4_BLUE,
    F5,
    DATA,

} teRC_CmdCode;


// HDMI Spec CEC Table 6 (Command codes additional operands)
typedef enum
{
    XPLAY = 0x60,
    XTUNE = 0x67,
    XSELECT_MEDIA_FUNCTION,
    XSELECT_AV_INPUT_FUNCTION,
    XSELECT_AUDIO_INPUT_FUNCTION,

} teExtraOperands;

// play MODE additional byte expansion
typedef enum
{
    FAST_FORWARD_MIN = 0x05,
    FAST_FORWARD_MED,
    FAST_FORWARD_MAX,

    FAST_REVERSE_MIN = 0x09,
    FAST_REVERSE_MED,
    FAST_REVERSE_MAX,

    SLOW_FORWARD_MIN = 0x15,
    SLOW_FORWARD_MED,
    SLOW_FORWARD_MAX,

    SLOW_REVERSE_MIN = 0x19,
    SLOW_REVERSE_MED,
    SLOW_REVERSE_MAX,

    PLAY_FORWARD     = 0x24,
    PLAY_REVERSE,
    PLAY_STILL


} tePlayMode;



/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

PUBLIC void vZRC_SendUserControlPressed(uint8 u8ReceiverPairingRef, teRC_CmdCode eRC_CmdCode, uint8 u8RC_CmdPayloadLen, uint8 *pau8RC_CmdPayload);
PUBLIC void vZRC_SendUserControlRepeated(uint8 u8ReceiverPairingRef, teRC_CmdCode eRC_CmdCode, uint8 u8RC_CmdPayloadLen, uint8 *pau8RC_CmdPayload);
PUBLIC void vZRC_SendUserControlReleased(uint8 u8ReceiverPairingRef, teRC_CmdCode eRC_CmdCode);
PUBLIC void vZRC_SendCmdDiscRequest(uint8 u8ReceiverPairingRef);
PUBLIC void vZRC_SendCmdDiscResponse(uint8 u8ReceiverPairingRef, uint8 *pau8CmdsSupported);

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/


#if defined __cplusplus
}
#endif

#endif  /* ZRC_INCLUDED */

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
