/*****************************************************************************
 *
 * MODULE:             JN-AN-xxxx
 *
 * COMPONENT:          ntag.h
 *
 * DESCRIPTION:        NTAG I2C layer driver - include file
 *
 *****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164,
 * JN5161, JN5148, JN5142, JN5139].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2015. All rights reserved
 *
 ****************************************************************************/

#ifndef _NTAG_H_
#define _NTAG_H_

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/

#include <jendefs.h>

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

typedef enum {
    NTAG_POWER_OFF = 0,   //!< Switch NTAG power off
    NTAG_POWER_OFF_ON,    //!< Power cycle the NTAG (switch NTAG power off and then on again)
    NTAG_POWER_ON         //!< Switch NTAG power on
} ntag_power_cmd_t;

#define NTAG_BLOCK_SIZE           16           //!< NTAG data access from I2C side is done in blocks of 16 bytes (fixed in HW)

#define NTAG_LAST_USER_MEM_BLOCK  55           //!< Last 16 bytes user memory block of 1K NTAG-I2C IC

#define NS_REG_NDEF_DATA_READ     (1 << 7)     //!< NTAG NS_REG bit 7
#define NS_REG_I2C_LOCKED         (1 << 6)     //!< NTAG NS_REG bit 6
#define NS_REG_RF_LOCKED          (1 << 5)     //!< NTAG NS_REG bit 5
#define NS_REG_SRAM_I2C_READY     (1 << 4)     //!< NTAG NS_REG bit 4
#define NS_REG_SRAM_RF_READY      (1 << 3)     //!< NTAG NS_REG bit 3
#define NS_REG_EEPROM_WR_ERR      (1 << 2)     //!< NTAG NS_REG bit 2
#define NS_REG_EEPROM_WR_BUSY     (1 << 1)     //!< NTAG NS_REG bit 1
#define NS_REG_RF_FIELD_PRESENT   (1 << 0)     //!< NTAG NS_REG bit 0

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

bool   bNtagPower(ntag_power_cmd_t mode);
bool   bNtagSetup(uint16 u16Wdt, uint8 end_block);
bool   bNtagGetNsReg(uint8 *pu8regval);
void   vNtagClearNdefDataRead(void);
bool   bNtagTry2SetI2cLock(void);
bool   bNtagStartRead(uint16 u16Offset);
uint32 u32NtagRead(uint8 *pu8Buffer, uint32 u32Nbyte);
bool   bNtagStartWrite(uint16 u16Offset);
uint32 u32NtagWrite(uint8 *pu8Buffer, uint32 u32Nbyte);
bool   bNtagFlush(void);
bool   bNtagReleaseI2cLock(void);

#if defined __cplusplus
}
#endif

#endif  // _NTAG_H_

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
