/*****************************************************************************
 *
 * MODULE:             JN-AN-xxxx
 *
 * COMPONENT:          ndef.h
 *
 * DESCRIPTION:        NDEF layer driver - include file
 *
 *****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164,
 * JN5161, JN5148, JN5142, JN5139].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2015. All rights reserved
 *
 ****************************************************************************/

#ifndef _NDEF_H_
#define _NDEF_H_

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/

#include <jendefs.h>

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

// NDEF status codes returned to the user
typedef enum
{
    E_NDEF_SUCCESS = 0x0,               //!<  0 - NDEF API function was successful
    E_NDEF_ERR_NTAG_ALREADY_LOCKED,     //!<  1 - NTAG already locked by other app/module
    E_NDEF_ERR_NTAG_NOT_LOCKED,         //!<  2 - app/module doesn't have a lock on the NTAG
    E_NDEF_ERR_WRONG_APP,               //!<  3 - wrong app/module tries to access NTAG
    E_NDEF_ERR_NTAG_NO_MEM_LOCK,        //!<  4 - could not lock the EEPROM of the NTAG
    E_NDEF_ERR_WRITE_HDR,               //!<  5 - error writing header of NDEF message
    E_NDEF_ERR_WRITE_PAYLOAD,           //!<  6 - error writing payload of NDEF message
    E_NDEF_ERR_WRITE_TERMINATOR,        //!<  7 - error writing NDEF terminator
    E_NDEF_ERR_WRITE_POSITION,          //!<  8 - error setting write position in NTAG
    E_NDEF_ERR_READ_POSITION,           //!<  9 - error setting read position in NTAG
    E_NDEF_ERR_READ_PAYLOAD,            //!< 10 - error reading payload of NDEF message
    E_NDEF_ERR_FLUSH_DATA,              //!< 11 - error flushing data to NTAG
    E_NDEF_ERR_NO_ROOM_IN_NTAG,         //!< 12 - error no room in NTAG for this NDEF
    E_NDEF_ERR_NTAG_FORMAT,             //!< 13 - error during NTAG format
    E_NDEF_ERR_TOO_MANY_MSGS,           //!< 14 - registered more then CONFIG_NUMBER_OF_APP_NDEF_MSGS messages
    E_NDEF_ERR_TYPE_LENGTH,             //!< 15 - NDEF type length bigger then CONFIG_NDEF_MAX_TYPE_LENGTH
    E_NDEF_ERR_ID_LENGTH,               //!< 16 - NDEF ID length bigger then CONFIG_NDEF_MAX_ID_LENGTH
    E_NDEF_ERR_PAYLOAD_LENGTH,          //!< 17 - error related to NDEF payload length
    E_NDEF_ERR_UNKNOWN_TYPE,            //!< 18 - unknown (not registered) NDEF type
    E_NDEF_ERR_ENUM_END                 //!< 19 - keep as last in enum
} teNDEF_Status;

typedef struct ndef_rec_info_struct
{
    bool   bNdefMsgBegin;     //!< Flag to indicate Start of NDEF message
    bool   bNdefMsgEnd;       //!< Flag to indicate End of NDEF message
    bool   bNdefChunkFlag;    //!< Flag to indicate chunked NDEF message
    uint8  u8NdefTnf;         //!< Value of Tnf field in NDEF record header
    uint8  u8NdefIdLen;       //!< Length of the NDEF identifier
    uint8 *pu8NdefId;         //!< Pointer to the NDEF identifier
} ndef_rec_info_t;

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

teNDEF_Status eNdefRegisterMsg(const uint8 *pu8NdefType,
                               uint8 u8NdefTypeLength,
                               uint8 *pu8NdefId,
                               uint8 u8NdefIdLength,
                               uint32 u32NdefPayloadLength,
                               void(*pCallbackFunc)(ndef_rec_info_t *));
void vNdefParser(void);
teNDEF_Status eNdefLockNtag(const uint8 *pu8NdefType);
teNDEF_Status eNdefUnlockNtag(const uint8 *pu8NdefType);
teNDEF_Status eNdefReadMsg(const uint8 *pu8NdefType, uint32 u32NdefOffset, uint8 *pu8Data, uint32 u32DataLength);
teNDEF_Status eNdefWriteMsg(const uint8 *pu8NdefType, uint32 u32NdefOffset, uint8 *pu8Data, uint32 u32DataLength);
teNDEF_Status eNdefFormatNtag(void);
void vNdefToggleDBG(void);

#if defined __cplusplus
}
#endif

#endif  // _NDEF_H_

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
