// ------------------------------------------------------------------
// Oob Request
// ------------------------------------------------------------------
// Oobrequest parser receives oobrequest struct
// ------------------------------------------------------------------
// Author:    nxp13257
// Copyright: NXP B.V. 2017. All rights reserved
// ------------------------------------------------------------------

/** \addtogroup sj
 * \file
 * \brief Oobrequest JSON parser
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "iotError.h"
#include "newLog.h"
#include "parsing.h"
#include "queue.h"
#include "socket.h"
#include "json.h"
#include "jsonCreate.h"
#include "nibbles.h"
#include "dump.h"
#include "oobrequest.h"

// #define LI_DEBUG

#ifdef LI_DEBUG
#define DEBUG_PRINTF(...) printf(__VA_ARGS__)
#else
#define DEBUG_PRINTF(...)
#endif /* LI_DEBUG */

// ------------------------------------------------------------------
// Attributes
// ------------------------------------------------------------------

#define NUMINTATTRS  3
static char * intAttrs[NUMINTATTRS] = { "version", "type", "profile" };

#define NUMSTRINGATTRS  2
static char * stringAttrs[NUMSTRINGATTRS] = { "mac", "key" };
static int    stringMaxlens[NUMSTRINGATTRS] = { 16,    32 };

// ------------------------------------------------------------------
// Globals
// ------------------------------------------------------------------

static oobrequest_t oobrequest;

// ------------------------------------------------------------------
// LinkInfo
// ------------------------------------------------------------------

/**
 * \brief Init the JSON Parser for this type of commands
 */
void oobrequestInit( void ) {
    int i;
    for ( i=0; i<NUMINTATTRS; i++ ) {
        parsingAddIntAttr( intAttrs[i] );
    }
    for ( i=0; i<NUMSTRINGATTRS; i++ ) {
        parsingAddStringAttr( stringAttrs[i], stringMaxlens[i] );
    }
}

#ifdef LI_DEBUG
static void oobrequestDump ( void ) {
    printf( "Oobrequest dump:\n" );
    int i;
    for ( i=0; i<NUMINTATTRS; i++ ) {
        printf( "- %-12s = %d\n", intAttrs[i], parsingGetIntAttr( intAttrs[i] ) );
    }
    for ( i=0; i<NUMSTRINGATTRS; i++ ) {
        printf( "- %-12s = %s\n", stringAttrs[i], parsingGetStringAttr( stringAttrs[i] ) );
    }
}
#endif

// ------------------------------------------------------------------
// Handle
// ------------------------------------------------------------------

/**
 * \brief JSON Parser for oobrequest data
 * \retval 0 When OK
 * \returns A pointer to a global oobrequest structure, or NULL on case of an error
 */
oobrequest_t * oobrequestHandle( void ) {
    // oobrequestDump();

    newLogAdd( NEWLOG_FROM_SECURE_JOINER, "Handle oob request" );

    char * mac     = parsingGetStringAttr( "mac" );

    char * key = parsingGetStringAttr( "key" );
    if ( mac != NULL && key != NULL ) {
        oobrequest.version = parsingGetIntAttr( "version" );
        oobrequest.type    = parsingGetIntAttr( "type" );
        oobrequest.profile = parsingGetIntAttr( "profile" );
        strcpy( oobrequest.mac, mac );
        strcpy( oobrequest.key, key );
        return( &oobrequest );
    }

    return( NULL );
}
