// ------------------------------------------------------------------
// Commissioning app - include file
// ------------------------------------------------------------------
// Contacts SecureJoiner to get SecJoin struct
// ------------------------------------------------------------------
// Author:    nlv10677
// Copyright: NXP B.V. 2014. All rights reserved
// ------------------------------------------------------------------

#define COMMISSION_URI_ICODE                "com.nxp:JN51xx-NWK"
#define COMMISSION_SUPPORTED_VERSION_ICODE  13

// ------------------------------------------------------------------
// Device type
// ------------------------------------------------------------------

#define FROM_SETTINGSAPP           0x01
#define FROM_GATEWAY               0x02
#define FROM_MANAGER               0x03
#define FROM_ROUTER                0x04
#define FROM_UISENSOR              0x20
#define FROM_SENSOR                0x22
#define FROM_ACTUATOR              0x23
#define FROM_UI_ONLY               0x24
#define FROM_PLUGMETER             0x30
#define FROM_LIGHT_ONOFF           0x0100 /* new values from ZLO */
#define FROM_LIGHT_DIMM            0x0101
#define FROM_LIGHT_COLOR_DIMM      0x0102
#define FROM_LIGHT_COLOR_TEMP      0x010C
#define FROM_LIGHT_COLOR_EXT       0x010D

#define NFC_CMD_NONE                  0x00 /* Null command value */
#define NFC_NTAG_CMD_JOIN_WITH_ICODE  0x41 /* NTAG request to NCI to join using installation code encrypted key */
#define NFC_NCI_CMD_FACTORY_RESET     0xA0 /* NCI request to NTAG to perform a factory reset */
#define NFC_NCI_CMD_JOIN_WITH_ICODE   0xA1 /* NCI request to NTAG to join using installation code encrypted key */

// ------------------------------------------------------------------
// Payload
// ------------------------------------------------------------------

#define LEN_MAC      8
#define LEN_LINKKEY  16
#define LEN_EXTPAN   8
#define LEN_TCADDR   8
#define LEN_MIC      4
#define LEN_NWKEY    16
#define LEN_ICODE    16

// Data structure with Installation Code

typedef struct commission_ntag_struct {
    /* Data written by NTAG side */
    //uint8_t  Version;                 /* Data structure version */
    uint8_t  Command;                 /* Command from NTAG to NCI */
    uint8_t  Sequence;                /* Write counter */
    uint16_t DeviceId;                /* Device type ID */
    uint8_t  ExtAddress[LEN_MAC];     /* Extended address */
    uint8_t  ShortAddress[2];         /* Current short address */
    uint8_t  Channel;                 /* Current channel */
    uint8_t  PanId[2];                /* Current PAN ID */
    uint8_t  ExtPanId[8];             /* Current extended PAN ID */
    uint8_t  Key[LEN_ICODE];          /* Installation code */
    uint8_t  Crc[2];                  /* Installation code CRC */
} __attribute__((__packed__)) commission_ntag_t;

typedef struct commission_nci_struct {
    /* Data written by NCI side */
    uint8_t  Command;                 /* Command from NCI to NTAG */
    uint8_t  Sequence;                /* Write counter */
    uint16_t DeviceId;                /* Device type ID */
    uint8_t  ExtAddress[LEN_MAC];     /* Network trust center extended address */
    uint8_t  ShortAddress[2];         /* Network trust center short address */
    uint8_t  Channel;                 /* Network channel */
    uint8_t  PanId[2];                /* Network PAN ID */
    uint8_t  ExtPanId[LEN_EXTPAN];    /* Network extended PAN ID */
    uint8_t  Key[LEN_NWKEY];          /* Encrypted network key */
    uint8_t  Mic[LEN_MIC];            /* MIC for encrypted key */
    uint8_t  KeySeqNum;               /* Network key sequence number */
} __attribute__((__packed__)) commission_nci_t;

typedef struct commission_icode_struct {
    uint8_t           version;        /* Data structure version */
   commission_ntag_t  ntag;
   commission_nci_t   nci;
} __attribute__((__packed__)) commission_icode_t;

typedef struct oob_request_info_struct {
    uint8_t  version; /* FIXME: version, type, profile to be removed ? */
    uint8_t  type;
    uint16_t profile;
    char     mac[LEN_MAC];
    char     key[LEN_ICODE];
} oob_request_info_t;

typedef struct oob_response_info_struct {
    char     deviceextaddress[LEN_MAC];
    char     key[LEN_NWKEY];
    char     mic[LEN_MIC];
    char     hostextaddress[LEN_MAC];
    uint8_t  keyseq;
    uint8_t  channel;
    uint16_t panid;
    char     extpanid[LEN_EXTPAN];
    uint16_t shortaddress;
    uint16_t deviceid;
    uint8_t  status;
} oob_response_info_t;


int commissionHandleNfcOob( int handle, char * payload, int plen );
void commissionResetOob( void );
void commissionInitOob( void );

