#!/bin/sh
# ------------------------------------------------------------------
# SW Update shell script
# - Note: altered by Makefile for site-diversity reasons
# ------------------------------------------------------------------
# Author:    nlv10677
# Copyright: NXP B.V. 2014. All rights reserved
# ------------------------------------------------------------------

# NOTE: following line is generated by Makefile (site-diversity)
CLOUD=http://www.nxpcloud.com/images/IotOrpi_EHV

IMAGE=iot_image.tgz

echo "********** Update script ************" > /tmp/su.log
echo "Update 1: Set permissions right" >> /tmp/su.log

# Make sure persmissions are ok
chmod +x /usr/bin/iot_*
chmod +x /usr/bin/killbyname

echo "Update 2: Stop all IoT processes" >> /tmp/su.log

# Stop all IoT processes
/usr/bin/iot_stop.sh > /dev/null

echo "Update 3: Remove specific IoT files" >> /tmp/su.log

# Remove all existing iot files in /tmp
rm /tmp/iot_*

# Legacy
if [ -f /etc/rc.d/*iot_dp_initd ]; then
    rm /etc/rc.d/*iot_dp_initd
fi

echo "Update 4: Create iot directory in /usr/share" >> /tmp/su.log

# Create iot directory in /usr/share if not already exists
if [ ! -d /usr/share/iot ]; then
    mkdir /usr/share/iot
fi

echo "Update 5: Get the new SW image from the cloud, $CLOUD/$IMAGE" >> /tmp/su.log

# Get the new SW image from the cloud
if [ -f /usr/bin/iot_wget.sh ]; then
    echo "Update 5a" >> /tmp/su.log
    /usr/bin/iot_wget.sh $CLOUD/$IMAGE -O /tmp/$IMAGE > /dev/null
else
    echo "Update 5b" >> /tmp/su.log
    /usr/bin/wget $CLOUD/$IMAGE -O /tmp/$IMAGE > /dev/null
fi

echo "Update 6: Unzip and install" >> /tmp/su.log

# UNZIP new SW image, prepare permissions, copy and remove
tar -xzf /tmp/$IMAGE -C /tmp
chown -R root:root /tmp/images
chmod -R +r /tmp/images/tmp
chmod -R +r /tmp/images/www
chmod -R +r /tmp/images/etc/*
chmod +x /tmp/images/usr/bin/*
cp -pR /tmp/images/* /
rm -R /tmp/images
rm /tmp/$IMAGE

# Remove the old DB
if [ -f /usr/share/iot/iot_*.db ]; then
        echo "Update 7: Remove the old DB" >> /tmp/su.log
        rm -f /usr/share/iot/iot_*.db
        rm -f /usr/share/iot/iot_*.bck
        # Empty the shared memory DB
        if [ -f /usr/bin/iot_ci ]; then
                /usr/bin/iot_ci -c
        fi
fi

echo "Update 8: Init as usual" >> /tmp/su.log

# Init as usual
/usr/bin/iot_init.sh > /dev/null

echo "Update 9: Finally restart IoT processes" >> /tmp/su.log

# and finally restart all IoT processes
/usr/bin/iot_start.sh > /dev/null

echo "********** Update end **********" >> /tmp/su.log

