/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _APP_H_
#define _APP_H_

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/*${macro:start}*/
#define DEMO_ADC_BASE ADC0

#define DEMO_ADC_SAMPLE0_CHANNEL_NUMBER 0U
#define DEMO_ADC_IRQ_SEQA_ID ADC0_SEQA_IRQn
#define DEMO_ADC_IRQ_SEQA_HANDLER_FUNC ADC0_SEQA_IRQHandler
/* Sample0 ADC Channel  Data register address*/
#define DEMO_ADC_DATA0_REG_ADDR (uint32_t)(&(DEMO_ADC_BASE->DAT[DEMO_ADC_SAMPLE0_CHANNEL_NUMBER]))

/* DMA channel Connected to Sample0 ADC Channel */
#define DEMO_DMA_ADC_SAMPLE0_CHANNEL 0U

#define DEMO_ADC_SAMPLE1_CHANNEL_NUMBER 4U
#define DEMO_ADC_IRQ_SEQB_ID ADC0_SEQB_IRQn
#define DEMO_ADC_IRQ_SEQB_HANDLER_FUNC ADC0_SEQB_IRQHandler
/* Sample1 ADC Channel Data register address*/
#define DEMO_ADC_DATA1_REG_ADDR (uint32_t)(&(DEMO_ADC_BASE->DAT[DEMO_ADC_SAMPLE1_CHANNEL_NUMBER]))

/* DMA channel Connected to Sample1 ADC Channel */
#define DEMO_DMA_ADC_SAMPLE1_CHANNEL 1U

#define DEMO_GPIO_BASE GPIO
#define DEMO_ADC_SAMPLE1_CHANNEL_GPIOPORT 0U
#define DEMO_ADC_SAMPLE1_CHANNEL_GPIOPIN 16U
/*${macro:end}*/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
/*${prototype:start}*/
void BOARD_InitHardware(void);
/*${prototype:end}*/

#endif /* _APP_H_ */
