/*
 * @brief LPC11U6x IRC Calibration library functions
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#ifndef __IRC_CALIB_LIB_11U6X_H_
#define __IRC_CALIB_LIB_11U6X_H_

#ifdef __cplusplus
extern "C" {
#endif

/** @defgroup IRC_CALIB_LIB_11U6X CHIP: LPC11U6X IRC CALIBRATION LIBRARY functions
 * The IRC Calibration library provides functions to control IRC clock frequency.<br>
 * @ingroup CHIP_11U6X_DRIVERS
 * @{
 */

/* Returns the version of the IRC Calibration library */
unsigned int irc_calib_Get_Lib_Ver(void);

/* timer instance */
/* timer clock frquency in KHz */
ErrorCode_t Chip_TIMER_Instance_Freq(LPC_TIMER_T *pTMR, unsigned int timerFreq);

/* USB_SOF_Event */
ErrorCode_t USB_SOF_Event(USBD_HANDLE_T hUsb);

/**
 * @}
 */

#ifdef __cplusplus
}
#endif

#endif /* __IRC_CALIB_LIB_11U6X_H_ */
