/**************************************************************************/
/* FILE NAME: m_sram.h                        COPYRIGHT (c) MOTOROLA 1999 */
/* VERSION:  1.1                                  All Rights Reserved     */
/*                                                                        */
//* DESCRIPTION:                                                          */
/* This file defines all of the registers and bit fields on the SRAM      */
/* modules and declares an instance of the SRAM structure.                */
/*========================================================================*/
/* AUTHOR: Jeff Loeliger                                                  */
/* COMPILER: Diab Data        VERSION: 4.2b                               */
/*                                                                        */
/* HISTORY                                                                */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 0.1   J. Loeliger  06/Apr/98    Initial version of file.               */
/* 0.2                20/Dec/98    Broke header file into modules.        */
/* 1.0   J. Loeliger  12/Jan/99    Added three ways to create an instance */
/*                                   of the module and added PACK.        */
/* 1.1   J. Loeliger  22/Jun/99    Added ifdef to support C++             */
/**************************************************************************/
#ifndef _MPC555_SRAM_H
#define _MPC555_SRAM_H

#ifndef _MPC555_COMMON_H
#include "M_COMMON.h"
#endif /*  ifndef _MPC555_COMMON_H  */

#ifdef  __cplusplus
extern "C" {
#endif

/****************************************************************************/
/*                              MODULE :SRAM                                */
/****************************************************************************/
struct SRAM_tag {
    union {
        VUINT32 R;
        struct {
            VUINT32 LCK:1;
            VUINT32 DIS:1;
            VUINT32 CY:1;
              VUINT32:17;
            VUINT32 R0:1;
            VUINT32 D0:1;
            VUINT32 S0:1;
            VUINT32 R1:1;
            VUINT32 D1:1;
            VUINT32 S1:1;
            VUINT32 R2:1;
            VUINT32 D2:1;
            VUINT32 S2:1;
            VUINT32 R3:1;
            VUINT32 D3:1;
            VUINT32 S3:1;
        } B;
    } SRAMMCR;

    union {
        VUINT32 R;
        VUINT32 B;
    } SRAMTST;
};


/******************************************************************/
/* There are three way to create an instance of the SRAM module:  */
/* -Use a fixed structure (Default)                               */
/* -Use the Diab compiler sections (if DIAB_SCETIONS is defined)  */
/* -Use a pointer (if HEADER_POINTERS is defined)                 */
/******************************************************************/
#ifdef DIAB_SECTIONS            /* Diab Compiler Only */

#pragma section SRAM_A  address=0x380000  /* Map modules to fixed addresses. */
#pragma use_section SRAM_A SRAM_A
EXT struct SRAM_tag SRAM_A;

#pragma section SRAM_B  address=0x380008
#pragma use_section SRAM_B SRAM_B
EXT struct SRAM_tag SRAM_B;

#else
#ifdef HEADER_POINTERS

/* Create a global pointer. */

#ifdef Main_Program
struct SRAM_tag *SRAM_A = (struct SRAM_tag *) (INTERNAL_MEMORY_BASE + 0x380000);
struct SRAM_tag *SRAM_B = (struct SRAM_tag *) (INTERNAL_MEMORY_BASE + 0x380008);
#else
EXT struct SRAM_tag *SRAM_A;
EXT struct SRAM_tag *SRAM_B;
#endif

#else

/* Use a fixed structure, this is the default */
#define SRAM_A (*( struct SRAM_tag *)   (INTERNAL_MEMORY_BASE + 0x380000))
#define SRAM_B (*( struct SRAM_tag *)   (INTERNAL_MEMORY_BASE + 0x380008))

#endif /* HEADER_POINTERS */

#endif /* DIAB_SECTIONS */

#ifdef  __cplusplus
}
#endif

#endif /* ifndef _MPC555_SRAM_H  */
/*****************************************************************************/
/* Motorola reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Motorola does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Motorola */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Motorola product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Motorola */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Motorola */
/* was negligent regarding the  design  or manufacture of the part. Motorola */
/* and the Motorola logo* are registered trademarks of Motorola Ltd.         */
/*****************************************************************************/
