/**************************************************************************/
/*                                            COPYRIGHT (c) MOTOROLA 1998 */
/* FILE NAME: mpc555.c                            All Rights Reserved     */
/*                                                                        */
/* INCLUDE FILES: mpc555.h                                                */
/* VERSION: 1.3                                                           */
/*                                                                        */
/*========================================================================*/
/*                                                                        */
/* DESCRIPTION: This file sets up the internal registers of the MPC555 to */
/*              generally useful values for the Motorola/ETAS EVB.        */
/*========================================================================*/
/*                                                                        */
/* COMPILER: Diab Data        VERSION: 4.1a                               */
/*                                                                        */
/* AUTHOR: John K Dunlop                  CREATION DATE:  22/Apr/98       */
/* LOCATION: East Kilbride, Scotland.                                     */
/*                                                                        */
/* UPDATE HISTORY                                                         */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 1.0   J. Dunlop    22/Apr/98    Initial version of function.           */
/* 1.1   J. Loeliger  22/Jun/98    Changed to init. MPC555 core only.     */
/* 1.2   J. Loeliger   4/Nov/98    Changed SRAM to SRAM_A & SRAM_B        */
/* 1.3   R. Dees       9/Feb/2000  add isync after BBCMCR write           */
/*                                                                        */
/**************************************************************************/

#include "m_usiu.h"
#include "m_uimb.h"

void setup_mpc555 (void)
{
    USIU.SYPCR.R = 0xffffff03;  /* Disable watchdog timer.                 *
                                 * WARNING: this is a WRITE ONLY register. */

    USIU.SIUMCR.R = 0x00000000; /*Expanded mode, normal pin options */

    USIU.PDMCR.R = 0xf0000000;  /*Normal slew rate with no pull ups on Pads */

/* Initialise external memory interface */
/* Write to chip select option register first, becuase setting the V bit in  */
/* the base reigister enables the chip select.                               */

/* The Chip selects are not used because it is assumed they are setup by the */
/* debugger.                                                                 */

/* External TI Burst FLASH on Motorola/ETAS EVB */
/* USIU.OR0.R = 0xfff00054; /* 1MB/32 bit/5 wait states  */
/*  USIU.BR0.R = 0x00800101; /* Base address = 0x800000   */

/*  USIU.OR1.R = 0xffe00000; /* 2MB/32 bit/0 wait states  */
/*  USIU.BR1.R = 0x00000001; /* Base address = 0x00000000 */


/***** Initialise clocks for 40MHz with external 40MHz osc. *****/
/*  USIU.SCCRK.R = 0x55ccaa33; /*Unlock SCCR with special key */
/*  USIU.SCCR.R = 0x01300100; */
    USIU.PLPRCRK.R = 0x55ccaa33;  /*Unlock PLPRC with special key */
    USIU.PLPRCR.R = 0x0093d000; /* 10x PLL operation on normal power mode */


    USIU.TBSCRK.R = 0x55ccaa33; /* Unlock timebase status reg */
    USIU.TBSCR.R = 0x0001;      /* Enable TB and decrementer */

    UIMB.UMCR.B.HSPEED = 0;     /* run IMB at full clock speed */

    asm (" mfspr r3,158");      /* Put PowerPC core in non-serialized */
    asm (" ori r3,r3,0x0007 "); /* (normal) mode with no show cycles  */
    asm (" mtspr 158,r3");

    asm (" mfspr r3,560");      /* Enable burst buffer */
    asm (" ori r3,r3,0x2000 ");
    asm (" mtspr 560,r3");
    asm (" isync");             /* writes to the BBCMCR should be followed */
                                /* with an ISYNC to hold off any instructions */
                                /* until the register command completes. */

    asm (" mfmsr r3");          /* Enable floating point and make      */
    asm (" ori r3,r3,0x3000 "); /* machine check exception recoverable */
    asm (" mtmsr r3");

}
