/**************************************************************************/
/* FILE NAME: example2.c                      COPYRIGHT (c) MOTOROLA 2000 */
/* VERSION: 0.2                                   All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION: This file shows how to use the standard set-up and header */
/* files for the MPC565. This program sets up the MPC565 EVB, generates a */
/* 10kHz PWM on the MIOS1 PWM19 channel and generates a software PWM on   */
/* QADC A port A7.                                                        */
/* This program uses the Diab sections feature of the header files. To    */
/* use the Diab sections you must #define DIAB_SECTIONS, this can be done */
/* by adding an option (-DDIAB_SECTIONS) in the makefile.                 */
/* This program may not work on the SPanish Oak hardware.                 */
/*========================================================================*/
/* COMPILER: Diab Data        VERSION: 4.2b                               */
/* AUTHOR: Jeff Loeliger                                                  */
/*                                                                        */
/* HISTORY                                                                */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 0.1   J. Loeliger  13/Sep/99    Initial version of program for         */
/*                                   MPC565.                              */
/* 0.2   J. Loeligert 03/Oct/00    Update MPC565 reigsters.               */
/**************************************************************************/
#define Main_Program

#include "mpc565.h"

void main ()
{
/*************************************************************
 * Set up PWM19 on the MIOS1 module to output a 10KHz signal *
 *************************************************************/

    MIOS14.MCPSMSCR.B.PREN = 1;  /* enable MIOS counters */

/* setup PWM19 */
    MIOS14.MPWMSM19PERR.R = 0xfa;   /* set period to 0xfa */

    MIOS14.MPWMSM19PULR.R = 0x3e;   /* set high time to 0x3e */

    MIOS14.MPWMSM19SCR.B.CP = 0xff; /* set prescaler to 1 */

    MIOS14.MPWMSM19SCR.B.EN = 1;    /* enable output on PWM19 */

/**************************************************
 * Generate a software PWM on QADC A port A7 pin. *
 **************************************************/
    QADC_A.DDRQA.B.DDQA7 = 1;   /* setup QADC A port A7 as output */

    while (1) {                 /* Toggle QADC A port A7 pin */
        QADC_A.PORTQA.B.PQA7 = 1;
        QADC_A.PORTQA.B.PQA7 = 0;
    }
}

/*****************************************************************************/
/* Motorola reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Motorola does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Motorola */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Motorola product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Motorola */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Motorola */
/* was negligent regarding the  design  or manufacture of the part. Motorola */
/* and the Motorola logo* are registered trademarks of Motorola Ltd.         */
/*****************************************************************************/
