/**************************************************************************/
/* FILE NAME: m_calram.h                      COPYRIGHT (c) MOTOROLA 1999 */
/* VERSION:  0.1                                  All Rights Reserved     */
/*                                                                        */
//* DESCRIPTION:                                                          */
/* This file defines all of the registers and bit fields on the CALRAM    */
/* modules and declares an instance of the CALRAM structure.              */
/*========================================================================*/
/* AUTHOR: Jeff Loeliger                                                  */
/* COMPILER: Diab Data        VERSION: 4.2b                               */
/*                                                                        */
/* HISTORY                                                                */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 0.1   J. Loeliger  13/Sep/98    Initial version of file for            */
/*                                   MPC565.                              */
/**************************************************************************/
#ifndef _MPC565_CALRAM_H
#define _MPC565_CALRAM_H

#ifndef _MPC565_COMMON_H
#include "M_COMMON.h"
#endif /*  ifndef _MPC565_COMMON_H  */

#ifdef  __cplusplus
extern "C" {
#endif

/****************************************************************************/
/*                              MODULE :CALRAM                                */
/****************************************************************************/
    struct CALRAM_tag {
        union {
            VUINT32 R;
            struct {
                VUINT32 LCK:1;
                VUINT32 DIS:1;
                VUINT32 CY2:1;
                  VUINT32:17;
                VUINT32 R0:1;
                VUINT32 D0:1;
                VUINT32 S0:1;
                VUINT32 R1:1;
                VUINT32 D1:1;
                VUINT32 S1:1;
                VUINT32 R2:1;
                VUINT32 D2:1;
                VUINT32 S2:1;
                VUINT32 R3:1;
                VUINT32 D3:1;
                VUINT32 S3:1;
            } B;
        } CRAMMCR;

        union {
            VUINT32 R;
            struct {
                VUINT32 RB:1;
                VUINT32 SOF:1;
                VUINT32 CLR:1;
                VUINT32 FALG:1;
                VUINT32 BDONE:1;
                VUINT32 PASS:1;
                VUINT32 UP:1;
                VUINT32 INV:1;
                VUINT32 BGND:3;
                VUINT32 RDCL:1;
                  VUINT32:16;
                VUINT32 ACTE:1;
                VUINT32 OCTI:1;
                VUINT32 OCTS:1;
                VUINT32 SDTE:1;
            } B;
        } CRAMTST;

        union {
            VUINT32 R;
            struct {
                VUINT32 RGN_SIZE:4;
                  VUINT32:7;
                VUINT32 RBA:19;
                  VUINT32:2;
            } B;
        } CRAM_RBA0;

        union {
            VUINT32 R;
            struct {
                VUINT32 RGN_SIZE:4;
                  VUINT32:7;
                VUINT32 RBA:19;
                  VUINT32:2;
            } B;
        } CRAM_RBA1;

        union {
            VUINT32 R;
            struct {
                VUINT32 RGN_SIZE:4;
                  VUINT32:7;
                VUINT32 RBA:19;
                  VUINT32:2;
            } B;
        } CRAM_RBA2;

        union {
            VUINT32 R;
            struct {
                VUINT32 RGN_SIZE:4;
                  VUINT32:7;
                VUINT32 RBA:19;
                  VUINT32:2;
            } B;
        } CRAM_RBA3;

        union {
            VUINT32 R;
            struct {
                VUINT32 RGN_SIZE:4;
                  VUINT32:7;
                VUINT32 RBA:19;
                  VUINT32:2;
            } B;
        } CRAM_RBA4;

        union {
            VUINT32 R;
            struct {
                VUINT32 RGN_SIZE:4;
                  VUINT32:7;
                VUINT32 RBA:19;
                  VUINT32:2;
            } B;
        } CRAM_RBA5;

        union {
            VUINT32 R;
            struct {
                VUINT32 RGN_SIZE:4;
                  VUINT32:7;
                VUINT32 RBA:19;
                  VUINT32:2;
            } B;
        } CRAM_RBA6;

        union {
            VUINT32 R;
            struct {
                VUINT32 RGN_SIZE:4;
                  VUINT32:7;
                VUINT32 RBA:19;
                  VUINT32:2;
            } B;
        } CRAM_RBA7;

        union {
            VUINT32 R;
            struct {
                VUINT32 OVL:1;
                VUINT32 DERR:1;
                VUINT32 CLPS:1;
                  VUINT32:29;
            } B;
        } CRAMOVLCR;

        union {
            VUINT32 R;
            VUINT32 B;
        } CRAM_OTR;

    };


/******************************************************************/
/* There are three way to create an instance of the CALRAM module: */
/* -Use a fixed structure (Default)                               */
/* -Use the Diab compiler sections (if DIAB_SCETIONS is defined)  */
/* -Use a pointer (if HEADER_POINTERS is defined)                 */
/******************************************************************/
#ifdef DIAB_SECTIONS            /* Diab Compiler Only */

#pragma section CALRAM_A  address=0x380000  /* Map modules to fixed addresses. */
#pragma use_section CALRAM_A CALRAM_A
    EXT struct CALRAM_tag CALRAM_A;

#pragma section CALRAM_B  address=0x380040
#pragma use_section CALRAM_B CALRAM_B
    EXT struct CALRAM_tag CALRAM_B;

#else
#ifdef HEADER_POINTERS

/* Create a global pointer. */

#ifdef Main_Program
    struct CALRAM_tag *CALRAM_A = (struct CALRAM_tag *) (INTERNAL_MEMORY_BASE + 0x380000);
    struct CALRAM_tag *CALRAM_B = (struct CALRAM_tag *) (INTERNAL_MEMORY_BASE + 0x380040);
#else
    EXT struct CALRAM_tag *CALRAM_A;
    EXT struct CALRAM_tag *CALRAM_B;
#endif

#else

/* Use a fixed structure, this is the default */
#define CALRAM_A (*( struct CALRAM_tag *)   (INTERNAL_MEMORY_BASE + 0x380000))
#define CALRAM_B (*( struct CALRAM_tag *)   (INTERNAL_MEMORY_BASE + 0x380040))

#endif                          /* HEADER_POINTERS */

#endif                          /* DIAB_SECTIONS */

#ifdef  __cplusplus
}

#endif
#endif
/* ifndef _MPC565_CALRAM_H  *//*****************************************************************************//* Motorola reserves the right to make changes without further notice to any *//* product herein to improve reliability, function, or design. Motorola does *//* not assume any  liability arising  out  of the  application or use of any *//* product,  circuit, or software described herein;  neither  does it convey *//* any license under its patent rights  nor the  rights of others.  Motorola *//* products are not designed, intended,  or authorized for use as components *//* in  systems  intended  for  surgical  implant  into  the  body, or  other *//* applications intended to support life, or  for any  other application  in *//* which the failure of the Motorola product  could create a situation where *//* personal injury or death may occur. Should Buyer purchase or use Motorola *//* products for any such intended  or unauthorized  application, Buyer shall *//* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, *//* affiliates,  and distributors harmless against all claims costs, damages, *//* and expenses, and reasonable  attorney  fees arising  out of, directly or *//* indirectly,  any claim of personal injury  or death  associated with such *//* unintended or unauthorized use, even if such claim alleges that  Motorola *//* was negligent regarding the  design  or manufacture of the part. Motorola *//* and the Motorola logo* are registered trademarks of Motorola Ltd.         *//*****************************************************************************/
