/**************************************************************************/
/* FILE NAME: m_dlcmd2.h                      COPYRIGHT (c) MOTOROLA 1999 */
/* VERSION:  0.2                                  All Rights Reserved     */
/*                                                                        */
//* DESCRIPTION:                                                          */
/* This file defines all of the registers and bit fields on the DLCMD2    */
/* module and declares an instance of the DLCMD2 structure                */
/*========================================================================*/
/* AUTHOR: Jeff Loeliger                                                  */
/* COMPILER: Diab Data        VERSION: 4.2b                               */
/*                                                                        */
/* HISTORY                                                                */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 0.1   J. Loeliger  13/Sep/99    Initial version of file for            */
/*                                   MPC565. Had to change 4XMD bit       */
/*                                   field becuase it can not start with  */
/*                                   a number.                            */
/* 0.2   J. Loeliger  19/Oct/99    Fixed bit sizes in DLCMCR ,ILR field   */
/*       S. Markos                   in DLCILR and DLCTCR register.       */
/**************************************************************************/
#ifndef _MPC565_DLCMD2_H
#define _MPC565_DLCMD2_H

#ifndef _MPC565_COMMON_H
#include "M_COMMON.h"
#endif /*  ifndef _MPC565_COMMON_H  */

#ifdef  __cplusplus
extern "C" {
#endif

/****************************************************************************/
/*                              MODULE :DLCMD2                              */
/****************************************************************************/
    struct DLCMD2_tag {
        union {
            VUINT16 R;
            struct {
                VUINT16 STOP:1;
                VUINT16 FRZ:2;
                VUINT16 DSAE:1;
                VUINT16 X4MD:1;
                VUINT16 SOFT_FRZ:1;
                VUINT16 NOT_RDY:1;
                VUINT16 FREEZ_ACK:1;
                VUINT16 SUPV:1;
                  VUINT16:2;
                VUINT16 STOP_ACK:1;
                VUINT16 IARB:4;
            } B;
        } DLCMCR;

        union {
            VUINT16 R;
            struct {
                VUINT16 TTPOP:1;
                VUINT16 TCA:1;
                VUINT16 TCD:1;
                VUINT16 RDFST:1;
                VUINT16 RSYNC:1;
                VUINT16 DLOOP:1;
                VUINT16 TRPSH:1;
                VUINT16 DIVTE:1;
                VUINT16 COUNTE:1;
                VUINT16 FIFOTE:1;
                VUINT16 SFSCRBIT:1;
                VUINT16 SFSCC2:1;
                  VUINT16:1;
                VUINT16 SCPT2:1;
                VUINT16 SCPT1:1;
                VUINT16 SCPT0:1;
            } B;
        } DLCTCR;

        union {
            VUINT16 R;
            struct {
                VUINT16:11;
                VUINT16 IPR_4:1;
                VUINT16 IPR_3:1;
                VUINT16 IPR_2:1;
                VUINT16 IPR_1:1;
                VUINT16 IPR_0:1;
            } B;
        } DLCIPR;

        union {
            VUINT8 R;
            struct {
                VUINT8 INTMODE:1;
                VUINT8 INTACL2E:1;
                  VUINT8:1;
                VUINT8 ILBS:2;
                VUINT8 ILR:3;
            } B;
        } DLCILR;

        union {
            VUINT8 R;
            VUINT8 B;
        } DLCIVR;

        union {
            VUINT16 R;
            struct {
                VUINT16:1;
                VUINT16 NBFS:1;
                VUINT16 RXPOL:1;
                  VUINT16:3;
                VUINT16 LCK:1;
                VUINT16 SEL:1;
                  VUINT16:2;
                VUINT16 PS:6;
            } B;
        } DLCSCTL;

        union {
            VUINT16 R;
            struct {
                VUINT16:5;
                VUINT16 S10:1;
                VUINT16 S9:1;
                VUINT16 S8:1;
                VUINT16 S7:1;
                VUINT16 S6:1;
                VUINT16 S5:1;
                VUINT16 S4:1;
                VUINT16 S3:1;
                VUINT16 S2:1;
                VUINT16 S1:1;
                VUINT16 S0:1;
            } B;
        } DLCSDATA;

        union {
            VUINT8 R;
            VUINT8 B;
        } DLCCMD;

        union {
            VUINT8 R;
            VUINT8 B;
        } DLCTDATA;

        union {
            VUINT8 R;
            VUINT8 B;
        } DLCSTAT;

        union {
            VUINT8 R;
            VUINT8 B;
        } DLCRDATA;
    };
/******************************************************************/
/* There are three way to create an instance of the DLCMD2 module: */
/* -Use a fixed structure (Default)                               */
/* -Use the Diab compiler sections (if DIAB_SCETIONS is defined)  */
/* -Use a pointer (if HEADER_POINTERS is defined)                 */
/******************************************************************/
#ifdef DIAB_SECTIONS            /* Diab Compiler Only */

#pragma section DLCMD2   address=0x300080  /* Map modules to fixed addresses. */
#pragma use_section DLCMD2 DLCMD2
    EXT struct DLCMD2_tag DLCMD2;

#else

#ifdef HEADER_POINTERS
/* Create a global pointer. */
#ifdef Main_Program
    struct DLCMD2_tag *DLCMD2 = (struct DLCMD2_tag *) (INTERNAL_MEMORY_BASE + 0x300080);
#else
    EXT struct DLCMD2_tag *DLCMD2;
#endif

#else

/* Use a fixed structure, this is the default */
#define DLCMD2 (*( struct DLCMD2_tag *) (INTERNAL_MEMORY_BASE + 0x300080))
#endif                          /* HEADER_POINTERS */
#endif                          /* DIAB_SECTIONS */

#ifdef  __cplusplus
}

#endif
#endif
/* ifndef _MPC565_DLCMD2_H  *//*****************************************************************************//* Motorola reserves the right to make changes without further notice to any *//* product herein to improve reliability, function, or design. Motorola does *//* not assume any  liability arising  out  of the  application or use of any *//* product,  circuit, or software described herein;  neither  does it convey *//* any license under its patent rights  nor the  rights of others.  Motorola *//* products are not designed, intended,  or authorized for use as components *//* in  systems  intended  for  surgical  implant  into  the  body, or  other *//* applications intended to support life, or  for any  other application  in *//* which the failure of the Motorola product  could create a situation where *//* personal injury or death may occur. Should Buyer purchase or use Motorola *//* products for any such intended  or unauthorized  application, Buyer shall *//* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, *//* affiliates,  and distributors harmless against all claims costs, damages, *//* and expenses, and reasonable  attorney  fees arising  out of, directly or *//* indirectly,  any claim of personal injury  or death  associated with such *//* unintended or unauthorized use, even if such claim alleges that  Motorola *//* was negligent regarding the  design  or manufacture of the part. Motorola *//* and the Motorola logo* are registered trademarks of Motorola Ltd.         *//*****************************************************************************/
