/**************************************************************************/
/* FILE NAME: m_tpu3.h                        COPYRIGHT (c) MOTOROLA 1999 */
/* VERSION:  0.1                                  All Rights Reserved     */
/*                                                                        */
//* DESCRIPTION:                                                          */
/* This file defines all of the registers and bit fields on the TPU3      */
/* modules and declares an instance of the TPU3 structure.                */
/*========================================================================*/
/* AUTHOR: Jeff Loeliger                                                  */
/* COMPILER: Diab Data        VERSION: 4.2b                               */
/*                                                                        */
/* HISTORY                                                                */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 0.1   J. Loeliger  13/Sep/99    Initial version of file for            */
/*                                   Spanish Oak.                         */
/**************************************************************************/
#ifndef _SPOAK_TPU_H
#define _SPOAK_TPU_H

#ifndef _SPOAK_COMMON_H
#include "M_COMMON.h"
#endif /*  ifndef _SPOAK_COMMON_H  */

#ifdef  __cplusplus
extern "C" {
#endif

/****************************************************************************/
/*                              MODULE :TPU3                                */
/****************************************************************************/
    struct TPU3_tag {
        union {
            VUINT16 R;
            struct {
                VUINT16 STOP:1;
                VUINT16 TCR1P:2;
                VUINT16 TCR2P:2;
                VUINT16 EMU:1;
                VUINT16 T2CG:1;
                VUINT16 STF:1;
                VUINT16 SUPV:1;
                VUINT16 PSCK:1;
                VUINT16 TPU3:1;
                VUINT16 T2CSL:1;
                  VUINT16:4;
            } B;
        } TPUMCR;

        union {
            VUINT16 R;
            VUINT16 B;
        } TCR;

        union {
            VUINT16 R;
            struct {
                VUINT16 HOT4:1;
                  VUINT16:4;
                VUINT16 BLC:1;
                VUINT16 CLKS:1;
                VUINT16 FRZ:2;
                VUINT16 CCL:1;
                VUINT16 BP:1;
                VUINT16 BC:1;
                VUINT16 BH:1;
                VUINT16 BL:1;
                VUINT16 BM:1;
                VUINT16 BT:1;
            } B;
        } DSCR;

        union {
            VUINT16 R;
            struct {
                VUINT16:8;
                VUINT16 BKPT:1;
                VUINT16 PCBK:1;
                VUINT16 CHBK:1;
                VUINT16 SRBK:1;
                VUINT16 TPUF:1;
                  VUINT16:3;
            } B;
        } DSSR;

        union {
            VUINT16 R;
            struct {
                VUINT16:5;
                VUINT16 CIRL:3;
                VUINT16 ILBS:2;
                  VUINT16:6;
            } B;
        } TICR;

        union {
            VUINT16 R;
            struct {
                VUINT16 CH15:1;
                VUINT16 CH14:1;
                VUINT16 CH13:1;
                VUINT16 CH12:1;
                VUINT16 CH11:1;
                VUINT16 CH10:1;
                VUINT16 CH9:1;
                VUINT16 CH8:1;
                VUINT16 CH7:1;
                VUINT16 CH6:1;
                VUINT16 CH5:1;
                VUINT16 CH4:1;
                VUINT16 CH3:1;
                VUINT16 CH2:1;
                VUINT16 CH1:1;
                VUINT16 CH0:1;
            } B;
        } CIER;

        union {
            VUINT16 R;
            struct {
                VUINT16 CH15:4;
                VUINT16 CH14:4;
                VUINT16 CH13:4;
                VUINT16 CH12:4;
            } B;
        } CFSR0;

        union {
            VUINT16 R;
            struct {
                VUINT16 CH11:4;
                VUINT16 CH10:4;
                VUINT16 CH9:4;
                VUINT16 CH8:4;
            } B;
        } CFSR1;

        union {
            VUINT16 R;
            struct {
                VUINT16 CH7:4;
                VUINT16 CH6:4;
                VUINT16 CH5:4;
                VUINT16 CH4:4;
            } B;
        } CFSR2;

        union {
            VUINT16 R;
            struct {
                VUINT16 CH3:4;
                VUINT16 CH2:4;
                VUINT16 CH1:4;
                VUINT16 CH0:4;
            } B;
        } CFSR3;

        union {
            VUINT16 R;
            struct {
                VUINT16 CH15:2;
                VUINT16 CH14:2;
                VUINT16 CH13:2;
                VUINT16 CH12:2;
                VUINT16 CH11:2;
                VUINT16 CH10:2;
                VUINT16 CH9:2;
                VUINT16 CH8:2;
            } B;
        } HSQR0;

        union {
            VUINT16 R;
            struct {
                VUINT16 CH7:2;
                VUINT16 CH6:2;
                VUINT16 CH5:2;
                VUINT16 CH4:2;
                VUINT16 CH3:2;
                VUINT16 CH2:2;
                VUINT16 CH1:2;
                VUINT16 CH0:2;
            } B;
        } HSQR1;

        union {
            VUINT16 R;
            struct {
                VUINT16 CH15:2;
                VUINT16 CH14:2;
                VUINT16 CH13:2;
                VUINT16 CH12:2;
                VUINT16 CH11:2;
                VUINT16 CH10:2;
                VUINT16 CH9:2;
                VUINT16 CH8:2;
            } B;
        } HSRR0;

        union {
            VUINT16 R;
            struct {
                VUINT16 CH7:2;
                VUINT16 CH6:2;
                VUINT16 CH5:2;
                VUINT16 CH4:2;
                VUINT16 CH3:2;
                VUINT16 CH2:2;
                VUINT16 CH1:2;
                VUINT16 CH0:2;
            } B;
        } HSRR1;

        union {
            VUINT16 R;
            struct {
                VUINT16 CH15:2;
                VUINT16 CH14:2;
                VUINT16 CH13:2;
                VUINT16 CH12:2;
                VUINT16 CH11:2;
                VUINT16 CH10:2;
                VUINT16 CH9:2;
                VUINT16 CH8:2;
            } B;
        } CPR0;

        union {
            VUINT16 R;
            struct {
                VUINT16 CH7:2;
                VUINT16 CH6:2;
                VUINT16 CH5:2;
                VUINT16 CH4:2;
                VUINT16 CH3:2;
                VUINT16 CH2:2;
                VUINT16 CH1:2;
                VUINT16 CH0:2;
            } B;
        } CPR1;

        union {
            VUINT16 R;
            struct {
                VUINT16 CH15:1;
                VUINT16 CH14:1;
                VUINT16 CH13:1;
                VUINT16 CH12:1;
                VUINT16 CH11:1;
                VUINT16 CH10:1;
                VUINT16 CH9:1;
                VUINT16 CH8:1;
                VUINT16 CH7:1;
                VUINT16 CH6:1;
                VUINT16 CH5:1;
                VUINT16 CH4:1;
                VUINT16 CH3:1;
                VUINT16 CH2:1;
                VUINT16 CH1:1;
                VUINT16 CH0:1;
            } B;
        } CISR;

        union {
            VUINT16 R;
            VUINT16 B;
        } LR;

        union {
            VUINT16 R;
            VUINT16 B;
        } SGLR;

        union {
            VUINT16 R;
            VUINT16 B;
        } DCNR;

        union {
            VUINT16 R;
            struct {
                VUINT16:7;
                VUINT16 DIV2:1;
                VUINT16 SOFTRST:1;
                VUINT16 ETBANK:2;
                VUINT16 FPSCK:3;
                VUINT16 T2CF:1;
                VUINT16 DTPU:1;
            } B;
        } TPUMCR2;

        union {
            VUINT16 R;
            struct {
                VUINT16:7;
                VUINT16 PWOD:1;
                VUINT16 TCR2PCK2:1;
                VUINT16 EPSCKE:1;
                  VUINT16:1;
                VUINT16 EPSCK:5;
            } B;
        } TPUMCR3;

        union {
            VUINT16 R;
            VUINT16 B;
        } ISDR;

        union {
            VUINT16 R;
            VUINT16 B;
        } ISCR;

/*    VUINT16 res17; */
        VUINT32 res18[52];

/*Parameter RAM */
        union {
            VUINT16 R[16][8];
            VUINT16 B[16][8];
            VUINT32 L[16][4];
        } PARM;

/* Old parameter definition, if you need it for compatibility uncomment
   the union below and comment out the union above. */
/*    union {  
   VUINT16 R;
   } PARM[16][8];    */

    };

/******************************************************************/
/* There are three way to create an instance of the TPU3 module:  */
/* -Use a fixed structure (Default)                               */
/* -Use the Diab compiler sections (if DIAB_SCETIONS is defined)  */
/* -Use a pointer (if HEADER_POINTERS is defined)                 */
/******************************************************************/
#ifdef DIAB_SECTIONS            /* Diab Compiler Only */

#pragma section TPU_A  address=0x304000  /* Map modules to fixed addresses. */
#pragma use_section TPU_A TPU_A
    EXT struct TPU3_tag TPU_A;

#pragma section TPU_B  address=0x304400
#pragma use_section TPU_B TPU_B
    EXT struct TPU3_tag TPU_B;

#pragma section TPU_C  address=0x305C00
#pragma use_section TPU_C TPU_C
    EXT struct TPU3_tag TPU_C;

#else
#ifdef HEADER_POINTERS

/* Create a global pointer. */

#ifdef Main_Program
    struct TPU3_tag *TPU_A = (struct TPU3_tag *) (INTERNAL_MEMORY_BASE + 0x304000);
    struct TPU3_tag *TPU_B = (struct TPU3_tag *) (INTERNAL_MEMORY_BASE + 0x304400);
    struct TPU3_tag *TPU_C = (struct TPU3_tag *) (INTERNAL_MEMORY_BASE + 0x305C00);
#else
    EXT struct TPU3_tag *TPU_A;
    EXT struct TPU3_tag *TPU_B;
    EXT struct TPU3_tag *TPU_C;
#endif

#else

/* Use a fixed structure, this is the default */
#define TPU_A  (*( struct TPU3_tag *)   (INTERNAL_MEMORY_BASE + 0x304000))
#define TPU_B  (*( struct TPU3_tag *)   (INTERNAL_MEMORY_BASE + 0x304400))
#define TPU_C  (*( struct TPU3_tag *)   (INTERNAL_MEMORY_BASE + 0x305C00))

#endif                          /* HEADER_POINTERS */

#endif                          /* DIAB_SECTIONS */

#ifdef  __cplusplus
}

#endif
#endif
/* ifndef _SPOAK_TPU_H  *//*****************************************************************************//* Motorola reserves the right to make changes without further notice to any *//* product herein to improve reliability, function, or design. Motorola does *//* not assume any  liability arising  out  of the  application or use of any *//* product,  circuit, or software described herein;  neither  does it convey *//* any license under its patent rights  nor the  rights of others.  Motorola *//* products are not designed, intended,  or authorized for use as components *//* in  systems  intended  for  surgical  implant  into  the  body, or  other *//* applications intended to support life, or  for any  other application  in *//* which the failure of the Motorola product  could create a situation where *//* personal injury or death may occur. Should Buyer purchase or use Motorola *//* products for any such intended  or unauthorized  application, Buyer shall *//* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, *//* affiliates,  and distributors harmless against all claims costs, damages, *//* and expenses, and reasonable  attorney  fees arising  out of, directly or *//* indirectly,  any claim of personal injury  or death  associated with such *//* unintended or unauthorized use, even if such claim alleges that  Motorola *//* was negligent regarding the  design  or manufacture of the part. Motorola *//* and the Motorola logo* are registered trademarks of Motorola Ltd.         *//*****************************************************************************/
