/*
 * Copyright 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2019 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _ACIM_CONTROL_H_
#define _ACIM_CONTROL_H_

#include "char_pwrstg.h"
#include "mlib.h"
#include "gflib.h"
#include "gmclib.h"
#include "gdflib.h"
#include "amclib.h"

#include "gflib_types.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*! @brief mcs speed structure */
typedef struct _mcs_speed_flux_a1
{
	GFLIB_CTRL_PI_P_AW_T_A32	sPIParSpdMe;
	AMCLIB_CTRL_FLUX_WKNG_T_A32 sFluxWkng;      /* Flux weakening controller structure */
	AMCLIB_ACIM_CTRL_MTPA_T_F32 sMTPA; 			/* Max. torque per amp structure */  
    GFLIB_RAMP_T_F32      sRampParSpdMe;        /* Speed ramp structure*/
    frac16_t f16SpdMeFilt;       /* Filtered mechanical speed value [rpm] */
    frac16_t f16SpdMeRamp;       /* Ramped mechanical speed [rpm] */
    frac16_t f16SpdMeReq;        /* Required mechanical speed [rpm] */
    frac16_t f16SpdMeErr;        /* Speed error [rpm] */
    frac16_t f16IdStart;         /* Excitation current at speed FOC startup [A] */
    frac16_t f16IdStartMinPct;   /* D-axis current threshold to go spin state at speed FOC startup [%] */
	frac16_t f16IdReqMin;        /* D-axis minimal required current */
    frac16_t f16IdReqMax;        /* Q-axis minimal required current */
    frac16_t f16IdMTPA;          /* MTPA d-axis current */
    frac16_t f16SpdMeReqMax;     /* Maximal mechanical required speed [rpm] */
    frac16_t f16SpdMeReqMin;     /* Minimal mechanical required speed [rpm] */
    bool_t bFlagPISpdMeStopInt;  /* Speed PI controller saturation flag */   
    bool_t bFlagPIFWStopInt;     /* Flux controller saturation flag */   
    bool_t bStartupDone;         /* Startup done flag */          
} mcs_speed_flux_a1_t;

/* Scalar structure */
typedef struct _mcs_scalar_a1
{
    GFLIB_RAMP_T_F32 sRampParSpdMe; 			/* Scalar speed ramp structure */
    GFLIB_INTEGRATOR_T_A32 sSpeedMeInteg;   	/* structure contains the integrator parameters */
    frac16_t f16SpdMeReq;            			/* Speed command [rpm] */
    frac16_t f16SpdMeRamp;           			/* Speed command ramped [rpm] */
	frac16_t f16PosEl;               			/* Scalar position [rad]*/
    frac16_t f16GainRpm2Volt;        			/* V/rpm constant (mechanical speed is considered) [V/rpm] */
    uint16_t ui16ShiftRpm2Volt;        			/* V/rpm constant (mechanical speed is considered) [V/rpm] */
    frac16_t f16UMin;                			/* Minimal voltage stator voltage [V] */
} mcs_scalar_a1_t;

/* ACIM FOC structure */
typedef struct _mcs_acim_foc_a1
{
	AMCLIB_ACIM_ROT_FLUX_OBSRV_T_A32 sRFO;    		/* Rotor Flux Observer structure */
    GDFLIB_FILTER_IIR1_T_F32 sSpeedElIIR1Param;		/* IIR1 filter structure for estimated speed */
    AMCLIB_ACIM_SPEED_MRAS_T_F32 sSpdObs;     		/* MRAS speed observer structure */
    GFLIB_CTRL_PI_P_AW_T_A32 sPIParId;        		/* D-axis current controller struct */
	GFLIB_CTRL_PI_P_AW_T_A32 sPIParIq;        		/* Q-axis current controller struct */
    GDFLIB_FILTER_IIR1_T_F32 sFiltParUDcBus;  		/* DC-bus voltage filter */
    GMCLIB_3COOR_T_F16 sIABCFrac;             		/* Measured 3-phase current (FRAC16) */
    GMCLIB_3COOR_T_F16 sIABC;                 		/* Measured 3-phase current [A] */
    GMCLIB_2COOR_ALBE_T_F16 sIAlBe;           		/* Alpha/Beta current [A] */
    GMCLIB_2COOR_DQ_T_F16 sIDQ;               		/* DQ current in rotor flux coordinates [A] */    
    GMCLIB_2COOR_DQ_T_F16 sIDQReq;            		/* Required DQ current in rotor flux coordinates [A] */  
    GMCLIB_2COOR_DQ_T_F16 sIDQErr;            		/* DQ current error in rotor flux coordinates [A] */  
    GMCLIB_3COOR_T_F16 sDutyABC;              		/* Applied duty cycles ABC (FRAC16) */
    GMCLIB_2COOR_ALBE_T_F16 sUAlBe;           		/* Alpha/Beta stator voltage */
    GMCLIB_2COOR_ALBE_T_F16 sUAlBeCmpFrac;    		/* Alpha/Beta stator voltage with DC-bus ripple elim (FRAC16)*/ 
    GMCLIB_2COOR_ALBE_T_F16 sUAlBeDTComp;     		/* Alpha/Beta stator voltage  */
    GMCLIB_2COOR_DQ_T_F16 sUDQReq;            		/* Required DQ voltage in rotor flux coordinates [V] */  
    GMCLIB_2COOR_DQ_T_F16 sUDQReqScalar;      		/* Required DQ voltage in scalar control */
    GMCLIB_2COOR_SINCOS_T_F16 sSCFOC;         		/* Sine & cosine of rotor flux angle [-] */
    frac16_t f16DutyLim;        					/* Max. allowable duty cycle [-] */
    frac16_t f16UDcBus;         					/* DC-bus voltage (FRAC16) */
    frac16_t f16UDcBusFilt;      					/* Filtered DC-bus voltage [V] */
    uint16_t ui16SectorSVM;     					/* SVM sector (sector) */     
    bool_t bFlagPIIdStopInt;    					/* D-axis PI controller stop integrate flag */
    bool_t bFlagPIIqStopInt;    					/* Q-axis PI controller stop integrate flag */
    bool_t bFlagSpdStart;       					/* Motor startup flag */
    bool_t bFlagDTComp;         					/* Enable/disable dead-time compensation flag */
} mcs_acim_foc_a1_t;

/* dead-time compensation voltage table */
extern const frac16_t f16UDtComp[];

#ifdef __cplusplus
extern "C" {
#endif
/*!
 * @name Motor control ACIM  functions
 * @{
 */

/*******************************************************************************
 * API
 ******************************************************************************/

/*!
 * @brief ACIM Scalar Open Loop Control
 *
 * This function is used to ACIM Open Loop scalar mode
 *
 * @param psFocACIM     The pointer of the ACIM FOC parameters structure
 * @param psScalarACIM  The pointer of the ACIM scalar parameters structure
 *
 * @return None
 */

void MCS_ACIMOpenLoopScalarCtrlA1(mcs_acim_foc_a1_t *psFocACIM, 
                                  mcs_scalar_a1_t *psScalarACIM);

/*!
 * @brief ACIM field oriented voltage control
 *
 * This function is used to perform ACIM field oriented voltage control with 
 * preset sin and cos of rotor flux position.
 *
 * @param psFocACIM     The pointer of the ACIM FOC parameters structure
 *
 * @return None
 */
void MCS_ACIMFocCtrlVoltageA1(mcs_acim_foc_a1_t *psFocACIM);

/*!
 * @brief ACIM field oriented voltage control
 *
 * This function is used to perform ACIM field oriented voltage control 
 *
 * @param psFocACIM     The pointer of the ACIM FOC parameters structure
 *
 * @return None
 */
void MCS_ACIMFocCtrlVoltageA2(mcs_acim_foc_a1_t *psFocACIM);

/*!
 * @brief ACIM field oriented current control
 *
 * This function is used to perform ACIM field oriented current control 
 *
 * @param psFocACIM     The pointer of the ACIM FOC parameters structure
 *
 * @return None
 */
void MCS_ACIMFocCtrlCurrentA1(mcs_acim_foc_a1_t *psFocACIM);

/*!
 * @brief ACIM FOC with speed and flux control
 *
 * This function is used to perform flux and speed control of ACIM
 *
 * @param psFocACIM     The pointer of the ACIM FOC parameters structure
 *
 * @return None
 */
void MCS_ACIMSpeedFluxCtrlA1(mcs_acim_foc_a1_t *psFocACIM, 
                             mcs_speed_flux_a1_t *psSpdFlux);


/****************************************************************************
* Exported function prototypes
****************************************************************************/


#ifdef __cplusplus
}
#endif


#endif /* _ACIM_CONTROL_H_ */
